/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.R;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class RUtils {
    public static String toStringList(Collection<? extends CharSequence> list) {
        if (list == null) {
            return "NA";
        }
        if (list.size() == 0) {
            return "c()";
        }
        return "c('" + StringUtils.join(list, (String)"','") + "')";
    }

    public static String toNumberList(Collection<? extends Number> list) {
        return list == null ? "NA" : "c(" + StringUtils.join(list, (String)",") + ")";
    }

    public static String toDateList(Collection<? extends Date> list) {
        return RUtils.toDateList(list, "''yyyy-MM-dd''");
    }

    public static String toDateList(Collection<? extends Date> list, String pattern) {
        if (list == null) {
            return "NA";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        StringBuilder sb = new StringBuilder();
        sb.append("c(");
        boolean first = true;
        for (Date date : list) {
            if (!first) {
                sb.append(",");
            }
            sb.append(format.format(date));
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }
}

