/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.util.Strings;

final class RGBColor {
    private final int r;
    private final int g;
    private final int b;

    RGBColor(int rgb) {
        this(RGBColor.r(rgb), RGBColor.g(rgb), RGBColor.b(rgb));
    }

    RGBColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    private static int r(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    private static int g(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    private static int b(int rgb) {
        return rgb >> 0 & 0xFF;
    }

    int r() {
        return this.r;
    }

    int g() {
        return this.g;
    }

    int b() {
        return this.b;
    }

    boolean isEqualTo(RGBColor color, int threshold) {
        if (Math.abs(this.r - color.r) > threshold) {
            return false;
        }
        if (Math.abs(this.g - color.g) > threshold) {
            return false;
        }
        return Math.abs(this.b - color.b) <= threshold;
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{"color[", "r=", String.valueOf(this.r), ",", "g=", String.valueOf(this.g), ",", "b=", String.valueOf(this.b), "]"});
    }
}

