/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.SAMSequenceDictionary;

public class ReferenceSequenceFileWalker {
    private final ReferenceSequenceFile referenceSequenceFile;
    private ReferenceSequence referenceSequence = null;

    public ReferenceSequenceFileWalker(ReferenceSequenceFile referenceSequenceFile) {
        this.referenceSequenceFile = referenceSequenceFile;
    }

    public ReferenceSequenceFileWalker(File file) {
        this(ReferenceSequenceFileFactory.getReferenceSequenceFile(file));
    }

    public ReferenceSequence get(int sequenceIndex, String sequenceName, int length) {
        this.get(sequenceIndex);
        if (!this.referenceSequence.getName().equals(sequenceName)) {
            throw new PicardException("Sequence name mismatch at sequence index (" + this.referenceSequence.getContigIndex() + ", " + this.referenceSequence.getName() + ") != " + sequenceName);
        }
        if (this.referenceSequence.getBases().length != length) {
            throw new PicardException("Sequence length mismatch for (" + sequenceIndex + ", " + sequenceName + ").  expected " + length + " but found " + this.referenceSequence.getBases().length);
        }
        return this.referenceSequence;
    }

    public ReferenceSequence get(int sequenceIndex) {
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() == sequenceIndex) {
            return this.referenceSequence;
        }
        if (this.referenceSequence != null && this.referenceSequence.getContigIndex() > sequenceIndex) {
            throw new PicardException("Requesting earlier reference sequence: " + sequenceIndex + " < " + this.referenceSequence.getContigIndex());
        }
        this.referenceSequence = null;
        this.referenceSequence = this.referenceSequenceFile.nextSequence();
        while (this.referenceSequence != null && this.referenceSequence.getContigIndex() < sequenceIndex) {
            this.referenceSequence = this.referenceSequenceFile.nextSequence();
        }
        if (this.referenceSequence == null || this.referenceSequence.getContigIndex() != sequenceIndex) {
            throw new PicardException("Reference sequence (" + sequenceIndex + ") not found in " + ((Object)this.referenceSequenceFile).toString());
        }
        return this.referenceSequence;
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.referenceSequenceFile.getSequenceDictionary();
    }
}

