#define _REENTRANT

#include <cuda.h>
#include <cupti.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include <eztrace-lib/eztrace.h>
#include <eztrace-core/eztrace_config.h>

/* This file intercepts calls to the CUDA driver API.
 * Since nvcc statically links the application against cuda by default, we cannot use the usual LD_PRELOAD method.
 * Instead, we use cupti callback API.
 */

struct cuda_driver_api_info {
  enum CUpti_driver_api_trace_cbid_enum id;
  char *function_name;
  OTF2_RegionRef region;
};

static struct cuda_driver_api_info cuda_driver_api_info[] = {
  {CUPTI_DRIVER_TRACE_CBID_INVALID, "cuda::driver::INVALID", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuInit, "cuda::driver::cuInit", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDriverGetVersion, "cuda::driver::cuDriverGetVersion", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGet, "cuda::driver::cuDeviceGet", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetCount, "cuda::driver::cuDeviceGetCount", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetName, "cuda::driver::cuDeviceGetName", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceComputeCapability, "cuda::driver::cuDeviceComputeCapability", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceTotalMem, "cuda::driver::cuDeviceTotalMem", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetProperties, "cuda::driver::cuDeviceGetProperties", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetAttribute, "cuda::driver::cuDeviceGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxCreate, "cuda::driver::cuCtxCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxDestroy, "cuda::driver::cuCtxDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxAttach, "cuda::driver::cuCtxAttach", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxDetach, "cuda::driver::cuCtxDetach", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxPushCurrent, "cuda::driver::cuCtxPushCurrent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxPopCurrent, "cuda::driver::cuCtxPopCurrent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetDevice, "cuda::driver::cuCtxGetDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxSynchronize, "cuda::driver::cuCtxSynchronize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleLoad, "cuda::driver::cuModuleLoad", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleLoadData, "cuda::driver::cuModuleLoadData", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleLoadDataEx, "cuda::driver::cuModuleLoadDataEx", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleLoadFatBinary, "cuda::driver::cuModuleLoadFatBinary", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleUnload, "cuda::driver::cuModuleUnload", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleGetFunction, "cuda::driver::cuModuleGetFunction", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleGetGlobal, "cuda::driver::cuModuleGetGlobal", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64ModuleGetGlobal, "cuda::driver::cu64ModuleGetGlobal", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleGetTexRef, "cuda::driver::cuModuleGetTexRef", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetInfo, "cuda::driver::cuMemGetInfo", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemGetInfo, "cuda::driver::cu64MemGetInfo", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAlloc, "cuda::driver::cuMemAlloc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemAlloc, "cuda::driver::cu64MemAlloc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocPitch, "cuda::driver::cuMemAllocPitch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemAllocPitch, "cuda::driver::cu64MemAllocPitch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemFree, "cuda::driver::cuMemFree", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemFree, "cuda::driver::cu64MemFree", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetAddressRange, "cuda::driver::cuMemGetAddressRange", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemGetAddressRange, "cuda::driver::cu64MemGetAddressRange", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocHost, "cuda::driver::cuMemAllocHost", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemFreeHost, "cuda::driver::cuMemFreeHost", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostAlloc, "cuda::driver::cuMemHostAlloc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostGetDevicePointer, "cuda::driver::cuMemHostGetDevicePointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemHostGetDevicePointer, "cuda::driver::cu64MemHostGetDevicePointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostGetFlags, "cuda::driver::cuMemHostGetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoD, "cuda::driver::cuMemcpyHtoD", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyHtoD, "cuda::driver::cu64MemcpyHtoD", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoH, "cuda::driver::cuMemcpyDtoH", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoH, "cuda::driver::cu64MemcpyDtoH", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoD, "cuda::driver::cuMemcpyDtoD", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoD, "cuda::driver::cu64MemcpyDtoD", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoA, "cuda::driver::cuMemcpyDtoA", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoA, "cuda::driver::cu64MemcpyDtoA", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoD, "cuda::driver::cuMemcpyAtoD", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyAtoD, "cuda::driver::cu64MemcpyAtoD", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoA, "cuda::driver::cuMemcpyHtoA", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoH, "cuda::driver::cuMemcpyAtoH", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoA, "cuda::driver::cuMemcpyAtoA", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2D, "cuda::driver::cuMemcpy2D", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DUnaligned, "cuda::driver::cuMemcpy2DUnaligned", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3D, "cuda::driver::cuMemcpy3D", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Memcpy3D, "cuda::driver::cu64Memcpy3D", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoDAsync, "cuda::driver::cuMemcpyHtoDAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyHtoDAsync, "cuda::driver::cu64MemcpyHtoDAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoHAsync, "cuda::driver::cuMemcpyDtoHAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoHAsync, "cuda::driver::cu64MemcpyDtoHAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoDAsync, "cuda::driver::cuMemcpyDtoDAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemcpyDtoDAsync, "cuda::driver::cu64MemcpyDtoDAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoAAsync, "cuda::driver::cuMemcpyHtoAAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoHAsync, "cuda::driver::cuMemcpyAtoHAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DAsync, "cuda::driver::cuMemcpy2DAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DAsync, "cuda::driver::cuMemcpy3DAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Memcpy3DAsync, "cuda::driver::cu64Memcpy3DAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD8, "cuda::driver::cuMemsetD8", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD8, "cuda::driver::cu64MemsetD8", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD16, "cuda::driver::cuMemsetD16", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD16, "cuda::driver::cu64MemsetD16", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD32, "cuda::driver::cuMemsetD32", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD32, "cuda::driver::cu64MemsetD32", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8, "cuda::driver::cuMemsetD2D8", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D8, "cuda::driver::cu64MemsetD2D8", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16, "cuda::driver::cuMemsetD2D16", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D16, "cuda::driver::cu64MemsetD2D16", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32, "cuda::driver::cuMemsetD2D32", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D32, "cuda::driver::cu64MemsetD2D32", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncSetBlockShape, "cuda::driver::cuFuncSetBlockShape", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncSetSharedSize, "cuda::driver::cuFuncSetSharedSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncGetAttribute, "cuda::driver::cuFuncGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncSetCacheConfig, "cuda::driver::cuFuncSetCacheConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayCreate, "cuda::driver::cuArrayCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayGetDescriptor, "cuda::driver::cuArrayGetDescriptor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayDestroy, "cuda::driver::cuArrayDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArray3DCreate, "cuda::driver::cuArray3DCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArray3DGetDescriptor, "cuda::driver::cuArray3DGetDescriptor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefCreate, "cuda::driver::cuTexRefCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefDestroy, "cuda::driver::cuTexRefDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetArray, "cuda::driver::cuTexRefSetArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress, "cuda::driver::cuTexRefSetAddress", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64TexRefSetAddress, "cuda::driver::cu64TexRefSetAddress", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress2D, "cuda::driver::cuTexRefSetAddress2D", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64TexRefSetAddress2D, "cuda::driver::cu64TexRefSetAddress2D", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetFormat, "cuda::driver::cuTexRefSetFormat", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddressMode, "cuda::driver::cuTexRefSetAddressMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetFilterMode, "cuda::driver::cuTexRefSetFilterMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetFlags, "cuda::driver::cuTexRefSetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetAddress, "cuda::driver::cuTexRefGetAddress", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64TexRefGetAddress, "cuda::driver::cu64TexRefGetAddress", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetArray, "cuda::driver::cuTexRefGetArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetAddressMode, "cuda::driver::cuTexRefGetAddressMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetFilterMode, "cuda::driver::cuTexRefGetFilterMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetFormat, "cuda::driver::cuTexRefGetFormat", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetFlags, "cuda::driver::cuTexRefGetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuParamSetSize, "cuda::driver::cuParamSetSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuParamSeti, "cuda::driver::cuParamSeti", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuParamSetf, "cuda::driver::cuParamSetf", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuParamSetv, "cuda::driver::cuParamSetv", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuParamSetTexRef, "cuda::driver::cuParamSetTexRef", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunch, "cuda::driver::cuLaunch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchGrid, "cuda::driver::cuLaunchGrid", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchGridAsync, "cuda::driver::cuLaunchGridAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventCreate, "cuda::driver::cuEventCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventRecord, "cuda::driver::cuEventRecord", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventQuery, "cuda::driver::cuEventQuery", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventSynchronize, "cuda::driver::cuEventSynchronize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventDestroy, "cuda::driver::cuEventDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventElapsedTime, "cuda::driver::cuEventElapsedTime", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamCreate, "cuda::driver::cuStreamCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamQuery, "cuda::driver::cuStreamQuery", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamSynchronize, "cuda::driver::cuStreamSynchronize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamDestroy, "cuda::driver::cuStreamDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsUnregisterResource, "cuda::driver::cuGraphicsUnregisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsSubResourceGetMappedArray, "cuda::driver::cuGraphicsSubResourceGetMappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedPointer, "cuda::driver::cuGraphicsResourceGetMappedPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64GraphicsResourceGetMappedPointer, "cuda::driver::cu64GraphicsResourceGetMappedPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceSetMapFlags, "cuda::driver::cuGraphicsResourceSetMapFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsMapResources, "cuda::driver::cuGraphicsMapResources", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsUnmapResources, "cuda::driver::cuGraphicsUnmapResources", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGetExportTable, "cuda::driver::cuGetExportTable", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxSetLimit, "cuda::driver::cuCtxSetLimit", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetLimit, "cuda::driver::cuCtxGetLimit", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10GetDevice, "cuda::driver::cuD3D10GetDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10CtxCreate, "cuda::driver::cuD3D10CtxCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsD3D10RegisterResource, "cuda::driver::cuGraphicsD3D10RegisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10RegisterResource, "cuda::driver::cuD3D10RegisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10UnregisterResource, "cuda::driver::cuD3D10UnregisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10MapResources, "cuda::driver::cuD3D10MapResources", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10UnmapResources, "cuda::driver::cuD3D10UnmapResources", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceSetMapFlags, "cuda::driver::cuD3D10ResourceSetMapFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedArray, "cuda::driver::cuD3D10ResourceGetMappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPointer, "cuda::driver::cuD3D10ResourceGetMappedPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedSize, "cuda::driver::cuD3D10ResourceGetMappedSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPitch, "cuda::driver::cuD3D10ResourceGetMappedPitch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetSurfaceDimensions, "cuda::driver::cuD3D10ResourceGetSurfaceDimensions", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D11GetDevice, "cuda::driver::cuD3D11GetDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D11CtxCreate, "cuda::driver::cuD3D11CtxCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsD3D11RegisterResource, "cuda::driver::cuGraphicsD3D11RegisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9GetDevice, "cuda::driver::cuD3D9GetDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9CtxCreate, "cuda::driver::cuD3D9CtxCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsD3D9RegisterResource, "cuda::driver::cuGraphicsD3D9RegisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9GetDirect3DDevice, "cuda::driver::cuD3D9GetDirect3DDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9RegisterResource, "cuda::driver::cuD3D9RegisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9UnregisterResource, "cuda::driver::cuD3D9UnregisterResource", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9MapResources, "cuda::driver::cuD3D9MapResources", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9UnmapResources, "cuda::driver::cuD3D9UnmapResources", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceSetMapFlags, "cuda::driver::cuD3D9ResourceSetMapFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetSurfaceDimensions, "cuda::driver::cuD3D9ResourceGetSurfaceDimensions", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedArray, "cuda::driver::cuD3D9ResourceGetMappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPointer, "cuda::driver::cuD3D9ResourceGetMappedPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedSize, "cuda::driver::cuD3D9ResourceGetMappedSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPitch, "cuda::driver::cuD3D9ResourceGetMappedPitch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9Begin, "cuda::driver::cuD3D9Begin", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9End, "cuda::driver::cuD3D9End", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9RegisterVertexBuffer, "cuda::driver::cuD3D9RegisterVertexBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9MapVertexBuffer, "cuda::driver::cuD3D9MapVertexBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9UnmapVertexBuffer, "cuda::driver::cuD3D9UnmapVertexBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9UnregisterVertexBuffer, "cuda::driver::cuD3D9UnregisterVertexBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLCtxCreate, "cuda::driver::cuGLCtxCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsGLRegisterBuffer, "cuda::driver::cuGraphicsGLRegisterBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsGLRegisterImage, "cuda::driver::cuGraphicsGLRegisterImage", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuWGLGetDevice, "cuda::driver::cuWGLGetDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLInit, "cuda::driver::cuGLInit", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLRegisterBufferObject, "cuda::driver::cuGLRegisterBufferObject", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObject, "cuda::driver::cuGLMapBufferObject", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLUnmapBufferObject, "cuda::driver::cuGLUnmapBufferObject", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLUnregisterBufferObject, "cuda::driver::cuGLUnregisterBufferObject", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLSetBufferObjectMapFlags, "cuda::driver::cuGLSetBufferObjectMapFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObjectAsync, "cuda::driver::cuGLMapBufferObjectAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLUnmapBufferObjectAsync, "cuda::driver::cuGLUnmapBufferObjectAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuVDPAUGetDevice, "cuda::driver::cuVDPAUGetDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuVDPAUCtxCreate, "cuda::driver::cuVDPAUCtxCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsVDPAURegisterVideoSurface, "cuda::driver::cuGraphicsVDPAURegisterVideoSurface", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsVDPAURegisterOutputSurface, "cuda::driver::cuGraphicsVDPAURegisterOutputSurface", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleGetSurfRef, "cuda::driver::cuModuleGetSurfRef", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfRefCreate, "cuda::driver::cuSurfRefCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfRefDestroy, "cuda::driver::cuSurfRefDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfRefSetFormat, "cuda::driver::cuSurfRefSetFormat", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfRefSetArray, "cuda::driver::cuSurfRefSetArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfRefGetFormat, "cuda::driver::cuSurfRefGetFormat", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfRefGetArray, "cuda::driver::cuSurfRefGetArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64DeviceTotalMem, "cuda::driver::cu64DeviceTotalMem", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetMappedPointer, "cuda::driver::cu64D3D10ResourceGetMappedPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetMappedSize, "cuda::driver::cu64D3D10ResourceGetMappedSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetMappedPitch, "cuda::driver::cu64D3D10ResourceGetMappedPitch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D10ResourceGetSurfaceDimensions, "cuda::driver::cu64D3D10ResourceGetSurfaceDimensions", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetSurfaceDimensions, "cuda::driver::cu64D3D9ResourceGetSurfaceDimensions", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetMappedPointer, "cuda::driver::cu64D3D9ResourceGetMappedPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetMappedSize, "cuda::driver::cu64D3D9ResourceGetMappedSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D9ResourceGetMappedPitch, "cuda::driver::cu64D3D9ResourceGetMappedPitch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64D3D9MapVertexBuffer, "cuda::driver::cu64D3D9MapVertexBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64GLMapBufferObject, "cuda::driver::cu64GLMapBufferObject", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64GLMapBufferObjectAsync, "cuda::driver::cu64GLMapBufferObjectAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D11GetDevices, "cuda::driver::cuD3D11GetDevices", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D11CtxCreateOnDevice, "cuda::driver::cuD3D11CtxCreateOnDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10GetDevices, "cuda::driver::cuD3D10GetDevices", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10CtxCreateOnDevice, "cuda::driver::cuD3D10CtxCreateOnDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9GetDevices, "cuda::driver::cuD3D9GetDevices", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9CtxCreateOnDevice, "cuda::driver::cuD3D9CtxCreateOnDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemHostAlloc, "cuda::driver::cu64MemHostAlloc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD8Async, "cuda::driver::cuMemsetD8Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD8Async, "cuda::driver::cu64MemsetD8Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD16Async, "cuda::driver::cuMemsetD16Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD16Async, "cuda::driver::cu64MemsetD16Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD32Async, "cuda::driver::cuMemsetD32Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD32Async, "cuda::driver::cu64MemsetD32Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8Async, "cuda::driver::cuMemsetD2D8Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D8Async, "cuda::driver::cu64MemsetD2D8Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16Async, "cuda::driver::cuMemsetD2D16Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D16Async, "cuda::driver::cu64MemsetD2D16Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32Async, "cuda::driver::cuMemsetD2D32Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64MemsetD2D32Async, "cuda::driver::cu64MemsetD2D32Async", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64ArrayCreate, "cuda::driver::cu64ArrayCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64ArrayGetDescriptor, "cuda::driver::cu64ArrayGetDescriptor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Array3DCreate, "cuda::driver::cu64Array3DCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Array3DGetDescriptor, "cuda::driver::cu64Array3DGetDescriptor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Memcpy2D, "cuda::driver::cu64Memcpy2D", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Memcpy2DUnaligned, "cuda::driver::cu64Memcpy2DUnaligned", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cu64Memcpy2DAsync, "cuda::driver::cu64Memcpy2DAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxCreate_v2, "cuda::driver::cuCtxCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10CtxCreate_v2, "cuda::driver::cuD3D10CtxCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D11CtxCreate_v2, "cuda::driver::cuD3D11CtxCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9CtxCreate_v2, "cuda::driver::cuD3D9CtxCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLCtxCreate_v2, "cuda::driver::cuGLCtxCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuVDPAUCtxCreate_v2, "cuda::driver::cuVDPAUCtxCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleGetGlobal_v2, "cuda::driver::cuModuleGetGlobal_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetInfo_v2, "cuda::driver::cuMemGetInfo_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAlloc_v2, "cuda::driver::cuMemAlloc_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocPitch_v2, "cuda::driver::cuMemAllocPitch_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemFree_v2, "cuda::driver::cuMemFree_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetAddressRange_v2, "cuda::driver::cuMemGetAddressRange_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostGetDevicePointer_v2, "cuda::driver::cuMemHostGetDevicePointer_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy_v2, "cuda::driver::cuMemcpy_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD8_v2, "cuda::driver::cuMemsetD8_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD16_v2, "cuda::driver::cuMemsetD16_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD32_v2, "cuda::driver::cuMemsetD32_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8_v2, "cuda::driver::cuMemsetD2D8_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16_v2, "cuda::driver::cuMemsetD2D16_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32_v2, "cuda::driver::cuMemsetD2D32_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress_v2, "cuda::driver::cuTexRefSetAddress_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress2D_v2, "cuda::driver::cuTexRefSetAddress2D_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetAddress_v2, "cuda::driver::cuTexRefGetAddress_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedPointer_v2, "cuda::driver::cuGraphicsResourceGetMappedPointer_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceTotalMem_v2, "cuda::driver::cuDeviceTotalMem_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPointer_v2, "cuda::driver::cuD3D10ResourceGetMappedPointer_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedSize_v2, "cuda::driver::cuD3D10ResourceGetMappedSize_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetMappedPitch_v2, "cuda::driver::cuD3D10ResourceGetMappedPitch_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10ResourceGetSurfaceDimensions_v2, "cuda::driver::cuD3D10ResourceGetSurfaceDimensions_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetSurfaceDimensions_v2, "cuda::driver::cuD3D9ResourceGetSurfaceDimensions_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPointer_v2, "cuda::driver::cuD3D9ResourceGetMappedPointer_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedSize_v2, "cuda::driver::cuD3D9ResourceGetMappedSize_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9ResourceGetMappedPitch_v2, "cuda::driver::cuD3D9ResourceGetMappedPitch_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D9MapVertexBuffer_v2, "cuda::driver::cuD3D9MapVertexBuffer_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObject_v2, "cuda::driver::cuGLMapBufferObject_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObjectAsync_v2, "cuda::driver::cuGLMapBufferObjectAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostAlloc_v2, "cuda::driver::cuMemHostAlloc_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayCreate_v2, "cuda::driver::cuArrayCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayGetDescriptor_v2, "cuda::driver::cuArrayGetDescriptor_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArray3DCreate_v2, "cuda::driver::cuArray3DCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArray3DGetDescriptor_v2, "cuda::driver::cuArray3DGetDescriptor_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoD_v2, "cuda::driver::cuMemcpyHtoD_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoDAsync_v2, "cuda::driver::cuMemcpyHtoDAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoH_v2, "cuda::driver::cuMemcpyDtoH_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoHAsync_v2, "cuda::driver::cuMemcpyDtoHAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoD_v2, "cuda::driver::cuMemcpyDtoD_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoDAsync_v2, "cuda::driver::cuMemcpyDtoDAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoH_v2, "cuda::driver::cuMemcpyAtoH_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoHAsync_v2, "cuda::driver::cuMemcpyAtoHAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoD_v2, "cuda::driver::cuMemcpyAtoD_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoA_v2, "cuda::driver::cuMemcpyDtoA_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoA_v2, "cuda::driver::cuMemcpyAtoA_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2D_v2, "cuda::driver::cuMemcpy2D_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DUnaligned_v2, "cuda::driver::cuMemcpy2DUnaligned_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DAsync_v2, "cuda::driver::cuMemcpy2DAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3D_v2, "cuda::driver::cuMemcpy3D_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DAsync_v2, "cuda::driver::cuMemcpy3DAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoA_v2, "cuda::driver::cuMemcpyHtoA_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoAAsync_v2, "cuda::driver::cuMemcpyHtoAAsync_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocHost_v2, "cuda::driver::cuMemAllocHost_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitEvent, "cuda::driver::cuStreamWaitEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetApiVersion, "cuda::driver::cuCtxGetApiVersion", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D10GetDirect3DDevice, "cuda::driver::cuD3D10GetDirect3DDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuD3D11GetDirect3DDevice, "cuda::driver::cuD3D11GetDirect3DDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetCacheConfig, "cuda::driver::cuCtxGetCacheConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxSetCacheConfig, "cuda::driver::cuCtxSetCacheConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostRegister, "cuda::driver::cuMemHostRegister", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostUnregister, "cuda::driver::cuMemHostUnregister", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxSetCurrent, "cuda::driver::cuCtxSetCurrent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetCurrent, "cuda::driver::cuCtxGetCurrent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy, "cuda::driver::cuMemcpy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAsync, "cuda::driver::cuMemcpyAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchKernel, "cuda::driver::cuLaunchKernel", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuProfilerStart, "cuda::driver::cuProfilerStart", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuProfilerStop, "cuda::driver::cuProfilerStop", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuPointerGetAttribute, "cuda::driver::cuPointerGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuProfilerInitialize, "cuda::driver::cuProfilerInitialize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceCanAccessPeer, "cuda::driver::cuDeviceCanAccessPeer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxEnablePeerAccess, "cuda::driver::cuCtxEnablePeerAccess", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxDisablePeerAccess, "cuda::driver::cuCtxDisablePeerAccess", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPeerRegister, "cuda::driver::cuMemPeerRegister", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPeerUnregister, "cuda::driver::cuMemPeerUnregister", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPeerGetDevicePointer, "cuda::driver::cuMemPeerGetDevicePointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeer, "cuda::driver::cuMemcpyPeer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeerAsync, "cuda::driver::cuMemcpyPeerAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeer, "cuda::driver::cuMemcpy3DPeer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeerAsync, "cuda::driver::cuMemcpy3DPeerAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxDestroy_v2, "cuda::driver::cuCtxDestroy_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxPushCurrent_v2, "cuda::driver::cuCtxPushCurrent_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxPopCurrent_v2, "cuda::driver::cuCtxPopCurrent_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventDestroy_v2, "cuda::driver::cuEventDestroy_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamDestroy_v2, "cuda::driver::cuStreamDestroy_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetAddress2D_v3, "cuda::driver::cuTexRefSetAddress2D_v3", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuIpcGetMemHandle, "cuda::driver::cuIpcGetMemHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuIpcOpenMemHandle, "cuda::driver::cuIpcOpenMemHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuIpcCloseMemHandle, "cuda::driver::cuIpcCloseMemHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetByPCIBusId, "cuda::driver::cuDeviceGetByPCIBusId", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetPCIBusId, "cuda::driver::cuDeviceGetPCIBusId", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLGetDevices, "cuda::driver::cuGLGetDevices", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuIpcGetEventHandle, "cuda::driver::cuIpcGetEventHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuIpcOpenEventHandle, "cuda::driver::cuIpcOpenEventHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxSetSharedMemConfig, "cuda::driver::cuCtxSetSharedMemConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetSharedMemConfig, "cuda::driver::cuCtxGetSharedMemConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncSetSharedMemConfig, "cuda::driver::cuFuncSetSharedMemConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexObjectCreate, "cuda::driver::cuTexObjectCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexObjectDestroy, "cuda::driver::cuTexObjectDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexObjectGetResourceDesc, "cuda::driver::cuTexObjectGetResourceDesc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexObjectGetTextureDesc, "cuda::driver::cuTexObjectGetTextureDesc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfObjectCreate, "cuda::driver::cuSurfObjectCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfObjectDestroy, "cuda::driver::cuSurfObjectDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSurfObjectGetResourceDesc, "cuda::driver::cuSurfObjectGetResourceDesc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamAddCallback, "cuda::driver::cuStreamAddCallback", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayCreate, "cuda::driver::cuMipmappedArrayCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayGetLevel, "cuda::driver::cuMipmappedArrayGetLevel", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayDestroy, "cuda::driver::cuMipmappedArrayDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmappedArray, "cuda::driver::cuTexRefSetMipmappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmapFilterMode, "cuda::driver::cuTexRefSetMipmapFilterMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmapLevelBias, "cuda::driver::cuTexRefSetMipmapLevelBias", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMipmapLevelClamp, "cuda::driver::cuTexRefSetMipmapLevelClamp", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetMaxAnisotropy, "cuda::driver::cuTexRefSetMaxAnisotropy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmappedArray, "cuda::driver::cuTexRefGetMipmappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmapFilterMode, "cuda::driver::cuTexRefGetMipmapFilterMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmapLevelBias, "cuda::driver::cuTexRefGetMipmapLevelBias", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMipmapLevelClamp, "cuda::driver::cuTexRefGetMipmapLevelClamp", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetMaxAnisotropy, "cuda::driver::cuTexRefGetMaxAnisotropy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedMipmappedArray, "cuda::driver::cuGraphicsResourceGetMappedMipmappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexObjectGetResourceViewDesc, "cuda::driver::cuTexObjectGetResourceViewDesc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkCreate, "cuda::driver::cuLinkCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkAddData, "cuda::driver::cuLinkAddData", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkAddFile, "cuda::driver::cuLinkAddFile", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkComplete, "cuda::driver::cuLinkComplete", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkDestroy, "cuda::driver::cuLinkDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamCreateWithPriority, "cuda::driver::cuStreamCreateWithPriority", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetPriority, "cuda::driver::cuStreamGetPriority", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetFlags, "cuda::driver::cuStreamGetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetStreamPriorityRange, "cuda::driver::cuCtxGetStreamPriorityRange", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocManaged, "cuda::driver::cuMemAllocManaged", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGetErrorString, "cuda::driver::cuGetErrorString", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGetErrorName, "cuda::driver::cuGetErrorName", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxActiveBlocksPerMultiprocessor, "cuda::driver::cuOccupancyMaxActiveBlocksPerMultiprocessor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCompilePtx, "cuda::driver::cuCompilePtx", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuBinaryFree, "cuda::driver::cuBinaryFree", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamAttachMemAsync, "cuda::driver::cuStreamAttachMemAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuPointerSetAttribute, "cuda::driver::cuPointerSetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemHostRegister_v2, "cuda::driver::cuMemHostRegister_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceSetMapFlags_v2, "cuda::driver::cuGraphicsResourceSetMapFlags_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkCreate_v2, "cuda::driver::cuLinkCreate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkAddData_v2, "cuda::driver::cuLinkAddData_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLinkAddFile_v2, "cuda::driver::cuLinkAddFile_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxPotentialBlockSize, "cuda::driver::cuOccupancyMaxPotentialBlockSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLGetDevices_v2, "cuda::driver::cuGLGetDevices_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxRetain, "cuda::driver::cuDevicePrimaryCtxRetain", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxRelease, "cuda::driver::cuDevicePrimaryCtxRelease", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxSetFlags, "cuda::driver::cuDevicePrimaryCtxSetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxReset, "cuda::driver::cuDevicePrimaryCtxReset", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsEGLRegisterImage, "cuda::driver::cuGraphicsEGLRegisterImage", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetFlags, "cuda::driver::cuCtxGetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxGetState, "cuda::driver::cuDevicePrimaryCtxGetState", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerConnect, "cuda::driver::cuEGLStreamConsumerConnect", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerDisconnect, "cuda::driver::cuEGLStreamConsumerDisconnect", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerAcquireFrame, "cuda::driver::cuEGLStreamConsumerAcquireFrame", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerReleaseFrame, "cuda::driver::cuEGLStreamConsumerReleaseFrame", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoD_v2_ptds, "cuda::driver::cuMemcpyHtoD_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoH_v2_ptds, "cuda::driver::cuMemcpyDtoH_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoD_v2_ptds, "cuda::driver::cuMemcpyDtoD_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoA_v2_ptds, "cuda::driver::cuMemcpyDtoA_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoD_v2_ptds, "cuda::driver::cuMemcpyAtoD_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoA_v2_ptds, "cuda::driver::cuMemcpyHtoA_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoH_v2_ptds, "cuda::driver::cuMemcpyAtoH_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoA_v2_ptds, "cuda::driver::cuMemcpyAtoA_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2D_v2_ptds, "cuda::driver::cuMemcpy2D_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DUnaligned_v2_ptds, "cuda::driver::cuMemcpy2DUnaligned_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3D_v2_ptds, "cuda::driver::cuMemcpy3D_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy_ptds, "cuda::driver::cuMemcpy_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeer_ptds, "cuda::driver::cuMemcpyPeer_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeer_ptds, "cuda::driver::cuMemcpy3DPeer_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD8_v2_ptds, "cuda::driver::cuMemsetD8_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD16_v2_ptds, "cuda::driver::cuMemsetD16_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD32_v2_ptds, "cuda::driver::cuMemsetD32_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8_v2_ptds, "cuda::driver::cuMemsetD2D8_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16_v2_ptds, "cuda::driver::cuMemsetD2D16_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32_v2_ptds, "cuda::driver::cuMemsetD2D32_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObject_v2_ptds, "cuda::driver::cuGLMapBufferObject_v2_ptds", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAsync_ptsz, "cuda::driver::cuMemcpyAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoAAsync_v2_ptsz, "cuda::driver::cuMemcpyHtoAAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyAtoHAsync_v2_ptsz, "cuda::driver::cuMemcpyAtoHAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyHtoDAsync_v2_ptsz, "cuda::driver::cuMemcpyHtoDAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoHAsync_v2_ptsz, "cuda::driver::cuMemcpyDtoHAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyDtoDAsync_v2_ptsz, "cuda::driver::cuMemcpyDtoDAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy2DAsync_v2_ptsz, "cuda::driver::cuMemcpy2DAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DAsync_v2_ptsz, "cuda::driver::cuMemcpy3DAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpyPeerAsync_ptsz, "cuda::driver::cuMemcpyPeerAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemcpy3DPeerAsync_ptsz, "cuda::driver::cuMemcpy3DPeerAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD8Async_ptsz, "cuda::driver::cuMemsetD8Async_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD16Async_ptsz, "cuda::driver::cuMemsetD16Async_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD32Async_ptsz, "cuda::driver::cuMemsetD32Async_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D8Async_ptsz, "cuda::driver::cuMemsetD2D8Async_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D16Async_ptsz, "cuda::driver::cuMemsetD2D16Async_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemsetD2D32Async_ptsz, "cuda::driver::cuMemsetD2D32Async_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetPriority_ptsz, "cuda::driver::cuStreamGetPriority_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetFlags_ptsz, "cuda::driver::cuStreamGetFlags_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitEvent_ptsz, "cuda::driver::cuStreamWaitEvent_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamAddCallback_ptsz, "cuda::driver::cuStreamAddCallback_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamAttachMemAsync_ptsz, "cuda::driver::cuStreamAttachMemAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamQuery_ptsz, "cuda::driver::cuStreamQuery_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamSynchronize_ptsz, "cuda::driver::cuStreamSynchronize_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventRecord_ptsz, "cuda::driver::cuEventRecord_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchKernel_ptsz, "cuda::driver::cuLaunchKernel_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsMapResources_ptsz, "cuda::driver::cuGraphicsMapResources_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsUnmapResources_ptsz, "cuda::driver::cuGraphicsUnmapResources_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGLMapBufferObjectAsync_v2_ptsz, "cuda::driver::cuGLMapBufferObjectAsync_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerConnect, "cuda::driver::cuEGLStreamProducerConnect", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerDisconnect, "cuda::driver::cuEGLStreamProducerDisconnect", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerPresentFrame, "cuda::driver::cuEGLStreamProducerPresentFrame", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphicsResourceGetMappedEglFrame, "cuda::driver::cuGraphicsResourceGetMappedEglFrame", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuPointerGetAttributes, "cuda::driver::cuPointerGetAttributes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags, "cuda::driver::cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxPotentialBlockSizeWithFlags, "cuda::driver::cuOccupancyMaxPotentialBlockSizeWithFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamProducerReturnFrame, "cuda::driver::cuEGLStreamProducerReturnFrame", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetP2PAttribute, "cuda::driver::cuDeviceGetP2PAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefSetBorderColor, "cuda::driver::cuTexRefSetBorderColor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTexRefGetBorderColor, "cuda::driver::cuTexRefGetBorderColor", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAdvise, "cuda::driver::cuMemAdvise", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32, "cuda::driver::cuStreamWaitValue32", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32_ptsz, "cuda::driver::cuStreamWaitValue32_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32, "cuda::driver::cuStreamWriteValue32", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32_ptsz, "cuda::driver::cuStreamWriteValue32_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp, "cuda::driver::cuStreamBatchMemOp", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp_ptsz, "cuda::driver::cuStreamBatchMemOp_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuNVNbufferGetPointer, "cuda::driver::cuNVNbufferGetPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuNVNtextureGetArray, "cuda::driver::cuNVNtextureGetArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuNNSetAllocator, "cuda::driver::cuNNSetAllocator", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPrefetchAsync, "cuda::driver::cuMemPrefetchAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPrefetchAsync_ptsz, "cuda::driver::cuMemPrefetchAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventCreateFromNVNSync, "cuda::driver::cuEventCreateFromNVNSync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEGLStreamConsumerConnectWithFlags, "cuda::driver::cuEGLStreamConsumerConnectWithFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemRangeGetAttribute, "cuda::driver::cuMemRangeGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemRangeGetAttributes, "cuda::driver::cuMemRangeGetAttributes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64, "cuda::driver::cuStreamWaitValue64", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64_ptsz, "cuda::driver::cuStreamWaitValue64_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64, "cuda::driver::cuStreamWriteValue64", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64_ptsz, "cuda::driver::cuStreamWriteValue64_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchCooperativeKernel, "cuda::driver::cuLaunchCooperativeKernel", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchCooperativeKernel_ptsz, "cuda::driver::cuLaunchCooperativeKernel_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventCreateFromEGLSync, "cuda::driver::cuEventCreateFromEGLSync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchCooperativeKernelMultiDevice, "cuda::driver::cuLaunchCooperativeKernelMultiDevice", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncSetAttribute, "cuda::driver::cuFuncSetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetUuid, "cuda::driver::cuDeviceGetUuid", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetCtx, "cuda::driver::cuStreamGetCtx", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetCtx_ptsz, "cuda::driver::cuStreamGetCtx_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuImportExternalMemory, "cuda::driver::cuImportExternalMemory", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuExternalMemoryGetMappedBuffer, "cuda::driver::cuExternalMemoryGetMappedBuffer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuExternalMemoryGetMappedMipmappedArray, "cuda::driver::cuExternalMemoryGetMappedMipmappedArray", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDestroyExternalMemory, "cuda::driver::cuDestroyExternalMemory", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuImportExternalSemaphore, "cuda::driver::cuImportExternalSemaphore", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSignalExternalSemaphoresAsync, "cuda::driver::cuSignalExternalSemaphoresAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuSignalExternalSemaphoresAsync_ptsz, "cuda::driver::cuSignalExternalSemaphoresAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuWaitExternalSemaphoresAsync, "cuda::driver::cuWaitExternalSemaphoresAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuWaitExternalSemaphoresAsync_ptsz, "cuda::driver::cuWaitExternalSemaphoresAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDestroyExternalSemaphore, "cuda::driver::cuDestroyExternalSemaphore", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture, "cuda::driver::cuStreamBeginCapture", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture_ptsz, "cuda::driver::cuStreamBeginCapture_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamEndCapture, "cuda::driver::cuStreamEndCapture", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamEndCapture_ptsz, "cuda::driver::cuStreamEndCapture_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamIsCapturing, "cuda::driver::cuStreamIsCapturing", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamIsCapturing_ptsz, "cuda::driver::cuStreamIsCapturing_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphCreate, "cuda::driver::cuGraphCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddKernelNode, "cuda::driver::cuGraphAddKernelNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeGetParams, "cuda::driver::cuGraphKernelNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemcpyNode, "cuda::driver::cuGraphAddMemcpyNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphMemcpyNodeGetParams, "cuda::driver::cuGraphMemcpyNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemsetNode, "cuda::driver::cuGraphAddMemsetNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphMemsetNodeGetParams, "cuda::driver::cuGraphMemsetNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphMemsetNodeSetParams, "cuda::driver::cuGraphMemsetNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetType, "cuda::driver::cuGraphNodeGetType", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphGetRootNodes, "cuda::driver::cuGraphGetRootNodes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetDependencies, "cuda::driver::cuGraphNodeGetDependencies", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetDependentNodes, "cuda::driver::cuGraphNodeGetDependentNodes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiate, "cuda::driver::cuGraphInstantiate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphLaunch, "cuda::driver::cuGraphLaunch", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphLaunch_ptsz, "cuda::driver::cuGraphLaunch_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecDestroy, "cuda::driver::cuGraphExecDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphDestroy, "cuda::driver::cuGraphDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddDependencies, "cuda::driver::cuGraphAddDependencies", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphRemoveDependencies, "cuda::driver::cuGraphRemoveDependencies", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphMemcpyNodeSetParams, "cuda::driver::cuGraphMemcpyNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeSetParams, "cuda::driver::cuGraphKernelNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphDestroyNode, "cuda::driver::cuGraphDestroyNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphClone, "cuda::driver::cuGraphClone", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphNodeFindInClone, "cuda::driver::cuGraphNodeFindInClone", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddChildGraphNode, "cuda::driver::cuGraphAddChildGraphNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddEmptyNode, "cuda::driver::cuGraphAddEmptyNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchHostFunc, "cuda::driver::cuLaunchHostFunc", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchHostFunc_ptsz, "cuda::driver::cuLaunchHostFunc_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphChildGraphNodeGetGraph, "cuda::driver::cuGraphChildGraphNodeGetGraph", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddHostNode, "cuda::driver::cuGraphAddHostNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphHostNodeGetParams, "cuda::driver::cuGraphHostNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetLuid, "cuda::driver::cuDeviceGetLuid", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphHostNodeSetParams, "cuda::driver::cuGraphHostNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphGetNodes, "cuda::driver::cuGraphGetNodes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphGetEdges, "cuda::driver::cuGraphGetEdges", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo, "cuda::driver::cuStreamGetCaptureInfo", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_ptsz, "cuda::driver::cuStreamGetCaptureInfo_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecKernelNodeSetParams, "cuda::driver::cuGraphExecKernelNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture_v2, "cuda::driver::cuStreamBeginCapture_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBeginCapture_v2_ptsz, "cuda::driver::cuStreamBeginCapture_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuThreadExchangeStreamCaptureMode, "cuda::driver::cuThreadExchangeStreamCaptureMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetNvSciSyncAttributes, "cuda::driver::cuDeviceGetNvSciSyncAttributes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyAvailableDynamicSMemPerBlock, "cuda::driver::cuOccupancyAvailableDynamicSMemPerBlock", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxRelease_v2, "cuda::driver::cuDevicePrimaryCtxRelease_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxReset_v2, "cuda::driver::cuDevicePrimaryCtxReset_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDevicePrimaryCtxSetFlags_v2, "cuda::driver::cuDevicePrimaryCtxSetFlags_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAddressReserve, "cuda::driver::cuMemAddressReserve", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAddressFree, "cuda::driver::cuMemAddressFree", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemCreate, "cuda::driver::cuMemCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemRelease, "cuda::driver::cuMemRelease", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemMap, "cuda::driver::cuMemMap", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemUnmap, "cuda::driver::cuMemUnmap", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemSetAccess, "cuda::driver::cuMemSetAccess", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemExportToShareableHandle, "cuda::driver::cuMemExportToShareableHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemImportFromShareableHandle, "cuda::driver::cuMemImportFromShareableHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetAllocationGranularity, "cuda::driver::cuMemGetAllocationGranularity", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetAllocationPropertiesFromHandle, "cuda::driver::cuMemGetAllocationPropertiesFromHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetAccess, "cuda::driver::cuMemGetAccess", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamSetFlags, "cuda::driver::cuStreamSetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamSetFlags_ptsz, "cuda::driver::cuStreamSetFlags_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecUpdate, "cuda::driver::cuGraphExecUpdate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecMemcpyNodeSetParams, "cuda::driver::cuGraphExecMemcpyNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecMemsetNodeSetParams, "cuda::driver::cuGraphExecMemsetNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecHostNodeSetParams, "cuda::driver::cuGraphExecHostNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemRetainAllocationHandle, "cuda::driver::cuMemRetainAllocationHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuFuncGetModule, "cuda::driver::cuFuncGetModule", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuIpcOpenMemHandle_v2, "cuda::driver::cuIpcOpenMemHandle_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxResetPersistingL2Cache, "cuda::driver::cuCtxResetPersistingL2Cache", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeCopyAttributes, "cuda::driver::cuGraphKernelNodeCopyAttributes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeGetAttribute, "cuda::driver::cuGraphKernelNodeGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeSetAttribute, "cuda::driver::cuGraphKernelNodeSetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamCopyAttributes, "cuda::driver::cuStreamCopyAttributes", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamCopyAttributes_ptsz, "cuda::driver::cuStreamCopyAttributes_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetAttribute, "cuda::driver::cuStreamGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetAttribute_ptsz, "cuda::driver::cuStreamGetAttribute_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamSetAttribute, "cuda::driver::cuStreamSetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamSetAttribute_ptsz, "cuda::driver::cuStreamSetAttribute_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiate_v2, "cuda::driver::cuGraphInstantiate_v2", OTF2_UNDEFINED_REGION},

#if  CUPTI_API_VERSION >= 14
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetTexture1DLinearMaxWidth, "cuda::driver::cuDeviceGetTexture1DLinearMaxWidth", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphUpload, "cuda::driver::cuGraphUpload", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphUpload_ptsz, "cuda::driver::cuGraphUpload_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayGetSparseProperties, "cuda::driver::cuArrayGetSparseProperties", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayGetSparseProperties, "cuda::driver::cuMipmappedArrayGetSparseProperties", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemMapArrayAsync, "cuda::driver::cuMemMapArrayAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemMapArrayAsync_ptsz, "cuda::driver::cuMemMapArrayAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecChildGraphNodeSetParams, "cuda::driver::cuGraphExecChildGraphNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventRecordWithFlags, "cuda::driver::cuEventRecordWithFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuEventRecordWithFlags_ptsz, "cuda::driver::cuEventRecordWithFlags_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddEventRecordNode, "cuda::driver::cuGraphAddEventRecordNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddEventWaitNode, "cuda::driver::cuGraphAddEventWaitNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphEventRecordNodeGetEvent, "cuda::driver::cuGraphEventRecordNodeGetEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphEventWaitNodeGetEvent, "cuda::driver::cuGraphEventWaitNodeGetEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphEventRecordNodeSetEvent, "cuda::driver::cuGraphEventRecordNodeSetEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphEventWaitNodeSetEvent, "cuda::driver::cuGraphEventWaitNodeSetEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecEventRecordNodeSetEvent, "cuda::driver::cuGraphExecEventRecordNodeSetEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecEventWaitNodeSetEvent, "cuda::driver::cuGraphExecEventWaitNodeSetEvent", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayGetPlane, "cuda::driver::cuArrayGetPlane", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocAsync, "cuda::driver::cuMemAllocAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocAsync_ptsz, "cuda::driver::cuMemAllocAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemFreeAsync, "cuda::driver::cuMemFreeAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemFreeAsync_ptsz, "cuda::driver::cuMemFreeAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolTrimTo, "cuda::driver::cuMemPoolTrimTo", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolSetAttribute, "cuda::driver::cuMemPoolSetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolGetAttribute, "cuda::driver::cuMemPoolGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolSetAccess, "cuda::driver::cuMemPoolSetAccess", OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 14
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetDefaultMemPool, "cuda::driver::cuDeviceGetDefaultMemPool", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolCreate, "cuda::driver::cuMemPoolCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolDestroy, "cuda::driver::cuMemPoolDestroy", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceSetMemPool, "cuda::driver::cuDeviceSetMemPool", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetMemPool, "cuda::driver::cuDeviceGetMemPool", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocFromPoolAsync, "cuda::driver::cuMemAllocFromPoolAsync", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemAllocFromPoolAsync_ptsz, "cuda::driver::cuMemAllocFromPoolAsync_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolExportToShareableHandle, "cuda::driver::cuMemPoolExportToShareableHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolImportFromShareableHandle, "cuda::driver::cuMemPoolImportFromShareableHandle", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolExportPointer, "cuda::driver::cuMemPoolExportPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolImportPointer, "cuda::driver::cuMemPoolImportPointer", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemPoolGetAccess, "cuda::driver::cuMemPoolGetAccess", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddExternalSemaphoresSignalNode, "cuda::driver::cuGraphAddExternalSemaphoresSignalNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresSignalNodeGetParams, "cuda::driver::cuGraphExternalSemaphoresSignalNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresSignalNodeSetParams, "cuda::driver::cuGraphExternalSemaphoresSignalNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddExternalSemaphoresWaitNode, "cuda::driver::cuGraphAddExternalSemaphoresWaitNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresWaitNodeGetParams, "cuda::driver::cuGraphExternalSemaphoresWaitNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExternalSemaphoresWaitNodeSetParams, "cuda::driver::cuGraphExternalSemaphoresWaitNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecExternalSemaphoresSignalNodeSetParams, "cuda::driver::cuGraphExecExternalSemaphoresSignalNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecExternalSemaphoresWaitNodeSetParams, "cuda::driver::cuGraphExecExternalSemaphoresWaitNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGetProcAddress, "cuda::driver::cuGetProcAddress", OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 13
  {CUPTI_DRIVER_TRACE_CBID_cuFlushGPUDirectRDMAWrites, "cuda::driver::cuFlushGPUDirectRDMAWrites", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphDebugDotPrint, "cuda::driver::cuGraphDebugDotPrint", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_v2, "cuda::driver::cuStreamGetCaptureInfo_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetCaptureInfo_v2_ptsz, "cuda::driver::cuStreamGetCaptureInfo_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamUpdateCaptureDependencies, "cuda::driver::cuStreamUpdateCaptureDependencies", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamUpdateCaptureDependencies_ptsz, "cuda::driver::cuStreamUpdateCaptureDependencies_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuUserObjectCreate, "cuda::driver::cuUserObjectCreate", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuUserObjectRetain, "cuda::driver::cuUserObjectRetain", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuUserObjectRelease, "cuda::driver::cuUserObjectRelease", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphRetainUserObject, "cuda::driver::cuGraphRetainUserObject", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphReleaseUserObject, "cuda::driver::cuGraphReleaseUserObject", OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 14  
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemAllocNode, "cuda::driver::cuGraphAddMemAllocNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddMemFreeNode, "cuda::driver::cuGraphAddMemFreeNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGraphMemTrim, "cuda::driver::cuDeviceGraphMemTrim", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetGraphMemAttribute, "cuda::driver::cuDeviceGetGraphMemAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceSetGraphMemAttribute, "cuda::driver::cuDeviceSetGraphMemAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiateWithFlags, "cuda::driver::cuGraphInstantiateWithFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetExecAffinitySupport, "cuda::driver::cuDeviceGetExecAffinitySupport", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxCreate_v3, "cuda::driver::cuCtxCreate_v3", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetExecAffinity, "cuda::driver::cuCtxGetExecAffinity", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuDeviceGetUuid_v2, "cuda::driver::cuDeviceGetUuid_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphMemAllocNodeGetParams, "cuda::driver::cuGraphMemAllocNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphMemFreeNodeGetParams, "cuda::driver::cuGraphMemFreeNodeGetParams", OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 16
  {CUPTI_DRIVER_TRACE_CBID_cuGraphNodeSetEnabled, "cuda::driver::cuGraphNodeSetEnabled", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphNodeGetEnabled, "cuda::driver::cuGraphNodeGetEnabled", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchKernelEx, "cuda::driver::cuLaunchKernelEx", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLaunchKernelEx_ptsz, "cuda::driver::cuLaunchKernelEx_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuArrayGetMemoryRequirements, "cuda::driver::cuArrayGetMemoryRequirements", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMipmappedArrayGetMemoryRequirements, "cuda::driver::cuMipmappedArrayGetMemoryRequirements", OTF2_UNDEFINED_REGION},
#endif
  
#if  CUPTI_API_VERSION >= 17
  {CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiateWithParams, "cuda::driver::cuGraphInstantiateWithParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphInstantiateWithParams_ptsz, "cuda::driver::cuGraphInstantiateWithParams_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecGetFlags, "cuda::driver::cuGraphExecGetFlags", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32_v2, "cuda::driver::cuStreamWaitValue32_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue32_v2_ptsz, "cuda::driver::cuStreamWaitValue32_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64_v2, "cuda::driver::cuStreamWaitValue64_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWaitValue64_v2_ptsz, "cuda::driver::cuStreamWaitValue64_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32_v2, "cuda::driver::cuStreamWriteValue32_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue32_v2_ptsz, "cuda::driver::cuStreamWriteValue32_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64_v2, "cuda::driver::cuStreamWriteValue64_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamWriteValue64_v2_ptsz, "cuda::driver::cuStreamWriteValue64_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp_v2, "cuda::driver::cuStreamBatchMemOp_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamBatchMemOp_v2_ptsz, "cuda::driver::cuStreamBatchMemOp_v2_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddBatchMemOpNode, "cuda::driver::cuGraphAddBatchMemOpNode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphBatchMemOpNodeGetParams, "cuda::driver::cuGraphBatchMemOpNodeGetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphBatchMemOpNodeSetParams, "cuda::driver::cuGraphBatchMemOpNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecBatchMemOpNodeSetParams, "cuda::driver::cuGraphExecBatchMemOpNodeSetParams", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuModuleGetLoadingMode, "cuda::driver::cuModuleGetLoadingMode", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuMemGetHandleForAddressRange, "cuda::driver::cuMemGetHandleForAddressRange", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxPotentialClusterSize, "cuda::driver::cuOccupancyMaxPotentialClusterSize", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuOccupancyMaxActiveClusters, "cuda::driver::cuOccupancyMaxActiveClusters", OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 19
  {CUPTI_DRIVER_TRACE_CBID_cuGetProcAddress_v2, "cuda::driver::cuGetProcAddress_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryLoadData, "cuda::driver::cuLibraryLoadData", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryLoadFromFile, "cuda::driver::cuLibraryLoadFromFile", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryUnload, "cuda::driver::cuLibraryUnload", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryGetKernel, "cuda::driver::cuLibraryGetKernel", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryGetModule, "cuda::driver::cuLibraryGetModule", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuKernelGetFunction, "cuda::driver::cuKernelGetFunction", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryGetGlobal, "cuda::driver::cuLibraryGetGlobal", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryGetManaged, "cuda::driver::cuLibraryGetManaged", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuKernelGetAttribute, "cuda::driver::cuKernelGetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuKernelSetAttribute, "cuda::driver::cuKernelSetAttribute", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuKernelSetCacheConfig, "cuda::driver::cuKernelSetCacheConfig", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphAddKernelNode_v2, "cuda::driver::cuGraphAddKernelNode_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeGetParams_v2, "cuda::driver::cuGraphKernelNodeGetParams_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphKernelNodeSetParams_v2, "cuda::driver::cuGraphKernelNodeSetParams_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecKernelNodeSetParams_v2, "cuda::driver::cuGraphExecKernelNodeSetParams_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetId, "cuda::driver::cuStreamGetId", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuStreamGetId_ptsz, "cuda::driver::cuStreamGetId_ptsz", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuCtxGetId, "cuda::driver::cuCtxGetId", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuGraphExecUpdate_v2, "cuda::driver::cuGraphExecUpdate_v2", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTensorMapEncodeTiled, "cuda::driver::cuTensorMapEncodeTiled", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTensorMapEncodeIm2col, "cuda::driver::cuTensorMapEncodeIm2col", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuTensorMapReplaceAddress, "cuda::driver::cuTensorMapReplaceAddress", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_cuLibraryGetUnifiedFunction, "cuda::driver::cuLibraryGetUnifiedFunction", OTF2_UNDEFINED_REGION},
#endif

  {CUPTI_DRIVER_TRACE_CBID_SIZE, "cuda::driver::SIZE", OTF2_UNDEFINED_REGION},
  {CUPTI_DRIVER_TRACE_CBID_FORCE_INT, "cuda::driver::FORCE_INT", OTF2_UNDEFINED_REGION},
};

void CUPTIAPI eztrace_cuda_driver_callback(void *userdata, CUpti_CallbackDomain domain,
					   CUpti_CallbackId cbid, const void *cbdata) {
  if(domain != CUPTI_CB_DOMAIN_DRIVER_API)
    return;
  if(!EZTRACE_SAFE)
    return;

  const CUpti_CallbackData *cbInfo = (CUpti_CallbackData *)cbdata;
      
  const char* enter_leave = cbInfo->callbackSite == CUPTI_API_ENTER? "Enter":"Leave";

  if(cuda_driver_api_info[cbid].region == OTF2_UNDEFINED_REGION) {
    cuda_driver_api_info[cbid].region = ezt_otf2_register_function(cuda_driver_api_info[cbid].function_name);

    if(cbInfo->callbackSite == CUPTI_API_ENTER) {
      EZT_OTF2_EvtWriter_Enter( evt_writer,
				NULL,
				ezt_get_timestamp(),
				cuda_driver_api_info[cbid].region);
    } else  {
      EZT_OTF2_EvtWriter_Leave( evt_writer,
				NULL,
				ezt_get_timestamp(),
				cuda_driver_api_info[cbid].region);
    }
  }
}
