/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICNAI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgChangeNameINI(char *name)

	Change the name of the application.

	This is also the basename == <appName> of the name of associated
	INI files.

	If name == NULL, the default is restored, which is "appName()".

	'name' is not duplicated into the heap!

	name must not contain any path component or extension.

	Return:
		0 on success

ob(ject): cfgChangeNameINI
su(bsystem): inifile
ty(pe): 
sy(nopsis): 
sh(ort description): Change the name of the current application
he(ader files): 
lo(ng description): Changes the name of the currently active application
	as it used by the \subsys{inifile}. By default it is the basename of the
	executable. The name of the application is also the name of the INI files
	to be opened.
pr(erequistes): The passed name must not contain neither path components nor
	extensions, meaning backslashes, forward slashes, dots and colons are
	invalid within the name.
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgicnai.c
in(itialized by): 
wa(rning): The name is not duplicated into the heap and the previous one is 
	not deallocted.\par
	Note: Expect inconsitencies if the name of the application is changed
	after the \subsys{inifile} has been initialized already.
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICNAI.C 1.4 1999/12/13 02:22:19 ska Exp ska $";
#endif

int cfgChangeNameINI(char * const name)
{	DBG_ENTER("cfgChangeNameINI", Suppl_inifile)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	if(name && strpbrk(name, "\\:/."))
		DBG_RETURN_I( CFG_ERR_ARG)

	chkHeap
	cfgi_appname = name;
	DBG_RETURN_I( 0)
}
