/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.StackLayoutPanel;

public class StackLayoutPanelParser
implements ElementParser {
    private static final String CUSTOM = "customHeader";
    private static final String HEADER = "header";
    private static final String STACK = "stack";

    public void parse(XMLElement panelElem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        JEnumType unitEnumType = writer.getOracle().findType(Style.Unit.class.getCanonicalName()).isEnum();
        String unit = panelElem.consumeAttributeWithDefault("unit", String.format("%s.%s", unitEnumType.getQualifiedSourceName(), "PX"), (JType)unitEnumType);
        writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(StackLayoutPanel.class.getName()), new String[]{unit});
        for (XMLElement stackElem : panelElem.consumeChildElements()) {
            String size;
            if (!this.isElementType(panelElem, stackElem, STACK)) {
                writer.die(stackElem, "Only <%s:%s> children are allowed.", new Object[]{panelElem.getPrefix(), STACK});
            }
            Children children = this.findChildren(stackElem, writer);
            if (children.body == null) {
                writer.die(stackElem, "Must have a child widget", new Object[0]);
            }
            if (!writer.isWidgetElement(children.body)) {
                writer.die(children.body, "Must be a widget", new Object[0]);
            }
            String childFieldName = writer.parseElementToField(children.body);
            if (children.header != null) {
                HtmlInterpreter htmlInt = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                size = children.header.consumeRequiredDoubleAttribute("size");
                String html = children.header.consumeInnerHtml((XMLElement.Interpreter)htmlInt);
                writer.addStatement("%s.add(%s, %s, true, %s);", new Object[]{fieldName, childFieldName, writer.declareTemplateCall(html), size});
                continue;
            }
            if (children.customHeader != null) {
                XMLElement headerElement = children.customHeader.consumeSingleChildElement();
                size = children.customHeader.consumeRequiredDoubleAttribute("size");
                if (!writer.isWidgetElement(headerElement)) {
                    writer.die(headerElement, "Is not a widget", new Object[0]);
                }
                String headerField = writer.parseElementToField(headerElement);
                writer.addStatement("%s.add(%s, %s, %s);", new Object[]{fieldName, childFieldName, headerField, size});
                continue;
            }
            writer.die(stackElem, "Requires either a <%1$s:%2$s> or <%1$s:%3$s>", new Object[]{stackElem.getPrefix(), HEADER, CUSTOM});
        }
    }

    private Children findChildren(final XMLElement elem, final UiBinderWriter writer) throws UnableToCompleteException {
        final Children children = new Children();
        elem.consumeChildElements((XMLElement.Interpreter)new XMLElement.Interpreter<Boolean>(){

            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (StackLayoutPanelParser.this.isElementType(elem, child, StackLayoutPanelParser.HEADER)) {
                    this.assertFirstHeader();
                    children.header = child;
                    return true;
                }
                if (StackLayoutPanelParser.this.isElementType(elem, child, StackLayoutPanelParser.CUSTOM)) {
                    this.assertFirstHeader();
                    children.customHeader = child;
                    return true;
                }
                if (children.body != null) {
                    writer.die(children.body, "May have only one body element", new Object[0]);
                }
                children.body = child;
                return true;
            }

            void assertFirstHeader() throws UnableToCompleteException {
                if (children.header != null || children.customHeader != null) {
                    writer.die(elem, "May have only one <%1$s:header> or <%1$s:customHeader>", new Object[]{elem.getPrefix()});
                }
            }
        });
        return children;
    }

    private boolean isElementType(XMLElement parent, XMLElement child, String type) {
        return parent.getNamespaceUri().equals(child.getNamespaceUri()) && type.equals(child.getLocalName());
    }

    private static class Children {
        XMLElement body;
        XMLElement header;
        XMLElement customHeader;

        private Children() {
        }
    }
}

