/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "to" locale.
 */
public class LocalizedNamesImpl_to extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AI",
        "AG",
        "FR",
        "GF",
        "PH",
        "FI",
        "FJ",
        "HT",
        "HU",
        "WS",
        "AS",
        "NL",
        "HK",
        "HN",
        "YE",
        "GR",
        "GM",
        "GH",
        "CA",
        "GA",
        "KZ",
        "QA",
        "KG",
        "GD",
        "CM",
        "KH",
        "KE",
        "KI",
        "GN",
        "GW",
        "CU",
        "KP",
        "KR",
        "CO",
        "KM",
        "CD",
        "CG",
        "CR",
        "GU",
        "GP",
        "GT",
        "KW",
        "GG",
        "GY",
        "GL",
        "HR",
        "LR",
        "LU",
        "LV",
        "LA",
        "LI",
        "LB",
        "LS",
        "LT",
        "CZ",
        "DO",
        "CF",
        "LY",
        "RE",
        "RO",
        "RW",
        "RU",
        "MO",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MC",
        "MK",
        "CI",
        "MG",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MA",
        "MD",
        "MN",
        "ME",
        "MZ",
        "CP",
        "CX",
        "IM",
        "NF",
        "BV",
        "AC",
        "MS",
        "CV",
        "NE",
        "NG",
        "NA",
        "NR",
        "NP",
        "AN",
        "NI",
        "NU",
        "NC",
        "NO",
        "NZ",
        "BS",
        "PK",
        "PY",
        "BR",
        "PW",
        "BH",
        "PA",
        "BB",
        "PG",
        "BF",
        "BI",
        "BY",
        "BE",
        "BZ",
        "PE",
        "MM",
        "BM",
        "BD",
        "BJ",
        "GB",
        "BG",
        "PL",
        "PF",
        "BO",
        "BA",
        "BW",
        "IO",
        "TF",
        "PT",
        "PS",
        "PR",
        "US",
        "BN",
        "BT",
        "EH",
        "CY",
        "JM",
        "ST",
        "SA",
        "SH",
        "KN",
        "LC",
        "MF",
        "BL",
        "PM",
        "VC",
        "JE",
        "ZM",
        "SN",
        "SM",
        "RS",
        "TD",
        "CN",
        "DE",
        "JP",
        "SL",
        "LK",
        "CL",
        "SY",
        "SK",
        "SI",
        "ZW",
        "SG",
        "GI",
        "ES",
        "DJ",
        "EA",
        "SJ",
        "JO",
        "SO",
        "GE",
        "SZ",
        "SE",
        "CH",
        "SR",
        "SD",
        "TH",
        "TW",
        "TJ",
        "TM",
        "DK",
        "TZ",
        "DG",
        "TT",
        "TL",
        "TR",
        "TK",
        "TG",
        "DM",
        "TO",
        "TA",
        "TN",
        "TV",
        "VU",
        "VA",
        "VE",
        "VN",
        "IE",
        "AF",
        "ZA",
        "IS",
        "DZ",
        "AE",
        "AL",
        "AW",
        "AM",
        "AQ",
        "AU",
        "AT",
        "AZ",
        "AR",
        "GQ",
        "EC",
        "SV",
        "ER",
        "AO",
        "AD",
        "EE",
        "IN",
        "ID",
        "IL",
        "EG",
        "IT",
        "ET",
        "UG",
        "UA",
        "IQ",
        "IR",
        "EU",
        "OM",
        "QO",
        "FO",
        "FK",
        "HM",
        "IC",
        "KY",
        "CC",
        "CK",
        "MP",
        "MH",
        "PN",
        "SC",
        "GS",
        "UM",
        "SB",
        "TC",
        "VG",
        "VI",
        "AX",
        "UY",
        "UZ",
        "WF",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Māmani");
    namesMap.put("002", "ʻAfilika");
    namesMap.put("003", "ʻAmelika tokelau");
    namesMap.put("005", "ʻAmelika tonga");
    namesMap.put("009", "ʻOsenia");
    namesMap.put("011", "ʻAfilika hihifo");
    namesMap.put("013", "ʻAmelika lotoloto");
    namesMap.put("014", "ʻAfilika hahake");
    namesMap.put("015", "ʻAfilika tokelau");
    namesMap.put("017", "ʻAfilika lotoloto");
    namesMap.put("018", "ʻAfilika fakatonga");
    namesMap.put("019", "Ongo ʻAmelika");
    namesMap.put("021", "ʻAmelika fakatokelau");
    namesMap.put("029", "Kalipiane");
    namesMap.put("030", "ʻĒsia hahake");
    namesMap.put("034", "ʻĒsia fakatonga");
    namesMap.put("035", "ʻĒsia tongahahake");
    namesMap.put("039", "ʻIulope fakatonga");
    namesMap.put("053", "ʻAositelēlia mo Nuʻusila");
    namesMap.put("054", "Melanisia");
    namesMap.put("057", "Potu fonua Mikolonisia");
    namesMap.put("061", "Polinīsia");
    namesMap.put("062", "ʻĒsia tongalotoloto");
    namesMap.put("142", "ʻĒsia");
    namesMap.put("143", "ʻĒsia lotoloto");
    namesMap.put("145", "ʻĒsia hihifo");
    namesMap.put("150", "ʻIulope");
    namesMap.put("151", "ʻIulope hahake");
    namesMap.put("154", "ʻIulope tokelau");
    namesMap.put("155", "ʻIulope hihifo");
    namesMap.put("172", "Kominiueli");
    namesMap.put("419", "ʻAmelika fakalatina mo Kalipeane");
    namesMap.put("AC", "Motu ʻAsenisini");
    namesMap.put("AD", "ʻEnitola");
    namesMap.put("AE", "ʻAlepea Fakatahataha");
    namesMap.put("AF", "ʻAfikānisitani");
    namesMap.put("AG", "Anitikua mo Palaputa");
    namesMap.put("AI", "Anikuila");
    namesMap.put("AL", "ʻAlipania");
    namesMap.put("AM", "ʻĀminia");
    namesMap.put("AN", "Netaleni ʻEnitilisi");
    namesMap.put("AO", "ʻEnikola");
    namesMap.put("AQ", "ʻAnitātika");
    namesMap.put("AR", "ʻAsenitina");
    namesMap.put("AS", "Haʻamoa ʻAmelika");
    namesMap.put("AT", "ʻAositulia");
    namesMap.put("AU", "ʻAositelēlia");
    namesMap.put("AW", "ʻAlupa");
    namesMap.put("AX", "ʻOtumotu ʻAlani");
    namesMap.put("AZ", "ʻAsapaisani");
    namesMap.put("BA", "Posinia mo Hesikōvinia");
    namesMap.put("BB", "Pāpeitosi");
    namesMap.put("BD", "Pengilātesi");
    namesMap.put("BE", "Pelesiume");
    namesMap.put("BF", "Pekano Faso");
    namesMap.put("BG", "Pokalia");
    namesMap.put("BH", "Paleini");
    namesMap.put("BI", "Pelaniti");
    namesMap.put("BJ", "Penini");
    namesMap.put("BL", "Seini Pafelemi");
    namesMap.put("BM", "Pēmuta");
    namesMap.put("BN", "Pulunei");
    namesMap.put("BO", "Polīvia");
    namesMap.put("BR", "Palāsili");
    namesMap.put("BS", "Pahama");
    namesMap.put("BT", "Pūtani");
    namesMap.put("BV", "Motu Puveti");
    namesMap.put("BW", "Potisiuana");
    namesMap.put("BY", "Pelelusi");
    namesMap.put("BZ", "Pelise");
    namesMap.put("CA", "Kānata");
    namesMap.put("CC", "ʻOtumotu Koko");
    namesMap.put("CD", "Kongo - Kinisasa");
    namesMap.put("CF", "Lipapilika ʻAfilika Lotoloto");
    namesMap.put("CG", "Kongo - Palasavila");
    namesMap.put("CH", "Suisilani");
    namesMap.put("CI", "Matafonua ʻAivili");
    namesMap.put("CK", "ʻOtumotu Kuki");
    namesMap.put("CL", "Sili");
    namesMap.put("CM", "Kemaluni");
    namesMap.put("CN", "Siaina");
    namesMap.put("CO", "Kolomipia");
    namesMap.put("CP", "Motu Kilipatoni");
    namesMap.put("CR", "Kosita Lika");
    namesMap.put("CU", "Kiupa");
    namesMap.put("CV", "Muiʻi Veti");
    namesMap.put("CX", "Motu Kilisimasi");
    namesMap.put("CY", "Saipalesi");
    namesMap.put("CZ", "Lipapilika Seki");
    namesMap.put("DE", "Siamane");
    namesMap.put("DG", "Tieko Kāsia");
    namesMap.put("DJ", "Siputi");
    namesMap.put("DK", "Tenimaʻake");
    namesMap.put("DM", "Tominika");
    namesMap.put("DO", "Lipapilika Tominika");
    namesMap.put("DZ", "ʻAisilia");
    namesMap.put("EA", "Siuta mo Melila");
    namesMap.put("EC", "ʻEkuetoa");
    namesMap.put("EE", "ʻEsitōnia");
    namesMap.put("EG", "ʻIsipite");
    namesMap.put("EH", "Sahala fakahihifo");
    namesMap.put("ER", "ʻElitulia");
    namesMap.put("ES", "Sipeini");
    namesMap.put("ET", "ʻItiōpea");
    namesMap.put("EU", "ʻIulope fakatahataha");
    namesMap.put("FI", "Finilani");
    namesMap.put("FJ", "Fisi");
    namesMap.put("FK", "ʻOtumotu Fokuleni");
    namesMap.put("FM", "Mikolonisia");
    namesMap.put("FO", "ʻOtumotu Felou");
    namesMap.put("FR", "Falanisē");
    namesMap.put("GA", "Kaponi");
    namesMap.put("GB", "Pilitānia");
    namesMap.put("GD", "Kelenatā");
    namesMap.put("GE", "Sōsia");
    namesMap.put("GF", "Falanise Kuiana");
    namesMap.put("GG", "Kuenisī");
    namesMap.put("GH", "Kana");
    namesMap.put("GI", "Sipalālitā");
    namesMap.put("GL", "Kulinileni");
    namesMap.put("GM", "Kamipia");
    namesMap.put("GN", "Kini");
    namesMap.put("GP", "Kuatalupe");
    namesMap.put("GQ", "ʻEkueta Kini");
    namesMap.put("GR", "Kalisi");
    namesMap.put("GS", "ʻOtumotu Siosia-tonga mo Saniuisi-tonga");
    namesMap.put("GT", "Kuatamala");
    namesMap.put("GU", "Kuamu");
    namesMap.put("GW", "Kini-Pisau");
    namesMap.put("GY", "Kuiana");
    namesMap.put("HK", "Hongi Kongi");
    namesMap.put("HM", "ʻOtumotu Heati mo Makitonali");
    namesMap.put("HN", "Honitulasi");
    namesMap.put("HR", "Kuloisia");
    namesMap.put("HU", "Hangakalia");
    namesMap.put("IC", "ʻOtumotu Kaneli");
    namesMap.put("ID", "ʻInitonēsia");
    namesMap.put("IE", "ʻAealani");
    namesMap.put("IL", "ʻIsileli");
    namesMap.put("IM", "Motu Mani");
    namesMap.put("IN", "ʻInitia");
    namesMap.put("IO", "Potu fonua moana ʻInitia fakapilitānia");
    namesMap.put("IQ", "ʻIulaaki");
    namesMap.put("IR", "ʻIulaani");
    namesMap.put("IS", "ʻAisilani");
    namesMap.put("IT", "ʻĪtali");
    namesMap.put("JE", "Selusī");
    namesMap.put("JM", "Samaika");
    namesMap.put("JO", "Soatane");
    namesMap.put("JP", "Siapani");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kekisiteni");
    namesMap.put("KH", "Kemipōtia");
    namesMap.put("KI", "Kilipasi");
    namesMap.put("KM", "Komolosi");
    namesMap.put("KN", "Seini Kitisi mo Nevisi");
    namesMap.put("KP", "Kōlea tokelau");
    namesMap.put("KR", "Kōlea tonga");
    namesMap.put("KW", "Kueiti");
    namesMap.put("KY", "ʻOtumotu Keimeni");
    namesMap.put("KZ", "Kasakiteni");
    namesMap.put("LA", "Lau");
    namesMap.put("LB", "Lepanoni");
    namesMap.put("LC", "Seini Lusia");
    namesMap.put("LI", "Lekitenisaini");
    namesMap.put("LK", "Silangikā");
    namesMap.put("LR", "Laipelia");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lifiuenia");
    namesMap.put("LU", "Lakisimipeki");
    namesMap.put("LV", "Lativia");
    namesMap.put("LY", "Lipia");
    namesMap.put("MA", "Molako");
    namesMap.put("MC", "Manako");
    namesMap.put("MD", "Molotova");
    namesMap.put("ME", "Monitenikalo");
    namesMap.put("MF", "Seini Matini");
    namesMap.put("MG", "Matakasika");
    namesMap.put("MH", "ʻOtumotu Māsolo");
    namesMap.put("MK", "Masitōnia");
    namesMap.put("ML", "Māli");
    namesMap.put("MM", "Pema");
    namesMap.put("MN", "Mongokōlia");
    namesMap.put("MO", "Makau");
    namesMap.put("MP", "ʻOtumotu Maliana tokelau");
    namesMap.put("MQ", "Mateniki");
    namesMap.put("MR", "Maulitenia");
    namesMap.put("MS", "Moʻungaselati");
    namesMap.put("MT", "Malita");
    namesMap.put("MU", "Maulitiusi");
    namesMap.put("MV", "Malativisi");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "Mekisikou");
    namesMap.put("MY", "Malēsia");
    namesMap.put("MZ", "Mosenipiki");
    namesMap.put("NA", "Namipia");
    namesMap.put("NC", "Niu Kaletōnia");
    namesMap.put("NE", "Naisia");
    namesMap.put("NF", "Motu Nōfoliki");
    namesMap.put("NG", "Naisilia");
    namesMap.put("NI", "Nikalakua");
    namesMap.put("NL", "Hōlani");
    namesMap.put("NO", "Noauē");
    namesMap.put("NP", "Nepali");
    namesMap.put("NR", "Naulu");
    namesMap.put("NU", "Niuē");
    namesMap.put("NZ", "Nuʻusila");
    namesMap.put("OM", "ʻOmani");
    namesMap.put("PA", "Panamā");
    namesMap.put("PE", "Pelū");
    namesMap.put("PF", "Polinisia fakafalanisē");
    namesMap.put("PG", "Papuaniukini");
    namesMap.put("PH", "Filipaini");
    namesMap.put("PK", "Pākisitani");
    namesMap.put("PL", "Poleni");
    namesMap.put("PM", "Seini Piea mo Mikaloni");
    namesMap.put("PN", "ʻOtumotu Pitikeni");
    namesMap.put("PR", "Pueto Liko");
    namesMap.put("PS", "Potu Palesitaine");
    namesMap.put("PT", "Potukali");
    namesMap.put("PY", "Palakuei");
    namesMap.put("QA", "Katā");
    namesMap.put("QO", "ʻOsenia Mamaʻo");
    namesMap.put("RE", "Liʻiunioni");
    namesMap.put("RO", "Lomēnia");
    namesMap.put("RS", "Sēpia");
    namesMap.put("RU", "Lūsia");
    namesMap.put("RW", "Luanitā");
    namesMap.put("SA", "Saute ʻAlepea");
    namesMap.put("SB", "ʻOtumotu Solomone");
    namesMap.put("SC", "ʻOtumotu Seiseli");
    namesMap.put("SD", "Sūteni");
    namesMap.put("SE", "Suēteni");
    namesMap.put("SG", "Singapoa");
    namesMap.put("SH", "Seini Helena");
    namesMap.put("SI", "Silōvenia");
    namesMap.put("SJ", "Sivolopaati mo Seni Meini");
    namesMap.put("SK", "Silōvakia");
    namesMap.put("SL", "Siela Lione");
    namesMap.put("SM", "Seni Malino");
    namesMap.put("SN", "Senikalo");
    namesMap.put("SO", "Sōmalia");
    namesMap.put("SR", "Sulinami");
    namesMap.put("ST", "Sao Tome mo Pilinisipe");
    namesMap.put("SV", "ʻEle Salavatoa");
    namesMap.put("SY", "Sīlia");
    namesMap.put("SZ", "Suasileni");
    namesMap.put("TA", "Tulisiteni ta Kunuha");
    namesMap.put("TC", "ʻOtumotu Teki mo Keikosi");
    namesMap.put("TD", "Seti");
    namesMap.put("TF", "Potu fonua tonga fakafalanisē");
    namesMap.put("TG", "Toko");
    namesMap.put("TH", "Taileni");
    namesMap.put("TJ", "Tasikitani");
    namesMap.put("TL", "Timoa Hahake");
    namesMap.put("TM", "Tekimenisiteni");
    namesMap.put("TN", "Tunīsia");
    namesMap.put("TR", "Toake");
    namesMap.put("TT", "Tilinitati mo Topako");
    namesMap.put("TV", "Tūvalu");
    namesMap.put("TW", "Taiuani");
    namesMap.put("TZ", "Tenisania");
    namesMap.put("UA", "ʻIukuleini");
    namesMap.put("UG", "ʻIukanitā");
    namesMap.put("UM", "ʻOtumotu siʻi ʻo ʻAmelika");
    namesMap.put("US", "Puleʻanga fakatahataha ʻAmelika");
    namesMap.put("UY", "ʻUlukuei");
    namesMap.put("UZ", "ʻUsipekitēni");
    namesMap.put("VA", "Vatikani");
    namesMap.put("VC", "Seini Viniseni mo Kulenatini");
    namesMap.put("VE", "Venisuela");
    namesMap.put("VG", "ʻOtumotu Vilikini fakapilitānia");
    namesMap.put("VI", "ʻOtumotu Vilikini fakaʻamelika");
    namesMap.put("VN", "Vietinemi");
    namesMap.put("WF", "ʻUvea mo Futuna");
    namesMap.put("WS", "Haʻamoa");
    namesMap.put("YE", "Iemeni");
    namesMap.put("YT", "Meioti");
    namesMap.put("ZA", "ʻAfilika tonga");
    namesMap.put("ZM", "Semipia");
    namesMap.put("ZW", "Simipapuei");
    namesMap.put("ZZ", "Potu fonua taʻeʻiloa pe hala");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Māmani",
        "002": "ʻAfilika",
        "003": "ʻAmelika tokelau",
        "005": "ʻAmelika tonga",
        "009": "ʻOsenia",
        "011": "ʻAfilika hihifo",
        "013": "ʻAmelika lotoloto",
        "014": "ʻAfilika hahake",
        "015": "ʻAfilika tokelau",
        "017": "ʻAfilika lotoloto",
        "018": "ʻAfilika fakatonga",
        "019": "Ongo ʻAmelika",
        "021": "ʻAmelika fakatokelau",
        "029": "Kalipiane",
        "030": "ʻĒsia hahake",
        "034": "ʻĒsia fakatonga",
        "035": "ʻĒsia tongahahake",
        "039": "ʻIulope fakatonga",
        "053": "ʻAositelēlia mo Nuʻusila",
        "054": "Melanisia",
        "057": "Potu fonua Mikolonisia",
        "061": "Polinīsia",
        "062": "ʻĒsia tongalotoloto",
        "142": "ʻĒsia",
        "143": "ʻĒsia lotoloto",
        "145": "ʻĒsia hihifo",
        "150": "ʻIulope",
        "151": "ʻIulope hahake",
        "154": "ʻIulope tokelau",
        "155": "ʻIulope hihifo",
        "172": "Kominiueli",
        "419": "ʻAmelika fakalatina mo Kalipeane",
        "AC": "Motu ʻAsenisini",
        "AD": "ʻEnitola",
        "AE": "ʻAlepea Fakatahataha",
        "AF": "ʻAfikānisitani",
        "AG": "Anitikua mo Palaputa",
        "AI": "Anikuila",
        "AL": "ʻAlipania",
        "AM": "ʻĀminia",
        "AN": "Netaleni ʻEnitilisi",
        "AO": "ʻEnikola",
        "AQ": "ʻAnitātika",
        "AR": "ʻAsenitina",
        "AS": "Haʻamoa ʻAmelika",
        "AT": "ʻAositulia",
        "AU": "ʻAositelēlia",
        "AW": "ʻAlupa",
        "AX": "ʻOtumotu ʻAlani",
        "AZ": "ʻAsapaisani",
        "BA": "Posinia mo Hesikōvinia",
        "BB": "Pāpeitosi",
        "BD": "Pengilātesi",
        "BE": "Pelesiume",
        "BF": "Pekano Faso",
        "BG": "Pokalia",
        "BH": "Paleini",
        "BI": "Pelaniti",
        "BJ": "Penini",
        "BL": "Seini Pafelemi",
        "BM": "Pēmuta",
        "BN": "Pulunei",
        "BO": "Polīvia",
        "BR": "Palāsili",
        "BS": "Pahama",
        "BT": "Pūtani",
        "BV": "Motu Puveti",
        "BW": "Potisiuana",
        "BY": "Pelelusi",
        "BZ": "Pelise",
        "CA": "Kānata",
        "CC": "ʻOtumotu Koko",
        "CD": "Kongo - Kinisasa",
        "CF": "Lipapilika ʻAfilika Lotoloto",
        "CG": "Kongo - Palasavila",
        "CH": "Suisilani",
        "CI": "Matafonua ʻAivili",
        "CK": "ʻOtumotu Kuki",
        "CL": "Sili",
        "CM": "Kemaluni",
        "CN": "Siaina",
        "CO": "Kolomipia",
        "CP": "Motu Kilipatoni",
        "CR": "Kosita Lika",
        "CU": "Kiupa",
        "CV": "Muiʻi Veti",
        "CX": "Motu Kilisimasi",
        "CY": "Saipalesi",
        "CZ": "Lipapilika Seki",
        "DE": "Siamane",
        "DG": "Tieko Kāsia",
        "DJ": "Siputi",
        "DK": "Tenimaʻake",
        "DM": "Tominika",
        "DO": "Lipapilika Tominika",
        "DZ": "ʻAisilia",
        "EA": "Siuta mo Melila",
        "EC": "ʻEkuetoa",
        "EE": "ʻEsitōnia",
        "EG": "ʻIsipite",
        "EH": "Sahala fakahihifo",
        "ER": "ʻElitulia",
        "ES": "Sipeini",
        "ET": "ʻItiōpea",
        "EU": "ʻIulope fakatahataha",
        "FI": "Finilani",
        "FJ": "Fisi",
        "FK": "ʻOtumotu Fokuleni",
        "FM": "Mikolonisia",
        "FO": "ʻOtumotu Felou",
        "FR": "Falanisē",
        "GA": "Kaponi",
        "GB": "Pilitānia",
        "GD": "Kelenatā",
        "GE": "Sōsia",
        "GF": "Falanise Kuiana",
        "GG": "Kuenisī",
        "GH": "Kana",
        "GI": "Sipalālitā",
        "GL": "Kulinileni",
        "GM": "Kamipia",
        "GN": "Kini",
        "GP": "Kuatalupe",
        "GQ": "ʻEkueta Kini",
        "GR": "Kalisi",
        "GS": "ʻOtumotu Siosia-tonga mo Saniuisi-tonga",
        "GT": "Kuatamala",
        "GU": "Kuamu",
        "GW": "Kini-Pisau",
        "GY": "Kuiana",
        "HK": "Hongi Kongi",
        "HM": "ʻOtumotu Heati mo Makitonali",
        "HN": "Honitulasi",
        "HR": "Kuloisia",
        "HU": "Hangakalia",
        "IC": "ʻOtumotu Kaneli",
        "ID": "ʻInitonēsia",
        "IE": "ʻAealani",
        "IL": "ʻIsileli",
        "IM": "Motu Mani",
        "IN": "ʻInitia",
        "IO": "Potu fonua moana ʻInitia fakapilitānia",
        "IQ": "ʻIulaaki",
        "IR": "ʻIulaani",
        "IS": "ʻAisilani",
        "IT": "ʻĪtali",
        "JE": "Selusī",
        "JM": "Samaika",
        "JO": "Soatane",
        "JP": "Siapani",
        "KE": "Kenia",
        "KG": "Kekisiteni",
        "KH": "Kemipōtia",
        "KI": "Kilipasi",
        "KM": "Komolosi",
        "KN": "Seini Kitisi mo Nevisi",
        "KP": "Kōlea tokelau",
        "KR": "Kōlea tonga",
        "KW": "Kueiti",
        "KY": "ʻOtumotu Keimeni",
        "KZ": "Kasakiteni",
        "LA": "Lau",
        "LB": "Lepanoni",
        "LC": "Seini Lusia",
        "LI": "Lekitenisaini",
        "LK": "Silangikā",
        "LR": "Laipelia",
        "LS": "Lesoto",
        "LT": "Lifiuenia",
        "LU": "Lakisimipeki",
        "LV": "Lativia",
        "LY": "Lipia",
        "MA": "Molako",
        "MC": "Manako",
        "MD": "Molotova",
        "ME": "Monitenikalo",
        "MF": "Seini Matini",
        "MG": "Matakasika",
        "MH": "ʻOtumotu Māsolo",
        "MK": "Masitōnia",
        "ML": "Māli",
        "MM": "Pema",
        "MN": "Mongokōlia",
        "MO": "Makau",
        "MP": "ʻOtumotu Maliana tokelau",
        "MQ": "Mateniki",
        "MR": "Maulitenia",
        "MS": "Moʻungaselati",
        "MT": "Malita",
        "MU": "Maulitiusi",
        "MV": "Malativisi",
        "MW": "Malaui",
        "MX": "Mekisikou",
        "MY": "Malēsia",
        "MZ": "Mosenipiki",
        "NA": "Namipia",
        "NC": "Niu Kaletōnia",
        "NE": "Naisia",
        "NF": "Motu Nōfoliki",
        "NG": "Naisilia",
        "NI": "Nikalakua",
        "NL": "Hōlani",
        "NO": "Noauē",
        "NP": "Nepali",
        "NR": "Naulu",
        "NU": "Niuē",
        "NZ": "Nuʻusila",
        "OM": "ʻOmani",
        "PA": "Panamā",
        "PE": "Pelū",
        "PF": "Polinisia fakafalanisē",
        "PG": "Papuaniukini",
        "PH": "Filipaini",
        "PK": "Pākisitani",
        "PL": "Poleni",
        "PM": "Seini Piea mo Mikaloni",
        "PN": "ʻOtumotu Pitikeni",
        "PR": "Pueto Liko",
        "PS": "Potu Palesitaine",
        "PT": "Potukali",
        "PY": "Palakuei",
        "QA": "Katā",
        "QO": "ʻOsenia Mamaʻo",
        "RE": "Liʻiunioni",
        "RO": "Lomēnia",
        "RS": "Sēpia",
        "RU": "Lūsia",
        "RW": "Luanitā",
        "SA": "Saute ʻAlepea",
        "SB": "ʻOtumotu Solomone",
        "SC": "ʻOtumotu Seiseli",
        "SD": "Sūteni",
        "SE": "Suēteni",
        "SG": "Singapoa",
        "SH": "Seini Helena",
        "SI": "Silōvenia",
        "SJ": "Sivolopaati mo Seni Meini",
        "SK": "Silōvakia",
        "SL": "Siela Lione",
        "SM": "Seni Malino",
        "SN": "Senikalo",
        "SO": "Sōmalia",
        "SR": "Sulinami",
        "ST": "Sao Tome mo Pilinisipe",
        "SV": "ʻEle Salavatoa",
        "SY": "Sīlia",
        "SZ": "Suasileni",
        "TA": "Tulisiteni ta Kunuha",
        "TC": "ʻOtumotu Teki mo Keikosi",
        "TD": "Seti",
        "TF": "Potu fonua tonga fakafalanisē",
        "TG": "Toko",
        "TH": "Taileni",
        "TJ": "Tasikitani",
        "TL": "Timoa Hahake",
        "TM": "Tekimenisiteni",
        "TN": "Tunīsia",
        "TR": "Toake",
        "TT": "Tilinitati mo Topako",
        "TV": "Tūvalu",
        "TW": "Taiuani",
        "TZ": "Tenisania",
        "UA": "ʻIukuleini",
        "UG": "ʻIukanitā",
        "UM": "ʻOtumotu siʻi ʻo ʻAmelika",
        "US": "Puleʻanga fakatahataha ʻAmelika",
        "UY": "ʻUlukuei",
        "UZ": "ʻUsipekitēni",
        "VA": "Vatikani",
        "VC": "Seini Viniseni mo Kulenatini",
        "VE": "Venisuela",
        "VG": "ʻOtumotu Vilikini fakapilitānia",
        "VI": "ʻOtumotu Vilikini fakaʻamelika",
        "VN": "Vietinemi",
        "WF": "ʻUvea mo Futuna",
        "WS": "Haʻamoa",
        "YE": "Iemeni",
        "YT": "Meioti",
        "ZA": "ʻAfilika tonga",
        "ZM": "Semipia",
        "ZW": "Simipapuei",
        "ZZ": "Potu fonua taʻeʻiloa pe hala"
    };
  }-*/;
}
