## RabbitMQ 3.8.7

RabbitMQ `3.8.7` is a maintenance release that patches
a security vulnerability.

RabbitMQ Core team would like to thank Ofir Hamam and Tomer Hadad at Ernst & Young's Hacktics Advanced Security Center
for researching and responsibly disclosing the vulnerability addressed in this release.

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.3` or `23.0` releases are recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release from `3.7.6` or an older version, extra care has to be taken.

Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` first, then Erlang 22.x or 23.x, then RabbitMQ to most recent
3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * Addressed a Windows-specific binary planting security vulnerability [CVE-2020-5419](https://tanzu.vmware.com/security/cve-2020-5419) that allowed for arbitrary code execution.
   The vulnerability requires the attacker to have local access and elevated privileges,
   and cannot be executed remotely.

   [CVSS score](https://www.first.org/cvss/calculator/3.0#CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H): `6.7` (medium severity).

   This vulnerability was researched and [responsibly disclosed](https://www.rabbitmq.com/contact.html#security) by
   Ofir Hamam and Tomer Hadad at Ernst & Young's Hacktics Advanced Security Center.

 * In a mixed version cluster, virtual host limits were incorrectly reported for yet-to-be-upgraded nodes.

   Contributed by @mnxumalo.

   GitHub issue: [rabbitmq/rabbitmq-server#2430](https://github.com/rabbitmq/rabbitmq-server/pull/2430)


### CLI Tools

#### Bug Fixes

 * Definition export using `rabbitmqctl export_definitions` exported [optional queue arguments](https://www.rabbitmq.com/queues.html#optional-arguments) as blank.
   Export performed via the HTTP API was not affected by this problem.

   GitHub issue: [rabbitmq/rabbitmq-server#2427](https://github.com/rabbitmq/rabbitmq-server/issues/2427)

 * Invoking `rabbitmqctl` (or other tools) without any arguments produced help output that was inconsistent
    from `rabbitmqctl help` in line spacing.


### Federation Plugin

#### Bug Fixes

 * Links in some environments upgraded from earlier `3.8.x` versions could run into a data coercion exception
   when connection credentials were unencrypted.

   GitHub issue: [rabbitmq/rabbitmq-federation#112](https://github.com/rabbitmq/rabbitmq-federation/pull/112)


### Shovel Plugin

#### Bug Fixes

 * Shovels where the source is AMQP 1.0 endpoint now gracefully handle link detachment
   if the remote end set the `closed` attribute to `false`.

   Contributed by @tstorck.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#56](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/pull/56)

 * Removed some debug logging that was unintentionally polluting standard output even when
   debug logging was not enabled.

   Contributed by @sircinek.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0-client#54](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/pull/54)


## Dependency Upgrades

 * `credentials_obfuscation` was upgraded [from 2.1.1 to 2.2.0](https://github.com/rabbitmq/credentials-obfuscation/compare/v2.1.1...v2.2.0)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.7.tar.xz`.
