/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.svg.io.SVGInputFormat;
import org.jhotdraw.samples.svg.io.SVGZInputFormat;

public class SVGCreateFromFileTool
extends CreationTool {
    protected FileDialog fileDialog;
    protected JFileChooser fileChooser;
    protected Thread workerThread;
    protected CompositeFigure groupPrototype;
    protected ImageHolderFigure imagePrototype;
    protected boolean useFileDialog;

    public SVGCreateFromFileTool(ImageHolderFigure imageHolderFigure, CompositeFigure compositeFigure) {
        super(imageHolderFigure);
        this.groupPrototype = compositeFigure;
        this.imagePrototype = imageHolderFigure;
    }

    public SVGCreateFromFileTool(ImageHolderFigure imageHolderFigure, CompositeFigure compositeFigure, Map<AttributeKey, Object> map) {
        super(imageHolderFigure, map);
        this.groupPrototype = compositeFigure;
        this.imagePrototype = imageHolderFigure;
    }

    public void setUseFileDialog(boolean bl) {
        this.useFileDialog = bl;
        if (this.useFileDialog) {
            this.fileChooser = null;
        } else {
            this.fileDialog = null;
        }
    }

    public boolean isUseFileDialog() {
        return this.useFileDialog;
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        File file;
        super.activate(drawingEditor);
        if (this.workerThread != null) {
            try {
                this.workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.useFileDialog) {
            this.getFileDialog().setVisible(true);
            file = this.getFileDialog().getFile() != null ? new File(this.getFileDialog().getDirectory(), this.getFileDialog().getFile()) : null;
        } else {
            file = this.getFileChooser().showOpenDialog(this.getView().getComponent()) == 0 ? this.getFileChooser().getSelectedFile() : null;
        }
        if (file != null) {
            Worker<Drawing> worker;
            if (file.getName().toLowerCase().endsWith(".svg") || file.getName().toLowerCase().endsWith(".svgz")) {
                this.prototype = (Figure)this.groupPrototype.clone();
                worker = new Worker<Drawing>(){

                    @Override
                    public Drawing construct() throws IOException {
                        DefaultDrawing defaultDrawing = new DefaultDrawing();
                        SVGInputFormat sVGInputFormat = file.getName().toLowerCase().endsWith(".svg") ? new SVGInputFormat() : new SVGZInputFormat();
                        sVGInputFormat.read(file, defaultDrawing);
                        return defaultDrawing;
                    }

                    @Override
                    protected void done(Drawing drawing) {
                        if (SVGCreateFromFileTool.this.createdFigure == null) {
                            CompositeFigure compositeFigure = (CompositeFigure)SVGCreateFromFileTool.this.prototype;
                            for (Figure figure : drawing.getChildren()) {
                                compositeFigure.basicAdd(figure);
                            }
                        } else {
                            CompositeFigure compositeFigure = (CompositeFigure)SVGCreateFromFileTool.this.createdFigure;
                            compositeFigure.willChange();
                            for (Figure figure : drawing.getChildren()) {
                                compositeFigure.add(figure);
                            }
                            compositeFigure.changed();
                        }
                    }

                    @Override
                    protected void failed(Throwable throwable) {
                        JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), throwable.getMessage(), null, 0);
                        SVGCreateFromFileTool.this.getDrawing().remove(SVGCreateFromFileTool.this.createdFigure);
                        SVGCreateFromFileTool.this.fireToolDone();
                    }

                    @Override
                    protected void finished() {
                    }
                };
            } else {
                this.prototype = this.imagePrototype;
                final ImageHolderFigure imageHolderFigure = (ImageHolderFigure)this.prototype.clone();
                worker = new Worker(){

                    protected Object construct() throws IOException {
                        imageHolderFigure.loadImage(file);
                        return null;
                    }

                    protected void done(Object object) {
                        try {
                            if (SVGCreateFromFileTool.this.createdFigure == null) {
                                ((ImageHolderFigure)SVGCreateFromFileTool.this.prototype).setImage(imageHolderFigure.getImageData(), imageHolderFigure.getBufferedImage());
                            } else {
                                ((ImageHolderFigure)SVGCreateFromFileTool.this.createdFigure).setImage(imageHolderFigure.getImageData(), imageHolderFigure.getBufferedImage());
                            }
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), iOException.getMessage(), null, 0);
                        }
                    }

                    @Override
                    protected void failed(Throwable throwable) {
                        JOptionPane.showMessageDialog(SVGCreateFromFileTool.this.getView().getComponent(), throwable.getMessage(), null, 0);
                        SVGCreateFromFileTool.this.getDrawing().remove(SVGCreateFromFileTool.this.createdFigure);
                        SVGCreateFromFileTool.this.fireToolDone();
                    }
                };
            }
            this.workerThread = new Thread(worker);
            this.workerThread.start();
        } else if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    protected Figure createFigure() {
        if (this.prototype instanceof CompositeFigure) {
            return (Figure)this.prototype.clone();
        }
        return super.createFigure();
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }

    private FileDialog getFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(new Frame());
        }
        return this.fileDialog;
    }
}

