/*
 * Copyright © 2021 Igalia S.L.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "tu_private.h"
#include "tu_perfetto.h"

/* Including tu_private.h in tu_perfetto.cc doesn't work, so
 * we need some helper methods to access tu_device.
 */

struct tu_perfetto_state *
tu_device_get_perfetto_state(struct tu_device *dev)
{
    return &dev->perfetto;
}

int
tu_device_get_timestamp(struct tu_device *dev,
                     uint64_t *ts)
{
    return tu_drm_get_timestamp(dev->physical_device, ts);
}

uint32_t
tu_u_trace_flush_data_get_submit_id(const struct tu_u_trace_flush_data *data)
{
    return data->submission_id;
}
