/*
 * test-desktop-infos.c
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>
#include <glib/gprintf.h>
#include <gio/gio.h>

#include "unity-webapps-desktop-infos.h"
#include "unity-webapps-debug.h"

static void
test_desktop_basename_onename_nospaces (void)
{
  const gchar * name = "simplename";
  const gchar * domain = "my.simple.domain";
  g_assert_cmpstr ("simplenamemysimpledomain",
                   ==,
                   unity_webapps_desktop_infos_build_desktop_basename (name, domain));
}

static void
test_desktop_basename_onename_spaces (void)
{
  const gchar * name = "simpl\t\ten ame";
  const gchar * domain = "my.simple.domain";
  g_assert_cmpstr ("simplenamemysimpledomain",
                   ==,
                   unity_webapps_desktop_infos_build_desktop_basename (name, domain));
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);

  g_test_add_func("/DesktopInfos/Basic/OneName/NoSpaces",
                  test_desktop_basename_onename_nospaces);

  g_test_add_func("/DesktopInfos/Basic/OneName/Spaces",
                  test_desktop_basename_onename_spaces);

  return g_test_run ();
}
