/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-interest-tracker.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_INTEREST_TRACKER_H
#define __UNITY_WEBAPPS_INTEREST_TRACKER_H


#define UNITY_WEBAPPS_TYPE_INTEREST_TRACKER              (unity_webapps_interest_tracker_get_type())
#define UNITY_WEBAPPS_INTEREST_TRACKER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_INTEREST_TRACKER, UnityWebappsInterestTracker))
#define UNITY_WEBAPPS_INTEREST_TRACKER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_INTEREST_TRACKER, UnityWebappsInterestTrackerClass))
#define UNITY_WEBAPPS_IS_INTEREST_TRACKER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_INTEREST_TRACKER))
#define UNITY_WEBAPPS_IS_INTEREST_TRACKER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_INTEREST_TRACKER))
#define UNITY_WEBAPPS_INTEREST_TRACKER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_INTEREST_TRACKER, UnityWebappsInterestTrackerClass))

#include "unity-webapps-window-tracker.h"
#include "unity-webapps-interest-manager.h"

typedef struct _UnityWebappsInterestTrackerPrivate UnityWebappsInterestTrackerPrivate;

typedef struct _UnityWebappsInterestTracker UnityWebappsInterestTracker;

struct _UnityWebappsInterestTracker {
	GObject object;

	UnityWebappsInterestTrackerPrivate *priv;
};

typedef struct _UnityWebappsInterestTrackerClass UnityWebappsInterestTrackerClass;

struct _UnityWebappsInterestTrackerClass
{
	GObjectClass parent_class;
};

GType unity_webapps_interest_tracker_get_type (void) G_GNUC_CONST;

UnityWebappsInterestTracker *unity_webapps_interest_tracker_new (UnityWebappsWindowTracker *window_tracker, UnityWebappsInterestManager *interest_manager);

gint unity_webapps_interest_tracker_get_most_recent_interest (UnityWebappsInterestTracker *tracker);
GList* unity_webapps_interest_tracker_get_most_recent_interests (UnityWebappsInterestTracker *tracker);
gboolean unity_webapps_interest_tracker_get_interest_is_active (UnityWebappsInterestTracker *tracker,
																gint interest_id);

void unity_webapps_interest_tracker_raise_most_recent (UnityWebappsInterestTracker *tracker, guint32 timestamp);
UnityWebappsInterestManager *unity_webapps_interest_tracker_get_interest_manager (UnityWebappsInterestTracker *tracker);



#endif
