/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <algorithm>

#include "EBOOKMemoryStream.h"

namespace libebook
{

EBOOKMemoryStream::EBOOKMemoryStream(const unsigned char *data, unsigned length)
  : m_data(0)
  , m_length(length)
  , m_pos(0)
{
  unsigned char *buffer = new unsigned char[length];
  std::copy(data, data + length, buffer);
  m_data = buffer;
}

EBOOKMemoryStream::~EBOOKMemoryStream()
{
  delete[] m_data;
}

bool EBOOKMemoryStream::isOLEStream()
{
  return false;
}

WPXInputStream *EBOOKMemoryStream::getDocumentOLEStream(const char *)
{
  return 0;
}

const unsigned char *EBOOKMemoryStream::read(unsigned long numBytes, unsigned long &numBytesRead) try
{
  numBytesRead = 0;

  if (0 == numBytes)
    return 0;

  if ((m_pos + numBytes) >= static_cast<unsigned long>(m_length))
    numBytes = static_cast<unsigned long>(m_length - m_pos);

  const long oldPos = m_pos;
  m_pos += numBytes;

  numBytesRead = numBytes;
  return m_data + oldPos;
}
catch (...)
{
  return 0;
}

int EBOOKMemoryStream::seek(const long offset, WPX_SEEK_TYPE seekType) try
{
  long pos = 0;
  switch (seekType)
  {
  case WPX_SEEK_SET :
    pos = offset;
    break;
  case WPX_SEEK_CUR :
    pos = offset + m_pos;
    break;
  case WPX_SEEK_END :
    pos = offset + m_length;
    break;
  default :
    return -1;
  }

  if ((pos < 0) || (pos > m_length))
    return 1;

  m_pos = pos;
  return 0;
}
catch (...)
{
  return -1;
}

long EBOOKMemoryStream::tell()
{
  return m_pos;
}

bool EBOOKMemoryStream::atEOS()
{
  return m_length == m_pos;
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
