/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.util.Arrays;

final class BitList
implements Cloneable {
    private int[] mData;

    public BitList(int capacity) {
        this.mData = new int[capacity + 31 >> 5];
    }

    public boolean get(int index) {
        return (this.mData[index >> 5] & Integer.MIN_VALUE >>> index) != 0;
    }

    public boolean set(int index) {
        int i = index >> 5;
        int v = this.mData[i];
        this.mData[i] = v | Integer.MIN_VALUE >>> index;
        return v != this.mData[i];
    }

    public boolean or(BitList list) {
        boolean changes = this.ensureCapacity(list.capacity());
        int i = list.mData.length;
        while (--i >= 0) {
            int v = this.mData[i];
            this.mData[i] = v | list.mData[i];
            changes |= v != this.mData[i];
        }
        return changes;
    }

    public boolean isAllClear() {
        int i = this.mData.length;
        while (--i >= 0) {
            if (this.mData[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isAllSet() {
        int i = this.mData.length;
        while (--i >= 0) {
            if (this.mData[i] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(BitList list) {
        if (list != null) {
            int i = Math.min(this.mData.length, list.mData.length);
            while (--i >= 0) {
                int v1 = this.mData[i];
                int v2 = list.mData[i];
                if ((v1 | v2) == (v1 ^ v2)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        int i = this.mData.length;
        while (--i >= 0) {
            hash = hash * 31 + this.mData[i];
        }
        return hash;
    }

    public int capacity() {
        return this.mData.length << 5;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitList) {
            return Arrays.equals(this.mData, ((BitList)obj).mData);
        }
        return false;
    }

    public BitList copy() {
        return (BitList)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.mData.length + 2);
        buf.append('[');
        for (int i = 0; i < this.mData.length; ++i) {
            String binary = Integer.toBinaryString(this.mData[i]);
            for (int j = binary.length(); j < 32; ++j) {
                buf.append('0');
            }
            buf.append(binary);
        }
        buf.append(']');
        return buf.toString();
    }

    private boolean ensureCapacity(int capacity) {
        int len = capacity + 31 >> 5;
        if (len > this.mData.length) {
            int[] newData = new int[len];
            System.arraycopy(this.mData, 0, newData, 0, this.mData.length);
            this.mData = newData;
            return true;
        }
        return false;
    }
}

