//===-- lldb-arm64-register-enums.h -----------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#ifndef lldb_arm64_register_enums_h
#define lldb_arm64_register_enums_h

namespace lldb_private
{
    // LLDB register codes (e.g. RegisterKind == eRegisterKindLLDB)

    //---------------------------------------------------------------------------
    // Internal codes for all ARM64 registers.
    //---------------------------------------------------------------------------
    enum
    {
        k_first_gpr_arm64,
        gpr_x0_arm64 = k_first_gpr_arm64,
        gpr_x1_arm64,
        gpr_x2_arm64,
        gpr_x3_arm64,
        gpr_x4_arm64,
        gpr_x5_arm64,
        gpr_x6_arm64,
        gpr_x7_arm64,
        gpr_x8_arm64,
        gpr_x9_arm64,
        gpr_x10_arm64,
        gpr_x11_arm64,
        gpr_x12_arm64,
        gpr_x13_arm64,
        gpr_x14_arm64,
        gpr_x15_arm64,
        gpr_x16_arm64,
        gpr_x17_arm64,
        gpr_x18_arm64,
        gpr_x19_arm64,
        gpr_x20_arm64,
        gpr_x21_arm64,
        gpr_x22_arm64,
        gpr_x23_arm64,
        gpr_x24_arm64,
        gpr_x25_arm64,
        gpr_x26_arm64,
        gpr_x27_arm64,
        gpr_x28_arm64,
        gpr_fp_arm64,
        gpr_lr_arm64,
        gpr_sp_arm64,
        gpr_pc_arm64,
        gpr_cpsr_arm64,

        k_last_gpr_arm64 = gpr_cpsr_arm64,

        k_first_fpr_arm64,
        fpu_v0_arm64 = k_first_fpr_arm64,
        fpu_v1_arm64,
        fpu_v2_arm64,
        fpu_v3_arm64,
        fpu_v4_arm64,
        fpu_v5_arm64,
        fpu_v6_arm64,
        fpu_v7_arm64,
        fpu_v8_arm64,
        fpu_v9_arm64,
        fpu_v10_arm64,
        fpu_v11_arm64,
        fpu_v12_arm64,
        fpu_v13_arm64,
        fpu_v14_arm64,
        fpu_v15_arm64,
        fpu_v16_arm64,
        fpu_v17_arm64,
        fpu_v18_arm64,
        fpu_v19_arm64,
        fpu_v20_arm64,
        fpu_v21_arm64,
        fpu_v22_arm64,
        fpu_v23_arm64,
        fpu_v24_arm64,
        fpu_v25_arm64,
        fpu_v26_arm64,
        fpu_v27_arm64,
        fpu_v28_arm64,
        fpu_v29_arm64,
        fpu_v30_arm64,
        fpu_v31_arm64,
        fpu_fpsr_arm64,
        fpu_fpcr_arm64,
        k_last_fpr_arm64 = fpu_fpcr_arm64,

        exc_far_arm64,
        exc_esr_arm64,
        exc_exception_arm64,

        dbg_bvr0_arm64,
        dbg_bvr1_arm64,
        dbg_bvr2_arm64,
        dbg_bvr3_arm64,
        dbg_bvr4_arm64,
        dbg_bvr5_arm64,
        dbg_bvr6_arm64,
        dbg_bvr7_arm64,
        dbg_bvr8_arm64,
        dbg_bvr9_arm64,
        dbg_bvr10_arm64,
        dbg_bvr11_arm64,
        dbg_bvr12_arm64,
        dbg_bvr13_arm64,
        dbg_bvr14_arm64,
        dbg_bvr15_arm64,
        dbg_bcr0_arm64,
        dbg_bcr1_arm64,
        dbg_bcr2_arm64,
        dbg_bcr3_arm64,
        dbg_bcr4_arm64,
        dbg_bcr5_arm64,
        dbg_bcr6_arm64,
        dbg_bcr7_arm64,
        dbg_bcr8_arm64,
        dbg_bcr9_arm64,
        dbg_bcr10_arm64,
        dbg_bcr11_arm64,
        dbg_bcr12_arm64,
        dbg_bcr13_arm64,
        dbg_bcr14_arm64,
        dbg_bcr15_arm64,
        dbg_wvr0_arm64,
        dbg_wvr1_arm64,
        dbg_wvr2_arm64,
        dbg_wvr3_arm64,
        dbg_wvr4_arm64,
        dbg_wvr5_arm64,
        dbg_wvr6_arm64,
        dbg_wvr7_arm64,
        dbg_wvr8_arm64,
        dbg_wvr9_arm64,
        dbg_wvr10_arm64,
        dbg_wvr11_arm64,
        dbg_wvr12_arm64,
        dbg_wvr13_arm64,
        dbg_wvr14_arm64,
        dbg_wvr15_arm64,
        dbg_wcr0_arm64,
        dbg_wcr1_arm64,
        dbg_wcr2_arm64,
        dbg_wcr3_arm64,
        dbg_wcr4_arm64,
        dbg_wcr5_arm64,
        dbg_wcr6_arm64,
        dbg_wcr7_arm64,
        dbg_wcr8_arm64,
        dbg_wcr9_arm64,
        dbg_wcr10_arm64,
        dbg_wcr11_arm64,
        dbg_wcr12_arm64,
        dbg_wcr13_arm64,
        dbg_wcr14_arm64,
        dbg_wcr15_arm64,

        k_num_registers_arm64,
        k_num_gpr_registers_arm64 = k_last_gpr_arm64 - k_first_gpr_arm64 + 1,
        k_num_fpr_registers_arm64 = k_last_fpr_arm64 - k_first_fpr_arm64 + 1
    };
}

#endif // #ifndef lldb_arm64_register_enums_h
