/*
 * Copyright (c) 2017-2022 ARM Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#pragma once

namespace mali_userspace
{
enum MaliCounterBlockName
{
	MALI_NAME_BLOCK_JM     = 0,
	MALI_NAME_BLOCK_TILER  = 1,
	MALI_NAME_BLOCK_SHADER = 2,
	MALI_NAME_BLOCK_MMU    = 3
};

enum
{
	MALI_NAME_BLOCK_SIZE = 64
};

/*
 * "Short names" for hardware counters used by Streamline. Counters names are
 * stored in accordance with their memory layout in the binary counter block
 * emitted by the Mali GPU. Each "master" in the GPU emits a fixed-size block
 * of 64 counters, and each GPU implements the same set of "masters" although
 * the counters each master exposes within its block of 64 may vary.
 *
 * Counters which are an empty string are simply "holes" in the counter memory
 * where no counter exists.
 */

static const char *const hardware_counters_mali_t60x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T60x_MESSAGES_SENT",
	"T60x_MESSAGES_RECEIVED",
	"T60x_GPU_ACTIVE",
	"T60x_IRQ_ACTIVE",
	"T60x_JS0_JOBS",
	"T60x_JS0_TASKS",
	"T60x_JS0_ACTIVE",
	"",
	"T60x_JS0_WAIT_READ",
	"T60x_JS0_WAIT_ISSUE",
	"T60x_JS0_WAIT_DEPEND",
	"T60x_JS0_WAIT_FINISH",
	"T60x_JS1_JOBS",
	"T60x_JS1_TASKS",
	"T60x_JS1_ACTIVE",
	"",
	"T60x_JS1_WAIT_READ",
	"T60x_JS1_WAIT_ISSUE",
	"T60x_JS1_WAIT_DEPEND",
	"T60x_JS1_WAIT_FINISH",
	"T60x_JS2_JOBS",
	"T60x_JS2_TASKS",
	"T60x_JS2_ACTIVE",
	"",
	"T60x_JS2_WAIT_READ",
	"T60x_JS2_WAIT_ISSUE",
	"T60x_JS2_WAIT_DEPEND",
	"T60x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T60x_TI_JOBS_PROCESSED",
	"T60x_TI_TRIANGLES",
	"T60x_TI_QUADS",
	"T60x_TI_POLYGONS",
	"T60x_TI_POINTS",
	"T60x_TI_LINES",
	"T60x_TI_VCACHE_HIT",
	"T60x_TI_VCACHE_MISS",
	"T60x_TI_FRONT_FACING",
	"T60x_TI_BACK_FACING",
	"T60x_TI_PRIM_VISIBLE",
	"T60x_TI_PRIM_CULLED",
	"T60x_TI_PRIM_CLIPPED",
	"T60x_TI_LEVEL0",
	"T60x_TI_LEVEL1",
	"T60x_TI_LEVEL2",
	"T60x_TI_LEVEL3",
	"T60x_TI_LEVEL4",
	"T60x_TI_LEVEL5",
	"T60x_TI_LEVEL6",
	"T60x_TI_LEVEL7",
	"T60x_TI_COMMAND_1",
	"T60x_TI_COMMAND_2",
	"T60x_TI_COMMAND_3",
	"T60x_TI_COMMAND_4",
	"T60x_TI_COMMAND_4_7",
	"T60x_TI_COMMAND_8_15",
	"T60x_TI_COMMAND_16_63",
	"T60x_TI_COMMAND_64",
	"T60x_TI_COMPRESS_IN",
	"T60x_TI_COMPRESS_OUT",
	"T60x_TI_COMPRESS_FLUSH",
	"T60x_TI_TIMESTAMPS",
	"T60x_TI_PCACHE_HIT",
	"T60x_TI_PCACHE_MISS",
	"T60x_TI_PCACHE_LINE",
	"T60x_TI_PCACHE_STALL",
	"T60x_TI_WRBUF_HIT",
	"T60x_TI_WRBUF_MISS",
	"T60x_TI_WRBUF_LINE",
	"T60x_TI_WRBUF_PARTIAL",
	"T60x_TI_WRBUF_STALL",
	"T60x_TI_ACTIVE",
	"T60x_TI_LOADING_DESC",
	"T60x_TI_INDEX_WAIT",
	"T60x_TI_INDEX_RANGE_WAIT",
	"T60x_TI_VERTEX_WAIT",
	"T60x_TI_PCACHE_WAIT",
	"T60x_TI_WRBUF_WAIT",
	"T60x_TI_BUS_READ",
	"T60x_TI_BUS_WRITE",
	"",
	"",
	"",
	"",
	"",
	"T60x_TI_UTLB_STALL",
	"T60x_TI_UTLB_REPLAY_MISS",
	"T60x_TI_UTLB_REPLAY_FULL",
	"T60x_TI_UTLB_NEW_MISS",
	"T60x_TI_UTLB_HIT",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T60x_FRAG_ACTIVE",
	"T60x_FRAG_PRIMITIVES",
	"T60x_FRAG_PRIMITIVES_DROPPED",
	"T60x_FRAG_CYCLES_DESC",
	"T60x_FRAG_CYCLES_PLR",
	"T60x_FRAG_CYCLES_VERT",
	"T60x_FRAG_CYCLES_TRISETUP",
	"T60x_FRAG_CYCLES_RAST",
	"T60x_FRAG_THREADS",
	"T60x_FRAG_DUMMY_THREADS",
	"T60x_FRAG_QUADS_RAST",
	"T60x_FRAG_QUADS_EZS_TEST",
	"T60x_FRAG_QUADS_EZS_KILLED",
	"T60x_FRAG_THREADS_LZS_TEST",
	"T60x_FRAG_THREADS_LZS_KILLED",
	"T60x_FRAG_CYCLES_NO_TILE",
	"T60x_FRAG_NUM_TILES",
	"T60x_FRAG_TRANS_ELIM",
	"T60x_COMPUTE_ACTIVE",
	"T60x_COMPUTE_TASKS",
	"T60x_COMPUTE_THREADS",
	"T60x_COMPUTE_CYCLES_DESC",
	"T60x_TRIPIPE_ACTIVE",
	"T60x_ARITH_WORDS",
	"T60x_ARITH_CYCLES_REG",
	"T60x_ARITH_CYCLES_L0",
	"T60x_ARITH_FRAG_DEPEND",
	"T60x_LS_WORDS",
	"T60x_LS_ISSUES",
	"T60x_LS_RESTARTS",
	"T60x_LS_REISSUES_MISS",
	"T60x_LS_REISSUES_VD",
	"T60x_LS_REISSUE_ATTRIB_MISS",
	"T60x_LS_NO_WB",
	"T60x_TEX_WORDS",
	"T60x_TEX_BUBBLES",
	"T60x_TEX_WORDS_L0",
	"T60x_TEX_WORDS_DESC",
	"T60x_TEX_ISSUES",
	"T60x_TEX_RECIRC_FMISS",
	"T60x_TEX_RECIRC_DESC",
	"T60x_TEX_RECIRC_MULTI",
	"T60x_TEX_RECIRC_PMISS",
	"T60x_TEX_RECIRC_CONF",
	"T60x_LSC_READ_HITS",
	"T60x_LSC_READ_MISSES",
	"T60x_LSC_WRITE_HITS",
	"T60x_LSC_WRITE_MISSES",
	"T60x_LSC_ATOMIC_HITS",
	"T60x_LSC_ATOMIC_MISSES",
	"T60x_LSC_LINE_FETCHES",
	"T60x_LSC_DIRTY_LINE",
	"T60x_LSC_SNOOPS",
	"T60x_AXI_TLB_STALL",
	"T60x_AXI_TLB_MISS",
	"T60x_AXI_TLB_TRANSACTION",
	"T60x_LS_TLB_MISS",
	"T60x_LS_TLB_HIT",
	"T60x_AXI_BEATS_READ",
	"T60x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T60x_MMU_HIT",
	"T60x_MMU_NEW_MISS",
	"T60x_MMU_REPLAY_FULL",
	"T60x_MMU_REPLAY_MISS",
	"T60x_MMU_TABLE_WALK",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T60x_UTLB_HIT",
	"T60x_UTLB_NEW_MISS",
	"T60x_UTLB_REPLAY_FULL",
	"T60x_UTLB_REPLAY_MISS",
	"T60x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T60x_L2_EXT_WRITE_BEATS",
	"T60x_L2_EXT_READ_BEATS",
	"T60x_L2_ANY_LOOKUP",
	"T60x_L2_READ_LOOKUP",
	"T60x_L2_SREAD_LOOKUP",
	"T60x_L2_READ_REPLAY",
	"T60x_L2_READ_SNOOP",
	"T60x_L2_READ_HIT",
	"T60x_L2_CLEAN_MISS",
	"T60x_L2_WRITE_LOOKUP",
	"T60x_L2_SWRITE_LOOKUP",
	"T60x_L2_WRITE_REPLAY",
	"T60x_L2_WRITE_SNOOP",
	"T60x_L2_WRITE_HIT",
	"T60x_L2_EXT_READ_FULL",
	"T60x_L2_EXT_READ_HALF",
	"T60x_L2_EXT_WRITE_FULL",
	"T60x_L2_EXT_WRITE_HALF",
	"T60x_L2_EXT_READ",
	"T60x_L2_EXT_READ_LINE",
	"T60x_L2_EXT_WRITE",
	"T60x_L2_EXT_WRITE_LINE",
	"T60x_L2_EXT_WRITE_SMALL",
	"T60x_L2_EXT_BARRIER",
	"T60x_L2_EXT_AR_STALL",
	"T60x_L2_EXT_R_BUF_FULL",
	"T60x_L2_EXT_RD_BUF_FULL",
	"T60x_L2_EXT_R_RAW",
	"T60x_L2_EXT_W_STALL",
	"T60x_L2_EXT_W_BUF_FULL",
	"T60x_L2_EXT_R_W_HAZARD",
	"T60x_L2_TAG_HAZARD",
	"T60x_L2_SNOOP_FULL",
	"T60x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_t62x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T62x_MESSAGES_SENT",
	"T62x_MESSAGES_RECEIVED",
	"T62x_GPU_ACTIVE",
	"T62x_IRQ_ACTIVE",
	"T62x_JS0_JOBS",
	"T62x_JS0_TASKS",
	"T62x_JS0_ACTIVE",
	"",
	"T62x_JS0_WAIT_READ",
	"T62x_JS0_WAIT_ISSUE",
	"T62x_JS0_WAIT_DEPEND",
	"T62x_JS0_WAIT_FINISH",
	"T62x_JS1_JOBS",
	"T62x_JS1_TASKS",
	"T62x_JS1_ACTIVE",
	"",
	"T62x_JS1_WAIT_READ",
	"T62x_JS1_WAIT_ISSUE",
	"T62x_JS1_WAIT_DEPEND",
	"T62x_JS1_WAIT_FINISH",
	"T62x_JS2_JOBS",
	"T62x_JS2_TASKS",
	"T62x_JS2_ACTIVE",
	"",
	"T62x_JS2_WAIT_READ",
	"T62x_JS2_WAIT_ISSUE",
	"T62x_JS2_WAIT_DEPEND",
	"T62x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T62x_TI_JOBS_PROCESSED",
	"T62x_TI_TRIANGLES",
	"T62x_TI_QUADS",
	"T62x_TI_POLYGONS",
	"T62x_TI_POINTS",
	"T62x_TI_LINES",
	"T62x_TI_VCACHE_HIT",
	"T62x_TI_VCACHE_MISS",
	"T62x_TI_FRONT_FACING",
	"T62x_TI_BACK_FACING",
	"T62x_TI_PRIM_VISIBLE",
	"T62x_TI_PRIM_CULLED",
	"T62x_TI_PRIM_CLIPPED",
	"T62x_TI_LEVEL0",
	"T62x_TI_LEVEL1",
	"T62x_TI_LEVEL2",
	"T62x_TI_LEVEL3",
	"T62x_TI_LEVEL4",
	"T62x_TI_LEVEL5",
	"T62x_TI_LEVEL6",
	"T62x_TI_LEVEL7",
	"T62x_TI_COMMAND_1",
	"T62x_TI_COMMAND_2",
	"T62x_TI_COMMAND_3",
	"T62x_TI_COMMAND_4",
	"T62x_TI_COMMAND_5_7",
	"T62x_TI_COMMAND_8_15",
	"T62x_TI_COMMAND_16_63",
	"T62x_TI_COMMAND_64",
	"T62x_TI_COMPRESS_IN",
	"T62x_TI_COMPRESS_OUT",
	"T62x_TI_COMPRESS_FLUSH",
	"T62x_TI_TIMESTAMPS",
	"T62x_TI_PCACHE_HIT",
	"T62x_TI_PCACHE_MISS",
	"T62x_TI_PCACHE_LINE",
	"T62x_TI_PCACHE_STALL",
	"T62x_TI_WRBUF_HIT",
	"T62x_TI_WRBUF_MISS",
	"T62x_TI_WRBUF_LINE",
	"T62x_TI_WRBUF_PARTIAL",
	"T62x_TI_WRBUF_STALL",
	"T62x_TI_ACTIVE",
	"T62x_TI_LOADING_DESC",
	"T62x_TI_INDEX_WAIT",
	"T62x_TI_INDEX_RANGE_WAIT",
	"T62x_TI_VERTEX_WAIT",
	"T62x_TI_PCACHE_WAIT",
	"T62x_TI_WRBUF_WAIT",
	"T62x_TI_BUS_READ",
	"T62x_TI_BUS_WRITE",
	"",
	"",
	"",
	"",
	"",
	"T62x_TI_UTLB_STALL",
	"T62x_TI_UTLB_REPLAY_MISS",
	"T62x_TI_UTLB_REPLAY_FULL",
	"T62x_TI_UTLB_NEW_MISS",
	"T62x_TI_UTLB_HIT",

	/* Shader Core */
	"",
	"",
	"",
	"T62x_SHADER_CORE_ACTIVE",
	"T62x_FRAG_ACTIVE",
	"T62x_FRAG_PRIMITIVES",
	"T62x_FRAG_PRIMITIVES_DROPPED",
	"T62x_FRAG_CYCLES_DESC",
	"T62x_FRAG_CYCLES_FPKQ_ACTIVE",
	"T62x_FRAG_CYCLES_VERT",
	"T62x_FRAG_CYCLES_TRISETUP",
	"T62x_FRAG_CYCLES_EZS_ACTIVE",
	"T62x_FRAG_THREADS",
	"T62x_FRAG_DUMMY_THREADS",
	"T62x_FRAG_QUADS_RAST",
	"T62x_FRAG_QUADS_EZS_TEST",
	"T62x_FRAG_QUADS_EZS_KILLED",
	"T62x_FRAG_THREADS_LZS_TEST",
	"T62x_FRAG_THREADS_LZS_KILLED",
	"T62x_FRAG_CYCLES_NO_TILE",
	"T62x_FRAG_NUM_TILES",
	"T62x_FRAG_TRANS_ELIM",
	"T62x_COMPUTE_ACTIVE",
	"T62x_COMPUTE_TASKS",
	"T62x_COMPUTE_THREADS",
	"T62x_COMPUTE_CYCLES_DESC",
	"T62x_TRIPIPE_ACTIVE",
	"T62x_ARITH_WORDS",
	"T62x_ARITH_CYCLES_REG",
	"T62x_ARITH_CYCLES_L0",
	"T62x_ARITH_FRAG_DEPEND",
	"T62x_LS_WORDS",
	"T62x_LS_ISSUES",
	"T62x_LS_RESTARTS",
	"T62x_LS_REISSUES_MISS",
	"T62x_LS_REISSUES_VD",
	"T62x_LS_REISSUE_ATTRIB_MISS",
	"T62x_LS_NO_WB",
	"T62x_TEX_WORDS",
	"T62x_TEX_BUBBLES",
	"T62x_TEX_WORDS_L0",
	"T62x_TEX_WORDS_DESC",
	"T62x_TEX_ISSUES",
	"T62x_TEX_RECIRC_FMISS",
	"T62x_TEX_RECIRC_DESC",
	"T62x_TEX_RECIRC_MULTI",
	"T62x_TEX_RECIRC_PMISS",
	"T62x_TEX_RECIRC_CONF",
	"T62x_LSC_READ_HITS",
	"T62x_LSC_READ_MISSES",
	"T62x_LSC_WRITE_HITS",
	"T62x_LSC_WRITE_MISSES",
	"T62x_LSC_ATOMIC_HITS",
	"T62x_LSC_ATOMIC_MISSES",
	"T62x_LSC_LINE_FETCHES",
	"T62x_LSC_DIRTY_LINE",
	"T62x_LSC_SNOOPS",
	"T62x_AXI_TLB_STALL",
	"T62x_AXI_TLB_MISS",
	"T62x_AXI_TLB_TRANSACTION",
	"T62x_LS_TLB_MISS",
	"T62x_LS_TLB_HIT",
	"T62x_AXI_BEATS_READ",
	"T62x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T62x_MMU_HIT",
	"T62x_MMU_NEW_MISS",
	"T62x_MMU_REPLAY_FULL",
	"T62x_MMU_REPLAY_MISS",
	"T62x_MMU_TABLE_WALK",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T62x_UTLB_HIT",
	"T62x_UTLB_NEW_MISS",
	"T62x_UTLB_REPLAY_FULL",
	"T62x_UTLB_REPLAY_MISS",
	"T62x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T62x_L2_EXT_WRITE_BEATS",
	"T62x_L2_EXT_READ_BEATS",
	"T62x_L2_ANY_LOOKUP",
	"T62x_L2_READ_LOOKUP",
	"T62x_L2_SREAD_LOOKUP",
	"T62x_L2_READ_REPLAY",
	"T62x_L2_READ_SNOOP",
	"T62x_L2_READ_HIT",
	"T62x_L2_CLEAN_MISS",
	"T62x_L2_WRITE_LOOKUP",
	"T62x_L2_SWRITE_LOOKUP",
	"T62x_L2_WRITE_REPLAY",
	"T62x_L2_WRITE_SNOOP",
	"T62x_L2_WRITE_HIT",
	"T62x_L2_EXT_READ_FULL",
	"T62x_L2_EXT_READ_HALF",
	"T62x_L2_EXT_WRITE_FULL",
	"T62x_L2_EXT_WRITE_HALF",
	"T62x_L2_EXT_READ",
	"T62x_L2_EXT_READ_LINE",
	"T62x_L2_EXT_WRITE",
	"T62x_L2_EXT_WRITE_LINE",
	"T62x_L2_EXT_WRITE_SMALL",
	"T62x_L2_EXT_BARRIER",
	"T62x_L2_EXT_AR_STALL",
	"T62x_L2_EXT_R_BUF_FULL",
	"T62x_L2_EXT_RD_BUF_FULL",
	"T62x_L2_EXT_R_RAW",
	"T62x_L2_EXT_W_STALL",
	"T62x_L2_EXT_W_BUF_FULL",
	"T62x_L2_EXT_R_W_HAZARD",
	"T62x_L2_TAG_HAZARD",
	"T62x_L2_SNOOP_FULL",
	"T62x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_t72x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T72x_GPU_ACTIVE",
	"T72x_IRQ_ACTIVE",
	"T72x_JS0_JOBS",
	"T72x_JS0_TASKS",
	"T72x_JS0_ACTIVE",
	"T72x_JS1_JOBS",
	"T72x_JS1_TASKS",
	"T72x_JS1_ACTIVE",
	"T72x_JS2_JOBS",
	"T72x_JS2_TASKS",
	"T72x_JS2_ACTIVE",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T72x_TI_JOBS_PROCESSED",
	"T72x_TI_TRIANGLES",
	"T72x_TI_QUADS",
	"T72x_TI_POLYGONS",
	"T72x_TI_POINTS",
	"T72x_TI_LINES",
	"T72x_TI_FRONT_FACING",
	"T72x_TI_BACK_FACING",
	"T72x_TI_PRIM_VISIBLE",
	"T72x_TI_PRIM_CULLED",
	"T72x_TI_PRIM_CLIPPED",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T72x_TI_ACTIVE",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T72x_FRAG_ACTIVE",
	"T72x_FRAG_PRIMITIVES",
	"T72x_FRAG_PRIMITIVES_DROPPED",
	"T72x_FRAG_THREADS",
	"T72x_FRAG_DUMMY_THREADS",
	"T72x_FRAG_QUADS_RAST",
	"T72x_FRAG_QUADS_EZS_TEST",
	"T72x_FRAG_QUADS_EZS_KILLED",
	"T72x_FRAG_THREADS_LZS_TEST",
	"T72x_FRAG_THREADS_LZS_KILLED",
	"T72x_FRAG_CYCLES_NO_TILE",
	"T72x_FRAG_NUM_TILES",
	"T72x_FRAG_TRANS_ELIM",
	"T72x_COMPUTE_ACTIVE",
	"T72x_COMPUTE_TASKS",
	"T72x_COMPUTE_THREADS",
	"T72x_TRIPIPE_ACTIVE",
	"T72x_ARITH_WORDS",
	"T72x_ARITH_CYCLES_REG",
	"T72x_LS_WORDS",
	"T72x_LS_ISSUES",
	"T72x_LS_RESTARTS",
	"T72x_LS_REISSUES_MISS",
	"T72x_TEX_WORDS",
	"T72x_TEX_BUBBLES",
	"T72x_TEX_ISSUES",
	"T72x_LSC_READ_HITS",
	"T72x_LSC_READ_MISSES",
	"T72x_LSC_WRITE_HITS",
	"T72x_LSC_WRITE_MISSES",
	"T72x_LSC_ATOMIC_HITS",
	"T72x_LSC_ATOMIC_MISSES",
	"T72x_LSC_LINE_FETCHES",
	"T72x_LSC_DIRTY_LINE",
	"T72x_LSC_SNOOPS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T72x_L2_EXT_WRITE_BEAT",
	"T72x_L2_EXT_READ_BEAT",
	"T72x_L2_READ_SNOOP",
	"T72x_L2_READ_HIT",
	"T72x_L2_WRITE_SNOOP",
	"T72x_L2_WRITE_HIT",
	"T72x_L2_EXT_WRITE_SMALL",
	"T72x_L2_EXT_BARRIER",
	"T72x_L2_EXT_AR_STALL",
	"T72x_L2_EXT_W_STALL",
	"T72x_L2_SNOOP_FULL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	""};

static const char *const hardware_counters_mali_t76x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T76x_MESSAGES_SENT",
	"T76x_MESSAGES_RECEIVED",
	"T76x_GPU_ACTIVE",
	"T76x_IRQ_ACTIVE",
	"T76x_JS0_JOBS",
	"T76x_JS0_TASKS",
	"T76x_JS0_ACTIVE",
	"",
	"T76x_JS0_WAIT_READ",
	"T76x_JS0_WAIT_ISSUE",
	"T76x_JS0_WAIT_DEPEND",
	"T76x_JS0_WAIT_FINISH",
	"T76x_JS1_JOBS",
	"T76x_JS1_TASKS",
	"T76x_JS1_ACTIVE",
	"",
	"T76x_JS1_WAIT_READ",
	"T76x_JS1_WAIT_ISSUE",
	"T76x_JS1_WAIT_DEPEND",
	"T76x_JS1_WAIT_FINISH",
	"T76x_JS2_JOBS",
	"T76x_JS2_TASKS",
	"T76x_JS2_ACTIVE",
	"",
	"T76x_JS2_WAIT_READ",
	"T76x_JS2_WAIT_ISSUE",
	"T76x_JS2_WAIT_DEPEND",
	"T76x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T76x_TI_JOBS_PROCESSED",
	"T76x_TI_TRIANGLES",
	"T76x_TI_QUADS",
	"T76x_TI_POLYGONS",
	"T76x_TI_POINTS",
	"T76x_TI_LINES",
	"T76x_TI_VCACHE_HIT",
	"T76x_TI_VCACHE_MISS",
	"T76x_TI_FRONT_FACING",
	"T76x_TI_BACK_FACING",
	"T76x_TI_PRIM_VISIBLE",
	"T76x_TI_PRIM_CULLED",
	"T76x_TI_PRIM_CLIPPED",
	"T76x_TI_LEVEL0",
	"T76x_TI_LEVEL1",
	"T76x_TI_LEVEL2",
	"T76x_TI_LEVEL3",
	"T76x_TI_LEVEL4",
	"T76x_TI_LEVEL5",
	"T76x_TI_LEVEL6",
	"T76x_TI_LEVEL7",
	"T76x_TI_COMMAND_1",
	"T76x_TI_COMMAND_2",
	"T76x_TI_COMMAND_3",
	"T76x_TI_COMMAND_4",
	"T76x_TI_COMMAND_5_7",
	"T76x_TI_COMMAND_8_15",
	"T76x_TI_COMMAND_16_63",
	"T76x_TI_COMMAND_64",
	"T76x_TI_COMPRESS_IN",
	"T76x_TI_COMPRESS_OUT",
	"T76x_TI_COMPRESS_FLUSH",
	"T76x_TI_TIMESTAMPS",
	"T76x_TI_PCACHE_HIT",
	"T76x_TI_PCACHE_MISS",
	"T76x_TI_PCACHE_LINE",
	"T76x_TI_PCACHE_STALL",
	"T76x_TI_WRBUF_HIT",
	"T76x_TI_WRBUF_MISS",
	"T76x_TI_WRBUF_LINE",
	"T76x_TI_WRBUF_PARTIAL",
	"T76x_TI_WRBUF_STALL",
	"T76x_TI_ACTIVE",
	"T76x_TI_LOADING_DESC",
	"T76x_TI_INDEX_WAIT",
	"T76x_TI_INDEX_RANGE_WAIT",
	"T76x_TI_VERTEX_WAIT",
	"T76x_TI_PCACHE_WAIT",
	"T76x_TI_WRBUF_WAIT",
	"T76x_TI_BUS_READ",
	"T76x_TI_BUS_WRITE",
	"",
	"",
	"",
	"",
	"",
	"T76x_TI_UTLB_HIT",
	"T76x_TI_UTLB_NEW_MISS",
	"T76x_TI_UTLB_REPLAY_FULL",
	"T76x_TI_UTLB_REPLAY_MISS",
	"T76x_TI_UTLB_STALL",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T76x_FRAG_ACTIVE",
	"T76x_FRAG_PRIMITIVES",
	"T76x_FRAG_PRIMITIVES_DROPPED",
	"T76x_FRAG_CYCLES_DESC",
	"T76x_FRAG_CYCLES_PLR",
	"T76x_FRAG_CYCLES_VERT",
	"T76x_FRAG_CYCLES_TRISETUP",
	"T76x_FRAG_CYCLES_FPKQ_ACTIVE",
	"T76x_FRAG_THREADS",
	"T76x_FRAG_DUMMY_THREADS",
	"T76x_FRAG_QUADS_RAST",
	"T76x_FRAG_QUADS_EZS_TEST",
	"T76x_FRAG_QUADS_EZS_KILLED",
	"T76x_FRAG_THREADS_LZS_TEST",
	"T76x_FRAG_THREADS_LZS_KILLED",
	"T76x_FRAG_CYCLES_NO_TILE",
	"T76x_FRAG_NUM_TILES",
	"T76x_FRAG_TRANS_ELIM",
	"T76x_COMPUTE_ACTIVE",
	"T76x_COMPUTE_TASKS",
	"T76x_COMPUTE_THREADS",
	"T76x_COMPUTE_CYCLES_DESC",
	"T76x_TRIPIPE_ACTIVE",
	"T76x_ARITH_WORDS",
	"T76x_ARITH_CYCLES_REG",
	"T76x_ARITH_CYCLES_L0",
	"T76x_ARITH_FRAG_DEPEND",
	"T76x_LS_WORDS",
	"T76x_LS_ISSUES",
	"T76x_LS_REISSUE_ATTR",
	"T76x_LS_REISSUES_VARY",
	"T76x_LS_VARY_RV_MISS",
	"T76x_LS_VARY_RV_HIT",
	"T76x_LS_NO_UNPARK",
	"T76x_TEX_WORDS",
	"T76x_TEX_BUBBLES",
	"T76x_TEX_WORDS_L0",
	"T76x_TEX_WORDS_DESC",
	"T76x_TEX_ISSUES",
	"T76x_TEX_RECIRC_FMISS",
	"T76x_TEX_RECIRC_DESC",
	"T76x_TEX_RECIRC_MULTI",
	"T76x_TEX_RECIRC_PMISS",
	"T76x_TEX_RECIRC_CONF",
	"T76x_LSC_READ_HITS",
	"T76x_LSC_READ_OP",
	"T76x_LSC_WRITE_HITS",
	"T76x_LSC_WRITE_OP",
	"T76x_LSC_ATOMIC_HITS",
	"T76x_LSC_ATOMIC_OP",
	"T76x_LSC_LINE_FETCHES",
	"T76x_LSC_DIRTY_LINE",
	"T76x_LSC_SNOOPS",
	"T76x_AXI_TLB_STALL",
	"T76x_AXI_TLB_MISS",
	"T76x_AXI_TLB_TRANSACTION",
	"T76x_LS_TLB_MISS",
	"T76x_LS_TLB_HIT",
	"T76x_AXI_BEATS_READ",
	"T76x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T76x_MMU_HIT",
	"T76x_MMU_NEW_MISS",
	"T76x_MMU_REPLAY_FULL",
	"T76x_MMU_REPLAY_MISS",
	"T76x_MMU_TABLE_WALK",
	"T76x_MMU_REQUESTS",
	"",
	"",
	"T76x_UTLB_HIT",
	"T76x_UTLB_NEW_MISS",
	"T76x_UTLB_REPLAY_FULL",
	"T76x_UTLB_REPLAY_MISS",
	"T76x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T76x_L2_EXT_WRITE_BEATS",
	"T76x_L2_EXT_READ_BEATS",
	"T76x_L2_ANY_LOOKUP",
	"T76x_L2_READ_LOOKUP",
	"T76x_L2_SREAD_LOOKUP",
	"T76x_L2_READ_REPLAY",
	"T76x_L2_READ_SNOOP",
	"T76x_L2_READ_HIT",
	"T76x_L2_CLEAN_MISS",
	"T76x_L2_WRITE_LOOKUP",
	"T76x_L2_SWRITE_LOOKUP",
	"T76x_L2_WRITE_REPLAY",
	"T76x_L2_WRITE_SNOOP",
	"T76x_L2_WRITE_HIT",
	"T76x_L2_EXT_READ_FULL",
	"",
	"T76x_L2_EXT_WRITE_FULL",
	"T76x_L2_EXT_R_W_HAZARD",
	"T76x_L2_EXT_READ",
	"T76x_L2_EXT_READ_LINE",
	"T76x_L2_EXT_WRITE",
	"T76x_L2_EXT_WRITE_LINE",
	"T76x_L2_EXT_WRITE_SMALL",
	"T76x_L2_EXT_BARRIER",
	"T76x_L2_EXT_AR_STALL",
	"T76x_L2_EXT_R_BUF_FULL",
	"T76x_L2_EXT_RD_BUF_FULL",
	"T76x_L2_EXT_R_RAW",
	"T76x_L2_EXT_W_STALL",
	"T76x_L2_EXT_W_BUF_FULL",
	"T76x_L2_EXT_R_BUF_FULL",
	"T76x_L2_TAG_HAZARD",
	"T76x_L2_SNOOP_FULL",
	"T76x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_t82x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T82x_MESSAGES_SENT",
	"T82x_MESSAGES_RECEIVED",
	"T82x_GPU_ACTIVE",
	"T82x_IRQ_ACTIVE",
	"T82x_JS0_JOBS",
	"T82x_JS0_TASKS",
	"T82x_JS0_ACTIVE",
	"",
	"T82x_JS0_WAIT_READ",
	"T82x_JS0_WAIT_ISSUE",
	"T82x_JS0_WAIT_DEPEND",
	"T82x_JS0_WAIT_FINISH",
	"T82x_JS1_JOBS",
	"T82x_JS1_TASKS",
	"T82x_JS1_ACTIVE",
	"",
	"T82x_JS1_WAIT_READ",
	"T82x_JS1_WAIT_ISSUE",
	"T82x_JS1_WAIT_DEPEND",
	"T82x_JS1_WAIT_FINISH",
	"T82x_JS2_JOBS",
	"T82x_JS2_TASKS",
	"T82x_JS2_ACTIVE",
	"",
	"T82x_JS2_WAIT_READ",
	"T82x_JS2_WAIT_ISSUE",
	"T82x_JS2_WAIT_DEPEND",
	"T82x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T82x_TI_JOBS_PROCESSED",
	"T82x_TI_TRIANGLES",
	"T82x_TI_QUADS",
	"T82x_TI_POLYGONS",
	"T82x_TI_POINTS",
	"T82x_TI_LINES",
	"T82x_TI_FRONT_FACING",
	"T82x_TI_BACK_FACING",
	"T82x_TI_PRIM_VISIBLE",
	"T82x_TI_PRIM_CULLED",
	"T82x_TI_PRIM_CLIPPED",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T82x_TI_ACTIVE",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T82x_FRAG_ACTIVE",
	"T82x_FRAG_PRIMITIVES",
	"T82x_FRAG_PRIMITIVES_DROPPED",
	"T82x_FRAG_CYCLES_DESC",
	"T82x_FRAG_CYCLES_ZS_REORDER_ACTIVE",
	"T82x_FRAG_CYCLES_VERT",
	"T82x_FRAG_CYCLES_TRISETUP",
	"T82x_FRAG_CYCLES_FPKQ_ACTIVE",
	"T82x_FRAG_THREADS",
	"T82x_FRAG_DUMMY_THREADS",
	"T82x_FRAG_QUADS_RAST",
	"T82x_FRAG_QUADS_EZS_TEST",
	"T82x_FRAG_QUADS_EZS_KILLED",
	"T82x_FRAG_THREADS_LZS_TEST",
	"T82x_FRAG_THREADS_LZS_KILLED",
	"T82x_FRAG_CYCLES_NO_TILE",
	"T82x_FRAG_NUM_TILES",
	"T82x_FRAG_TRANS_ELIM",
	"T82x_COMPUTE_ACTIVE",
	"T82x_COMPUTE_TASKS",
	"T82x_COMPUTE_THREADS",
	"T82x_COMPUTE_CYCLES_DESC",
	"T82x_TRIPIPE_ACTIVE",
	"T82x_ARITH_WORDS",
	"T82x_ARITH_CYCLES_REG",
	"T82x_ARITH_CYCLES_L0",
	"T82x_ARITH_FRAG_DEPEND",
	"T82x_LS_WORDS",
	"T82x_LS_ISSUES",
	"T82x_LS_REISSUE_ATTR",
	"T82x_LS_REISSUES_VARY",
	"T82x_LS_VARY_RV_MISS",
	"T82x_LS_VARY_RV_HIT",
	"T82x_LS_NO_UNPARK",
	"T82x_TEX_WORDS",
	"T82x_TEX_BUBBLES",
	"T82x_TEX_WORDS_L0",
	"T82x_TEX_WORDS_DESC",
	"T82x_TEX_ISSUES",
	"T82x_TEX_RECIRC_FMISS",
	"T82x_TEX_RECIRC_DESC",
	"T82x_TEX_RECIRC_MULTI",
	"T82x_TEX_RECIRC_PMISS",
	"T82x_TEX_RECIRC_CONF",
	"T82x_LSC_READ_HITS",
	"T82x_LSC_READ_OP",
	"T82x_LSC_WRITE_HITS",
	"T82x_LSC_WRITE_OP",
	"T82x_LSC_ATOMIC_HITS",
	"T82x_LSC_ATOMIC_OP",
	"T82x_LSC_LINE_FETCHES",
	"T82x_LSC_DIRTY_LINE",
	"T82x_LSC_SNOOPS",
	"T82x_AXI_TLB_STALL",
	"T82x_AXI_TLB_MISS",
	"T82x_AXI_TLB_TRANSACTION",
	"T82x_LS_TLB_MISS",
	"T82x_LS_TLB_HIT",
	"T82x_AXI_BEATS_READ",
	"T82x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T82x_MMU_HIT",
	"T82x_MMU_NEW_MISS",
	"T82x_MMU_REPLAY_FULL",
	"T82x_MMU_REPLAY_MISS",
	"T82x_MMU_TABLE_WALK",
	"T82x_MMU_REQUESTS",
	"",
	"",
	"T82x_UTLB_HIT",
	"T82x_UTLB_NEW_MISS",
	"T82x_UTLB_REPLAY_FULL",
	"T82x_UTLB_REPLAY_MISS",
	"T82x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T82x_L2_EXT_WRITE_BEATS",
	"T82x_L2_EXT_READ_BEATS",
	"T82x_L2_ANY_LOOKUP",
	"T82x_L2_READ_LOOKUP",
	"T82x_L2_SREAD_LOOKUP",
	"T82x_L2_READ_REPLAY",
	"T82x_L2_READ_SNOOP",
	"T82x_L2_READ_HIT",
	"T82x_L2_CLEAN_MISS",
	"T82x_L2_WRITE_LOOKUP",
	"T82x_L2_SWRITE_LOOKUP",
	"T82x_L2_WRITE_REPLAY",
	"T82x_L2_WRITE_SNOOP",
	"T82x_L2_WRITE_HIT",
	"T82x_L2_EXT_READ_FULL",
	"",
	"T82x_L2_EXT_WRITE_FULL",
	"T82x_L2_EXT_R_W_HAZARD",
	"T82x_L2_EXT_READ",
	"T82x_L2_EXT_READ_LINE",
	"T82x_L2_EXT_WRITE",
	"T82x_L2_EXT_WRITE_LINE",
	"T82x_L2_EXT_WRITE_SMALL",
	"T82x_L2_EXT_BARRIER",
	"T82x_L2_EXT_AR_STALL",
	"T82x_L2_EXT_R_BUF_FULL",
	"T82x_L2_EXT_RD_BUF_FULL",
	"T82x_L2_EXT_R_RAW",
	"T82x_L2_EXT_W_STALL",
	"T82x_L2_EXT_W_BUF_FULL",
	"T82x_L2_EXT_R_BUF_FULL",
	"T82x_L2_TAG_HAZARD",
	"T82x_L2_SNOOP_FULL",
	"T82x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_t83x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T83x_MESSAGES_SENT",
	"T83x_MESSAGES_RECEIVED",
	"T83x_GPU_ACTIVE",
	"T83x_IRQ_ACTIVE",
	"T83x_JS0_JOBS",
	"T83x_JS0_TASKS",
	"T83x_JS0_ACTIVE",
	"",
	"T83x_JS0_WAIT_READ",
	"T83x_JS0_WAIT_ISSUE",
	"T83x_JS0_WAIT_DEPEND",
	"T83x_JS0_WAIT_FINISH",
	"T83x_JS1_JOBS",
	"T83x_JS1_TASKS",
	"T83x_JS1_ACTIVE",
	"",
	"T83x_JS1_WAIT_READ",
	"T83x_JS1_WAIT_ISSUE",
	"T83x_JS1_WAIT_DEPEND",
	"T83x_JS1_WAIT_FINISH",
	"T83x_JS2_JOBS",
	"T83x_JS2_TASKS",
	"T83x_JS2_ACTIVE",
	"",
	"T83x_JS2_WAIT_READ",
	"T83x_JS2_WAIT_ISSUE",
	"T83x_JS2_WAIT_DEPEND",
	"T83x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T83x_TI_JOBS_PROCESSED",
	"T83x_TI_TRIANGLES",
	"T83x_TI_QUADS",
	"T83x_TI_POLYGONS",
	"T83x_TI_POINTS",
	"T83x_TI_LINES",
	"T83x_TI_FRONT_FACING",
	"T83x_TI_BACK_FACING",
	"T83x_TI_PRIM_VISIBLE",
	"T83x_TI_PRIM_CULLED",
	"T83x_TI_PRIM_CLIPPED",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T83x_TI_ACTIVE",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T83x_FRAG_ACTIVE",
	"T83x_FRAG_PRIMITIVES",
	"T83x_FRAG_PRIMITIVES_DROPPED",
	"T83x_FRAG_CYCLES_DESC",
	"T83x_FRAG_CYCLES_ZS_REORDER_ACTIVE",
	"T83x_FRAG_CYCLES_VERT",
	"T83x_FRAG_CYCLES_TRISETUP",
	"T83x_FRAG_CYCLES_FPKQ_ACTIVE",
	"T83x_FRAG_THREADS",
	"T83x_FRAG_DUMMY_THREADS",
	"T83x_FRAG_QUADS_RAST",
	"T83x_FRAG_QUADS_EZS_TEST",
	"T83x_FRAG_QUADS_EZS_KILLED",
	"T83x_FRAG_THREADS_LZS_TEST",
	"T83x_FRAG_THREADS_LZS_KILLED",
	"T83x_FRAG_CYCLES_NO_TILE",
	"T83x_FRAG_NUM_TILES",
	"T83x_FRAG_TRANS_ELIM",
	"T83x_COMPUTE_ACTIVE",
	"T83x_COMPUTE_TASKS",
	"T83x_COMPUTE_THREADS",
	"T83x_COMPUTE_CYCLES_DESC",
	"T83x_TRIPIPE_ACTIVE",
	"T83x_ARITH_WORDS",
	"T83x_ARITH_CYCLES_REG",
	"T83x_ARITH_CYCLES_L0",
	"T83x_ARITH_FRAG_DEPEND",
	"T83x_LS_WORDS",
	"T83x_LS_ISSUES",
	"T83x_LS_REISSUE_ATTR",
	"T83x_LS_REISSUES_VARY",
	"T83x_LS_VARY_RV_MISS",
	"T83x_LS_VARY_RV_HIT",
	"T83x_LS_NO_UNPARK",
	"T83x_TEX_WORDS",
	"T83x_TEX_BUBBLES",
	"T83x_TEX_WORDS_L0",
	"T83x_TEX_WORDS_DESC",
	"T83x_TEX_ISSUES",
	"T83x_TEX_RECIRC_FMISS",
	"T83x_TEX_RECIRC_DESC",
	"T83x_TEX_RECIRC_MULTI",
	"T83x_TEX_RECIRC_PMISS",
	"T83x_TEX_RECIRC_CONF",
	"T83x_LSC_READ_HITS",
	"T83x_LSC_READ_OP",
	"T83x_LSC_WRITE_HITS",
	"T83x_LSC_WRITE_OP",
	"T83x_LSC_ATOMIC_HITS",
	"T83x_LSC_ATOMIC_OP",
	"T83x_LSC_LINE_FETCHES",
	"T83x_LSC_DIRTY_LINE",
	"T83x_LSC_SNOOPS",
	"T83x_AXI_TLB_STALL",
	"T83x_AXI_TLB_MISS",
	"T83x_AXI_TLB_TRANSACTION",
	"T83x_LS_TLB_MISS",
	"T83x_LS_TLB_HIT",
	"T83x_AXI_BEATS_READ",
	"T83x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T83x_MMU_HIT",
	"T83x_MMU_NEW_MISS",
	"T83x_MMU_REPLAY_FULL",
	"T83x_MMU_REPLAY_MISS",
	"T83x_MMU_TABLE_WALK",
	"T83x_MMU_REQUESTS",
	"",
	"",
	"T83x_UTLB_HIT",
	"T83x_UTLB_NEW_MISS",
	"T83x_UTLB_REPLAY_FULL",
	"T83x_UTLB_REPLAY_MISS",
	"T83x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T83x_L2_EXT_WRITE_BEATS",
	"T83x_L2_EXT_READ_BEATS",
	"T83x_L2_ANY_LOOKUP",
	"T83x_L2_READ_LOOKUP",
	"T83x_L2_SREAD_LOOKUP",
	"T83x_L2_READ_REPLAY",
	"T83x_L2_READ_SNOOP",
	"T83x_L2_READ_HIT",
	"T83x_L2_CLEAN_MISS",
	"T83x_L2_WRITE_LOOKUP",
	"T83x_L2_SWRITE_LOOKUP",
	"T83x_L2_WRITE_REPLAY",
	"T83x_L2_WRITE_SNOOP",
	"T83x_L2_WRITE_HIT",
	"T83x_L2_EXT_READ_FULL",
	"",
	"T83x_L2_EXT_WRITE_FULL",
	"T83x_L2_EXT_R_W_HAZARD",
	"T83x_L2_EXT_READ",
	"T83x_L2_EXT_READ_LINE",
	"T83x_L2_EXT_WRITE",
	"T83x_L2_EXT_WRITE_LINE",
	"T83x_L2_EXT_WRITE_SMALL",
	"T83x_L2_EXT_BARRIER",
	"T83x_L2_EXT_AR_STALL",
	"T83x_L2_EXT_R_BUF_FULL",
	"T83x_L2_EXT_RD_BUF_FULL",
	"T83x_L2_EXT_R_RAW",
	"T83x_L2_EXT_W_STALL",
	"T83x_L2_EXT_W_BUF_FULL",
	"T83x_L2_EXT_R_BUF_FULL",
	"T83x_L2_TAG_HAZARD",
	"T83x_L2_SNOOP_FULL",
	"T83x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_t86x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T86x_MESSAGES_SENT",
	"T86x_MESSAGES_RECEIVED",
	"T86x_GPU_ACTIVE",
	"T86x_IRQ_ACTIVE",
	"T86x_JS0_JOBS",
	"T86x_JS0_TASKS",
	"T86x_JS0_ACTIVE",
	"",
	"T86x_JS0_WAIT_READ",
	"T86x_JS0_WAIT_ISSUE",
	"T86x_JS0_WAIT_DEPEND",
	"T86x_JS0_WAIT_FINISH",
	"T86x_JS1_JOBS",
	"T86x_JS1_TASKS",
	"T86x_JS1_ACTIVE",
	"",
	"T86x_JS1_WAIT_READ",
	"T86x_JS1_WAIT_ISSUE",
	"T86x_JS1_WAIT_DEPEND",
	"T86x_JS1_WAIT_FINISH",
	"T86x_JS2_JOBS",
	"T86x_JS2_TASKS",
	"T86x_JS2_ACTIVE",
	"",
	"T86x_JS2_WAIT_READ",
	"T86x_JS2_WAIT_ISSUE",
	"T86x_JS2_WAIT_DEPEND",
	"T86x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T86x_TI_JOBS_PROCESSED",
	"T86x_TI_TRIANGLES",
	"T86x_TI_QUADS",
	"T86x_TI_POLYGONS",
	"T86x_TI_POINTS",
	"T86x_TI_LINES",
	"T86x_TI_VCACHE_HIT",
	"T86x_TI_VCACHE_MISS",
	"T86x_TI_FRONT_FACING",
	"T86x_TI_BACK_FACING",
	"T86x_TI_PRIM_VISIBLE",
	"T86x_TI_PRIM_CULLED",
	"T86x_TI_PRIM_CLIPPED",
	"T86x_TI_LEVEL0",
	"T86x_TI_LEVEL1",
	"T86x_TI_LEVEL2",
	"T86x_TI_LEVEL3",
	"T86x_TI_LEVEL4",
	"T86x_TI_LEVEL5",
	"T86x_TI_LEVEL6",
	"T86x_TI_LEVEL7",
	"T86x_TI_COMMAND_1",
	"T86x_TI_COMMAND_2",
	"T86x_TI_COMMAND_3",
	"T86x_TI_COMMAND_4",
	"T86x_TI_COMMAND_5_7",
	"T86x_TI_COMMAND_8_15",
	"T86x_TI_COMMAND_16_63",
	"T86x_TI_COMMAND_64",
	"T86x_TI_COMPRESS_IN",
	"T86x_TI_COMPRESS_OUT",
	"T86x_TI_COMPRESS_FLUSH",
	"T86x_TI_TIMESTAMPS",
	"T86x_TI_PCACHE_HIT",
	"T86x_TI_PCACHE_MISS",
	"T86x_TI_PCACHE_LINE",
	"T86x_TI_PCACHE_STALL",
	"T86x_TI_WRBUF_HIT",
	"T86x_TI_WRBUF_MISS",
	"T86x_TI_WRBUF_LINE",
	"T86x_TI_WRBUF_PARTIAL",
	"T86x_TI_WRBUF_STALL",
	"T86x_TI_ACTIVE",
	"T86x_TI_LOADING_DESC",
	"T86x_TI_INDEX_WAIT",
	"T86x_TI_INDEX_RANGE_WAIT",
	"T86x_TI_VERTEX_WAIT",
	"T86x_TI_PCACHE_WAIT",
	"T86x_TI_WRBUF_WAIT",
	"T86x_TI_BUS_READ",
	"T86x_TI_BUS_WRITE",
	"",
	"",
	"",
	"",
	"",
	"T86x_TI_UTLB_HIT",
	"T86x_TI_UTLB_NEW_MISS",
	"T86x_TI_UTLB_REPLAY_FULL",
	"T86x_TI_UTLB_REPLAY_MISS",
	"T86x_TI_UTLB_STALL",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T86x_FRAG_ACTIVE",
	"T86x_FRAG_PRIMITIVES",
	"T86x_FRAG_PRIMITIVES_DROPPED",
	"T86x_FRAG_CYCLES_DESC",
	"T86x_FRAG_CYCLES_ZS_REORDER_ACTIVE",
	"T86x_FRAG_CYCLES_VERT",
	"T86x_FRAG_CYCLES_TRISETUP",
	"T86x_FRAG_CYCLES_FPKQ_ACTIVE",
	"T86x_FRAG_THREADS",
	"T86x_FRAG_DUMMY_THREADS",
	"T86x_FRAG_QUADS_RAST",
	"T86x_FRAG_QUADS_EZS_TEST",
	"T86x_FRAG_QUADS_EZS_KILLED",
	"T86x_FRAG_THREADS_LZS_TEST",
	"T86x_FRAG_THREADS_LZS_KILLED",
	"T86x_FRAG_CYCLES_NO_TILE",
	"T86x_FRAG_NUM_TILES",
	"T86x_FRAG_TRANS_ELIM",
	"T86x_COMPUTE_ACTIVE",
	"T86x_COMPUTE_TASKS",
	"T86x_COMPUTE_THREADS",
	"T86x_COMPUTE_CYCLES_DESC",
	"T86x_TRIPIPE_ACTIVE",
	"T86x_ARITH_WORDS",
	"T86x_ARITH_CYCLES_REG",
	"T86x_ARITH_CYCLES_L0",
	"T86x_ARITH_FRAG_DEPEND",
	"T86x_LS_WORDS",
	"T86x_LS_ISSUES",
	"T86x_LS_REISSUE_ATTR",
	"T86x_LS_REISSUES_VARY",
	"T86x_LS_VARY_RV_MISS",
	"T86x_LS_VARY_RV_HIT",
	"T86x_LS_NO_UNPARK",
	"T86x_TEX_WORDS",
	"T86x_TEX_BUBBLES",
	"T86x_TEX_WORDS_L0",
	"T86x_TEX_WORDS_DESC",
	"T86x_TEX_ISSUES",
	"T86x_TEX_RECIRC_FMISS",
	"T86x_TEX_RECIRC_DESC",
	"T86x_TEX_RECIRC_MULTI",
	"T86x_TEX_RECIRC_PMISS",
	"T86x_TEX_RECIRC_CONF",
	"T86x_LSC_READ_HITS",
	"T86x_LSC_READ_OP",
	"T86x_LSC_WRITE_HITS",
	"T86x_LSC_WRITE_OP",
	"T86x_LSC_ATOMIC_HITS",
	"T86x_LSC_ATOMIC_OP",
	"T86x_LSC_LINE_FETCHES",
	"T86x_LSC_DIRTY_LINE",
	"T86x_LSC_SNOOPS",
	"T86x_AXI_TLB_STALL",
	"T86x_AXI_TLB_MISS",
	"T86x_AXI_TLB_TRANSACTION",
	"T86x_LS_TLB_MISS",
	"T86x_LS_TLB_HIT",
	"T86x_AXI_BEATS_READ",
	"T86x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T86x_MMU_HIT",
	"T86x_MMU_NEW_MISS",
	"T86x_MMU_REPLAY_FULL",
	"T86x_MMU_REPLAY_MISS",
	"T86x_MMU_TABLE_WALK",
	"T86x_MMU_REQUESTS",
	"",
	"",
	"T86x_UTLB_HIT",
	"T86x_UTLB_NEW_MISS",
	"T86x_UTLB_REPLAY_FULL",
	"T86x_UTLB_REPLAY_MISS",
	"T86x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T86x_L2_EXT_WRITE_BEATS",
	"T86x_L2_EXT_READ_BEATS",
	"T86x_L2_ANY_LOOKUP",
	"T86x_L2_READ_LOOKUP",
	"T86x_L2_SREAD_LOOKUP",
	"T86x_L2_READ_REPLAY",
	"T86x_L2_READ_SNOOP",
	"T86x_L2_READ_HIT",
	"T86x_L2_CLEAN_MISS",
	"T86x_L2_WRITE_LOOKUP",
	"T86x_L2_SWRITE_LOOKUP",
	"T86x_L2_WRITE_REPLAY",
	"T86x_L2_WRITE_SNOOP",
	"T86x_L2_WRITE_HIT",
	"T86x_L2_EXT_READ_FULL",
	"",
	"T86x_L2_EXT_WRITE_FULL",
	"T86x_L2_EXT_R_W_HAZARD",
	"T86x_L2_EXT_READ",
	"T86x_L2_EXT_READ_LINE",
	"T86x_L2_EXT_WRITE",
	"T86x_L2_EXT_WRITE_LINE",
	"T86x_L2_EXT_WRITE_SMALL",
	"T86x_L2_EXT_BARRIER",
	"T86x_L2_EXT_AR_STALL",
	"T86x_L2_EXT_R_BUF_FULL",
	"T86x_L2_EXT_RD_BUF_FULL",
	"T86x_L2_EXT_R_RAW",
	"T86x_L2_EXT_W_STALL",
	"T86x_L2_EXT_W_BUF_FULL",
	"T86x_L2_EXT_R_BUF_FULL",
	"T86x_L2_TAG_HAZARD",
	"T86x_L2_SNOOP_FULL",
	"T86x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_t88x[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"T88x_MESSAGES_SENT",
	"T88x_MESSAGES_RECEIVED",
	"T88x_GPU_ACTIVE",
	"T88x_IRQ_ACTIVE",
	"T88x_JS0_JOBS",
	"T88x_JS0_TASKS",
	"T88x_JS0_ACTIVE",
	"",
	"T88x_JS0_WAIT_READ",
	"T88x_JS0_WAIT_ISSUE",
	"T88x_JS0_WAIT_DEPEND",
	"T88x_JS0_WAIT_FINISH",
	"T88x_JS1_JOBS",
	"T88x_JS1_TASKS",
	"T88x_JS1_ACTIVE",
	"",
	"T88x_JS1_WAIT_READ",
	"T88x_JS1_WAIT_ISSUE",
	"T88x_JS1_WAIT_DEPEND",
	"T88x_JS1_WAIT_FINISH",
	"T88x_JS2_JOBS",
	"T88x_JS2_TASKS",
	"T88x_JS2_ACTIVE",
	"",
	"T88x_JS2_WAIT_READ",
	"T88x_JS2_WAIT_ISSUE",
	"T88x_JS2_WAIT_DEPEND",
	"T88x_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"T88x_TI_JOBS_PROCESSED",
	"T88x_TI_TRIANGLES",
	"T88x_TI_QUADS",
	"T88x_TI_POLYGONS",
	"T88x_TI_POINTS",
	"T88x_TI_LINES",
	"T88x_TI_VCACHE_HIT",
	"T88x_TI_VCACHE_MISS",
	"T88x_TI_FRONT_FACING",
	"T88x_TI_BACK_FACING",
	"T88x_TI_PRIM_VISIBLE",
	"T88x_TI_PRIM_CULLED",
	"T88x_TI_PRIM_CLIPPED",
	"T88x_TI_LEVEL0",
	"T88x_TI_LEVEL1",
	"T88x_TI_LEVEL2",
	"T88x_TI_LEVEL3",
	"T88x_TI_LEVEL4",
	"T88x_TI_LEVEL5",
	"T88x_TI_LEVEL6",
	"T88x_TI_LEVEL7",
	"T88x_TI_COMMAND_1",
	"T88x_TI_COMMAND_2",
	"T88x_TI_COMMAND_3",
	"T88x_TI_COMMAND_4",
	"T88x_TI_COMMAND_5_7",
	"T88x_TI_COMMAND_8_15",
	"T88x_TI_COMMAND_16_63",
	"T88x_TI_COMMAND_64",
	"T88x_TI_COMPRESS_IN",
	"T88x_TI_COMPRESS_OUT",
	"T88x_TI_COMPRESS_FLUSH",
	"T88x_TI_TIMESTAMPS",
	"T88x_TI_PCACHE_HIT",
	"T88x_TI_PCACHE_MISS",
	"T88x_TI_PCACHE_LINE",
	"T88x_TI_PCACHE_STALL",
	"T88x_TI_WRBUF_HIT",
	"T88x_TI_WRBUF_MISS",
	"T88x_TI_WRBUF_LINE",
	"T88x_TI_WRBUF_PARTIAL",
	"T88x_TI_WRBUF_STALL",
	"T88x_TI_ACTIVE",
	"T88x_TI_LOADING_DESC",
	"T88x_TI_INDEX_WAIT",
	"T88x_TI_INDEX_RANGE_WAIT",
	"T88x_TI_VERTEX_WAIT",
	"T88x_TI_PCACHE_WAIT",
	"T88x_TI_WRBUF_WAIT",
	"T88x_TI_BUS_READ",
	"T88x_TI_BUS_WRITE",
	"",
	"",
	"",
	"",
	"",
	"T88x_TI_UTLB_HIT",
	"T88x_TI_UTLB_NEW_MISS",
	"T88x_TI_UTLB_REPLAY_FULL",
	"T88x_TI_UTLB_REPLAY_MISS",
	"T88x_TI_UTLB_STALL",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"T88x_FRAG_ACTIVE",
	"T88x_FRAG_PRIMITIVES",
	"T88x_FRAG_PRIMITIVES_DROPPED",
	"T88x_FRAG_CYCLES_DESC",
	"T88x_FRAG_CYCLES_ZS_REORDER_ACTIVE",
	"T88x_FRAG_CYCLES_VERT",
	"T88x_FRAG_CYCLES_TRISETUP",
	"T88x_FRAG_CYCLES_FPKQ_ACTIVE",
	"T88x_FRAG_THREADS",
	"T88x_FRAG_DUMMY_THREADS",
	"T88x_FRAG_QUADS_RAST",
	"T88x_FRAG_QUADS_EZS_TEST",
	"T88x_FRAG_QUADS_EZS_KILLED",
	"T88x_FRAG_THREADS_LZS_TEST",
	"T88x_FRAG_THREADS_LZS_KILLED",
	"T88x_FRAG_CYCLES_NO_TILE",
	"T88x_FRAG_NUM_TILES",
	"T88x_FRAG_TRANS_ELIM",
	"T88x_COMPUTE_ACTIVE",
	"T88x_COMPUTE_TASKS",
	"T88x_COMPUTE_THREADS",
	"T88x_COMPUTE_CYCLES_DESC",
	"T88x_TRIPIPE_ACTIVE",
	"T88x_ARITH_WORDS",
	"T88x_ARITH_CYCLES_REG",
	"T88x_ARITH_CYCLES_L0",
	"T88x_ARITH_FRAG_DEPEND",
	"T88x_LS_WORDS",
	"T88x_LS_ISSUES",
	"T88x_LS_REISSUE_ATTR",
	"T88x_LS_REISSUES_VARY",
	"T88x_LS_VARY_RV_MISS",
	"T88x_LS_VARY_RV_HIT",
	"T88x_LS_NO_UNPARK",
	"T88x_TEX_WORDS",
	"T88x_TEX_BUBBLES",
	"T88x_TEX_WORDS_L0",
	"T88x_TEX_WORDS_DESC",
	"T88x_TEX_ISSUES",
	"T88x_TEX_RECIRC_FMISS",
	"T88x_TEX_RECIRC_DESC",
	"T88x_TEX_RECIRC_MULTI",
	"T88x_TEX_RECIRC_PMISS",
	"T88x_TEX_RECIRC_CONF",
	"T88x_LSC_READ_HITS",
	"T88x_LSC_READ_OP",
	"T88x_LSC_WRITE_HITS",
	"T88x_LSC_WRITE_OP",
	"T88x_LSC_ATOMIC_HITS",
	"T88x_LSC_ATOMIC_OP",
	"T88x_LSC_LINE_FETCHES",
	"T88x_LSC_DIRTY_LINE",
	"T88x_LSC_SNOOPS",
	"T88x_AXI_TLB_STALL",
	"T88x_AXI_TLB_MISS",
	"T88x_AXI_TLB_TRANSACTION",
	"T88x_LS_TLB_MISS",
	"T88x_LS_TLB_HIT",
	"T88x_AXI_BEATS_READ",
	"T88x_AXI_BEATS_WRITTEN",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"T88x_MMU_HIT",
	"T88x_MMU_NEW_MISS",
	"T88x_MMU_REPLAY_FULL",
	"T88x_MMU_REPLAY_MISS",
	"T88x_MMU_TABLE_WALK",
	"T88x_MMU_REQUESTS",
	"",
	"",
	"T88x_UTLB_HIT",
	"T88x_UTLB_NEW_MISS",
	"T88x_UTLB_REPLAY_FULL",
	"T88x_UTLB_REPLAY_MISS",
	"T88x_UTLB_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"T88x_L2_EXT_WRITE_BEATS",
	"T88x_L2_EXT_READ_BEATS",
	"T88x_L2_ANY_LOOKUP",
	"T88x_L2_READ_LOOKUP",
	"T88x_L2_SREAD_LOOKUP",
	"T88x_L2_READ_REPLAY",
	"T88x_L2_READ_SNOOP",
	"T88x_L2_READ_HIT",
	"T88x_L2_CLEAN_MISS",
	"T88x_L2_WRITE_LOOKUP",
	"T88x_L2_SWRITE_LOOKUP",
	"T88x_L2_WRITE_REPLAY",
	"T88x_L2_WRITE_SNOOP",
	"T88x_L2_WRITE_HIT",
	"T88x_L2_EXT_READ_FULL",
	"",
	"T88x_L2_EXT_WRITE_FULL",
	"T88x_L2_EXT_R_W_HAZARD",
	"T88x_L2_EXT_READ",
	"T88x_L2_EXT_READ_LINE",
	"T88x_L2_EXT_WRITE",
	"T88x_L2_EXT_WRITE_LINE",
	"T88x_L2_EXT_WRITE_SMALL",
	"T88x_L2_EXT_BARRIER",
	"T88x_L2_EXT_AR_STALL",
	"T88x_L2_EXT_R_BUF_FULL",
	"T88x_L2_EXT_RD_BUF_FULL",
	"T88x_L2_EXT_R_RAW",
	"T88x_L2_EXT_W_STALL",
	"T88x_L2_EXT_W_BUF_FULL",
	"T88x_L2_EXT_R_BUF_FULL",
	"T88x_L2_TAG_HAZARD",
	"T88x_L2_SNOOP_FULL",
	"T88x_L2_REPLAY_FULL"};

static const char *const hardware_counters_mali_tHEx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"THEx_MESSAGES_SENT",
	"THEx_MESSAGES_RECEIVED",
	"THEx_GPU_ACTIVE",
	"THEx_IRQ_ACTIVE",
	"THEx_JS0_JOBS",
	"THEx_JS0_TASKS",
	"THEx_JS0_ACTIVE",
	"",
	"THEx_JS0_WAIT_READ",
	"THEx_JS0_WAIT_ISSUE",
	"THEx_JS0_WAIT_DEPEND",
	"THEx_JS0_WAIT_FINISH",
	"THEx_JS1_JOBS",
	"THEx_JS1_TASKS",
	"THEx_JS1_ACTIVE",
	"",
	"THEx_JS1_WAIT_READ",
	"THEx_JS1_WAIT_ISSUE",
	"THEx_JS1_WAIT_DEPEND",
	"THEx_JS1_WAIT_FINISH",
	"THEx_JS2_JOBS",
	"THEx_JS2_TASKS",
	"THEx_JS2_ACTIVE",
	"",
	"THEx_JS2_WAIT_READ",
	"THEx_JS2_WAIT_ISSUE",
	"THEx_JS2_WAIT_DEPEND",
	"THEx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"THEx_TILER_ACTIVE",
	"THEx_JOBS_PROCESSED",
	"THEx_TRIANGLES",
	"THEx_LINES",
	"THEx_POINTS",
	"THEx_FRONT_FACING",
	"THEx_BACK_FACING",
	"THEx_PRIM_VISIBLE",
	"THEx_PRIM_CULLED",
	"THEx_PRIM_CLIPPED",
	"THEx_PRIM_SAT_CULLED",
	"",
	"",
	"THEx_BUS_READ",
	"",
	"THEx_BUS_WRITE",
	"THEx_LOADING_DESC",
	"THEx_IDVS_POS_SHAD_REQ",
	"THEx_IDVS_POS_SHAD_WAIT",
	"THEx_IDVS_POS_SHAD_STALL",
	"THEx_IDVS_POS_FIFO_FULL",
	"THEx_PREFETCH_STALL",
	"THEx_VCACHE_HIT",
	"THEx_VCACHE_MISS",
	"THEx_VCACHE_LINE_WAIT",
	"THEx_VFETCH_POS_READ_WAIT",
	"THEx_VFETCH_VERTEX_WAIT",
	"THEx_VFETCH_STALL",
	"THEx_PRIMASSY_STALL",
	"THEx_BBOX_GEN_STALL",
	"THEx_IDVS_VBU_HIT",
	"THEx_IDVS_VBU_MISS",
	"THEx_IDVS_VBU_LINE_DEALLOCATE",
	"THEx_IDVS_VAR_SHAD_REQ",
	"THEx_IDVS_VAR_SHAD_STALL",
	"THEx_BINNER_STALL",
	"THEx_ITER_STALL",
	"THEx_COMPRESS_MISS",
	"THEx_COMPRESS_STALL",
	"THEx_PCACHE_HIT",
	"THEx_PCACHE_MISS",
	"THEx_PCACHE_MISS_STALL",
	"THEx_PCACHE_EVICT_STALL",
	"THEx_PMGR_PTR_WR_STALL",
	"THEx_PMGR_PTR_RD_STALL",
	"THEx_PMGR_CMD_WR_STALL",
	"THEx_WRBUF_ACTIVE",
	"THEx_WRBUF_HIT",
	"THEx_WRBUF_MISS",
	"THEx_WRBUF_NO_FREE_LINE_STALL",
	"THEx_WRBUF_NO_AXI_ID_STALL",
	"THEx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"THEx_UTLB_TRANS",
	"THEx_UTLB_TRANS_HIT",
	"THEx_UTLB_TRANS_STALL",
	"THEx_UTLB_TRANS_MISS_DELAY",
	"THEx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"THEx_FRAG_ACTIVE",
	"THEx_FRAG_PRIMITIVES",
	"THEx_FRAG_PRIM_RAST",
	"THEx_FRAG_FPK_ACTIVE",
	"THEx_FRAG_STARVING",
	"THEx_FRAG_WARPS",
	"THEx_FRAG_PARTIAL_WARPS",
	"THEx_FRAG_QUADS_RAST",
	"THEx_FRAG_QUADS_EZS_TEST",
	"THEx_FRAG_QUADS_EZS_UPDATE",
	"THEx_FRAG_QUADS_EZS_KILL",
	"THEx_FRAG_LZS_TEST",
	"THEx_FRAG_LZS_KILL",
	"",
	"THEx_FRAG_PTILES",
	"THEx_FRAG_TRANS_ELIM",
	"THEx_QUAD_FPK_KILLER",
	"",
	"THEx_COMPUTE_ACTIVE",
	"THEx_COMPUTE_TASKS",
	"THEx_COMPUTE_WARPS",
	"THEx_COMPUTE_STARVING",
	"THEx_EXEC_CORE_ACTIVE",
	"THEx_EXEC_ACTIVE",
	"THEx_EXEC_INSTR_COUNT",
	"THEx_EXEC_INSTR_DIVERGED",
	"THEx_EXEC_INSTR_STARVING",
	"THEx_ARITH_INSTR_SINGLE_FMA",
	"THEx_ARITH_INSTR_DOUBLE",
	"THEx_ARITH_INSTR_MSG",
	"THEx_ARITH_INSTR_MSG_ONLY",
	"THEx_TEX_INSTR",
	"THEx_TEX_INSTR_MIPMAP",
	"THEx_TEX_INSTR_COMPRESSED",
	"THEx_TEX_INSTR_3D",
	"THEx_TEX_INSTR_TRILINEAR",
	"THEx_TEX_COORD_ISSUE",
	"THEx_TEX_COORD_STALL",
	"THEx_TEX_STARVE_CACHE",
	"THEx_TEX_STARVE_FILTER",
	"THEx_LS_MEM_READ_FULL",
	"THEx_LS_MEM_READ_SHORT",
	"THEx_LS_MEM_WRITE_FULL",
	"THEx_LS_MEM_WRITE_SHORT",
	"THEx_LS_MEM_ATOMIC",
	"THEx_VARY_INSTR",
	"THEx_VARY_SLOT_32",
	"THEx_VARY_SLOT_16",
	"THEx_ATTR_INSTR",
	"THEx_ARITH_INSTR_FP_MUL",
	"THEx_BEATS_RD_FTC",
	"THEx_BEATS_RD_FTC_EXT",
	"THEx_BEATS_RD_LSC",
	"THEx_BEATS_RD_LSC_EXT",
	"THEx_BEATS_RD_TEX",
	"THEx_BEATS_RD_TEX_EXT",
	"THEx_BEATS_RD_OTHER",
	"THEx_BEATS_WR_LSC",
	"THEx_BEATS_WR_TIB",
	"",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"THEx_MMU_REQUESTS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"THEx_L2_RD_MSG_IN",
	"THEx_L2_RD_MSG_IN_STALL",
	"THEx_L2_WR_MSG_IN",
	"THEx_L2_WR_MSG_IN_STALL",
	"THEx_L2_SNP_MSG_IN",
	"THEx_L2_SNP_MSG_IN_STALL",
	"THEx_L2_RD_MSG_OUT",
	"THEx_L2_RD_MSG_OUT_STALL",
	"THEx_L2_WR_MSG_OUT",
	"THEx_L2_ANY_LOOKUP",
	"THEx_L2_READ_LOOKUP",
	"THEx_L2_WRITE_LOOKUP",
	"THEx_L2_EXT_SNOOP_LOOKUP",
	"THEx_L2_EXT_READ",
	"THEx_L2_EXT_READ_NOSNP",
	"THEx_L2_EXT_READ_UNIQUE",
	"THEx_L2_EXT_READ_BEATS",
	"THEx_L2_EXT_AR_STALL",
	"THEx_L2_EXT_AR_CNT_Q1",
	"THEx_L2_EXT_AR_CNT_Q2",
	"THEx_L2_EXT_AR_CNT_Q3",
	"THEx_L2_EXT_RRESP_0_127",
	"THEx_L2_EXT_RRESP_128_191",
	"THEx_L2_EXT_RRESP_192_255",
	"THEx_L2_EXT_RRESP_256_319",
	"THEx_L2_EXT_RRESP_320_383",
	"THEx_L2_EXT_WRITE",
	"THEx_L2_EXT_WRITE_NOSNP_FULL",
	"THEx_L2_EXT_WRITE_NOSNP_PTL",
	"THEx_L2_EXT_WRITE_SNP_FULL",
	"THEx_L2_EXT_WRITE_SNP_PTL",
	"THEx_L2_EXT_WRITE_BEATS",
	"THEx_L2_EXT_W_STALL",
	"THEx_L2_EXT_AW_CNT_Q1",
	"THEx_L2_EXT_AW_CNT_Q2",
	"THEx_L2_EXT_AW_CNT_Q3",
	"THEx_L2_EXT_SNOOP",
	"THEx_L2_EXT_SNOOP_STALL",
	"THEx_L2_EXT_SNOOP_RESP_CLEAN",
	"THEx_L2_EXT_SNOOP_RESP_DATA",
	"THEx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tMIx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TMIx_MESSAGES_SENT",
	"TMIx_MESSAGES_RECEIVED",
	"TMIx_GPU_ACTIVE",
	"TMIx_IRQ_ACTIVE",
	"TMIx_JS0_JOBS",
	"TMIx_JS0_TASKS",
	"TMIx_JS0_ACTIVE",
	"",
	"TMIx_JS0_WAIT_READ",
	"TMIx_JS0_WAIT_ISSUE",
	"TMIx_JS0_WAIT_DEPEND",
	"TMIx_JS0_WAIT_FINISH",
	"TMIx_JS1_JOBS",
	"TMIx_JS1_TASKS",
	"TMIx_JS1_ACTIVE",
	"",
	"TMIx_JS1_WAIT_READ",
	"TMIx_JS1_WAIT_ISSUE",
	"TMIx_JS1_WAIT_DEPEND",
	"TMIx_JS1_WAIT_FINISH",
	"TMIx_JS2_JOBS",
	"TMIx_JS2_TASKS",
	"TMIx_JS2_ACTIVE",
	"",
	"TMIx_JS2_WAIT_READ",
	"TMIx_JS2_WAIT_ISSUE",
	"TMIx_JS2_WAIT_DEPEND",
	"TMIx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TMIx_TILER_ACTIVE",
	"TMIx_JOBS_PROCESSED",
	"TMIx_TRIANGLES",
	"TMIx_LINES",
	"TMIx_POINTS",
	"TMIx_FRONT_FACING",
	"TMIx_BACK_FACING",
	"TMIx_PRIM_VISIBLE",
	"TMIx_PRIM_CULLED",
	"TMIx_PRIM_CLIPPED",
	"TMIx_PRIM_SAT_CULLED",
	"TMIx_BIN_ALLOC_INIT",
	"TMIx_BIN_ALLOC_OVERFLOW",
	"TMIx_BUS_READ",
	"",
	"TMIx_BUS_WRITE",
	"TMIx_LOADING_DESC",
	"TMIx_IDVS_POS_SHAD_REQ",
	"TMIx_IDVS_POS_SHAD_WAIT",
	"TMIx_IDVS_POS_SHAD_STALL",
	"TMIx_IDVS_POS_FIFO_FULL",
	"TMIx_PREFETCH_STALL",
	"TMIx_VCACHE_HIT",
	"TMIx_VCACHE_MISS",
	"TMIx_VCACHE_LINE_WAIT",
	"TMIx_VFETCH_POS_READ_WAIT",
	"TMIx_VFETCH_VERTEX_WAIT",
	"TMIx_VFETCH_STALL",
	"TMIx_PRIMASSY_STALL",
	"TMIx_BBOX_GEN_STALL",
	"TMIx_IDVS_VBU_HIT",
	"TMIx_IDVS_VBU_MISS",
	"TMIx_IDVS_VBU_LINE_DEALLOCATE",
	"TMIx_IDVS_VAR_SHAD_REQ",
	"TMIx_IDVS_VAR_SHAD_STALL",
	"TMIx_BINNER_STALL",
	"TMIx_ITER_STALL",
	"TMIx_COMPRESS_MISS",
	"TMIx_COMPRESS_STALL",
	"TMIx_PCACHE_HIT",
	"TMIx_PCACHE_MISS",
	"TMIx_PCACHE_MISS_STALL",
	"TMIx_PCACHE_EVICT_STALL",
	"TMIx_PMGR_PTR_WR_STALL",
	"TMIx_PMGR_PTR_RD_STALL",
	"TMIx_PMGR_CMD_WR_STALL",
	"TMIx_WRBUF_ACTIVE",
	"TMIx_WRBUF_HIT",
	"TMIx_WRBUF_MISS",
	"TMIx_WRBUF_NO_FREE_LINE_STALL",
	"TMIx_WRBUF_NO_AXI_ID_STALL",
	"TMIx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TMIx_UTLB_TRANS",
	"TMIx_UTLB_TRANS_HIT",
	"TMIx_UTLB_TRANS_STALL",
	"TMIx_UTLB_TRANS_MISS_DELAY",
	"TMIx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TMIx_FRAG_ACTIVE",
	"TMIx_FRAG_PRIMITIVES",
	"TMIx_FRAG_PRIM_RAST",
	"TMIx_FRAG_FPK_ACTIVE",
	"TMIx_FRAG_STARVING",
	"TMIx_FRAG_WARPS",
	"TMIx_FRAG_PARTIAL_WARPS",
	"TMIx_FRAG_QUADS_RAST",
	"TMIx_FRAG_QUADS_EZS_TEST",
	"TMIx_FRAG_QUADS_EZS_UPDATE",
	"TMIx_FRAG_QUADS_EZS_KILL",
	"TMIx_FRAG_LZS_TEST",
	"TMIx_FRAG_LZS_KILL",
	"",
	"TMIx_FRAG_PTILES",
	"TMIx_FRAG_TRANS_ELIM",
	"TMIx_QUAD_FPK_KILLER",
	"",
	"TMIx_COMPUTE_ACTIVE",
	"TMIx_COMPUTE_TASKS",
	"TMIx_COMPUTE_WARPS",
	"TMIx_COMPUTE_STARVING",
	"TMIx_EXEC_CORE_ACTIVE",
	"TMIx_EXEC_ACTIVE",
	"TMIx_EXEC_INSTR_COUNT",
	"TMIx_EXEC_INSTR_DIVERGED",
	"TMIx_EXEC_INSTR_STARVING",
	"TMIx_ARITH_INSTR_SINGLE_FMA",
	"TMIx_ARITH_INSTR_DOUBLE",
	"TMIx_ARITH_INSTR_MSG",
	"TMIx_ARITH_INSTR_MSG_ONLY",
	"TMIx_TEX_INSTR",
	"TMIx_TEX_INSTR_MIPMAP",
	"TMIx_TEX_INSTR_COMPRESSED",
	"TMIx_TEX_INSTR_3D",
	"TMIx_TEX_INSTR_TRILINEAR",
	"TMIx_TEX_COORD_ISSUE",
	"TMIx_TEX_COORD_STALL",
	"TMIx_TEX_STARVE_CACHE",
	"TMIx_TEX_STARVE_FILTER",
	"TMIx_LS_MEM_READ_FULL",
	"TMIx_LS_MEM_READ_SHORT",
	"TMIx_LS_MEM_WRITE_FULL",
	"TMIx_LS_MEM_WRITE_SHORT",
	"TMIx_LS_MEM_ATOMIC",
	"TMIx_VARY_INSTR",
	"TMIx_VARY_SLOT_32",
	"TMIx_VARY_SLOT_16",
	"TMIx_ATTR_INSTR",
	"TMIx_ARITH_INSTR_FP_MUL",
	"TMIx_BEATS_RD_FTC",
	"TMIx_BEATS_RD_FTC_EXT",
	"TMIx_BEATS_RD_LSC",
	"TMIx_BEATS_RD_LSC_EXT",
	"TMIx_BEATS_RD_TEX",
	"TMIx_BEATS_RD_TEX_EXT",
	"TMIx_BEATS_RD_OTHER",
	"TMIx_BEATS_WR_LSC",
	"TMIx_BEATS_WR_TIB",
	"",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TMIx_MMU_REQUESTS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TMIx_L2_RD_MSG_IN",
	"TMIx_L2_RD_MSG_IN_STALL",
	"TMIx_L2_WR_MSG_IN",
	"TMIx_L2_WR_MSG_IN_STALL",
	"TMIx_L2_SNP_MSG_IN",
	"TMIx_L2_SNP_MSG_IN_STALL",
	"TMIx_L2_RD_MSG_OUT",
	"TMIx_L2_RD_MSG_OUT_STALL",
	"TMIx_L2_WR_MSG_OUT",
	"TMIx_L2_ANY_LOOKUP",
	"TMIx_L2_READ_LOOKUP",
	"TMIx_L2_WRITE_LOOKUP",
	"TMIx_L2_EXT_SNOOP_LOOKUP",
	"TMIx_L2_EXT_READ",
	"TMIx_L2_EXT_READ_NOSNP",
	"TMIx_L2_EXT_READ_UNIQUE",
	"TMIx_L2_EXT_READ_BEATS",
	"TMIx_L2_EXT_AR_STALL",
	"TMIx_L2_EXT_AR_CNT_Q1",
	"TMIx_L2_EXT_AR_CNT_Q2",
	"TMIx_L2_EXT_AR_CNT_Q3",
	"TMIx_L2_EXT_RRESP_0_127",
	"TMIx_L2_EXT_RRESP_128_191",
	"TMIx_L2_EXT_RRESP_192_255",
	"TMIx_L2_EXT_RRESP_256_319",
	"TMIx_L2_EXT_RRESP_320_383",
	"TMIx_L2_EXT_WRITE",
	"TMIx_L2_EXT_WRITE_NOSNP_FULL",
	"TMIx_L2_EXT_WRITE_NOSNP_PTL",
	"TMIx_L2_EXT_WRITE_SNP_FULL",
	"TMIx_L2_EXT_WRITE_SNP_PTL",
	"TMIx_L2_EXT_WRITE_BEATS",
	"TMIx_L2_EXT_W_STALL",
	"TMIx_L2_EXT_AW_CNT_Q1",
	"TMIx_L2_EXT_AW_CNT_Q2",
	"TMIx_L2_EXT_AW_CNT_Q3",
	"TMIx_L2_EXT_SNOOP",
	"TMIx_L2_EXT_SNOOP_STALL",
	"TMIx_L2_EXT_SNOOP_RESP_CLEAN",
	"TMIx_L2_EXT_SNOOP_RESP_DATA",
	"TMIx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tDVx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TDVx_MESSAGES_SENT",
	"TDVx_MESSAGES_RECEIVED",
	"TDVx_GPU_ACTIVE",
	"TDVx_IRQ_ACTIVE",
	"TDVx_JS0_JOBS",
	"TDVx_JS0_TASKS",
	"TDVx_JS0_ACTIVE",
	"TDVx_JS0_WAIT_FLUSH",
	"TDVx_JS0_WAIT_READ",
	"TDVx_JS0_WAIT_ISSUE",
	"TDVx_JS0_WAIT_DEPEND",
	"TDVx_JS0_WAIT_FINISH",
	"TDVx_JS1_JOBS",
	"TDVx_JS1_TASKS",
	"TDVx_JS1_ACTIVE",
	"TDVx_JS1_WAIT_FLUSH",
	"TDVx_JS1_WAIT_READ",
	"TDVx_JS1_WAIT_ISSUE",
	"TDVx_JS1_WAIT_DEPEND",
	"TDVx_JS1_WAIT_FINISH",
	"TDVx_JS2_JOBS",
	"TDVx_JS2_TASKS",
	"TDVx_JS2_ACTIVE",
	"TDVx_JS2_WAIT_FLUSH",
	"TDVx_JS2_WAIT_READ",
	"TDVx_JS2_WAIT_ISSUE",
	"TDVx_JS2_WAIT_DEPEND",
	"TDVx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TDVx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TDVx_TILER_ACTIVE",
	"TDVx_JOBS_PROCESSED",
	"TDVx_TRIANGLES",
	"TDVx_LINES",
	"TDVx_POINTS",
	"TDVx_FRONT_FACING",
	"TDVx_BACK_FACING",
	"TDVx_PRIM_VISIBLE",
	"TDVx_PRIM_CULLED",
	"TDVx_PRIM_CLIPPED",
	"TDVx_PRIM_SAT_CULLED",
	"TDVx_BIN_ALLOC_INIT",
	"TDVx_BIN_ALLOC_OVERFLOW",
	"TDVx_BUS_READ",
	"",
	"TDVx_BUS_WRITE",
	"TDVx_LOADING_DESC",
	"TDVx_IDVS_POS_SHAD_REQ",
	"TDVx_IDVS_POS_SHAD_WAIT",
	"TDVx_IDVS_POS_SHAD_STALL",
	"TDVx_IDVS_POS_FIFO_FULL",
	"TDVx_PREFETCH_STALL",
	"TDVx_VCACHE_HIT",
	"TDVx_VCACHE_MISS",
	"TDVx_VCACHE_LINE_WAIT",
	"TDVx_VFETCH_POS_READ_WAIT",
	"TDVx_VFETCH_VERTEX_WAIT",
	"TDVx_VFETCH_STALL",
	"TDVx_PRIMASSY_STALL",
	"TDVx_BBOX_GEN_STALL",
	"TDVx_IDVS_VBU_HIT",
	"TDVx_IDVS_VBU_MISS",
	"TDVx_IDVS_VBU_LINE_DEALLOCATE",
	"TDVx_IDVS_VAR_SHAD_REQ",
	"TDVx_IDVS_VAR_SHAD_STALL",
	"TDVx_BINNER_STALL",
	"TDVx_ITER_STALL",
	"TDVx_COMPRESS_MISS",
	"TDVx_COMPRESS_STALL",
	"TDVx_PCACHE_HIT",
	"TDVx_PCACHE_MISS",
	"TDVx_PCACHE_MISS_STALL",
	"TDVx_PCACHE_EVICT_STALL",
	"TDVx_PMGR_PTR_WR_STALL",
	"TDVx_PMGR_PTR_RD_STALL",
	"TDVx_PMGR_CMD_WR_STALL",
	"TDVx_WRBUF_ACTIVE",
	"TDVx_WRBUF_HIT",
	"TDVx_WRBUF_MISS",
	"TDVx_WRBUF_NO_FREE_LINE_STALL",
	"TDVx_WRBUF_NO_AXI_ID_STALL",
	"TDVx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TDVx_UTLB_TRANS",
	"TDVx_UTLB_TRANS_HIT",
	"TDVx_UTLB_TRANS_STALL",
	"TDVx_UTLB_TRANS_MISS_DELAY",
	"TDVx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TDVx_FRAG_ACTIVE",
	"TDVx_FRAG_PRIMITIVES",
	"TDVx_FRAG_PRIM_RAST",
	"TDVx_FRAG_FPK_ACTIVE",
	"TDVx_FRAG_STARVING",
	"TDVx_FRAG_WARPS",
	"TDVx_FRAG_PARTIAL_WARPS",
	"TDVx_FRAG_QUADS_RAST",
	"TDVx_FRAG_QUADS_EZS_TEST",
	"TDVx_FRAG_QUADS_EZS_UPDATE",
	"TDVx_FRAG_QUADS_EZS_KILL",
	"TDVx_FRAG_LZS_TEST",
	"TDVx_FRAG_LZS_KILL",
	"",
	"TDVx_FRAG_PTILES",
	"TDVx_FRAG_TRANS_ELIM",
	"TDVx_QUAD_FPK_KILLER",
	"",
	"TDVx_COMPUTE_ACTIVE",
	"TDVx_COMPUTE_TASKS",
	"TDVx_COMPUTE_WARPS",
	"TDVx_COMPUTE_STARVING",
	"TDVx_EXEC_CORE_ACTIVE",
	"TDVx_EXEC_ACTIVE",
	"TDVx_EXEC_INSTR_COUNT",
	"TDVx_EXEC_INSTR_DIVERGED",
	"TDVx_EXEC_INSTR_STARVING",
	"TDVx_ARITH_INSTR_SINGLE_FMA",
	"TDVx_ARITH_INSTR_DOUBLE",
	"TDVx_ARITH_INSTR_MSG",
	"TDVx_ARITH_INSTR_MSG_ONLY",
	"TDVx_TEX_MSGI_NUM_QUADS",
	"TDVx_TEX_DFCH_NUM_PASSES",
	"TDVx_TEX_DFCH_NUM_PASSES_MISS",
	"TDVx_TEX_DFCH_NUM_PASSES_MIP_MAP",
	"TDVx_TEX_TIDX_NUM_SPLIT_MIP_MAP",
	"TDVx_TEX_TFCH_NUM_LINES_FETCHED",
	"TDVx_TEX_TFCH_NUM_LINES_FETCHED_BLOCK_COMPRESSED",
	"TDVx_TEX_TFCH_NUM_OPERATIONS",
	"TDVx_TEX_FILT_NUM_OPERATIONS",
	"TDVx_LS_MEM_READ_FULL",
	"TDVx_LS_MEM_READ_SHORT",
	"TDVx_LS_MEM_WRITE_FULL",
	"TDVx_LS_MEM_WRITE_SHORT",
	"TDVx_LS_MEM_ATOMIC",
	"TDVx_VARY_INSTR",
	"TDVx_VARY_SLOT_32",
	"TDVx_VARY_SLOT_16",
	"TDVx_ATTR_INSTR",
	"TDVx_ARITH_INSTR_FP_MUL",
	"TDVx_BEATS_RD_FTC",
	"TDVx_BEATS_RD_FTC_EXT",
	"TDVx_BEATS_RD_LSC",
	"TDVx_BEATS_RD_LSC_EXT",
	"TDVx_BEATS_RD_TEX",
	"TDVx_BEATS_RD_TEX_EXT",
	"TDVx_BEATS_RD_OTHER",
	"TDVx_BEATS_WR_LSC_OTHER",
	"TDVx_BEATS_WR_TIB",
	"TDVx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TDVx_MMU_REQUESTS",
	"TDVx_MMU_TABLE_READS_L3",
	"TDVx_MMU_TABLE_READS_L2",
	"TDVx_MMU_HIT_L3",
	"TDVx_MMU_HIT_L2",
	"TDVx_MMU_S2_REQUESTS",
	"TDVx_MMU_S2_TABLE_READS_L3",
	"TDVx_MMU_S2_TABLE_READS_L2",
	"TDVx_MMU_S2_HIT_L3",
	"TDVx_MMU_S2_HIT_L2",
	"",
	"",
	"TDVx_L2_RD_MSG_IN",
	"TDVx_L2_RD_MSG_IN_STALL",
	"TDVx_L2_WR_MSG_IN",
	"TDVx_L2_WR_MSG_IN_STALL",
	"TDVx_L2_SNP_MSG_IN",
	"TDVx_L2_SNP_MSG_IN_STALL",
	"TDVx_L2_RD_MSG_OUT",
	"TDVx_L2_RD_MSG_OUT_STALL",
	"TDVx_L2_WR_MSG_OUT",
	"TDVx_L2_ANY_LOOKUP",
	"TDVx_L2_READ_LOOKUP",
	"TDVx_L2_WRITE_LOOKUP",
	"TDVx_L2_EXT_SNOOP_LOOKUP",
	"TDVx_L2_EXT_READ",
	"TDVx_L2_EXT_READ_NOSNP",
	"TDVx_L2_EXT_READ_UNIQUE",
	"TDVx_L2_EXT_READ_BEATS",
	"TDVx_L2_EXT_AR_STALL",
	"TDVx_L2_EXT_AR_CNT_Q1",
	"TDVx_L2_EXT_AR_CNT_Q2",
	"TDVx_L2_EXT_AR_CNT_Q3",
	"TDVx_L2_EXT_RRESP_0_127",
	"TDVx_L2_EXT_RRESP_128_191",
	"TDVx_L2_EXT_RRESP_192_255",
	"TDVx_L2_EXT_RRESP_256_319",
	"TDVx_L2_EXT_RRESP_320_383",
	"TDVx_L2_EXT_WRITE",
	"TDVx_L2_EXT_WRITE_NOSNP_FULL",
	"TDVx_L2_EXT_WRITE_NOSNP_PTL",
	"TDVx_L2_EXT_WRITE_SNP_FULL",
	"TDVx_L2_EXT_WRITE_SNP_PTL",
	"TDVx_L2_EXT_WRITE_BEATS",
	"TDVx_L2_EXT_W_STALL",
	"TDVx_L2_EXT_AW_CNT_Q1",
	"TDVx_L2_EXT_AW_CNT_Q2",
	"TDVx_L2_EXT_AW_CNT_Q3",
	"TDVx_L2_EXT_SNOOP",
	"TDVx_L2_EXT_SNOOP_STALL",
	"TDVx_L2_EXT_SNOOP_RESP_CLEAN",
	"TDVx_L2_EXT_SNOOP_RESP_DATA",
	"TDVx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tSIx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TSIx_MESSAGES_SENT",
	"TSIx_MESSAGES_RECEIVED",
	"TSIx_GPU_ACTIVE",
	"TSIx_IRQ_ACTIVE",
	"TSIx_JS0_JOBS",
	"TSIx_JS0_TASKS",
	"TSIx_JS0_ACTIVE",
	"TSIx_JS0_WAIT_FLUSH",
	"TSIx_JS0_WAIT_READ",
	"TSIx_JS0_WAIT_ISSUE",
	"TSIx_JS0_WAIT_DEPEND",
	"TSIx_JS0_WAIT_FINISH",
	"TSIx_JS1_JOBS",
	"TSIx_JS1_TASKS",
	"TSIx_JS1_ACTIVE",
	"TSIx_JS1_WAIT_FLUSH",
	"TSIx_JS1_WAIT_READ",
	"TSIx_JS1_WAIT_ISSUE",
	"TSIx_JS1_WAIT_DEPEND",
	"TSIx_JS1_WAIT_FINISH",
	"TSIx_JS2_JOBS",
	"TSIx_JS2_TASKS",
	"TSIx_JS2_ACTIVE",
	"TSIx_JS2_WAIT_FLUSH",
	"TSIx_JS2_WAIT_READ",
	"TSIx_JS2_WAIT_ISSUE",
	"TSIx_JS2_WAIT_DEPEND",
	"TSIx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TSIx_TILER_ACTIVE",
	"TSIx_JOBS_PROCESSED",
	"TSIx_TRIANGLES",
	"TSIx_LINES",
	"TSIx_POINTS",
	"TSIx_FRONT_FACING",
	"TSIx_BACK_FACING",
	"TSIx_PRIM_VISIBLE",
	"TSIx_PRIM_CULLED",
	"TSIx_PRIM_CLIPPED",
	"TSIx_PRIM_SAT_CULLED",
	"TSIx_BIN_ALLOC_INIT",
	"TSIx_BIN_ALLOC_OVERFLOW",
	"TSIx_BUS_READ",
	"",
	"TSIx_BUS_WRITE",
	"TSIx_LOADING_DESC",
	"TSIx_IDVS_POS_SHAD_REQ",
	"TSIx_IDVS_POS_SHAD_WAIT",
	"TSIx_IDVS_POS_SHAD_STALL",
	"TSIx_IDVS_POS_FIFO_FULL",
	"TSIx_PREFETCH_STALL",
	"TSIx_VCACHE_HIT",
	"TSIx_VCACHE_MISS",
	"TSIx_VCACHE_LINE_WAIT",
	"TSIx_VFETCH_POS_READ_WAIT",
	"TSIx_VFETCH_VERTEX_WAIT",
	"TSIx_VFETCH_STALL",
	"TSIx_PRIMASSY_STALL",
	"TSIx_BBOX_GEN_STALL",
	"TSIx_IDVS_VBU_HIT",
	"TSIx_IDVS_VBU_MISS",
	"TSIx_IDVS_VBU_LINE_DEALLOCATE",
	"TSIx_IDVS_VAR_SHAD_REQ",
	"TSIx_IDVS_VAR_SHAD_STALL",
	"TSIx_BINNER_STALL",
	"TSIx_ITER_STALL",
	"TSIx_COMPRESS_MISS",
	"TSIx_COMPRESS_STALL",
	"TSIx_PCACHE_HIT",
	"TSIx_PCACHE_MISS",
	"TSIx_PCACHE_MISS_STALL",
	"TSIx_PCACHE_EVICT_STALL",
	"TSIx_PMGR_PTR_WR_STALL",
	"TSIx_PMGR_PTR_RD_STALL",
	"TSIx_PMGR_CMD_WR_STALL",
	"TSIx_WRBUF_ACTIVE",
	"TSIx_WRBUF_HIT",
	"TSIx_WRBUF_MISS",
	"TSIx_WRBUF_NO_FREE_LINE_STALL",
	"TSIx_WRBUF_NO_AXI_ID_STALL",
	"TSIx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TSIx_UTLB_TRANS",
	"TSIx_UTLB_TRANS_HIT",
	"TSIx_UTLB_TRANS_STALL",
	"TSIx_UTLB_TRANS_MISS_DELAY",
	"TSIx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TSIx_FRAG_ACTIVE",
	"TSIx_FRAG_PRIMITIVES",
	"TSIx_FRAG_PRIM_RAST",
	"TSIx_FRAG_FPK_ACTIVE",
	"TSIx_FRAG_STARVING",
	"TSIx_FRAG_WARPS",
	"TSIx_FRAG_PARTIAL_WARPS",
	"TSIx_FRAG_QUADS_RAST",
	"TSIx_FRAG_QUADS_EZS_TEST",
	"TSIx_FRAG_QUADS_EZS_UPDATE",
	"TSIx_FRAG_QUADS_EZS_KILL",
	"TSIx_FRAG_LZS_TEST",
	"TSIx_FRAG_LZS_KILL",
	"",
	"TSIx_FRAG_PTILES",
	"TSIx_FRAG_TRANS_ELIM",
	"TSIx_QUAD_FPK_KILLER",
	"",
	"TSIx_COMPUTE_ACTIVE",
	"TSIx_COMPUTE_TASKS",
	"TSIx_COMPUTE_WARPS",
	"TSIx_COMPUTE_STARVING",
	"TSIx_EXEC_CORE_ACTIVE",
	"TSIx_EXEC_ACTIVE",
	"TSIx_EXEC_INSTR_COUNT",
	"TSIx_EXEC_INSTR_DIVERGED",
	"TSIx_EXEC_INSTR_STARVING",
	"TSIx_ARITH_INSTR_SINGLE_FMA",
	"TSIx_ARITH_INSTR_DOUBLE",
	"TSIx_ARITH_INSTR_MSG",
	"TSIx_ARITH_INSTR_MSG_ONLY",
	"TSIx_TEX_MSGI_NUM_QUADS",
	"TSIx_TEX_DFCH_NUM_PASSES",
	"TSIx_TEX_DFCH_NUM_PASSES_MISS",
	"TSIx_TEX_DFCH_NUM_PASSES_MIP_MAP",
	"TSIx_TEX_TIDX_NUM_SPLIT_MIP_MAP",
	"TSIx_TEX_TFCH_NUM_LINES_FETCHED",
	"TSIx_TEX_TFCH_NUM_LINES_FETCHED_BLOCK_COMPRESSED",
	"TSIx_TEX_TFCH_NUM_OPERATIONS",
	"TSIx_TEX_FILT_NUM_OPERATIONS",
	"TSIx_LS_MEM_READ_FULL",
	"TSIx_LS_MEM_READ_SHORT",
	"TSIx_LS_MEM_WRITE_FULL",
	"TSIx_LS_MEM_WRITE_SHORT",
	"TSIx_LS_MEM_ATOMIC",
	"TSIx_VARY_INSTR",
	"TSIx_VARY_SLOT_32",
	"TSIx_VARY_SLOT_16",
	"TSIx_ATTR_INSTR",
	"TSIx_ARITH_INSTR_FP_MUL",
	"TSIx_BEATS_RD_FTC",
	"TSIx_BEATS_RD_FTC_EXT",
	"TSIx_BEATS_RD_LSC",
	"TSIx_BEATS_RD_LSC_EXT",
	"TSIx_BEATS_RD_TEX",
	"TSIx_BEATS_RD_TEX_EXT",
	"TSIx_BEATS_RD_OTHER",
	"TSIx_BEATS_WR_LSC_OTHER",
	"TSIx_BEATS_WR_TIB",
	"TSIx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TSIx_MMU_REQUESTS",
	"TSIx_MMU_TABLE_READS_L3",
	"TSIx_MMU_TABLE_READS_L2",
	"TSIx_MMU_HIT_L3",
	"TSIx_MMU_HIT_L2",
	"TSIx_MMU_S2_REQUESTS",
	"TSIx_MMU_S2_TABLE_READS_L3",
	"TSIx_MMU_S2_TABLE_READS_L2",
	"TSIx_MMU_S2_HIT_L3",
	"TSIx_MMU_S2_HIT_L2",
	"",
	"",
	"TSIx_L2_RD_MSG_IN",
	"TSIx_L2_RD_MSG_IN_STALL",
	"TSIx_L2_WR_MSG_IN",
	"TSIx_L2_WR_MSG_IN_STALL",
	"TSIx_L2_SNP_MSG_IN",
	"TSIx_L2_SNP_MSG_IN_STALL",
	"TSIx_L2_RD_MSG_OUT",
	"TSIx_L2_RD_MSG_OUT_STALL",
	"TSIx_L2_WR_MSG_OUT",
	"TSIx_L2_ANY_LOOKUP",
	"TSIx_L2_READ_LOOKUP",
	"TSIx_L2_WRITE_LOOKUP",
	"TSIx_L2_EXT_SNOOP_LOOKUP",
	"TSIx_L2_EXT_READ",
	"TSIx_L2_EXT_READ_NOSNP",
	"TSIx_L2_EXT_READ_UNIQUE",
	"TSIx_L2_EXT_READ_BEATS",
	"TSIx_L2_EXT_AR_STALL",
	"TSIx_L2_EXT_AR_CNT_Q1",
	"TSIx_L2_EXT_AR_CNT_Q2",
	"TSIx_L2_EXT_AR_CNT_Q3",
	"TSIx_L2_EXT_RRESP_0_127",
	"TSIx_L2_EXT_RRESP_128_191",
	"TSIx_L2_EXT_RRESP_192_255",
	"TSIx_L2_EXT_RRESP_256_319",
	"TSIx_L2_EXT_RRESP_320_383",
	"TSIx_L2_EXT_WRITE",
	"TSIx_L2_EXT_WRITE_NOSNP_FULL",
	"TSIx_L2_EXT_WRITE_NOSNP_PTL",
	"TSIx_L2_EXT_WRITE_SNP_FULL",
	"TSIx_L2_EXT_WRITE_SNP_PTL",
	"TSIx_L2_EXT_WRITE_BEATS",
	"TSIx_L2_EXT_W_STALL",
	"TSIx_L2_EXT_AW_CNT_Q1",
	"TSIx_L2_EXT_AW_CNT_Q2",
	"TSIx_L2_EXT_AW_CNT_Q3",
	"TSIx_L2_EXT_SNOOP",
	"TSIx_L2_EXT_SNOOP_STALL",
	"TSIx_L2_EXT_SNOOP_RESP_CLEAN",
	"TSIx_L2_EXT_SNOOP_RESP_DATA",
	"TSIx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tNOx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TNOx_MESSAGES_SENT",
	"TNOx_MESSAGES_RECEIVED",
	"TNOx_GPU_ACTIVE",
	"TNOx_IRQ_ACTIVE",
	"TNOx_JS0_JOBS",
	"TNOx_JS0_TASKS",
	"TNOx_JS0_ACTIVE",
	"TNOx_JS0_WAIT_FLUSH",
	"TNOx_JS0_WAIT_READ",
	"TNOx_JS0_WAIT_ISSUE",
	"TNOx_JS0_WAIT_DEPEND",
	"TNOx_JS0_WAIT_FINISH",
	"TNOx_JS1_JOBS",
	"TNOx_JS1_TASKS",
	"TNOx_JS1_ACTIVE",
	"TNOx_JS1_WAIT_FLUSH",
	"TNOx_JS1_WAIT_READ",
	"TNOx_JS1_WAIT_ISSUE",
	"TNOx_JS1_WAIT_DEPEND",
	"TNOx_JS1_WAIT_FINISH",
	"TNOx_JS2_JOBS",
	"TNOx_JS2_TASKS",
	"TNOx_JS2_ACTIVE",
	"TNOx_JS2_WAIT_FLUSH",
	"TNOx_JS2_WAIT_READ",
	"TNOx_JS2_WAIT_ISSUE",
	"TNOx_JS2_WAIT_DEPEND",
	"TNOx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TNOx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TNOx_TILER_ACTIVE",
	"TNOx_JOBS_PROCESSED",
	"TNOx_TRIANGLES",
	"TNOx_LINES",
	"TNOx_POINTS",
	"TNOx_FRONT_FACING",
	"TNOx_BACK_FACING",
	"TNOx_PRIM_VISIBLE",
	"TNOx_PRIM_CULLED",
	"TNOx_PRIM_CLIPPED",
	"TNOx_PRIM_SAT_CULLED",
	"TNOx_BIN_ALLOC_INIT",
	"TNOx_BIN_ALLOC_OVERFLOW",
	"TNOx_BUS_READ",
	"",
	"TNOx_BUS_WRITE",
	"TNOx_LOADING_DESC",
	"TNOx_IDVS_POS_SHAD_REQ",
	"TNOx_IDVS_POS_SHAD_WAIT",
	"TNOx_IDVS_POS_SHAD_STALL",
	"TNOx_IDVS_POS_FIFO_FULL",
	"TNOx_PREFETCH_STALL",
	"TNOx_VCACHE_HIT",
	"TNOx_VCACHE_MISS",
	"TNOx_VCACHE_LINE_WAIT",
	"TNOx_VFETCH_POS_READ_WAIT",
	"TNOx_VFETCH_VERTEX_WAIT",
	"TNOx_VFETCH_STALL",
	"TNOx_PRIMASSY_STALL",
	"TNOx_BBOX_GEN_STALL",
	"TNOx_IDVS_VBU_HIT",
	"TNOx_IDVS_VBU_MISS",
	"TNOx_IDVS_VBU_LINE_DEALLOCATE",
	"TNOx_IDVS_VAR_SHAD_REQ",
	"TNOx_IDVS_VAR_SHAD_STALL",
	"TNOx_BINNER_STALL",
	"TNOx_ITER_STALL",
	"TNOx_COMPRESS_MISS",
	"TNOx_COMPRESS_STALL",
	"TNOx_PCACHE_HIT",
	"TNOx_PCACHE_MISS",
	"TNOx_PCACHE_MISS_STALL",
	"TNOx_PCACHE_EVICT_STALL",
	"TNOx_PMGR_PTR_WR_STALL",
	"TNOx_PMGR_PTR_RD_STALL",
	"TNOx_PMGR_CMD_WR_STALL",
	"TNOx_WRBUF_ACTIVE",
	"TNOx_WRBUF_HIT",
	"TNOx_WRBUF_MISS",
	"TNOx_WRBUF_NO_FREE_LINE_STALL",
	"TNOx_WRBUF_NO_AXI_ID_STALL",
	"TNOx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TNOx_UTLB_TRANS",
	"TNOx_UTLB_TRANS_HIT",
	"TNOx_UTLB_TRANS_STALL",
	"TNOx_UTLB_TRANS_MISS_DELAY",
	"TNOx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TNOx_FRAG_ACTIVE",
	"TNOx_FRAG_PRIMITIVES",
	"TNOx_FRAG_PRIM_RAST",
	"TNOx_FRAG_FPK_ACTIVE",
	"TNOx_FRAG_STARVING",
	"TNOx_FRAG_WARPS",
	"TNOx_FRAG_PARTIAL_WARPS",
	"TNOx_FRAG_QUADS_RAST",
	"TNOx_FRAG_QUADS_EZS_TEST",
	"TNOx_FRAG_QUADS_EZS_UPDATE",
	"TNOx_FRAG_QUADS_EZS_KILL",
	"TNOx_FRAG_LZS_TEST",
	"TNOx_FRAG_LZS_KILL",
	"TNOx_WARP_REG_SIZE_64",
	"TNOx_FRAG_PTILES",
	"TNOx_FRAG_TRANS_ELIM",
	"TNOx_QUAD_FPK_KILLER",
	"TNOx_FULL_QUAD_WARPS",
	"TNOx_COMPUTE_ACTIVE",
	"TNOx_COMPUTE_TASKS",
	"TNOx_COMPUTE_WARPS",
	"TNOx_COMPUTE_STARVING",
	"TNOx_EXEC_CORE_ACTIVE",
	"TNOx_EXEC_ACTIVE",
	"TNOx_EXEC_INSTR_COUNT",
	"TNOx_EXEC_INSTR_DIVERGED",
	"TNOx_EXEC_INSTR_STARVING",
	"TNOx_ARITH_INSTR_SINGLE_FMA",
	"TNOx_ARITH_INSTR_DOUBLE",
	"TNOx_ARITH_INSTR_MSG",
	"TNOx_ARITH_INSTR_MSG_ONLY",
	"TNOx_TEX_MSGI_NUM_QUADS",
	"TNOx_TEX_DFCH_NUM_PASSES",
	"TNOx_TEX_DFCH_NUM_PASSES_MISS",
	"TNOx_TEX_DFCH_NUM_PASSES_MIP_MAP",
	"TNOx_TEX_TIDX_NUM_SPLIT_MIP_MAP",
	"TNOx_TEX_TFCH_NUM_LINES_FETCHED",
	"TNOx_TEX_TFCH_NUM_LINES_FETCHED_BLOCK_COMPRESSED",
	"TNOx_TEX_TFCH_NUM_OPERATIONS",
	"TNOx_TEX_FILT_NUM_OPERATIONS",
	"TNOx_LS_MEM_READ_FULL",
	"TNOx_LS_MEM_READ_SHORT",
	"TNOx_LS_MEM_WRITE_FULL",
	"TNOx_LS_MEM_WRITE_SHORT",
	"TNOx_LS_MEM_ATOMIC",
	"TNOx_VARY_INSTR",
	"TNOx_VARY_SLOT_32",
	"TNOx_VARY_SLOT_16",
	"TNOx_ATTR_INSTR",
	"TNOx_ARITH_INSTR_FP_MUL",
	"TNOx_BEATS_RD_FTC",
	"TNOx_BEATS_RD_FTC_EXT",
	"TNOx_BEATS_RD_LSC",
	"TNOx_BEATS_RD_LSC_EXT",
	"TNOx_BEATS_RD_TEX",
	"TNOx_BEATS_RD_TEX_EXT",
	"TNOx_BEATS_RD_OTHER",
	"TNOx_BEATS_WR_LSC_OTHER",
	"TNOx_BEATS_WR_TIB",
	"TNOx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TNOx_MMU_REQUESTS",
	"TNOx_MMU_TABLE_READS_L3",
	"TNOx_MMU_TABLE_READS_L2",
	"TNOx_MMU_HIT_L3",
	"TNOx_MMU_HIT_L2",
	"TNOx_MMU_S2_REQUESTS",
	"TNOx_MMU_S2_TABLE_READS_L3",
	"TNOx_MMU_S2_TABLE_READS_L2",
	"TNOx_MMU_S2_HIT_L3",
	"TNOx_MMU_S2_HIT_L2",
	"",
	"",
	"TNOx_L2_RD_MSG_IN",
	"TNOx_L2_RD_MSG_IN_STALL",
	"TNOx_L2_WR_MSG_IN",
	"TNOx_L2_WR_MSG_IN_STALL",
	"TNOx_L2_SNP_MSG_IN",
	"TNOx_L2_SNP_MSG_IN_STALL",
	"TNOx_L2_RD_MSG_OUT",
	"TNOx_L2_RD_MSG_OUT_STALL",
	"TNOx_L2_WR_MSG_OUT",
	"TNOx_L2_ANY_LOOKUP",
	"TNOx_L2_READ_LOOKUP",
	"TNOx_L2_WRITE_LOOKUP",
	"TNOx_L2_EXT_SNOOP_LOOKUP",
	"TNOx_L2_EXT_READ",
	"TNOx_L2_EXT_READ_NOSNP",
	"TNOx_L2_EXT_READ_UNIQUE",
	"TNOx_L2_EXT_READ_BEATS",
	"TNOx_L2_EXT_AR_STALL",
	"TNOx_L2_EXT_AR_CNT_Q1",
	"TNOx_L2_EXT_AR_CNT_Q2",
	"TNOx_L2_EXT_AR_CNT_Q3",
	"TNOx_L2_EXT_RRESP_0_127",
	"TNOx_L2_EXT_RRESP_128_191",
	"TNOx_L2_EXT_RRESP_192_255",
	"TNOx_L2_EXT_RRESP_256_319",
	"TNOx_L2_EXT_RRESP_320_383",
	"TNOx_L2_EXT_WRITE",
	"TNOx_L2_EXT_WRITE_NOSNP_FULL",
	"TNOx_L2_EXT_WRITE_NOSNP_PTL",
	"TNOx_L2_EXT_WRITE_SNP_FULL",
	"TNOx_L2_EXT_WRITE_SNP_PTL",
	"TNOx_L2_EXT_WRITE_BEATS",
	"TNOx_L2_EXT_W_STALL",
	"TNOx_L2_EXT_AW_CNT_Q1",
	"TNOx_L2_EXT_AW_CNT_Q2",
	"TNOx_L2_EXT_AW_CNT_Q3",
	"TNOx_L2_EXT_SNOOP",
	"TNOx_L2_EXT_SNOOP_STALL",
	"TNOx_L2_EXT_SNOOP_RESP_CLEAN",
	"TNOx_L2_EXT_SNOOP_RESP_DATA",
	"TNOx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tGOx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TGOx_MESSAGES_SENT",
	"TGOx_MESSAGES_RECEIVED",
	"TGOx_GPU_ACTIVE",
	"TGOx_IRQ_ACTIVE",
	"TGOx_JS0_JOBS",
	"TGOx_JS0_TASKS",
	"TGOx_JS0_ACTIVE",
	"TGOx_JS0_WAIT_FLUSH",
	"TGOx_JS0_WAIT_READ",
	"TGOx_JS0_WAIT_ISSUE",
	"TGOx_JS0_WAIT_DEPEND",
	"TGOx_JS0_WAIT_FINISH",
	"TGOx_JS1_JOBS",
	"TGOx_JS1_TASKS",
	"TGOx_JS1_ACTIVE",
	"TGOx_JS1_WAIT_FLUSH",
	"TGOx_JS1_WAIT_READ",
	"TGOx_JS1_WAIT_ISSUE",
	"TGOx_JS1_WAIT_DEPEND",
	"TGOx_JS1_WAIT_FINISH",
	"TGOx_JS2_JOBS",
	"TGOx_JS2_TASKS",
	"TGOx_JS2_ACTIVE",
	"TGOx_JS2_WAIT_FLUSH",
	"TGOx_JS2_WAIT_READ",
	"TGOx_JS2_WAIT_ISSUE",
	"TGOx_JS2_WAIT_DEPEND",
	"TGOx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TGOx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TGOx_TILER_ACTIVE",
	"TGOx_JOBS_PROCESSED",
	"TGOx_TRIANGLES",
	"TGOx_LINES",
	"TGOx_POINTS",
	"TGOx_FRONT_FACING",
	"TGOx_BACK_FACING",
	"TGOx_PRIM_VISIBLE",
	"TGOx_PRIM_CULLED",
	"TGOx_PRIM_CLIPPED",
	"TGOx_PRIM_SAT_CULLED",
	"TGOx_BIN_ALLOC_INIT",
	"TGOx_BIN_ALLOC_OVERFLOW",
	"TGOx_BUS_READ",
	"",
	"TGOx_BUS_WRITE",
	"TGOx_LOADING_DESC",
	"TGOx_IDVS_POS_SHAD_REQ",
	"TGOx_IDVS_POS_SHAD_WAIT",
	"TGOx_IDVS_POS_SHAD_STALL",
	"TGOx_IDVS_POS_FIFO_FULL",
	"TGOx_PREFETCH_STALL",
	"TGOx_VCACHE_HIT",
	"TGOx_VCACHE_MISS",
	"TGOx_VCACHE_LINE_WAIT",
	"TGOx_VFETCH_POS_READ_WAIT",
	"TGOx_VFETCH_VERTEX_WAIT",
	"TGOx_VFETCH_STALL",
	"TGOx_PRIMASSY_STALL",
	"TGOx_BBOX_GEN_STALL",
	"TGOx_IDVS_VBU_HIT",
	"TGOx_IDVS_VBU_MISS",
	"TGOx_IDVS_VBU_LINE_DEALLOCATE",
	"TGOx_IDVS_VAR_SHAD_REQ",
	"TGOx_IDVS_VAR_SHAD_STALL",
	"TGOx_BINNER_STALL",
	"TGOx_ITER_STALL",
	"TGOx_COMPRESS_MISS",
	"TGOx_COMPRESS_STALL",
	"TGOx_PCACHE_HIT",
	"TGOx_PCACHE_MISS",
	"TGOx_PCACHE_MISS_STALL",
	"TGOx_PCACHE_EVICT_STALL",
	"TGOx_PMGR_PTR_WR_STALL",
	"TGOx_PMGR_PTR_RD_STALL",
	"TGOx_PMGR_CMD_WR_STALL",
	"TGOx_WRBUF_ACTIVE",
	"TGOx_WRBUF_HIT",
	"TGOx_WRBUF_MISS",
	"TGOx_WRBUF_NO_FREE_LINE_STALL",
	"TGOx_WRBUF_NO_AXI_ID_STALL",
	"TGOx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TGOx_UTLB_TRANS",
	"TGOx_UTLB_TRANS_HIT",
	"TGOx_UTLB_TRANS_STALL",
	"TGOx_UTLB_TRANS_MISS_DELAY",
	"TGOx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TGOx_FRAG_ACTIVE",
	"TGOx_FRAG_PRIMITIVES",
	"TGOx_FRAG_PRIM_RAST",
	"TGOx_FRAG_FPK_ACTIVE",
	"TGOx_FRAG_STARVING",
	"TGOx_FRAG_WARPS",
	"TGOx_FRAG_PARTIAL_WARPS",
	"TGOx_FRAG_QUADS_RAST",
	"TGOx_FRAG_QUADS_EZS_TEST",
	"TGOx_FRAG_QUADS_EZS_UPDATE",
	"TGOx_FRAG_QUADS_EZS_KILL",
	"TGOx_FRAG_LZS_TEST",
	"TGOx_FRAG_LZS_KILL",
	"TGOx_WARP_REG_SIZE_64",
	"TGOx_FRAG_PTILES",
	"TGOx_FRAG_TRANS_ELIM",
	"TGOx_QUAD_FPK_KILLER",
	"TGOx_FULL_QUAD_WARPS",
	"TGOx_COMPUTE_ACTIVE",
	"TGOx_COMPUTE_TASKS",
	"TGOx_COMPUTE_WARPS",
	"TGOx_COMPUTE_STARVING",
	"TGOx_EXEC_CORE_ACTIVE",
	"TGOx_EXEC_ACTIVE",
	"TGOx_EXEC_INSTR_COUNT",
	"TGOx_EXEC_INSTR_DIVERGED",
	"TGOx_EXEC_INSTR_STARVING",
	"TGOx_ARITH_INSTR_SINGLE_FMA",
	"TGOx_ARITH_INSTR_DOUBLE",
	"TGOx_ARITH_INSTR_MSG",
	"TGOx_ARITH_INSTR_MSG_ONLY",
	"TGOx_TEX_MSGI_NUM_QUADS",
	"TGOx_TEX_DFCH_NUM_PASSES",
	"TGOx_TEX_DFCH_NUM_PASSES_MISS",
	"TGOx_TEX_DFCH_NUM_PASSES_MIP_MAP",
	"TGOx_TEX_TIDX_NUM_SPLIT_MIP_MAP",
	"TGOx_TEX_TFCH_NUM_LINES_FETCHED",
	"TGOx_TEX_TFCH_NUM_LINES_FETCHED_BLOCK_COMPRESSED",
	"TGOx_TEX_TFCH_NUM_OPERATIONS",
	"TGOx_TEX_FILT_NUM_OPERATIONS",
	"TGOx_LS_MEM_READ_FULL",
	"TGOx_LS_MEM_READ_SHORT",
	"TGOx_LS_MEM_WRITE_FULL",
	"TGOx_LS_MEM_WRITE_SHORT",
	"TGOx_LS_MEM_ATOMIC",
	"TGOx_VARY_INSTR",
	"TGOx_VARY_SLOT_32",
	"TGOx_VARY_SLOT_16",
	"TGOx_ATTR_INSTR",
	"TGOx_ARITH_INSTR_FP_MUL",
	"TGOx_BEATS_RD_FTC",
	"TGOx_BEATS_RD_FTC_EXT",
	"TGOx_BEATS_RD_LSC",
	"TGOx_BEATS_RD_LSC_EXT",
	"TGOx_BEATS_RD_TEX",
	"TGOx_BEATS_RD_TEX_EXT",
	"TGOx_BEATS_RD_OTHER",
	"TGOx_BEATS_WR_LSC_WB",
	"TGOx_BEATS_WR_TIB",
	"TGOx_BEATS_WR_LSC_OTHER",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TGOx_MMU_REQUESTS",
	"TGOx_MMU_TABLE_READS_L3",
	"TGOx_MMU_TABLE_READS_L2",
	"TGOx_MMU_HIT_L3",
	"TGOx_MMU_HIT_L2",
	"TGOx_MMU_S2_REQUESTS",
	"TGOx_MMU_S2_TABLE_READS_L3",
	"TGOx_MMU_S2_TABLE_READS_L2",
	"TGOx_MMU_S2_HIT_L3",
	"TGOx_MMU_S2_HIT_L2",
	"",
	"",
	"TGOx_L2_RD_MSG_IN",
	"TGOx_L2_RD_MSG_IN_STALL",
	"TGOx_L2_WR_MSG_IN",
	"TGOx_L2_WR_MSG_IN_STALL",
	"TGOx_L2_SNP_MSG_IN",
	"TGOx_L2_SNP_MSG_IN_STALL",
	"TGOx_L2_RD_MSG_OUT",
	"TGOx_L2_RD_MSG_OUT_STALL",
	"TGOx_L2_WR_MSG_OUT",
	"TGOx_L2_ANY_LOOKUP",
	"TGOx_L2_READ_LOOKUP",
	"TGOx_L2_WRITE_LOOKUP",
	"TGOx_L2_EXT_SNOOP_LOOKUP",
	"TGOx_L2_EXT_READ",
	"TGOx_L2_EXT_READ_NOSNP",
	"TGOx_L2_EXT_READ_UNIQUE",
	"TGOx_L2_EXT_READ_BEATS",
	"TGOx_L2_EXT_AR_STALL",
	"TGOx_L2_EXT_AR_CNT_Q1",
	"TGOx_L2_EXT_AR_CNT_Q2",
	"TGOx_L2_EXT_AR_CNT_Q3",
	"TGOx_L2_EXT_RRESP_0_127",
	"TGOx_L2_EXT_RRESP_128_191",
	"TGOx_L2_EXT_RRESP_192_255",
	"TGOx_L2_EXT_RRESP_256_319",
	"TGOx_L2_EXT_RRESP_320_383",
	"TGOx_L2_EXT_WRITE",
	"TGOx_L2_EXT_WRITE_NOSNP_FULL",
	"TGOx_L2_EXT_WRITE_NOSNP_PTL",
	"TGOx_L2_EXT_WRITE_SNP_FULL",
	"TGOx_L2_EXT_WRITE_SNP_PTL",
	"TGOx_L2_EXT_WRITE_BEATS",
	"TGOx_L2_EXT_W_STALL",
	"TGOx_L2_EXT_AW_CNT_Q1",
	"TGOx_L2_EXT_AW_CNT_Q2",
	"TGOx_L2_EXT_AW_CNT_Q3",
	"TGOx_L2_EXT_SNOOP",
	"TGOx_L2_EXT_SNOOP_STALL",
	"TGOx_L2_EXT_SNOOP_RESP_CLEAN",
	"TGOx_L2_EXT_SNOOP_RESP_DATA",
	"TGOx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tTRx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TTRx_MESSAGES_SENT",
	"TTRx_MESSAGES_RECEIVED",
	"TTRx_GPU_ACTIVE",
	"TTRx_IRQ_ACTIVE",
	"TTRx_JS0_JOBS",
	"TTRx_JS0_TASKS",
	"TTRx_JS0_ACTIVE",
	"TTRx_JS0_WAIT_FLUSH",
	"TTRx_JS0_WAIT_READ",
	"TTRx_JS0_WAIT_ISSUE",
	"TTRx_JS0_WAIT_DEPEND",
	"TTRx_JS0_WAIT_FINISH",
	"TTRx_JS1_JOBS",
	"TTRx_JS1_TASKS",
	"TTRx_JS1_ACTIVE",
	"TTRx_JS1_WAIT_FLUSH",
	"TTRx_JS1_WAIT_READ",
	"TTRx_JS1_WAIT_ISSUE",
	"TTRx_JS1_WAIT_DEPEND",
	"TTRx_JS1_WAIT_FINISH",
	"TTRx_JS2_JOBS",
	"TTRx_JS2_TASKS",
	"TTRx_JS2_ACTIVE",
	"TTRx_JS2_WAIT_FLUSH",
	"TTRx_JS2_WAIT_READ",
	"TTRx_JS2_WAIT_ISSUE",
	"TTRx_JS2_WAIT_DEPEND",
	"TTRx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TTRx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TTRx_TILER_ACTIVE",
	"TTRx_JOBS_PROCESSED",
	"TTRx_TRIANGLES",
	"TTRx_LINES",
	"TTRx_POINTS",
	"TTRx_FRONT_FACING",
	"TTRx_BACK_FACING",
	"TTRx_PRIM_VISIBLE",
	"TTRx_PRIM_CULLED",
	"TTRx_PRIM_CLIPPED",
	"TTRx_PRIM_SAT_CULLED",
	"TTRx_BIN_ALLOC_INIT",
	"TTRx_BIN_ALLOC_OVERFLOW",
	"TTRx_BUS_READ",
	"",
	"TTRx_BUS_WRITE",
	"TTRx_LOADING_DESC",
	"TTRx_IDVS_POS_SHAD_REQ",
	"TTRx_IDVS_POS_SHAD_WAIT",
	"TTRx_IDVS_POS_SHAD_STALL",
	"TTRx_IDVS_POS_FIFO_FULL",
	"TTRx_PREFETCH_STALL",
	"TTRx_VCACHE_HIT",
	"TTRx_VCACHE_MISS",
	"TTRx_VCACHE_LINE_WAIT",
	"TTRx_VFETCH_POS_READ_WAIT",
	"TTRx_VFETCH_VERTEX_WAIT",
	"TTRx_VFETCH_STALL",
	"TTRx_PRIMASSY_STALL",
	"TTRx_BBOX_GEN_STALL",
	"TTRx_IDVS_VBU_HIT",
	"TTRx_IDVS_VBU_MISS",
	"TTRx_IDVS_VBU_LINE_DEALLOCATE",
	"TTRx_IDVS_VAR_SHAD_REQ",
	"TTRx_IDVS_VAR_SHAD_STALL",
	"TTRx_BINNER_STALL",
	"TTRx_ITER_STALL",
	"TTRx_COMPRESS_MISS",
	"TTRx_COMPRESS_STALL",
	"TTRx_PCACHE_HIT",
	"TTRx_PCACHE_MISS",
	"TTRx_PCACHE_MISS_STALL",
	"TTRx_PCACHE_EVICT_STALL",
	"TTRx_PMGR_PTR_WR_STALL",
	"TTRx_PMGR_PTR_RD_STALL",
	"TTRx_PMGR_CMD_WR_STALL",
	"TTRx_WRBUF_ACTIVE",
	"TTRx_WRBUF_HIT",
	"TTRx_WRBUF_MISS",
	"TTRx_WRBUF_NO_FREE_LINE_STALL",
	"TTRx_WRBUF_NO_AXI_ID_STALL",
	"TTRx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TTRx_UTLB_TRANS",
	"TTRx_UTLB_TRANS_HIT",
	"TTRx_UTLB_TRANS_STALL",
	"TTRx_UTLB_TRANS_MISS_DELAY",
	"TTRx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TTRx_FRAG_ACTIVE",
	"TTRx_FRAG_PRIMITIVES_OUT",
	"TTRx_FRAG_PRIM_RAST",
	"TTRx_FRAG_FPK_ACTIVE",
	"TTRx_FRAG_STARVING",
	"TTRx_FRAG_WARPS",
	"TTRx_FRAG_PARTIAL_QUADS_RAST",
	"TTRx_FRAG_QUADS_RAST",
	"TTRx_FRAG_QUADS_EZS_TEST",
	"TTRx_FRAG_QUADS_EZS_UPDATE",
	"TTRx_FRAG_QUADS_EZS_KILL",
	"TTRx_FRAG_LZS_TEST",
	"TTRx_FRAG_LZS_KILL",
	"TTRx_WARP_REG_SIZE_64",
	"TTRx_FRAG_PTILES",
	"TTRx_FRAG_TRANS_ELIM",
	"TTRx_QUAD_FPK_KILLER",
	"TTRx_FULL_QUAD_WARPS",
	"TTRx_COMPUTE_ACTIVE",
	"TTRx_COMPUTE_TASKS",
	"TTRx_COMPUTE_WARPS",
	"TTRx_COMPUTE_STARVING",
	"TTRx_EXEC_CORE_ACTIVE",
	"TTRx_EXEC_INSTR_FMA",
	"TTRx_EXEC_INSTR_CVT",
	"TTRx_EXEC_INSTR_SFU",
	"TTRx_EXEC_INSTR_MSG",
	"TTRx_EXEC_INSTR_DIVERGED",
	"TTRx_EXEC_ICACHE_MISS",
	"TTRx_EXEC_STARVE_ARITH",
	"TTRx_CALL_BLEND_SHADER",
	"TTRx_TEX_MSGI_NUM_FLITS",
	"TTRx_TEX_DFCH_CLK_STALLED",
	"TTRx_TEX_TFCH_CLK_STALLED",
	"TTRx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TTRx_TEX_FILT_NUM_OPERATIONS",
	"TTRx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TTRx_TEX_FILT_NUM_FST_OPERATIONS",
	"TTRx_TEX_MSGO_NUM_MSG",
	"TTRx_TEX_MSGO_NUM_FLITS",
	"TTRx_LS_MEM_READ_FULL",
	"TTRx_LS_MEM_READ_SHORT",
	"TTRx_LS_MEM_WRITE_FULL",
	"TTRx_LS_MEM_WRITE_SHORT",
	"TTRx_LS_MEM_ATOMIC",
	"TTRx_VARY_INSTR",
	"TTRx_VARY_SLOT_32",
	"TTRx_VARY_SLOT_16",
	"TTRx_ATTR_INSTR",
	"TTRx_ARITH_INSTR_FP_MUL",
	"TTRx_BEATS_RD_FTC",
	"TTRx_BEATS_RD_FTC_EXT",
	"TTRx_BEATS_RD_LSC",
	"TTRx_BEATS_RD_LSC_EXT",
	"TTRx_BEATS_RD_TEX",
	"TTRx_BEATS_RD_TEX_EXT",
	"TTRx_BEATS_RD_OTHER",
	"TTRx_BEATS_WR_LSC_OTHER",
	"TTRx_BEATS_WR_TIB",
	"TTRx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TTRx_MMU_REQUESTS",
	"TTRx_MMU_TABLE_READS_L3",
	"TTRx_MMU_TABLE_READS_L2",
	"TTRx_MMU_HIT_L3",
	"TTRx_MMU_HIT_L2",
	"TTRx_MMU_S2_REQUESTS",
	"TTRx_MMU_S2_TABLE_READS_L3",
	"TTRx_MMU_S2_TABLE_READS_L2",
	"TTRx_MMU_S2_HIT_L3",
	"TTRx_MMU_S2_HIT_L2",
	"",
	"",
	"TTRx_L2_RD_MSG_IN",
	"TTRx_L2_RD_MSG_IN_STALL",
	"TTRx_L2_WR_MSG_IN",
	"TTRx_L2_WR_MSG_IN_STALL",
	"TTRx_L2_SNP_MSG_IN",
	"TTRx_L2_SNP_MSG_IN_STALL",
	"TTRx_L2_RD_MSG_OUT",
	"TTRx_L2_RD_MSG_OUT_STALL",
	"TTRx_L2_WR_MSG_OUT",
	"TTRx_L2_ANY_LOOKUP",
	"TTRx_L2_READ_LOOKUP",
	"TTRx_L2_WRITE_LOOKUP",
	"TTRx_L2_EXT_SNOOP_LOOKUP",
	"TTRx_L2_EXT_READ",
	"TTRx_L2_EXT_READ_NOSNP",
	"TTRx_L2_EXT_READ_UNIQUE",
	"TTRx_L2_EXT_READ_BEATS",
	"TTRx_L2_EXT_AR_STALL",
	"TTRx_L2_EXT_AR_CNT_Q1",
	"TTRx_L2_EXT_AR_CNT_Q2",
	"TTRx_L2_EXT_AR_CNT_Q3",
	"TTRx_L2_EXT_RRESP_0_127",
	"TTRx_L2_EXT_RRESP_128_191",
	"TTRx_L2_EXT_RRESP_192_255",
	"TTRx_L2_EXT_RRESP_256_319",
	"TTRx_L2_EXT_RRESP_320_383",
	"TTRx_L2_EXT_WRITE",
	"TTRx_L2_EXT_WRITE_NOSNP_FULL",
	"TTRx_L2_EXT_WRITE_NOSNP_PTL",
	"TTRx_L2_EXT_WRITE_SNP_FULL",
	"TTRx_L2_EXT_WRITE_SNP_PTL",
	"TTRx_L2_EXT_WRITE_BEATS",
	"TTRx_L2_EXT_W_STALL",
	"TTRx_L2_EXT_AW_CNT_Q1",
	"TTRx_L2_EXT_AW_CNT_Q2",
	"TTRx_L2_EXT_AW_CNT_Q3",
	"TTRx_L2_EXT_SNOOP",
	"TTRx_L2_EXT_SNOOP_STALL",
	"TTRx_L2_EXT_SNOOP_RESP_CLEAN",
	"TTRx_L2_EXT_SNOOP_RESP_DATA",
	"TTRx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tNAx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TNAx_MESSAGES_SENT",
	"TNAx_MESSAGES_RECEIVED",
	"TNAx_GPU_ACTIVE",
	"TNAx_IRQ_ACTIVE",
	"TNAx_JS0_JOBS",
	"TNAx_JS0_TASKS",
	"TNAx_JS0_ACTIVE",
	"TNAx_JS0_WAIT_FLUSH",
	"TNAx_JS0_WAIT_READ",
	"TNAx_JS0_WAIT_ISSUE",
	"TNAx_JS0_WAIT_DEPEND",
	"TNAx_JS0_WAIT_FINISH",
	"TNAx_JS1_JOBS",
	"TNAx_JS1_TASKS",
	"TNAx_JS1_ACTIVE",
	"TNAx_JS1_WAIT_FLUSH",
	"TNAx_JS1_WAIT_READ",
	"TNAx_JS1_WAIT_ISSUE",
	"TNAx_JS1_WAIT_DEPEND",
	"TNAx_JS1_WAIT_FINISH",
	"TNAx_JS2_JOBS",
	"TNAx_JS2_TASKS",
	"TNAx_JS2_ACTIVE",
	"TNAx_JS2_WAIT_FLUSH",
	"TNAx_JS2_WAIT_READ",
	"TNAx_JS2_WAIT_ISSUE",
	"TNAx_JS2_WAIT_DEPEND",
	"TNAx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TNAx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TNAx_TILER_ACTIVE",
	"TNAx_JOBS_PROCESSED",
	"TNAx_TRIANGLES",
	"TNAx_LINES",
	"TNAx_POINTS",
	"TNAx_FRONT_FACING",
	"TNAx_BACK_FACING",
	"TNAx_PRIM_VISIBLE",
	"TNAx_PRIM_CULLED",
	"TNAx_PRIM_CLIPPED",
	"TNAx_PRIM_SAT_CULLED",
	"TNAx_BIN_ALLOC_INIT",
	"TNAx_BIN_ALLOC_OVERFLOW",
	"TNAx_BUS_READ",
	"",
	"TNAx_BUS_WRITE",
	"TNAx_LOADING_DESC",
	"TNAx_IDVS_POS_SHAD_REQ",
	"TNAx_IDVS_POS_SHAD_WAIT",
	"TNAx_IDVS_POS_SHAD_STALL",
	"TNAx_IDVS_POS_FIFO_FULL",
	"TNAx_PREFETCH_STALL",
	"TNAx_VCACHE_HIT",
	"TNAx_VCACHE_MISS",
	"TNAx_VCACHE_LINE_WAIT",
	"TNAx_VFETCH_POS_READ_WAIT",
	"TNAx_VFETCH_VERTEX_WAIT",
	"TNAx_VFETCH_STALL",
	"TNAx_PRIMASSY_STALL",
	"TNAx_BBOX_GEN_STALL",
	"TNAx_IDVS_VBU_HIT",
	"TNAx_IDVS_VBU_MISS",
	"TNAx_IDVS_VBU_LINE_DEALLOCATE",
	"TNAx_IDVS_VAR_SHAD_REQ",
	"TNAx_IDVS_VAR_SHAD_STALL",
	"TNAx_BINNER_STALL",
	"TNAx_ITER_STALL",
	"TNAx_COMPRESS_MISS",
	"TNAx_COMPRESS_STALL",
	"TNAx_PCACHE_HIT",
	"TNAx_PCACHE_MISS",
	"TNAx_PCACHE_MISS_STALL",
	"TNAx_PCACHE_EVICT_STALL",
	"TNAx_PMGR_PTR_WR_STALL",
	"TNAx_PMGR_PTR_RD_STALL",
	"TNAx_PMGR_CMD_WR_STALL",
	"TNAx_WRBUF_ACTIVE",
	"TNAx_WRBUF_HIT",
	"TNAx_WRBUF_MISS",
	"TNAx_WRBUF_NO_FREE_LINE_STALL",
	"TNAx_WRBUF_NO_AXI_ID_STALL",
	"TNAx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"TNAx_UTLB_TRANS",
	"TNAx_UTLB_TRANS_HIT",
	"TNAx_UTLB_TRANS_STALL",
	"TNAx_UTLB_TRANS_MISS_DELAY",
	"TNAx_UTLB_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TNAx_FRAG_ACTIVE",
	"TNAx_FRAG_PRIMITIVES_OUT",
	"TNAx_FRAG_PRIM_RAST",
	"TNAx_FRAG_FPK_ACTIVE",
	"TNAx_FRAG_STARVING",
	"TNAx_FRAG_WARPS",
	"TNAx_FRAG_PARTIAL_QUADS_RAST",
	"TNAx_FRAG_QUADS_RAST",
	"TNAx_FRAG_QUADS_EZS_TEST",
	"TNAx_FRAG_QUADS_EZS_UPDATE",
	"TNAx_FRAG_QUADS_EZS_KILL",
	"TNAx_FRAG_LZS_TEST",
	"TNAx_FRAG_LZS_KILL",
	"TNAx_WARP_REG_SIZE_64",
	"TNAx_FRAG_PTILES",
	"TNAx_FRAG_TRANS_ELIM",
	"TNAx_QUAD_FPK_KILLER",
	"TNAx_FULL_QUAD_WARPS",
	"TNAx_COMPUTE_ACTIVE",
	"TNAx_COMPUTE_TASKS",
	"TNAx_COMPUTE_WARPS",
	"TNAx_COMPUTE_STARVING",
	"TNAx_EXEC_CORE_ACTIVE",
	"TNAx_EXEC_INSTR_FMA",
	"TNAx_EXEC_INSTR_CVT",
	"TNAx_EXEC_INSTR_SFU",
	"TNAx_EXEC_INSTR_MSG",
	"TNAx_EXEC_INSTR_DIVERGED",
	"TNAx_EXEC_ICACHE_MISS",
	"TNAx_EXEC_STARVE_ARITH",
	"TNAx_CALL_BLEND_SHADER",
	"TNAx_TEX_MSGI_NUM_FLITS",
	"TNAx_TEX_DFCH_CLK_STALLED",
	"TNAx_TEX_TFCH_CLK_STALLED",
	"TNAx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TNAx_TEX_FILT_NUM_OPERATIONS",
	"TNAx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TNAx_TEX_FILT_NUM_FST_OPERATIONS",
	"TNAx_TEX_MSGO_NUM_MSG",
	"TNAx_TEX_MSGO_NUM_FLITS",
	"TNAx_LS_MEM_READ_FULL",
	"TNAx_LS_MEM_READ_SHORT",
	"TNAx_LS_MEM_WRITE_FULL",
	"TNAx_LS_MEM_WRITE_SHORT",
	"TNAx_LS_MEM_ATOMIC",
	"TNAx_VARY_INSTR",
	"TNAx_VARY_SLOT_32",
	"TNAx_VARY_SLOT_16",
	"TNAx_ATTR_INSTR",
	"TNAx_ARITH_INSTR_FP_MUL",
	"TNAx_BEATS_RD_FTC",
	"TNAx_BEATS_RD_FTC_EXT",
	"TNAx_BEATS_RD_LSC",
	"TNAx_BEATS_RD_LSC_EXT",
	"TNAx_BEATS_RD_TEX",
	"TNAx_BEATS_RD_TEX_EXT",
	"TNAx_BEATS_RD_OTHER",
	"TNAx_BEATS_WR_LSC_OTHER",
	"TNAx_BEATS_WR_TIB",
	"TNAx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TNAx_MMU_REQUESTS",
	"TNAx_MMU_TABLE_READS_L3",
	"TNAx_MMU_TABLE_READS_L2",
	"TNAx_MMU_HIT_L3",
	"TNAx_MMU_HIT_L2",
	"TNAx_MMU_S2_REQUESTS",
	"TNAx_MMU_S2_TABLE_READS_L3",
	"TNAx_MMU_S2_TABLE_READS_L2",
	"TNAx_MMU_S2_HIT_L3",
	"TNAx_MMU_S2_HIT_L2",
	"",
	"",
	"TNAx_L2_RD_MSG_IN",
	"TNAx_L2_RD_MSG_IN_STALL",
	"TNAx_L2_WR_MSG_IN",
	"TNAx_L2_WR_MSG_IN_STALL",
	"TNAx_L2_SNP_MSG_IN",
	"TNAx_L2_SNP_MSG_IN_STALL",
	"TNAx_L2_RD_MSG_OUT",
	"TNAx_L2_RD_MSG_OUT_STALL",
	"TNAx_L2_WR_MSG_OUT",
	"TNAx_L2_ANY_LOOKUP",
	"TNAx_L2_READ_LOOKUP",
	"TNAx_L2_WRITE_LOOKUP",
	"TNAx_L2_EXT_SNOOP_LOOKUP",
	"TNAx_L2_EXT_READ",
	"TNAx_L2_EXT_READ_NOSNP",
	"TNAx_L2_EXT_READ_UNIQUE",
	"TNAx_L2_EXT_READ_BEATS",
	"TNAx_L2_EXT_AR_STALL",
	"TNAx_L2_EXT_AR_CNT_Q1",
	"TNAx_L2_EXT_AR_CNT_Q2",
	"TNAx_L2_EXT_AR_CNT_Q3",
	"TNAx_L2_EXT_RRESP_0_127",
	"TNAx_L2_EXT_RRESP_128_191",
	"TNAx_L2_EXT_RRESP_192_255",
	"TNAx_L2_EXT_RRESP_256_319",
	"TNAx_L2_EXT_RRESP_320_383",
	"TNAx_L2_EXT_WRITE",
	"TNAx_L2_EXT_WRITE_NOSNP_FULL",
	"TNAx_L2_EXT_WRITE_NOSNP_PTL",
	"TNAx_L2_EXT_WRITE_SNP_FULL",
	"TNAx_L2_EXT_WRITE_SNP_PTL",
	"TNAx_L2_EXT_WRITE_BEATS",
	"TNAx_L2_EXT_W_STALL",
	"TNAx_L2_EXT_AW_CNT_Q1",
	"TNAx_L2_EXT_AW_CNT_Q2",
	"TNAx_L2_EXT_AW_CNT_Q3",
	"TNAx_L2_EXT_SNOOP",
	"TNAx_L2_EXT_SNOOP_STALL",
	"TNAx_L2_EXT_SNOOP_RESP_CLEAN",
	"TNAx_L2_EXT_SNOOP_RESP_DATA",
	"TNAx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tOTx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TOTx_MESSAGES_SENT",
	"TOTx_MESSAGES_RECEIVED",
	"TOTx_GPU_ACTIVE",
	"TOTx_IRQ_ACTIVE",
	"TOTx_JS0_JOBS",
	"TOTx_JS0_TASKS",
	"TOTx_JS0_ACTIVE",
	"TOTx_JS0_WAIT_FLUSH",
	"TOTx_JS0_WAIT_READ",
	"TOTx_JS0_WAIT_ISSUE",
	"TOTx_JS0_WAIT_DEPEND",
	"TOTx_JS0_WAIT_FINISH",
	"TOTx_JS1_JOBS",
	"TOTx_JS1_TASKS",
	"TOTx_JS1_ACTIVE",
	"TOTx_JS1_WAIT_FLUSH",
	"TOTx_JS1_WAIT_READ",
	"TOTx_JS1_WAIT_ISSUE",
	"TOTx_JS1_WAIT_DEPEND",
	"TOTx_JS1_WAIT_FINISH",
	"TOTx_JS2_JOBS",
	"TOTx_JS2_TASKS",
	"TOTx_JS2_ACTIVE",
	"TOTx_JS2_WAIT_FLUSH",
	"TOTx_JS2_WAIT_READ",
	"TOTx_JS2_WAIT_ISSUE",
	"TOTx_JS2_WAIT_DEPEND",
	"TOTx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TOTx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TOTx_TILER_ACTIVE",
	"TOTx_JOBS_PROCESSED",
	"TOTx_TRIANGLES",
	"TOTx_LINES",
	"TOTx_POINTS",
	"TOTx_FRONT_FACING",
	"TOTx_BACK_FACING",
	"TOTx_PRIM_VISIBLE",
	"TOTx_PRIM_CULLED",
	"TOTx_PRIM_CLIPPED",
	"TOTx_PRIM_SAT_CULLED",
	"TOTx_BIN_ALLOC_INIT",
	"TOTx_BIN_ALLOC_OVERFLOW",
	"TOTx_BUS_READ",
	"",
	"TOTx_BUS_WRITE",
	"TOTx_LOADING_DESC",
	"TOTx_IDVS_POS_SHAD_REQ",
	"TOTx_IDVS_POS_SHAD_WAIT",
	"TOTx_IDVS_POS_SHAD_STALL",
	"TOTx_IDVS_POS_FIFO_FULL",
	"TOTx_PREFETCH_STALL",
	"TOTx_VCACHE_HIT",
	"TOTx_VCACHE_MISS",
	"TOTx_VCACHE_LINE_WAIT",
	"TOTx_VFETCH_POS_READ_WAIT",
	"TOTx_VFETCH_VERTEX_WAIT",
	"TOTx_VFETCH_STALL",
	"TOTx_PRIMASSY_STALL",
	"TOTx_BBOX_GEN_STALL",
	"TOTx_IDVS_VBU_HIT",
	"TOTx_IDVS_VBU_MISS",
	"TOTx_IDVS_VBU_LINE_DEALLOCATE",
	"TOTx_IDVS_VAR_SHAD_REQ",
	"TOTx_IDVS_VAR_SHAD_STALL",
	"TOTx_BINNER_STALL",
	"TOTx_ITER_STALL",
	"TOTx_COMPRESS_MISS",
	"TOTx_COMPRESS_STALL",
	"TOTx_PCACHE_HIT",
	"TOTx_PCACHE_MISS",
	"TOTx_PCACHE_MISS_STALL",
	"TOTx_PCACHE_EVICT_STALL",
	"TOTx_PMGR_PTR_WR_STALL",
	"TOTx_PMGR_PTR_RD_STALL",
	"TOTx_PMGR_CMD_WR_STALL",
	"TOTx_WRBUF_ACTIVE",
	"TOTx_WRBUF_HIT",
	"TOTx_WRBUF_MISS",
	"TOTx_WRBUF_NO_FREE_LINE_STALL",
	"TOTx_WRBUF_NO_AXI_ID_STALL",
	"TOTx_WRBUF_AXI_STALL",
	"TOTx_UTLB0_TRANS",
	"TOTx_UTLB0_TRANS_HIT",
	"TOTx_UTLB0_TRANS_STALL",
	"TOTx_UTLB0_MMU_REQ",
	"TOTx_UTLB1_TRANS",
	"TOTx_UTLB1_TRANS_HIT",
	"TOTx_UTLB1_TRANS_STALL",
	"TOTx_UTLB1_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TOTx_FRAG_ACTIVE",
	"TOTx_FRAG_PRIMITIVES_OUT",
	"TOTx_FRAG_PRIM_RAST",
	"TOTx_FRAG_FPK_ACTIVE",
	"TOTx_FRAG_STARVING",
	"TOTx_FRAG_WARPS",
	"TOTx_FRAG_PARTIAL_QUADS_RAST",
	"TOTx_FRAG_QUADS_RAST",
	"TOTx_FRAG_QUADS_EZS_TEST",
	"TOTx_FRAG_QUADS_EZS_UPDATE",
	"TOTx_FRAG_QUADS_EZS_KILL",
	"TOTx_FRAG_LZS_TEST",
	"TOTx_FRAG_LZS_KILL",
	"TOTx_WARP_REG_SIZE_64",
	"TOTx_FRAG_PTILES",
	"TOTx_FRAG_TRANS_ELIM",
	"TOTx_QUAD_FPK_KILLER",
	"TOTx_FULL_QUAD_WARPS",
	"TOTx_COMPUTE_ACTIVE",
	"TOTx_COMPUTE_TASKS",
	"TOTx_COMPUTE_WARPS",
	"TOTx_COMPUTE_STARVING",
	"TOTx_EXEC_CORE_ACTIVE",
	"TOTx_EXEC_INSTR_FMA",
	"TOTx_EXEC_INSTR_CVT",
	"TOTx_EXEC_INSTR_SFU",
	"TOTx_EXEC_INSTR_MSG",
	"TOTx_EXEC_INSTR_DIVERGED",
	"TOTx_EXEC_ICACHE_MISS",
	"TOTx_EXEC_STARVE_ARITH",
	"TOTx_CALL_BLEND_SHADER",
	"TOTx_TEX_MSGI_NUM_FLITS",
	"TOTx_TEX_DFCH_CLK_STALLED",
	"TOTx_TEX_TFCH_CLK_STALLED",
	"TOTx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TOTx_TEX_FILT_NUM_OPERATIONS",
	"TOTx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TOTx_TEX_FILT_NUM_FST_OPERATIONS",
	"TOTx_TEX_MSGO_NUM_MSG",
	"TOTx_TEX_MSGO_NUM_FLITS",
	"TOTx_LS_MEM_READ_FULL",
	"TOTx_LS_MEM_READ_SHORT",
	"TOTx_LS_MEM_WRITE_FULL",
	"TOTx_LS_MEM_WRITE_SHORT",
	"TOTx_LS_MEM_ATOMIC",
	"TOTx_VARY_INSTR",
	"TOTx_VARY_SLOT_32",
	"TOTx_VARY_SLOT_16",
	"TOTx_ATTR_INSTR",
	"TOTx_SHADER_CORE_ACTIVE",
	"TOTx_BEATS_RD_FTC",
	"TOTx_BEATS_RD_FTC_EXT",
	"TOTx_BEATS_RD_LSC",
	"TOTx_BEATS_RD_LSC_EXT",
	"TOTx_BEATS_RD_TEX",
	"TOTx_BEATS_RD_TEX_EXT",
	"TOTx_BEATS_RD_OTHER",
	"TOTx_BEATS_WR_LSC_OTHER",
	"TOTx_BEATS_WR_TIB",
	"TOTx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TOTx_MMU_REQUESTS",
	"TOTx_MMU_TABLE_READS_L3",
	"TOTx_MMU_TABLE_READS_L2",
	"TOTx_MMU_HIT_L3",
	"TOTx_MMU_HIT_L2",
	"TOTx_MMU_S2_REQUESTS",
	"TOTx_MMU_S2_TABLE_READS_L3",
	"TOTx_MMU_S2_TABLE_READS_L2",
	"TOTx_MMU_S2_HIT_L3",
	"TOTx_MMU_S2_HIT_L2",
	"",
	"",
	"TOTx_L2_RD_MSG_IN",
	"TOTx_L2_RD_MSG_IN_STALL",
	"TOTx_L2_WR_MSG_IN",
	"TOTx_L2_WR_MSG_IN_STALL",
	"TOTx_L2_SNP_MSG_IN",
	"TOTx_L2_SNP_MSG_IN_STALL",
	"TOTx_L2_RD_MSG_OUT",
	"TOTx_L2_RD_MSG_OUT_STALL",
	"TOTx_L2_WR_MSG_OUT",
	"TOTx_L2_ANY_LOOKUP",
	"TOTx_L2_READ_LOOKUP",
	"TOTx_L2_WRITE_LOOKUP",
	"TOTx_L2_EXT_SNOOP_LOOKUP",
	"TOTx_L2_EXT_READ",
	"TOTx_L2_EXT_READ_NOSNP",
	"TOTx_L2_EXT_READ_UNIQUE",
	"TOTx_L2_EXT_READ_BEATS",
	"TOTx_L2_EXT_AR_STALL",
	"TOTx_L2_EXT_AR_CNT_Q1",
	"TOTx_L2_EXT_AR_CNT_Q2",
	"TOTx_L2_EXT_AR_CNT_Q3",
	"TOTx_L2_EXT_RRESP_0_127",
	"TOTx_L2_EXT_RRESP_128_191",
	"TOTx_L2_EXT_RRESP_192_255",
	"TOTx_L2_EXT_RRESP_256_319",
	"TOTx_L2_EXT_RRESP_320_383",
	"TOTx_L2_EXT_WRITE",
	"TOTx_L2_EXT_WRITE_NOSNP_FULL",
	"TOTx_L2_EXT_WRITE_NOSNP_PTL",
	"TOTx_L2_EXT_WRITE_SNP_FULL",
	"TOTx_L2_EXT_WRITE_SNP_PTL",
	"TOTx_L2_EXT_WRITE_BEATS",
	"TOTx_L2_EXT_W_STALL",
	"TOTx_L2_EXT_AW_CNT_Q1",
	"TOTx_L2_EXT_AW_CNT_Q2",
	"TOTx_L2_EXT_AW_CNT_Q3",
	"TOTx_L2_EXT_SNOOP",
	"TOTx_L2_EXT_SNOOP_STALL",
	"TOTx_L2_EXT_SNOOP_RESP_CLEAN",
	"TOTx_L2_EXT_SNOOP_RESP_DATA",
	"TOTx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tBOx[] = {
	/* Job Manager */
	"",
	"",
	"",
	"",
	"TBOx_MESSAGES_SENT",
	"TBOx_MESSAGES_RECEIVED",
	"TBOx_GPU_ACTIVE",
	"TBOx_IRQ_ACTIVE",
	"TBOx_JS0_JOBS",
	"TBOx_JS0_TASKS",
	"TBOx_JS0_ACTIVE",
	"TBOx_JS0_WAIT_FLUSH",
	"TBOx_JS0_WAIT_READ",
	"TBOx_JS0_WAIT_ISSUE",
	"TBOx_JS0_WAIT_DEPEND",
	"TBOx_JS0_WAIT_FINISH",
	"TBOx_JS1_JOBS",
	"TBOx_JS1_TASKS",
	"TBOx_JS1_ACTIVE",
	"TBOx_JS1_WAIT_FLUSH",
	"TBOx_JS1_WAIT_READ",
	"TBOx_JS1_WAIT_ISSUE",
	"TBOx_JS1_WAIT_DEPEND",
	"TBOx_JS1_WAIT_FINISH",
	"TBOx_JS2_JOBS",
	"TBOx_JS2_TASKS",
	"TBOx_JS2_ACTIVE",
	"TBOx_JS2_WAIT_FLUSH",
	"TBOx_JS2_WAIT_READ",
	"TBOx_JS2_WAIT_ISSUE",
	"TBOx_JS2_WAIT_DEPEND",
	"TBOx_JS2_WAIT_FINISH",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TBOx_CACHE_FLUSH",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TBOx_TILER_ACTIVE",
	"TBOx_JOBS_PROCESSED",
	"TBOx_TRIANGLES",
	"TBOx_LINES",
	"TBOx_POINTS",
	"TBOx_FRONT_FACING",
	"TBOx_BACK_FACING",
	"TBOx_PRIM_VISIBLE",
	"TBOx_PRIM_CULLED",
	"TBOx_PRIM_CLIPPED",
	"TBOx_PRIM_SAT_CULLED",
	"TBOx_BIN_ALLOC_INIT",
	"TBOx_BIN_ALLOC_OVERFLOW",
	"TBOx_BUS_READ",
	"",
	"TBOx_BUS_WRITE",
	"TBOx_LOADING_DESC",
	"TBOx_IDVS_POS_SHAD_REQ",
	"TBOx_IDVS_POS_SHAD_WAIT",
	"TBOx_IDVS_POS_SHAD_STALL",
	"TBOx_IDVS_POS_FIFO_FULL",
	"TBOx_PREFETCH_STALL",
	"TBOx_VCACHE_HIT",
	"TBOx_VCACHE_MISS",
	"TBOx_VCACHE_LINE_WAIT",
	"TBOx_VFETCH_POS_READ_WAIT",
	"TBOx_VFETCH_VERTEX_WAIT",
	"TBOx_VFETCH_STALL",
	"TBOx_PRIMASSY_STALL",
	"TBOx_BBOX_GEN_STALL",
	"TBOx_IDVS_VBU_HIT",
	"TBOx_IDVS_VBU_MISS",
	"TBOx_IDVS_VBU_LINE_DEALLOCATE",
	"TBOx_IDVS_VAR_SHAD_REQ",
	"TBOx_IDVS_VAR_SHAD_STALL",
	"TBOx_BINNER_STALL",
	"TBOx_ITER_STALL",
	"TBOx_COMPRESS_MISS",
	"TBOx_COMPRESS_STALL",
	"TBOx_PCACHE_HIT",
	"TBOx_PCACHE_MISS",
	"TBOx_PCACHE_MISS_STALL",
	"TBOx_PCACHE_EVICT_STALL",
	"TBOx_PMGR_PTR_WR_STALL",
	"TBOx_PMGR_PTR_RD_STALL",
	"TBOx_PMGR_CMD_WR_STALL",
	"TBOx_WRBUF_ACTIVE",
	"TBOx_WRBUF_HIT",
	"TBOx_WRBUF_MISS",
	"TBOx_WRBUF_NO_FREE_LINE_STALL",
	"TBOx_WRBUF_NO_AXI_ID_STALL",
	"TBOx_WRBUF_AXI_STALL",
	"TBOx_UTLB0_TRANS",
	"TBOx_UTLB0_TRANS_HIT",
	"TBOx_UTLB0_TRANS_STALL",
	"TBOx_UTLB0_MMU_REQ",
	"TBOx_UTLB1_TRANS",
	"TBOx_UTLB1_TRANS_HIT",
	"TBOx_UTLB1_TRANS_STALL",
	"TBOx_UTLB1_MMU_REQ",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TBOx_FRAG_ACTIVE",
	"TBOx_FRAG_PRIMITIVES_OUT",
	"TBOx_FRAG_PRIM_RAST",
	"TBOx_FRAG_FPK_ACTIVE",
	"TBOx_FRAG_STARVING",
	"TBOx_FRAG_WARPS",
	"TBOx_FRAG_PARTIAL_QUADS_RAST",
	"TBOx_FRAG_QUADS_RAST",
	"TBOx_FRAG_QUADS_EZS_TEST",
	"TBOx_FRAG_QUADS_EZS_UPDATE",
	"TBOx_FRAG_QUADS_EZS_KILL",
	"TBOx_FRAG_LZS_TEST",
	"TBOx_FRAG_LZS_KILL",
	"TBOx_WARP_REG_SIZE_64",
	"TBOx_FRAG_PTILES",
	"TBOx_FRAG_TRANS_ELIM",
	"TBOx_QUAD_FPK_KILLER",
	"TBOx_FULL_QUAD_WARPS",
	"TBOx_COMPUTE_ACTIVE",
	"TBOx_COMPUTE_TASKS",
	"TBOx_COMPUTE_WARPS",
	"TBOx_COMPUTE_STARVING",
	"TBOx_EXEC_CORE_ACTIVE",
	"TBOx_EXEC_INSTR_FMA",
	"TBOx_EXEC_INSTR_CVT",
	"TBOx_EXEC_INSTR_SFU",
	"TBOx_EXEC_INSTR_MSG",
	"TBOx_EXEC_INSTR_DIVERGED",
	"TBOx_EXEC_ICACHE_MISS",
	"TBOx_EXEC_STARVE_ARITH",
	"TBOx_CALL_BLEND_SHADER",
	"TBOx_TEX_MSGI_NUM_FLITS",
	"TBOx_TEX_DFCH_CLK_STALLED",
	"TBOx_TEX_TFCH_CLK_STALLED",
	"TBOx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TBOx_TEX_FILT_NUM_OPERATIONS",
	"TBOx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TBOx_TEX_FILT_NUM_FST_OPERATIONS",
	"TBOx_TEX_MSGO_NUM_MSG",
	"TBOx_TEX_MSGO_NUM_FLITS",
	"TBOx_LS_MEM_READ_FULL",
	"TBOx_LS_MEM_READ_SHORT",
	"TBOx_LS_MEM_WRITE_FULL",
	"TBOx_LS_MEM_WRITE_SHORT",
	"TBOx_LS_MEM_ATOMIC",
	"TBOx_VARY_INSTR",
	"TBOx_VARY_SLOT_32",
	"TBOx_VARY_SLOT_16",
	"TBOx_ATTR_INSTR",
	"TBOx_SHADER_CORE_ACTIVE",
	"TBOx_BEATS_RD_FTC",
	"TBOx_BEATS_RD_FTC_EXT",
	"TBOx_BEATS_RD_LSC",
	"TBOx_BEATS_RD_LSC_EXT",
	"TBOx_BEATS_RD_TEX",
	"TBOx_BEATS_RD_TEX_EXT",
	"TBOx_BEATS_RD_OTHER",
	"TBOx_BEATS_WR_LSC_OTHER",
	"TBOx_BEATS_WR_TIB",
	"TBOx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TBOx_MMU_REQUESTS",
	"TBOx_MMU_TABLE_READS_L3",
	"TBOx_MMU_TABLE_READS_L2",
	"TBOx_MMU_HIT_L3",
	"TBOx_MMU_HIT_L2",
	"TBOx_MMU_S2_REQUESTS",
	"TBOx_MMU_S2_TABLE_READS_L3",
	"TBOx_MMU_S2_TABLE_READS_L2",
	"TBOx_MMU_S2_HIT_L3",
	"TBOx_MMU_S2_HIT_L2",
	"",
	"",
	"TBOx_L2_RD_MSG_IN",
	"TBOx_L2_RD_MSG_IN_STALL",
	"TBOx_L2_WR_MSG_IN",
	"TBOx_L2_WR_MSG_IN_STALL",
	"TBOx_L2_SNP_MSG_IN",
	"TBOx_L2_SNP_MSG_IN_STALL",
	"TBOx_L2_RD_MSG_OUT",
	"TBOx_L2_RD_MSG_OUT_STALL",
	"TBOx_L2_WR_MSG_OUT",
	"TBOx_L2_ANY_LOOKUP",
	"TBOx_L2_READ_LOOKUP",
	"TBOx_L2_WRITE_LOOKUP",
	"TBOx_L2_EXT_SNOOP_LOOKUP",
	"TBOx_L2_EXT_READ",
	"TBOx_L2_EXT_READ_NOSNP",
	"TBOx_L2_EXT_READ_UNIQUE",
	"TBOx_L2_EXT_READ_BEATS",
	"TBOx_L2_EXT_AR_STALL",
	"TBOx_L2_EXT_AR_CNT_Q1",
	"TBOx_L2_EXT_AR_CNT_Q2",
	"TBOx_L2_EXT_AR_CNT_Q3",
	"TBOx_L2_EXT_RRESP_0_127",
	"TBOx_L2_EXT_RRESP_128_191",
	"TBOx_L2_EXT_RRESP_192_255",
	"TBOx_L2_EXT_RRESP_256_319",
	"TBOx_L2_EXT_RRESP_320_383",
	"TBOx_L2_EXT_WRITE",
	"TBOx_L2_EXT_WRITE_NOSNP_FULL",
	"TBOx_L2_EXT_WRITE_NOSNP_PTL",
	"TBOx_L2_EXT_WRITE_SNP_FULL",
	"TBOx_L2_EXT_WRITE_SNP_PTL",
	"TBOx_L2_EXT_WRITE_BEATS",
	"TBOx_L2_EXT_W_STALL",
	"TBOx_L2_EXT_AW_CNT_Q1",
	"TBOx_L2_EXT_AW_CNT_Q2",
	"TBOx_L2_EXT_AW_CNT_Q3",
	"TBOx_L2_EXT_SNOOP",
	"TBOx_L2_EXT_SNOOP_STALL",
	"TBOx_L2_EXT_SNOOP_RESP_CLEAN",
	"TBOx_L2_EXT_SNOOP_RESP_DATA",
	"TBOx_L2_EXT_SNOOP_INTERNAL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tODx[] = {
	/* Frontend  */
	"",
	"",
	"",
	"",
	"TODx_GPU_ACTIVE",
	"TODx_MCU_ACTIVE",
	"TODx_GPU_ITER_ACTIVE",
	"TODx_MMU_FLUSH_COUNT",
	"",
	"",
	"TODx_IRQ_ACTIVE",
	"TODx_GPU_IRQ_COUNT",
	"",
	"",
	"TODx_DOORBELL_IRQ_ACTIVE",
	"TODx_DOORBELL_IRQ_COUNT",
	"TODx_ITER_TILER_ACTIVE",
	"TODx_ITER_TILER_JOB_COMPLETED",
	"TODx_ITER_TILER_IDVS_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TODx_ITER_COMP_ACTIVE",
	"TODx_ITER_COMP_JOB_COMPLETED",
	"TODx_ITER_COMP_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TODx_ITER_FRAG_ACTIVE",
	"TODx_ITER_FRAG_JOB_COMPLETED",
	"TODx_ITER_FRAG_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TODx_CEU_ACTIVE",
	"",
	"",
	"",
	"",
	"TODx_LSU_ACTIVE",
	"",
	"",
	"TODx_CSHWIF0_ENABLED",
	"",
	"",
	"",
	"TODx_CSHWIF1_ENABLED",
	"",
	"",
	"",
	"TODx_CSHWIF2_ENABLED",
	"",
	"",
	"",
	"TODx_CSHWIF3_ENABLED",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TODx_TILER_ACTIVE",
	"",
	"TODx_TRIANGLES",
	"TODx_LINES",
	"TODx_POINTS",
	"TODx_FRONT_FACING",
	"TODx_BACK_FACING",
	"TODx_PRIM_VISIBLE",
	"TODx_PRIM_CULLED",
	"TODx_PRIM_CLIPPED",
	"TODx_PRIM_SAT_CULLED",
	"",
	"",
	"TODx_BUS_READ",
	"TODx_BUS_WRITE_UTLB0",
	"TODx_BUS_WRITE_UTLB1",
	"TODx_SUSPENDED",
	"TODx_IDVS_POS_SHAD_REQ",
	"",
	"TODx_IDVS_POS_SHAD_STALL",
	"TODx_IDVS_POS_FIFO_FULL",
	"",
	"TODx_VCACHE_HIT",
	"TODx_VCACHE_MISS",
	"",
	"",
	"",
	"TODx_VFETCH_STALL",
	"",
	"TODx_RESUMED",
	"TODx_IDVS_VBU_HIT",
	"TODx_IDVS_VBU_MISS",
	"",
	"TODx_IDVS_VAR_SHAD_REQ",
	"TODx_IDVS_VAR_SHAD_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TODx_WRBUF_NO_AXI_ID_STALL",
	"TODx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TODx_FRAG_ACTIVE",
	"TODx_FRAG_PRIMITIVES_OUT",
	"TODx_FRAG_PRIM_RAST",
	"TODx_FRAG_FPK_ACTIVE",
	"",
	"TODx_FRAG_WARPS",
	"TODx_FRAG_PARTIAL_QUADS_RAST",
	"TODx_FRAG_QUADS_RAST",
	"TODx_FRAG_QUADS_EZS_TEST",
	"TODx_FRAG_QUADS_EZS_UPDATE",
	"TODx_FRAG_QUADS_EZS_KILL",
	"TODx_FRAG_LZS_TEST",
	"TODx_FRAG_LZS_KILL",
	"TODx_WARP_REG_SIZE_64",
	"TODx_FRAG_PTILES",
	"TODx_FRAG_TRANS_ELIM",
	"TODx_QUAD_FPK_KILLER",
	"TODx_FULL_QUAD_WARPS",
	"TODx_COMPUTE_ACTIVE",
	"TODx_COMPUTE_TASKS",
	"TODx_COMPUTE_WARPS",
	"TODx_COMPUTE_STARVING",
	"TODx_EXEC_CORE_ACTIVE",
	"TODx_EXEC_INSTR_FMA",
	"TODx_EXEC_INSTR_CVT",
	"TODx_EXEC_INSTR_SFU",
	"TODx_EXEC_INSTR_MSG",
	"TODx_EXEC_INSTR_DIVERGED",
	"TODx_EXEC_ICACHE_MISS",
	"TODx_EXEC_STARVE_ARITH",
	"TODx_CALL_BLEND_SHADER",
	"TODx_TEX_MSGI_NUM_FLITS",
	"TODx_TEX_DFCH_CLK_STALLED",
	"TODx_TEX_TFCH_CLK_STALLED",
	"TODx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TODx_TEX_FILT_NUM_OPERATIONS",
	"TODx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TODx_TEX_FILT_NUM_FST_OPERATIONS",
	"TODx_TEX_MSGO_NUM_MSG",
	"TODx_TEX_MSGO_NUM_FLITS",
	"TODx_LS_MEM_READ_FULL",
	"TODx_LS_MEM_READ_SHORT",
	"TODx_LS_MEM_WRITE_FULL",
	"TODx_LS_MEM_WRITE_SHORT",
	"TODx_LS_MEM_ATOMIC",
	"TODx_VARY_INSTR",
	"TODx_VARY_SLOT_32",
	"TODx_VARY_SLOT_16",
	"TODx_ATTR_INSTR",
	"TODx_SHADER_CORE_ACTIVE",
	"TODx_BEATS_RD_FTC",
	"TODx_BEATS_RD_FTC_EXT",
	"TODx_BEATS_RD_LSC",
	"TODx_BEATS_RD_LSC_EXT",
	"TODx_BEATS_RD_TEX",
	"TODx_BEATS_RD_TEX_EXT",
	"TODx_BEATS_RD_OTHER",
	"TODx_BEATS_WR_LSC_OTHER",
	"TODx_BEATS_WR_TIB",
	"TODx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TODx_MMU_REQUESTS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TODx_L2_RD_MSG_IN_EVICT",
	"TODx_L2_RD_MSG_IN_CU",
	"",
	"",
	"TODx_L2_RD_MSG_IN",
	"TODx_L2_RD_MSG_IN_STALL",
	"TODx_L2_WR_MSG_IN",
	"TODx_L2_WR_MSG_IN_STALL",
	"TODx_L2_SNP_MSG_IN",
	"TODx_L2_SNP_MSG_IN_STALL",
	"TODx_L2_RD_MSG_OUT",
	"TODx_L2_RD_MSG_OUT_STALL",
	"TODx_L2_WR_MSG_OUT",
	"TODx_L2_ANY_LOOKUP",
	"TODx_L2_READ_LOOKUP",
	"TODx_L2_WRITE_LOOKUP",
	"TODx_L2_EXT_SNOOP_LOOKUP",
	"TODx_L2_EXT_READ",
	"TODx_L2_EXT_READ_NOSNP",
	"TODx_L2_EXT_READ_UNIQUE",
	"TODx_L2_EXT_READ_BEATS",
	"TODx_L2_EXT_AR_STALL",
	"TODx_L2_EXT_AR_CNT_Q1",
	"TODx_L2_EXT_AR_CNT_Q2",
	"TODx_L2_EXT_AR_CNT_Q3",
	"TODx_L2_EXT_RRESP_0_127",
	"TODx_L2_EXT_RRESP_128_191",
	"TODx_L2_EXT_RRESP_192_255",
	"TODx_L2_EXT_RRESP_256_319",
	"TODx_L2_EXT_RRESP_320_383",
	"TODx_L2_EXT_WRITE",
	"TODx_L2_EXT_WRITE_NOSNP_FULL",
	"TODx_L2_EXT_WRITE_NOSNP_PTL",
	"TODx_L2_EXT_WRITE_SNP_FULL",
	"TODx_L2_EXT_WRITE_SNP_PTL",
	"TODx_L2_EXT_WRITE_BEATS",
	"TODx_L2_EXT_W_STALL",
	"TODx_L2_EXT_AW_CNT_Q1",
	"TODx_L2_EXT_AW_CNT_Q2",
	"TODx_L2_EXT_AW_CNT_Q3",
	"TODx_L2_EXT_SNOOP",
	"TODx_L2_EXT_SNOOP_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tVIx[] = {
	/* Frontend  */
	"",
	"",
	"",
	"",
	"TVIx_GPU_ACTIVE",
	"TVIx_MCU_ACTIVE",
	"TVIx_GPU_ITER_ACTIVE",
	"TVIx_MMU_FLUSH_COUNT",
	"",
	"",
	"TVIx_IRQ_ACTIVE",
	"TVIx_GPU_IRQ_COUNT",
	"",
	"",
	"TVIx_DOORBELL_IRQ_ACTIVE",
	"TVIx_DOORBELL_IRQ_COUNT",
	"TVIx_ITER_TILER_ACTIVE",
	"TVIx_ITER_TILER_JOB_COMPLETED",
	"TVIx_ITER_TILER_IDVS_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TVIx_ITER_COMP_ACTIVE",
	"TVIx_ITER_COMP_JOB_COMPLETED",
	"TVIx_ITER_COMP_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TVIx_ITER_FRAG_ACTIVE",
	"TVIx_ITER_FRAG_JOB_COMPLETED",
	"TVIx_ITER_FRAG_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TVIx_CEU_ACTIVE",
	"",
	"",
	"",
	"",
	"TVIx_LSU_ACTIVE",
	"",
	"",
	"TVIx_CSHWIF0_ENABLED",
	"",
	"",
	"",
	"TVIx_CSHWIF1_ENABLED",
	"",
	"",
	"",
	"TVIx_CSHWIF2_ENABLED",
	"",
	"",
	"",
	"TVIx_CSHWIF3_ENABLED",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TVIx_TILER_ACTIVE",
	"",
	"TVIx_TRIANGLES",
	"TVIx_LINES",
	"TVIx_POINTS",
	"TVIx_FRONT_FACING",
	"TVIx_BACK_FACING",
	"TVIx_PRIM_VISIBLE",
	"TVIx_PRIM_CULLED",
	"TVIx_PRIM_CLIPPED",
	"TVIx_PRIM_SAT_CULLED",
	"",
	"",
	"TVIx_BUS_READ",
	"TVIx_BUS_WRITE_UTLB0",
	"TVIx_BUS_WRITE_UTLB1",
	"TVIx_SUSPENDED",
	"TVIx_IDVS_POS_SHAD_REQ",
	"",
	"TVIx_IDVS_POS_SHAD_STALL",
	"TVIx_IDVS_POS_FIFO_FULL",
	"",
	"TVIx_VCACHE_HIT",
	"TVIx_VCACHE_MISS",
	"",
	"",
	"",
	"TVIx_VFETCH_STALL",
	"",
	"TVIx_RESUMED",
	"TVIx_IDVS_VBU_HIT",
	"TVIx_IDVS_VBU_MISS",
	"",
	"TVIx_IDVS_VAR_SHAD_REQ",
	"TVIx_IDVS_VAR_SHAD_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TVIx_WRBUF_NO_AXI_ID_STALL",
	"TVIx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TVIx_FRAG_ACTIVE",
	"TVIx_FRAG_PRIMITIVES_OUT",
	"TVIx_FRAG_PRIM_RAST",
	"TVIx_FRAG_FPK_ACTIVE",
	"",
	"TVIx_FRAG_WARPS",
	"TVIx_FRAG_PARTIAL_QUADS_RAST",
	"TVIx_FRAG_QUADS_RAST",
	"TVIx_FRAG_QUADS_EZS_TEST",
	"TVIx_FRAG_QUADS_EZS_UPDATE",
	"TVIx_FRAG_QUADS_EZS_KILL",
	"TVIx_FRAG_LZS_TEST",
	"TVIx_FRAG_LZS_KILL",
	"TVIx_WARP_REG_SIZE_64",
	"TVIx_FRAG_PTILES",
	"TVIx_FRAG_TRANS_ELIM",
	"TVIx_QUAD_FPK_KILLER",
	"TVIx_FULL_QUAD_WARPS",
	"TVIx_COMPUTE_ACTIVE",
	"TVIx_COMPUTE_TASKS",
	"TVIx_COMPUTE_WARPS",
	"TVIx_COMPUTE_STARVING",
	"TVIx_EXEC_CORE_ACTIVE",
	"TVIx_EXEC_INSTR_FMA",
	"TVIx_EXEC_INSTR_CVT",
	"TVIx_EXEC_INSTR_SFU",
	"TVIx_EXEC_INSTR_MSG",
	"TVIx_EXEC_INSTR_DIVERGED",
	"TVIx_EXEC_ICACHE_MISS",
	"TVIx_EXEC_STARVE_ARITH",
	"TVIx_CALL_BLEND_SHADER",
	"TVIx_TEX_MSGI_NUM_FLITS",
	"TVIx_TEX_DFCH_CLK_STALLED",
	"TVIx_TEX_TFCH_CLK_STALLED",
	"TVIx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TVIx_TEX_FILT_NUM_OPERATIONS",
	"TVIx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TVIx_TEX_FILT_NUM_FST_OPERATIONS",
	"TVIx_TEX_MSGO_NUM_MSG",
	"TVIx_TEX_MSGO_NUM_FLITS",
	"TVIx_LS_MEM_READ_FULL",
	"TVIx_LS_MEM_READ_SHORT",
	"TVIx_LS_MEM_WRITE_FULL",
	"TVIx_LS_MEM_WRITE_SHORT",
	"TVIx_LS_MEM_ATOMIC",
	"TVIx_VARY_INSTR",
	"TVIx_VARY_SLOT_32",
	"TVIx_VARY_SLOT_16",
	"TVIx_ATTR_INSTR",
	"TVIx_SHADER_CORE_ACTIVE",
	"TVIx_BEATS_RD_FTC",
	"TVIx_BEATS_RD_FTC_EXT",
	"TVIx_BEATS_RD_LSC",
	"TVIx_BEATS_RD_LSC_EXT",
	"TVIx_BEATS_RD_TEX",
	"TVIx_BEATS_RD_TEX_EXT",
	"TVIx_BEATS_RD_OTHER",
	"TVIx_BEATS_WR_LSC_OTHER",
	"TVIx_BEATS_WR_TIB",
	"TVIx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TVIx_MMU_REQUESTS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TVIx_L2_RD_MSG_IN_EVICT",
	"TVIx_L2_RD_MSG_IN_CU",
	"",
	"",
	"TVIx_L2_RD_MSG_IN",
	"TVIx_L2_RD_MSG_IN_STALL",
	"TVIx_L2_WR_MSG_IN",
	"TVIx_L2_WR_MSG_IN_STALL",
	"TVIx_L2_SNP_MSG_IN",
	"TVIx_L2_SNP_MSG_IN_STALL",
	"TVIx_L2_RD_MSG_OUT",
	"TVIx_L2_RD_MSG_OUT_STALL",
	"TVIx_L2_WR_MSG_OUT",
	"TVIx_L2_ANY_LOOKUP",
	"TVIx_L2_READ_LOOKUP",
	"TVIx_L2_WRITE_LOOKUP",
	"TVIx_L2_EXT_SNOOP_LOOKUP",
	"TVIx_L2_EXT_READ",
	"TVIx_L2_EXT_READ_NOSNP",
	"TVIx_L2_EXT_READ_UNIQUE",
	"TVIx_L2_EXT_READ_BEATS",
	"TVIx_L2_EXT_AR_STALL",
	"TVIx_L2_EXT_AR_CNT_Q1",
	"TVIx_L2_EXT_AR_CNT_Q2",
	"TVIx_L2_EXT_AR_CNT_Q3",
	"TVIx_L2_EXT_RRESP_0_127",
	"TVIx_L2_EXT_RRESP_128_191",
	"TVIx_L2_EXT_RRESP_192_255",
	"TVIx_L2_EXT_RRESP_256_319",
	"TVIx_L2_EXT_RRESP_320_383",
	"TVIx_L2_EXT_WRITE",
	"TVIx_L2_EXT_WRITE_NOSNP_FULL",
	"TVIx_L2_EXT_WRITE_NOSNP_PTL",
	"TVIx_L2_EXT_WRITE_SNP_FULL",
	"TVIx_L2_EXT_WRITE_SNP_PTL",
	"TVIx_L2_EXT_WRITE_BEATS",
	"TVIx_L2_EXT_W_STALL",
	"TVIx_L2_EXT_AW_CNT_Q1",
	"TVIx_L2_EXT_AW_CNT_Q2",
	"TVIx_L2_EXT_AW_CNT_Q3",
	"TVIx_L2_EXT_SNOOP",
	"TVIx_L2_EXT_SNOOP_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tGRx[] = {

	/* Frontend  */
	"",
	"",
	"",
	"",
	"TGRx_GPU_ACTIVE",
	"TGRx_MCU_ACTIVE",
	"TGRx_GPU_ITER_ACTIVE",
	"TGRx_MMU_FLUSH_COUNT",
	"",
	"",
	"TGRx_IRQ_ACTIVE",
	"TGRx_GPU_IRQ_COUNT",
	"",
	"",
	"TGRx_DOORBELL_IRQ_ACTIVE",
	"TGRx_DOORBELL_IRQ_COUNT",
	"TGRx_ITER_TILER_ACTIVE",
	"TGRx_ITER_TILER_JOB_COMPLETED",
	"TGRx_ITER_TILER_IDVS_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TGRx_ITER_COMP_ACTIVE",
	"TGRx_ITER_COMP_JOB_COMPLETED",
	"TGRx_ITER_COMP_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TGRx_ITER_FRAG_ACTIVE",
	"TGRx_ITER_FRAG_JOB_COMPLETED",
	"TGRx_ITER_FRAG_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TGRx_CEU_ACTIVE",
	"",
	"",
	"",
	"",
	"TGRx_LSU_ACTIVE",
	"",
	"",
	"TGRx_CSHWIF0_ENABLED",
	"",
	"",
	"",
	"TGRx_CSHWIF1_ENABLED",
	"",
	"",
	"",
	"TGRx_CSHWIF2_ENABLED",
	"",
	"",
	"",
	"TGRx_CSHWIF3_ENABLED",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TGRx_TILER_ACTIVE",
	"",
	"TGRx_TRIANGLES",
	"TGRx_LINES",
	"TGRx_POINTS",
	"TGRx_FRONT_FACING",
	"TGRx_BACK_FACING",
	"TGRx_PRIM_VISIBLE",
	"TGRx_PRIM_CULLED",
	"TGRx_PRIM_CLIPPED",
	"TGRx_PRIM_SAT_CULLED",
	"",
	"",
	"TGRx_BUS_READ",
	"TGRx_BUS_WRITE_UTLB0",
	"TGRx_BUS_WRITE_UTLB1",
	"TGRx_SUSPENDED",
	"TGRx_IDVS_POS_SHAD_REQ",
	"",
	"TGRx_IDVS_POS_SHAD_STALL",
	"TGRx_IDVS_POS_FIFO_FULL",
	"",
	"TGRx_VCACHE_HIT",
	"TGRx_VCACHE_MISS",
	"",
	"",
	"",
	"TGRx_VFETCH_STALL",
	"",
	"TGRx_RESUMED",
	"TGRx_IDVS_VBU_HIT",
	"TGRx_IDVS_VBU_MISS",
	"",
	"TGRx_IDVS_VAR_SHAD_REQ",
	"TGRx_IDVS_VAR_SHAD_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TGRx_WRBUF_NO_AXI_ID_STALL",
	"TGRx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TGRx_FRAG_ACTIVE",
	"TGRx_FRAG_PRIMITIVES_OUT",
	"TGRx_FRAG_PRIM_RAST",
	"TGRx_FRAG_FPK_ACTIVE",
	"",
	"TGRx_FRAG_WARPS",
	"TGRx_FRAG_PARTIAL_QUADS_RAST",
	"TGRx_FRAG_QUADS_RAST",
	"TGRx_FRAG_QUADS_EZS_TEST",
	"TGRx_FRAG_QUADS_EZS_UPDATE",
	"TGRx_FRAG_QUADS_EZS_KILL",
	"TGRx_FRAG_LZS_TEST",
	"TGRx_FRAG_LZS_KILL",
	"TGRx_WARP_REG_SIZE_64",
	"TGRx_FRAG_PTILES",
	"TGRx_FRAG_TRANS_ELIM",
	"TGRx_QUAD_FPK_KILLER",
	"TGRx_FULL_QUAD_WARPS",
	"TGRx_COMPUTE_ACTIVE",
	"TGRx_COMPUTE_TASKS",
	"TGRx_COMPUTE_WARPS",
	"TGRx_COMPUTE_STARVING",
	"TGRx_EXEC_CORE_ACTIVE",
	"TGRx_EXEC_INSTR_FMA",
	"TGRx_EXEC_INSTR_CVT",
	"TGRx_EXEC_INSTR_SFU",
	"TGRx_EXEC_INSTR_MSG",
	"TGRx_EXEC_INSTR_DIVERGED",
	"TGRx_EXEC_ICACHE_MISS",
	"TGRx_EXEC_STARVE_ARITH",
	"TGRx_CALL_BLEND_SHADER",
	"TGRx_TEX_MSGI_NUM_FLITS",
	"TGRx_TEX_DFCH_CLK_STALLED",
	"TGRx_TEX_TFCH_CLK_STALLED",
	"TGRx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TGRx_TEX_FILT_NUM_OPERATIONS",
	"TGRx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TGRx_TEX_FILT_NUM_FST_OPERATIONS",
	"TGRx_TEX_MSGO_NUM_MSG",
	"TGRx_TEX_MSGO_NUM_FLITS",
	"TGRx_LS_MEM_READ_FULL",
	"TGRx_LS_MEM_READ_SHORT",
	"TGRx_LS_MEM_WRITE_FULL",
	"TGRx_LS_MEM_WRITE_SHORT",
	"TGRx_LS_MEM_ATOMIC",
	"TGRx_VARY_INSTR",
	"TGRx_VARY_SLOT_32",
	"TGRx_VARY_SLOT_16",
	"TGRx_ATTR_INSTR",
	"TGRx_SHADER_CORE_ACTIVE",
	"TGRx_BEATS_RD_FTC",
	"TGRx_BEATS_RD_FTC_EXT",
	"TGRx_BEATS_RD_LSC",
	"TGRx_BEATS_RD_LSC_EXT",
	"TGRx_BEATS_RD_TEX",
	"TGRx_BEATS_RD_TEX_EXT",
	"TGRx_BEATS_RD_OTHER",
	"TGRx_BEATS_WR_LSC_OTHER",
	"TGRx_BEATS_WR_TIB",
	"TGRx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TGRx_MMU_REQUESTS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TGRx_L2_RD_MSG_IN_EVICT",
	"TGRx_L2_RD_MSG_IN_CU",
	"",
	"",
	"TGRx_L2_RD_MSG_IN",
	"TGRx_L2_RD_MSG_IN_STALL",
	"TGRx_L2_WR_MSG_IN",
	"TGRx_L2_WR_MSG_IN_STALL",
	"TGRx_L2_SNP_MSG_IN",
	"TGRx_L2_SNP_MSG_IN_STALL",
	"TGRx_L2_RD_MSG_OUT",
	"TGRx_L2_RD_MSG_OUT_STALL",
	"TGRx_L2_WR_MSG_OUT",
	"TGRx_L2_ANY_LOOKUP",
	"TGRx_L2_READ_LOOKUP",
	"TGRx_L2_WRITE_LOOKUP",
	"TGRx_L2_EXT_SNOOP_LOOKUP",
	"TGRx_L2_EXT_READ",
	"TGRx_L2_EXT_READ_NOSNP",
	"TGRx_L2_EXT_READ_UNIQUE",
	"TGRx_L2_EXT_READ_BEATS",
	"TGRx_L2_EXT_AR_STALL",
	"TGRx_L2_EXT_AR_CNT_Q1",
	"TGRx_L2_EXT_AR_CNT_Q2",
	"TGRx_L2_EXT_AR_CNT_Q3",
	"TGRx_L2_EXT_RRESP_0_127",
	"TGRx_L2_EXT_RRESP_128_191",
	"TGRx_L2_EXT_RRESP_192_255",
	"TGRx_L2_EXT_RRESP_256_319",
	"TGRx_L2_EXT_RRESP_320_383",
	"TGRx_L2_EXT_WRITE",
	"TGRx_L2_EXT_WRITE_NOSNP_FULL",
	"TGRx_L2_EXT_WRITE_NOSNP_PTL",
	"TGRx_L2_EXT_WRITE_SNP_FULL",
	"TGRx_L2_EXT_WRITE_SNP_PTL",
	"TGRx_L2_EXT_WRITE_BEATS",
	"TGRx_L2_EXT_W_STALL",
	"TGRx_L2_EXT_AW_CNT_Q1",
	"TGRx_L2_EXT_AW_CNT_Q2",
	"TGRx_L2_EXT_AW_CNT_Q3",
	"TGRx_L2_EXT_SNOOP",
	"TGRx_L2_EXT_SNOOP_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

static const char *const hardware_counters_mali_tVAx[] = {
	/* Frontend  */
	"",
	"",
	"",
	"",
	"TVAx_GPU_ACTIVE",
	"TVAx_MCU_ACTIVE",
	"TVAx_GPU_ITER_ACTIVE",
	"TVAx_MMU_FLUSH_COUNT",
	"",
	"",
	"TVAx_IRQ_ACTIVE",
	"TVAx_GPU_IRQ_COUNT",
	"",
	"",
	"TVAx_DOORBELL_IRQ_ACTIVE",
	"TVAx_DOORBELL_IRQ_COUNT",
	"TVAx_ITER_TILER_ACTIVE",
	"TVAx_ITER_TILER_JOB_COMPLETED",
	"TVAx_ITER_TILER_IDVS_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TVAx_ITER_COMP_ACTIVE",
	"TVAx_ITER_COMP_JOB_COMPLETED",
	"TVAx_ITER_COMP_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TVAx_ITER_FRAG_ACTIVE",
	"TVAx_ITER_FRAG_JOB_COMPLETED",
	"TVAx_ITER_FRAG_TASK_COMPLETED",
	"",
	"",
	"",
	"",
	"",
	"TVAx_CEU_ACTIVE",
	"",
	"",
	"",
	"",
	"TVAx_LSU_ACTIVE",
	"",
	"",
	"TVAx_CSHWIF0_ENABLED",
	"",
	"",
	"",
	"TVAx_CSHWIF1_ENABLED",
	"",
	"",
	"",
	"TVAx_CSHWIF2_ENABLED",
	"",
	"",
	"",
	"TVAx_CSHWIF3_ENABLED",
	"",
	"",
	"",

	/* Tiler */
	"",
	"",
	"",
	"",
	"TVAx_TILER_ACTIVE",
	"",
	"TVAx_TRIANGLES",
	"TVAx_LINES",
	"TVAx_POINTS",
	"TVAx_FRONT_FACING",
	"TVAx_BACK_FACING",
	"TVAx_PRIM_VISIBLE",
	"TVAx_PRIM_CULLED",
	"TVAx_PRIM_CLIPPED",
	"TVAx_PRIM_SAT_CULLED",
	"",
	"",
	"TVAx_BUS_READ",
	"TVAx_BUS_WRITE_UTLB0",
	"TVAx_BUS_WRITE_UTLB1",
	"TVAx_SUSPENDED",
	"TVAx_IDVS_POS_SHAD_REQ",
	"",
	"TVAx_IDVS_POS_SHAD_STALL",
	"TVAx_IDVS_POS_FIFO_FULL",
	"",
	"TVAx_VCACHE_HIT",
	"TVAx_VCACHE_MISS",
	"",
	"",
	"",
	"TVAx_VFETCH_STALL",
	"",
	"TVAx_RESUMED",
	"TVAx_IDVS_VBU_HIT",
	"TVAx_IDVS_VBU_MISS",
	"",
	"TVAx_IDVS_VAR_SHAD_REQ",
	"TVAx_IDVS_VAR_SHAD_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TVAx_WRBUF_NO_AXI_ID_STALL",
	"TVAx_WRBUF_AXI_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",

	/* Shader Core */
	"",
	"",
	"",
	"",
	"TVAx_FRAG_ACTIVE",
	"TVAx_FRAG_PRIMITIVES_OUT",
	"TVAx_FRAG_PRIM_RAST",
	"TVAx_FRAG_FPK_ACTIVE",
	"",
	"TVAx_FRAG_WARPS",
	"TVAx_FRAG_PARTIAL_QUADS_RAST",
	"TVAx_FRAG_QUADS_RAST",
	"TVAx_FRAG_QUADS_EZS_TEST",
	"TVAx_FRAG_QUADS_EZS_UPDATE",
	"TVAx_FRAG_QUADS_EZS_KILL",
	"TVAx_FRAG_LZS_TEST",
	"TVAx_FRAG_LZS_KILL",
	"TVAx_WARP_REG_SIZE_64",
	"TVAx_FRAG_PTILES",
	"TVAx_FRAG_TRANS_ELIM",
	"TVAx_QUAD_FPK_KILLER",
	"TVAx_FULL_QUAD_WARPS",
	"TVAx_COMPUTE_ACTIVE",
	"TVAx_COMPUTE_TASKS",
	"TVAx_COMPUTE_WARPS",
	"TVAx_COMPUTE_STARVING",
	"TVAx_EXEC_CORE_ACTIVE",
	"TVAx_EXEC_INSTR_FMA",
	"TVAx_EXEC_INSTR_CVT",
	"TVAx_EXEC_INSTR_SFU",
	"TVAx_EXEC_INSTR_MSG",
	"TVAx_EXEC_INSTR_DIVERGED",
	"TVAx_EXEC_ICACHE_MISS",
	"TVAx_EXEC_STARVE_ARITH",
	"TVAx_CALL_BLEND_SHADER",
	"TVAx_TEX_MSGI_NUM_FLITS",
	"TVAx_TEX_DFCH_CLK_STALLED",
	"TVAx_TEX_TFCH_CLK_STALLED",
	"TVAx_TEX_TFCH_STARVED_PENDING_DATA_FETCH",
	"TVAx_TEX_FILT_NUM_OPERATIONS",
	"TVAx_TEX_FILT_NUM_FXR_OPERATIONS",
	"TVAx_TEX_FILT_NUM_FST_OPERATIONS",
	"TVAx_TEX_MSGO_NUM_MSG",
	"TVAx_TEX_MSGO_NUM_FLITS",
	"TVAx_LS_MEM_READ_FULL",
	"TVAx_LS_MEM_READ_SHORT",
	"TVAx_LS_MEM_WRITE_FULL",
	"TVAx_LS_MEM_WRITE_SHORT",
	"TVAx_LS_MEM_ATOMIC",
	"TVAx_VARY_INSTR",
	"TVAx_VARY_SLOT_32",
	"TVAx_VARY_SLOT_16",
	"TVAx_ATTR_INSTR",
	"TVAx_SHADER_CORE_ACTIVE",
	"TVAx_BEATS_RD_FTC",
	"TVAx_BEATS_RD_FTC_EXT",
	"TVAx_BEATS_RD_LSC",
	"TVAx_BEATS_RD_LSC_EXT",
	"TVAx_BEATS_RD_TEX",
	"TVAx_BEATS_RD_TEX_EXT",
	"TVAx_BEATS_RD_OTHER",
	"TVAx_BEATS_WR_LSC_OTHER",
	"TVAx_BEATS_WR_TIB",
	"TVAx_BEATS_WR_LSC_WB",

	/* L2 and MMU */
	"",
	"",
	"",
	"",
	"TVAx_MMU_REQUESTS",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"TVAx_L2_RD_MSG_IN_EVICT",
	"TVAx_L2_RD_MSG_IN_CU",
	"",
	"",
	"TVAx_L2_RD_MSG_IN",
	"TVAx_L2_RD_MSG_IN_STALL",
	"TVAx_L2_WR_MSG_IN",
	"TVAx_L2_WR_MSG_IN_STALL",
	"TVAx_L2_SNP_MSG_IN",
	"TVAx_L2_SNP_MSG_IN_STALL",
	"TVAx_L2_RD_MSG_OUT",
	"TVAx_L2_RD_MSG_OUT_STALL",
	"TVAx_L2_WR_MSG_OUT",
	"TVAx_L2_ANY_LOOKUP",
	"TVAx_L2_READ_LOOKUP",
	"TVAx_L2_WRITE_LOOKUP",
	"TVAx_L2_EXT_SNOOP_LOOKUP",
	"TVAx_L2_EXT_READ",
	"TVAx_L2_EXT_READ_NOSNP",
	"TVAx_L2_EXT_READ_UNIQUE",
	"TVAx_L2_EXT_READ_BEATS",
	"TVAx_L2_EXT_AR_STALL",
	"TVAx_L2_EXT_AR_CNT_Q1",
	"TVAx_L2_EXT_AR_CNT_Q2",
	"TVAx_L2_EXT_AR_CNT_Q3",
	"TVAx_L2_EXT_RRESP_0_127",
	"TVAx_L2_EXT_RRESP_128_191",
	"TVAx_L2_EXT_RRESP_192_255",
	"TVAx_L2_EXT_RRESP_256_319",
	"TVAx_L2_EXT_RRESP_320_383",
	"TVAx_L2_EXT_WRITE",
	"TVAx_L2_EXT_WRITE_NOSNP_FULL",
	"TVAx_L2_EXT_WRITE_NOSNP_PTL",
	"TVAx_L2_EXT_WRITE_SNP_FULL",
	"TVAx_L2_EXT_WRITE_SNP_PTL",
	"TVAx_L2_EXT_WRITE_BEATS",
	"TVAx_L2_EXT_W_STALL",
	"TVAx_L2_EXT_AW_CNT_Q1",
	"TVAx_L2_EXT_AW_CNT_Q2",
	"TVAx_L2_EXT_AW_CNT_Q3",
	"TVAx_L2_EXT_SNOOP",
	"TVAx_L2_EXT_SNOOP_STALL",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
};

enum
{
	/* Product id masks for old and new versions of the id field. NB: the T60x
	 * must be tested before anything else as it could exceptionally be
	 * treated as a new style of id with product code 0x6006 */
	PRODUCT_ID_MASK_OLD = 0xffff,
	PRODUCT_ID_MASK_NEW = 0xf00f,
	/* Old style product ids */
	PRODUCT_ID_T60X = 0x6956,
	PRODUCT_ID_T62X = 0x0620,
	PRODUCT_ID_T72X = 0x0720,
	PRODUCT_ID_T76X = 0x0750,
	PRODUCT_ID_T82X = 0x0820,
	PRODUCT_ID_T83X = 0x0830,
	PRODUCT_ID_T86X = 0x0860,
	PRODUCT_ID_TFRX = 0x0880,
	/* New style product ids */
	PRODUCT_ID_TMIX   = 0x6000,
	PRODUCT_ID_THEX   = 0x6001,
	PRODUCT_ID_TSIX   = 0x7000,
	PRODUCT_ID_TNOX   = 0x7001,
	PRODUCT_ID_TGOX   = 0x7002,
	PRODUCT_ID_TDVX   = 0x7003,
	PRODUCT_ID_TTRX   = 0x9000,
	PRODUCT_ID_TNAXa  = 0x9001,
	PRODUCT_ID_TNAXb  = 0x9003,
	PRODUCT_ID_TOTX   = 0x9004,
	PRODUCT_ID_TBOX   = 0x9002,
	PRODUCT_ID_TBOXAE = 0x9005,
	PRODUCT_ID_TODX   = 0xa002,
	PRODUCT_ID_TVIX   = 0xa007,
	PRODUCT_ID_TGRX   = 0xa003,
	PRODUCT_ID_TVAX   = 0xa004,
};

struct CounterMapping
{
	uint32_t           product_mask;
	uint32_t           product_id;
	const char *const *names_lut;
};

static const CounterMapping products[] = {
	{
		// Mali-T600
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T60X,
		hardware_counters_mali_t60x,
	},
	{
		// Mali-T620
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T62X,
		hardware_counters_mali_t62x,
	},
	{
		// Mali-T720
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T72X,
		hardware_counters_mali_t72x,
	},
	{
		// Mali-T760
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T76X,
		hardware_counters_mali_t76x,
	},
	{
		// Mali-T820
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T82X,
		hardware_counters_mali_t82x,
	},
	{
		// Mali-T830
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T83X,
		hardware_counters_mali_t83x,
	},
	{
		// Mali-T860
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_T86X,
		hardware_counters_mali_t86x,
	},
	{
		// Mali-T880
		PRODUCT_ID_MASK_OLD,
		PRODUCT_ID_TFRX,
		hardware_counters_mali_t88x,
	},
	{
		// Mali-G71
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TMIX,
		hardware_counters_mali_tMIx,
	},
	{
		// Mali-G72
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_THEX,
		hardware_counters_mali_tHEx,
	},
	{
		// Mali-G31
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TDVX,
		hardware_counters_mali_tDVx,
	},
	{
		// Mali-G51
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TSIX,
		hardware_counters_mali_tSIx,
	},
	{
		// Mali-G52
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TGOX,
		hardware_counters_mali_tGOx,
	},
	{
		// Mali-G76
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TNOX,
		hardware_counters_mali_tNOx,
	},
	{
		// Mali-G57
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TNAXa,
		hardware_counters_mali_tNAx,
	},
	{
		// Mali-G57 variant
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TNAXb,
		hardware_counters_mali_tNAx,
	},
	{
		// Mali-G77
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TTRX,
		hardware_counters_mali_tTRx,
	},
	{
		// Mali-G68
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TOTX,
		hardware_counters_mali_tOTx,
	},
	{
		// Mali-G78
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TBOX,
		hardware_counters_mali_tBOx,
	},
	{
		// Mali-G78AE
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TBOXAE,
		hardware_counters_mali_tBOx,
	},
	{
		// Mali-G310
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TVAX,
		hardware_counters_mali_tVAx,
	},
	{
		// Mali-G510
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TGRX,
		hardware_counters_mali_tGRx,
	},
	{
		// Mali-G610
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TVIX,
		hardware_counters_mali_tVIx,
	},
	{
		// Mali-G710
		PRODUCT_ID_MASK_NEW,
		PRODUCT_ID_TODX,
		hardware_counters_mali_tODx,
	}
};

enum
{
	NUM_PRODUCTS = sizeof(products) / sizeof(products[0])
};

}        // namespace mali_userspace
