#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main(int argc,char **argv)
{
  char buf[256],s[100];
  char *name,*ext;
  int c;
  FILE *fp;
  if (argc!=2)
    {
      fprintf(stderr,"Usage: %s file\n",*argv);
      return 1;
    }
  if (!(fp = fopen(argv[1],"rb")))
    {
      fputs("Cannot open ",stderr);
      perror(argv[1]);
      return 1;
    }
  name = strdup(argv[1]);
  if ((ext = strrchr(name, '.')))
    *ext = '\0';
  printf("static const unsigned char %s[] =\n{\n", name);
  free(name);
  strcpy(buf,"  ");
  while ((c=getc(fp))!=EOF)
    {
      sprintf(s,"0x%02X,",(unsigned char) c);
      if (strlen(s)+strlen(buf) > 2+8*5)
	puts(buf), strcpy(buf,"  ");
      strcat(buf,s);
    }
  if (*buf)
    strcat(buf,"\n");
  printf("%s};\n",buf);
  fclose(fp);
  return 0;
}
