// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: info.c,v 1.44 1998/05/12 12:46:36 phares Exp $
//
//  Copyright (C) 1999 by
//  id Software, Chi Hoang, Lee Killough, Jim Flynn, Rand Phares, Ty Halderman
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
//  02111-1307, USA.
//
// DESCRIPTION:
//  Thing frame/state LUT,
//  generated by multigen utilitiy.
//  This one is the original DOOM version, preserved.
//  BOOM changes include commenting and addition of predefined lumps
//  for providing things that aren't in the IWAD without sending a
//  separate must-use wad file around with the EXE.
//
//-----------------------------------------------------------------------------

#include "doomdef.h"
#include "sounds.h"
#include "m_fixed.h"
#include "p_mobj.h"
#include "w_wad.h"
#include "info.h"


// ********************************************************************
// Sprite names
// ********************************************************************
// This is the list of sprite 4-character prefixes.  They are searched
// through, with a NULL entry terminating the list.  In DOOM originally
// this NULL entry was missing, and coincidentally the next thing in
// memory was the dummy state_t[] entry that started with zero bytes.
// killough 1/17/98: add an explicit NULL entry.
// NUMSPRITES is an enum from info.h where all these are listed
// as SPR_xxxx

char *original_sprnames[NUMSPRITES+1] = {
  "TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
  "MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
  "PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
  "SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
  "HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
  "PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
  "BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
  "SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
  "ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
  "LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
  "POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
  "COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
  "COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
  "HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2",
  "TNT1", // invisible sprite                                 phares 3/9/98

  "DOGS", // killough 7/19/98: Marine's best friend :)

  "PLS1", // killough 7/19/98: first  of two plasma fireballs in the beta
  "PLS2", // killough 7/19/98: second of two plasma fireballs in the beta
  "BON3", // killough 7/11/98: evil sceptre in the beta version
  "BON4", // killough 7/11/98: unholy bible in the beta version

  "BLD2", // [FG] blood splats from Doom Retro, unsused in Woof!

  // [FG] 100 extra sprite names to use in dehacked patches
  "SP00", "SP01", "SP02", "SP03", "SP04", "SP05", "SP06", "SP07", "SP08", "SP09",
  "SP10", "SP11", "SP12", "SP13", "SP14", "SP15", "SP16", "SP17", "SP18", "SP19",
  "SP20", "SP21", "SP22", "SP23", "SP24", "SP25", "SP26", "SP27", "SP28", "SP29",
  "SP30", "SP31", "SP32", "SP33", "SP34", "SP35", "SP36", "SP37", "SP38", "SP39",
  "SP40", "SP41", "SP42", "SP43", "SP44", "SP45", "SP46", "SP47", "SP48", "SP49",
  "SP50", "SP51", "SP52", "SP53", "SP54", "SP55", "SP56", "SP57", "SP58", "SP59",
  "SP60", "SP61", "SP62", "SP63", "SP64", "SP65", "SP66", "SP67", "SP68", "SP69",
  "SP70", "SP71", "SP72", "SP73", "SP74", "SP75", "SP76", "SP77", "SP78", "SP79",
  "SP80", "SP81", "SP82", "SP83", "SP84", "SP85", "SP86", "SP87", "SP88", "SP89",
  "SP90", "SP91", "SP92", "SP93", "SP94", "SP95", "SP96", "SP97", "SP98", "SP99",

  NULL
};

#include "p_action.h"

// ********************************************************************
// State or "frame" information
// ********************************************************************
// Each of the states, otherwise known as "frames", is outlined
// here.  The data in each element of the array is the way it is
// initialized, with sprite names identified by their enumerator
// value such as SPR_SHTG.  These correlate to the above sprite
// array so don't change them around unless you understand what
// you're doing.
//
// The commented name beginning with S_ at the end of each line
// is there to help figure out where the next-frame pointer is
// pointing.  These are also additionally identified in info.h
// as enumerated values.  From a change-and-recompile point of
// view this is fairly workable, but it adds a lot to the effort
// when trying to change things externally.  See also the d_deh.c
// parts where frame rewiring is done for more details and the
// extended way a BEX file can handle this.
//
// killough 11/98: cleaned up, since we don't need to accomodate C++

state_t original_states[NUMSTATES] = {
  {SPR_TROO,0,-1,{NULL},S_NULL},  // S_NULL
  {SPR_SHTG,4,0,{A_Light0},S_NULL}, // S_LIGHTDONE
  {SPR_PUNG,0,1,{A_WeaponReady},S_PUNCH}, // S_PUNCH
  {SPR_PUNG,0,1,{A_Lower},S_PUNCHDOWN}, // S_PUNCHDOWN
  {SPR_PUNG,0,1,{A_Raise},S_PUNCHUP}, // S_PUNCHUP
  {SPR_PUNG,1,4,{NULL},S_PUNCH2},   // S_PUNCH1
  {SPR_PUNG,2,4,{A_Punch},S_PUNCH3},  // S_PUNCH2
  {SPR_PUNG,3,5,{NULL},S_PUNCH4},   // S_PUNCH3
  {SPR_PUNG,2,4,{NULL},S_PUNCH5},   // S_PUNCH4
  {SPR_PUNG,1,5,{A_ReFire},S_PUNCH},  // S_PUNCH5
  {SPR_PISG,0,1,{A_WeaponReady},S_PISTOL},// S_PISTOL
  {SPR_PISG,0,1,{A_Lower},S_PISTOLDOWN},  // S_PISTOLDOWN
  {SPR_PISG,0,1,{A_Raise},S_PISTOLUP},  // S_PISTOLUP
  {SPR_PISG,0,4,{NULL},S_PISTOL2},  // S_PISTOL1
  {SPR_PISG,1,6,{A_FirePistol},S_PISTOL3},// S_PISTOL2
  {SPR_PISG,2,4,{NULL},S_PISTOL4},  // S_PISTOL3
  {SPR_PISG,1,5,{A_ReFire},S_PISTOL}, // S_PISTOL4
  {SPR_PISF,0|FF_FULLBRIGHT,7,{A_Light1},S_LIGHTDONE},  // S_PISTOLFLASH
  {SPR_SHTG,0,1,{A_WeaponReady},S_SGUN},  // S_SGUN
  {SPR_SHTG,0,1,{A_Lower},S_SGUNDOWN},  // S_SGUNDOWN
  {SPR_SHTG,0,1,{A_Raise},S_SGUNUP},  // S_SGUNUP
  {SPR_SHTG,0,3,{NULL},S_SGUN2},  // S_SGUN1
  {SPR_SHTG,0,7,{A_FireShotgun},S_SGUN3}, // S_SGUN2
  {SPR_SHTG,1,5,{NULL},S_SGUN4},  // S_SGUN3
  {SPR_SHTG,2,5,{NULL},S_SGUN5},  // S_SGUN4
  {SPR_SHTG,3,4,{NULL},S_SGUN6},  // S_SGUN5
  {SPR_SHTG,2,5,{NULL},S_SGUN7},  // S_SGUN6
  {SPR_SHTG,1,5,{NULL},S_SGUN8},  // S_SGUN7
  {SPR_SHTG,0,3,{NULL},S_SGUN9},  // S_SGUN8
  {SPR_SHTG,0,7,{A_ReFire},S_SGUN}, // S_SGUN9
  {SPR_SHTF,0|FF_FULLBRIGHT,4,{A_Light1},S_SGUNFLASH2}, // S_SGUNFLASH1
  {SPR_SHTF,1|FF_FULLBRIGHT,3,{A_Light2},S_LIGHTDONE},  // S_SGUNFLASH2
  {SPR_SHT2,0,1,{A_WeaponReady},S_DSGUN}, // S_DSGUN
  {SPR_SHT2,0,1,{A_Lower},S_DSGUNDOWN}, // S_DSGUNDOWN
  {SPR_SHT2,0,1,{A_Raise},S_DSGUNUP}, // S_DSGUNUP
  {SPR_SHT2,0,3,{NULL},S_DSGUN2}, // S_DSGUN1

  // killough 9/5/98: make SSG lighting flash more uniform along super shotgun:

  {SPR_SHT2,0|FF_FULLBRIGHT /* killough */,7,{A_FireShotgun2},S_DSGUN3}, // S_DSGUN2
  {SPR_SHT2,1,7,{NULL},S_DSGUN4}, // S_DSGUN3
  {SPR_SHT2,2,7,{A_CheckReload},S_DSGUN5},  // S_DSGUN4
  {SPR_SHT2,3,7,{A_OpenShotgun2},S_DSGUN6}, // S_DSGUN5
  {SPR_SHT2,4,7,{NULL},S_DSGUN7}, // S_DSGUN6
  {SPR_SHT2,5,7,{A_LoadShotgun2},S_DSGUN8}, // S_DSGUN7
  {SPR_SHT2,6,6,{NULL},S_DSGUN9}, // S_DSGUN8
  {SPR_SHT2,7,6,{A_CloseShotgun2},S_DSGUN10}, // S_DSGUN9
  {SPR_SHT2,0,5,{A_ReFire},S_DSGUN},  // S_DSGUN10
  {SPR_SHT2,1,7,{NULL},S_DSNR2},  // S_DSNR1
  {SPR_SHT2,0,3,{NULL},S_DSGUNDOWN},  // S_DSNR2

  // killough 8/20/98: reduce first SSG flash frame one tic, to fix
  // Doom II SSG flash bug, in which SSG raises before flash finishes

  {SPR_SHT2,8|FF_FULLBRIGHT,4/*killough*/,{A_Light1},S_DSGUNFLASH2}, // S_DSGUNFLASH1
  {SPR_SHT2,9|FF_FULLBRIGHT,4,{A_Light2},S_LIGHTDONE},  // S_DSGUNFLASH2
  {SPR_CHGG,0,1,{A_WeaponReady},S_CHAIN}, // S_CHAIN
  {SPR_CHGG,0,1,{A_Lower},S_CHAINDOWN}, // S_CHAINDOWN
  {SPR_CHGG,0,1,{A_Raise},S_CHAINUP}, // S_CHAINUP
  {SPR_CHGG,0,4,{A_FireCGun},S_CHAIN2}, // S_CHAIN1
  {SPR_CHGG,1,4,{A_FireCGun},S_CHAIN3}, // S_CHAIN2
  {SPR_CHGG,1,0,{A_ReFire},S_CHAIN},  // S_CHAIN3
  {SPR_CHGF,0|FF_FULLBRIGHT,5,{A_Light1},S_LIGHTDONE},  // S_CHAINFLASH1
  {SPR_CHGF,1|FF_FULLBRIGHT,5,{A_Light2},S_LIGHTDONE},  // S_CHAINFLASH2
  {SPR_MISG,0,1,{A_WeaponReady},S_MISSILE}, // S_MISSILE
  {SPR_MISG,0,1,{A_Lower},S_MISSILEDOWN}, // S_MISSILEDOWN
  {SPR_MISG,0,1,{A_Raise},S_MISSILEUP}, // S_MISSILEUP
  {SPR_MISG,1,8,{A_GunFlash},S_MISSILE2}, // S_MISSILE1
  {SPR_MISG,1,12,{A_FireMissile},S_MISSILE3}, // S_MISSILE2
  {SPR_MISG,1,0,{A_ReFire},S_MISSILE},  // S_MISSILE3
  {SPR_MISF,0|FF_FULLBRIGHT,3,{A_Light1},S_MISSILEFLASH2},  // S_MISSILEFLASH1
  {SPR_MISF,1|FF_FULLBRIGHT,4,{NULL},S_MISSILEFLASH3},  // S_MISSILEFLASH2
  {SPR_MISF,2|FF_FULLBRIGHT,4,{A_Light2},S_MISSILEFLASH4},  // S_MISSILEFLASH3
  {SPR_MISF,3|FF_FULLBRIGHT,4,{A_Light2},S_LIGHTDONE},  // S_MISSILEFLASH4
  {SPR_SAWG,2,4,{A_WeaponReady},S_SAWB},  // S_SAW
  {SPR_SAWG,3,4,{A_WeaponReady},S_SAW}, // S_SAWB
  {SPR_SAWG,2,1,{A_Lower},S_SAWDOWN}, // S_SAWDOWN
  {SPR_SAWG,2,1,{A_Raise},S_SAWUP}, // S_SAWUP
  {SPR_SAWG,0,4,{A_Saw},S_SAW2}, // S_SAW1
  {SPR_SAWG,1,4,{A_Saw},S_SAW3},  // S_SAW2
  {SPR_SAWG,1,0,{A_ReFire},S_SAW},  // S_SAW3
  {SPR_PLSG,0,1,{A_WeaponReady},S_PLASMA},  // S_PLASMA
  {SPR_PLSG,0,1,{A_Lower},S_PLASMADOWN},  // S_PLASMADOWN
  {SPR_PLSG,0,1,{A_Raise},S_PLASMAUP},  // S_PLASMAUP
  {SPR_PLSG,0,3,{A_FirePlasma},S_PLASMA2},  // S_PLASMA1
  {SPR_PLSG,1,20,{A_ReFire},S_PLASMA},  // S_PLASMA2
  {SPR_PLSF,0|FF_FULLBRIGHT,4,{A_Light1},S_LIGHTDONE},  // S_PLASMAFLASH1
  {SPR_PLSF,1|FF_FULLBRIGHT,4,{A_Light1},S_LIGHTDONE},  // S_PLASMAFLASH2
  {SPR_BFGG,0,1,{A_WeaponReady},S_BFG}, // S_BFG
  {SPR_BFGG,0,1,{A_Lower},S_BFGDOWN}, // S_BFGDOWN
  {SPR_BFGG,0,1,{A_Raise},S_BFGUP}, // S_BFGUP
  {SPR_BFGG,0,20,{A_BFGsound},S_BFG2},  // S_BFG1
  {SPR_BFGG,1,10,{A_GunFlash},S_BFG3},  // S_BFG2
  {SPR_BFGG,1,10,{A_FireBFG},S_BFG4}, // S_BFG3
  {SPR_BFGG,1,20,{A_ReFire},S_BFG}, // S_BFG4
  {SPR_BFGF,0|FF_FULLBRIGHT,11,{A_Light1},S_BFGFLASH2}, // S_BFGFLASH1
  {SPR_BFGF,1|FF_FULLBRIGHT,6,{A_Light2},S_LIGHTDONE},  // S_BFGFLASH2
  {SPR_BLUD,2,8,{NULL},S_BLOOD2}, // S_BLOOD1
  {SPR_BLUD,1,8,{NULL},S_BLOOD3}, // S_BLOOD2
  {SPR_BLUD,0,8,{NULL},S_NULL}, // S_BLOOD3
  {SPR_PUFF,0|FF_FULLBRIGHT,4,{NULL},S_PUFF2},  // S_PUFF1
  {SPR_PUFF,1,4,{NULL},S_PUFF3},  // S_PUFF2
  {SPR_PUFF,2,4,{NULL},S_PUFF4},  // S_PUFF3
  {SPR_PUFF,3,4,{NULL},S_NULL}, // S_PUFF4
  {SPR_BAL1,0|FF_FULLBRIGHT,4,{NULL},S_TBALL2}, // S_TBALL1
  {SPR_BAL1,1|FF_FULLBRIGHT,4,{NULL},S_TBALL1}, // S_TBALL2
  {SPR_BAL1,2|FF_FULLBRIGHT,6,{NULL},S_TBALLX2},  // S_TBALLX1
  {SPR_BAL1,3|FF_FULLBRIGHT,6,{NULL},S_TBALLX3},  // S_TBALLX2
  {SPR_BAL1,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_TBALLX3
  {SPR_BAL2,0|FF_FULLBRIGHT,4,{NULL},S_RBALL2}, // S_RBALL1
  {SPR_BAL2,1|FF_FULLBRIGHT,4,{NULL},S_RBALL1}, // S_RBALL2
  {SPR_BAL2,2|FF_FULLBRIGHT,6,{NULL},S_RBALLX2},  // S_RBALLX1
  {SPR_BAL2,3|FF_FULLBRIGHT,6,{NULL},S_RBALLX3},  // S_RBALLX2
  {SPR_BAL2,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_RBALLX3
  {SPR_PLSS,0|FF_FULLBRIGHT,6,{NULL},S_PLASBALL2},  // S_PLASBALL
  {SPR_PLSS,1|FF_FULLBRIGHT,6,{NULL},S_PLASBALL}, // S_PLASBALL2
  {SPR_PLSE,0|FF_FULLBRIGHT,4,{NULL},S_PLASEXP2}, // S_PLASEXP
  {SPR_PLSE,1|FF_FULLBRIGHT,4,{NULL},S_PLASEXP3}, // S_PLASEXP2
  {SPR_PLSE,2|FF_FULLBRIGHT,4,{NULL},S_PLASEXP4}, // S_PLASEXP3
  {SPR_PLSE,3|FF_FULLBRIGHT,4,{NULL},S_PLASEXP5}, // S_PLASEXP4
  {SPR_PLSE,4|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_PLASEXP5
  {SPR_MISL,0|FF_FULLBRIGHT,1,{NULL},S_ROCKET}, // S_ROCKET
  {SPR_BFS1,0|FF_FULLBRIGHT,4,{NULL},S_BFGSHOT2}, // S_BFGSHOT
  {SPR_BFS1,1|FF_FULLBRIGHT,4,{NULL},S_BFGSHOT},  // S_BFGSHOT2
  {SPR_BFE1,0|FF_FULLBRIGHT,8,{NULL},S_BFGLAND2}, // S_BFGLAND
  {SPR_BFE1,1|FF_FULLBRIGHT,8,{NULL},S_BFGLAND3}, // S_BFGLAND2
  {SPR_BFE1,2|FF_FULLBRIGHT,8,{A_BFGSpray},S_BFGLAND4}, // S_BFGLAND3
  {SPR_BFE1,3|FF_FULLBRIGHT,8,{NULL},S_BFGLAND5}, // S_BFGLAND4
  {SPR_BFE1,4|FF_FULLBRIGHT,8,{NULL},S_BFGLAND6}, // S_BFGLAND5
  {SPR_BFE1,5|FF_FULLBRIGHT,8,{NULL},S_NULL}, // S_BFGLAND6
  {SPR_BFE2,0|FF_FULLBRIGHT,8,{NULL},S_BFGEXP2},  // S_BFGEXP
  {SPR_BFE2,1|FF_FULLBRIGHT,8,{NULL},S_BFGEXP3},  // S_BFGEXP2
  {SPR_BFE2,2|FF_FULLBRIGHT,8,{NULL},S_BFGEXP4},  // S_BFGEXP3
  {SPR_BFE2,3|FF_FULLBRIGHT,8,{NULL},S_NULL}, // S_BFGEXP4
  {SPR_MISL,1|FF_FULLBRIGHT,8,{A_Explode},S_EXPLODE2},  // S_EXPLODE1
  {SPR_MISL,2|FF_FULLBRIGHT,6,{NULL},S_EXPLODE3}, // S_EXPLODE2
  {SPR_MISL,3|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_EXPLODE3
  {SPR_TFOG,0|FF_FULLBRIGHT,6,{NULL},S_TFOG01}, // S_TFOG
  {SPR_TFOG,1|FF_FULLBRIGHT,6,{NULL},S_TFOG02}, // S_TFOG01
  {SPR_TFOG,0|FF_FULLBRIGHT,6,{NULL},S_TFOG2},  // S_TFOG02
  {SPR_TFOG,1|FF_FULLBRIGHT,6,{NULL},S_TFOG3},  // S_TFOG2
  {SPR_TFOG,2|FF_FULLBRIGHT,6,{NULL},S_TFOG4},  // S_TFOG3
  {SPR_TFOG,3|FF_FULLBRIGHT,6,{NULL},S_TFOG5},  // S_TFOG4
  {SPR_TFOG,4|FF_FULLBRIGHT,6,{NULL},S_TFOG6},  // S_TFOG5
  {SPR_TFOG,5|FF_FULLBRIGHT,6,{NULL},S_TFOG7},  // S_TFOG6
  {SPR_TFOG,6|FF_FULLBRIGHT,6,{NULL},S_TFOG8},  // S_TFOG7
  {SPR_TFOG,7|FF_FULLBRIGHT,6,{NULL},S_TFOG9},  // S_TFOG8
  {SPR_TFOG,8|FF_FULLBRIGHT,6,{NULL},S_TFOG10}, // S_TFOG9
  {SPR_TFOG,9|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_TFOG10
  {SPR_IFOG,0|FF_FULLBRIGHT,6,{NULL},S_IFOG01}, // S_IFOG
  {SPR_IFOG,1|FF_FULLBRIGHT,6,{NULL},S_IFOG02}, // S_IFOG01
  {SPR_IFOG,0|FF_FULLBRIGHT,6,{NULL},S_IFOG2},  // S_IFOG02
  {SPR_IFOG,1|FF_FULLBRIGHT,6,{NULL},S_IFOG3},  // S_IFOG2
  {SPR_IFOG,2|FF_FULLBRIGHT,6,{NULL},S_IFOG4},  // S_IFOG3
  {SPR_IFOG,3|FF_FULLBRIGHT,6,{NULL},S_IFOG5},  // S_IFOG4
  {SPR_IFOG,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_IFOG5
  {SPR_PLAY,0,-1,{NULL},S_NULL},  // S_PLAY
  {SPR_PLAY,0,4,{NULL},S_PLAY_RUN2},  // S_PLAY_RUN1
  {SPR_PLAY,1,4,{NULL},S_PLAY_RUN3},  // S_PLAY_RUN2
  {SPR_PLAY,2,4,{NULL},S_PLAY_RUN4},  // S_PLAY_RUN3
  {SPR_PLAY,3,4,{NULL},S_PLAY_RUN1},  // S_PLAY_RUN4
  {SPR_PLAY,4,12,{NULL},S_PLAY},  // S_PLAY_ATK1
  {SPR_PLAY,5|FF_FULLBRIGHT,6,{NULL},S_PLAY_ATK1},  // S_PLAY_ATK2
  {SPR_PLAY,6,4,{NULL},S_PLAY_PAIN2}, // S_PLAY_PAIN
  {SPR_PLAY,6,4,{A_Pain},S_PLAY}, // S_PLAY_PAIN2
  {SPR_PLAY,7,10,{NULL},S_PLAY_DIE2}, // S_PLAY_DIE1
  {SPR_PLAY,8,10,{A_PlayerScream},S_PLAY_DIE3}, // S_PLAY_DIE2
  {SPR_PLAY,9,10,{A_Fall},S_PLAY_DIE4}, // S_PLAY_DIE3
  {SPR_PLAY,10,10,{NULL},S_PLAY_DIE5},  // S_PLAY_DIE4
  {SPR_PLAY,11,10,{NULL},S_PLAY_DIE6},  // S_PLAY_DIE5
  {SPR_PLAY,12,10,{NULL},S_PLAY_DIE7},  // S_PLAY_DIE6
  {SPR_PLAY,13,-1,{NULL},S_NULL}, // S_PLAY_DIE7
  {SPR_PLAY,14,5,{NULL},S_PLAY_XDIE2},  // S_PLAY_XDIE1
  {SPR_PLAY,15,5,{A_XScream},S_PLAY_XDIE3}, // S_PLAY_XDIE2
  {SPR_PLAY,16,5,{A_Fall},S_PLAY_XDIE4},  // S_PLAY_XDIE3
  {SPR_PLAY,17,5,{NULL},S_PLAY_XDIE5},  // S_PLAY_XDIE4
  {SPR_PLAY,18,5,{NULL},S_PLAY_XDIE6},  // S_PLAY_XDIE5
  {SPR_PLAY,19,5,{NULL},S_PLAY_XDIE7},  // S_PLAY_XDIE6
  {SPR_PLAY,20,5,{NULL},S_PLAY_XDIE8},  // S_PLAY_XDIE7
  {SPR_PLAY,21,5,{NULL},S_PLAY_XDIE9},  // S_PLAY_XDIE8
  {SPR_PLAY,22,-1,{NULL},S_NULL}, // S_PLAY_XDIE9
  {SPR_POSS,0,10,{A_Look},S_POSS_STND2},  // S_POSS_STND
  {SPR_POSS,1,10,{A_Look},S_POSS_STND}, // S_POSS_STND2
  {SPR_POSS,0,4,{A_Chase},S_POSS_RUN2}, // S_POSS_RUN1
  {SPR_POSS,0,4,{A_Chase},S_POSS_RUN3}, // S_POSS_RUN2
  {SPR_POSS,1,4,{A_Chase},S_POSS_RUN4}, // S_POSS_RUN3
  {SPR_POSS,1,4,{A_Chase},S_POSS_RUN5}, // S_POSS_RUN4
  {SPR_POSS,2,4,{A_Chase},S_POSS_RUN6}, // S_POSS_RUN5
  {SPR_POSS,2,4,{A_Chase},S_POSS_RUN7}, // S_POSS_RUN6
  {SPR_POSS,3,4,{A_Chase},S_POSS_RUN8}, // S_POSS_RUN7
  {SPR_POSS,3,4,{A_Chase},S_POSS_RUN1}, // S_POSS_RUN8
  {SPR_POSS,4,10,{A_FaceTarget},S_POSS_ATK2}, // S_POSS_ATK1
  {SPR_POSS,5,8,{A_PosAttack},S_POSS_ATK3}, // S_POSS_ATK2
  {SPR_POSS,4,8,{NULL},S_POSS_RUN1},  // S_POSS_ATK3
  {SPR_POSS,6,3,{NULL},S_POSS_PAIN2}, // S_POSS_PAIN
  {SPR_POSS,6,3,{A_Pain},S_POSS_RUN1},  // S_POSS_PAIN2
  {SPR_POSS,7,5,{NULL},S_POSS_DIE2},  // S_POSS_DIE1
  {SPR_POSS,8,5,{A_Scream},S_POSS_DIE3},  // S_POSS_DIE2
  {SPR_POSS,9,5,{A_Fall},S_POSS_DIE4},  // S_POSS_DIE3
  {SPR_POSS,10,5,{NULL},S_POSS_DIE5}, // S_POSS_DIE4
  {SPR_POSS,11,-1,{NULL},S_NULL}, // S_POSS_DIE5
  {SPR_POSS,12,5,{NULL},S_POSS_XDIE2},  // S_POSS_XDIE1
  {SPR_POSS,13,5,{A_XScream},S_POSS_XDIE3}, // S_POSS_XDIE2
  {SPR_POSS,14,5,{A_Fall},S_POSS_XDIE4},  // S_POSS_XDIE3
  {SPR_POSS,15,5,{NULL},S_POSS_XDIE5},  // S_POSS_XDIE4
  {SPR_POSS,16,5,{NULL},S_POSS_XDIE6},  // S_POSS_XDIE5
  {SPR_POSS,17,5,{NULL},S_POSS_XDIE7},  // S_POSS_XDIE6
  {SPR_POSS,18,5,{NULL},S_POSS_XDIE8},  // S_POSS_XDIE7
  {SPR_POSS,19,5,{NULL},S_POSS_XDIE9},  // S_POSS_XDIE8
  {SPR_POSS,20,-1,{NULL},S_NULL}, // S_POSS_XDIE9
  {SPR_POSS,10,5,{NULL},S_POSS_RAISE2}, // S_POSS_RAISE1
  {SPR_POSS,9,5,{NULL},S_POSS_RAISE3},  // S_POSS_RAISE2
  {SPR_POSS,8,5,{NULL},S_POSS_RAISE4},  // S_POSS_RAISE3
  {SPR_POSS,7,5,{NULL},S_POSS_RUN1},  // S_POSS_RAISE4
  {SPR_SPOS,0,10,{A_Look},S_SPOS_STND2},  // S_SPOS_STND
  {SPR_SPOS,1,10,{A_Look},S_SPOS_STND}, // S_SPOS_STND2
  {SPR_SPOS,0,3,{A_Chase},S_SPOS_RUN2}, // S_SPOS_RUN1
  {SPR_SPOS,0,3,{A_Chase},S_SPOS_RUN3}, // S_SPOS_RUN2
  {SPR_SPOS,1,3,{A_Chase},S_SPOS_RUN4}, // S_SPOS_RUN3
  {SPR_SPOS,1,3,{A_Chase},S_SPOS_RUN5}, // S_SPOS_RUN4
  {SPR_SPOS,2,3,{A_Chase},S_SPOS_RUN6}, // S_SPOS_RUN5
  {SPR_SPOS,2,3,{A_Chase},S_SPOS_RUN7}, // S_SPOS_RUN6
  {SPR_SPOS,3,3,{A_Chase},S_SPOS_RUN8}, // S_SPOS_RUN7
  {SPR_SPOS,3,3,{A_Chase},S_SPOS_RUN1}, // S_SPOS_RUN8
  {SPR_SPOS,4,10,{A_FaceTarget},S_SPOS_ATK2}, // S_SPOS_ATK1
  {SPR_SPOS,5|FF_FULLBRIGHT,10,{A_SPosAttack},S_SPOS_ATK3}, // S_SPOS_ATK2
  {SPR_SPOS,4,10,{NULL},S_SPOS_RUN1}, // S_SPOS_ATK3
  {SPR_SPOS,6,3,{NULL},S_SPOS_PAIN2}, // S_SPOS_PAIN
  {SPR_SPOS,6,3,{A_Pain},S_SPOS_RUN1},  // S_SPOS_PAIN2
  {SPR_SPOS,7,5,{NULL},S_SPOS_DIE2},  // S_SPOS_DIE1
  {SPR_SPOS,8,5,{A_Scream},S_SPOS_DIE3},  // S_SPOS_DIE2
  {SPR_SPOS,9,5,{A_Fall},S_SPOS_DIE4},  // S_SPOS_DIE3
  {SPR_SPOS,10,5,{NULL},S_SPOS_DIE5}, // S_SPOS_DIE4
  {SPR_SPOS,11,-1,{NULL},S_NULL}, // S_SPOS_DIE5
  {SPR_SPOS,12,5,{NULL},S_SPOS_XDIE2},  // S_SPOS_XDIE1
  {SPR_SPOS,13,5,{A_XScream},S_SPOS_XDIE3}, // S_SPOS_XDIE2
  {SPR_SPOS,14,5,{A_Fall},S_SPOS_XDIE4},  // S_SPOS_XDIE3
  {SPR_SPOS,15,5,{NULL},S_SPOS_XDIE5},  // S_SPOS_XDIE4
  {SPR_SPOS,16,5,{NULL},S_SPOS_XDIE6},  // S_SPOS_XDIE5
  {SPR_SPOS,17,5,{NULL},S_SPOS_XDIE7},  // S_SPOS_XDIE6
  {SPR_SPOS,18,5,{NULL},S_SPOS_XDIE8},  // S_SPOS_XDIE7
  {SPR_SPOS,19,5,{NULL},S_SPOS_XDIE9},  // S_SPOS_XDIE8
  {SPR_SPOS,20,-1,{NULL},S_NULL}, // S_SPOS_XDIE9
  {SPR_SPOS,11,5,{NULL},S_SPOS_RAISE2}, // S_SPOS_RAISE1
  {SPR_SPOS,10,5,{NULL},S_SPOS_RAISE3}, // S_SPOS_RAISE2
  {SPR_SPOS,9,5,{NULL},S_SPOS_RAISE4},  // S_SPOS_RAISE3
  {SPR_SPOS,8,5,{NULL},S_SPOS_RAISE5},  // S_SPOS_RAISE4
  {SPR_SPOS,7,5,{NULL},S_SPOS_RUN1},  // S_SPOS_RAISE5
  {SPR_VILE,0,10,{A_Look},S_VILE_STND2},  // S_VILE_STND
  {SPR_VILE,1,10,{A_Look},S_VILE_STND}, // S_VILE_STND2
  {SPR_VILE,0,2,{A_VileChase},S_VILE_RUN2}, // S_VILE_RUN1
  {SPR_VILE,0,2,{A_VileChase},S_VILE_RUN3}, // S_VILE_RUN2
  {SPR_VILE,1,2,{A_VileChase},S_VILE_RUN4}, // S_VILE_RUN3
  {SPR_VILE,1,2,{A_VileChase},S_VILE_RUN5}, // S_VILE_RUN4
  {SPR_VILE,2,2,{A_VileChase},S_VILE_RUN6}, // S_VILE_RUN5
  {SPR_VILE,2,2,{A_VileChase},S_VILE_RUN7}, // S_VILE_RUN6
  {SPR_VILE,3,2,{A_VileChase},S_VILE_RUN8}, // S_VILE_RUN7
  {SPR_VILE,3,2,{A_VileChase},S_VILE_RUN9}, // S_VILE_RUN8
  {SPR_VILE,4,2,{A_VileChase},S_VILE_RUN10},  // S_VILE_RUN9
  {SPR_VILE,4,2,{A_VileChase},S_VILE_RUN11},  // S_VILE_RUN10
  {SPR_VILE,5,2,{A_VileChase},S_VILE_RUN12},  // S_VILE_RUN11
  {SPR_VILE,5,2,{A_VileChase},S_VILE_RUN1}, // S_VILE_RUN12
  {SPR_VILE,6|FF_FULLBRIGHT,0,{A_VileStart},S_VILE_ATK2}, // S_VILE_ATK1
  {SPR_VILE,6|FF_FULLBRIGHT,10,{A_FaceTarget},S_VILE_ATK3}, // S_VILE_ATK2
  {SPR_VILE,7|FF_FULLBRIGHT,8,{A_VileTarget},S_VILE_ATK4},  // S_VILE_ATK3
  {SPR_VILE,8|FF_FULLBRIGHT,8,{A_FaceTarget},S_VILE_ATK5},  // S_VILE_ATK4
  {SPR_VILE,9|FF_FULLBRIGHT,8,{A_FaceTarget},S_VILE_ATK6},  // S_VILE_ATK5
  {SPR_VILE,10|FF_FULLBRIGHT,8,{A_FaceTarget},S_VILE_ATK7},  // S_VILE_ATK6
  {SPR_VILE,11|FF_FULLBRIGHT,8,{A_FaceTarget},S_VILE_ATK8},  // S_VILE_ATK7
  {SPR_VILE,12|FF_FULLBRIGHT,8,{A_FaceTarget},S_VILE_ATK9},  // S_VILE_ATK8
  {SPR_VILE,13|FF_FULLBRIGHT,8,{A_FaceTarget},S_VILE_ATK10}, // S_VILE_ATK9
  {SPR_VILE,14|FF_FULLBRIGHT,8,{A_VileAttack},S_VILE_ATK11}, // S_VILE_ATK10
  {SPR_VILE,15|FF_FULLBRIGHT,20,{NULL},S_VILE_RUN1}, // S_VILE_ATK11
  {SPR_VILE,26|FF_FULLBRIGHT,10,{NULL},S_VILE_HEAL2},  // S_VILE_HEAL1
  {SPR_VILE,27|FF_FULLBRIGHT,10,{NULL},S_VILE_HEAL3},  // S_VILE_HEAL2
  {SPR_VILE,28|FF_FULLBRIGHT,10,{NULL},S_VILE_RUN1}, // S_VILE_HEAL3
  {SPR_VILE,16,5,{NULL},S_VILE_PAIN2},  // S_VILE_PAIN
  {SPR_VILE,16,5,{A_Pain},S_VILE_RUN1}, // S_VILE_PAIN2
  {SPR_VILE,16,7,{NULL},S_VILE_DIE2}, // S_VILE_DIE1
  {SPR_VILE,17,7,{A_Scream},S_VILE_DIE3},  // S_VILE_DIE2
  {SPR_VILE,18,7,{A_Fall},S_VILE_DIE4}, // S_VILE_DIE3
  {SPR_VILE,19,7,{NULL},S_VILE_DIE5}, // S_VILE_DIE4
  {SPR_VILE,20,7,{NULL},S_VILE_DIE6}, // S_VILE_DIE5
  {SPR_VILE,21,7,{NULL},S_VILE_DIE7}, // S_VILE_DIE6
  {SPR_VILE,22,7,{NULL},S_VILE_DIE8}, // S_VILE_DIE7
  {SPR_VILE,23,5,{NULL},S_VILE_DIE9}, // S_VILE_DIE8
  {SPR_VILE,24,5,{NULL},S_VILE_DIE10},  // S_VILE_DIE9
  {SPR_VILE,25,-1,{NULL},S_NULL}, // S_VILE_DIE10
  {SPR_FIRE,0|FF_FULLBRIGHT,2,{A_StartFire},S_FIRE2}, // S_FIRE1
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{A_Fire},S_FIRE3},  // S_FIRE2
  {SPR_FIRE,0|FF_FULLBRIGHT,2,{A_Fire},S_FIRE4},  // S_FIRE3
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{A_Fire},S_FIRE5},  // S_FIRE4
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{A_FireCrackle},S_FIRE6}, // S_FIRE5
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{A_Fire},S_FIRE7},  // S_FIRE6
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{A_Fire},S_FIRE8},  // S_FIRE7
  {SPR_FIRE,1|FF_FULLBRIGHT,2,{A_Fire},S_FIRE9},  // S_FIRE8
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{A_Fire},S_FIRE10}, // S_FIRE9
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{A_Fire},S_FIRE11}, // S_FIRE10
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{A_Fire},S_FIRE12}, // S_FIRE11
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{A_Fire},S_FIRE13}, // S_FIRE12
  {SPR_FIRE,2|FF_FULLBRIGHT,2,{A_Fire},S_FIRE14}, // S_FIRE13
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{A_Fire},S_FIRE15}, // S_FIRE14
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{A_Fire},S_FIRE16}, // S_FIRE15
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{A_Fire},S_FIRE17}, // S_FIRE16
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{A_Fire},S_FIRE18}, // S_FIRE17
  {SPR_FIRE,3|FF_FULLBRIGHT,2,{A_Fire},S_FIRE19}, // S_FIRE18
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{A_FireCrackle},S_FIRE20},  // S_FIRE19
  {SPR_FIRE,5|FF_FULLBRIGHT,2,{A_Fire},S_FIRE21}, // S_FIRE20
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{A_Fire},S_FIRE22}, // S_FIRE21
  {SPR_FIRE,5|FF_FULLBRIGHT,2,{A_Fire},S_FIRE23}, // S_FIRE22
  {SPR_FIRE,4|FF_FULLBRIGHT,2,{A_Fire},S_FIRE24}, // S_FIRE23
  {SPR_FIRE,5|FF_FULLBRIGHT,2,{A_Fire},S_FIRE25}, // S_FIRE24
  {SPR_FIRE,6|FF_FULLBRIGHT,2,{A_Fire},S_FIRE26}, // S_FIRE25
  {SPR_FIRE,7|FF_FULLBRIGHT,2,{A_Fire},S_FIRE27}, // S_FIRE26
  {SPR_FIRE,6|FF_FULLBRIGHT,2,{A_Fire},S_FIRE28}, // S_FIRE27
  {SPR_FIRE,7|FF_FULLBRIGHT,2,{A_Fire},S_FIRE29}, // S_FIRE28
  {SPR_FIRE,6|FF_FULLBRIGHT,2,{A_Fire},S_FIRE30}, // S_FIRE29
  {SPR_FIRE,7|FF_FULLBRIGHT,2,{A_Fire},S_NULL}, // S_FIRE30
  {SPR_PUFF,1,4,{NULL},S_SMOKE2}, // S_SMOKE1
  {SPR_PUFF,2,4,{NULL},S_SMOKE3}, // S_SMOKE2
  {SPR_PUFF,1,4,{NULL},S_SMOKE4}, // S_SMOKE3
  {SPR_PUFF,2,4,{NULL},S_SMOKE5}, // S_SMOKE4
  {SPR_PUFF,3,4,{NULL},S_NULL}, // S_SMOKE5
  {SPR_FATB,0|FF_FULLBRIGHT,2,{A_Tracer},S_TRACER2},  // S_TRACER
  {SPR_FATB,1|FF_FULLBRIGHT,2,{A_Tracer},S_TRACER}, // S_TRACER2
  {SPR_FBXP,0|FF_FULLBRIGHT,8,{NULL},S_TRACEEXP2},  // S_TRACEEXP1
  {SPR_FBXP,1|FF_FULLBRIGHT,6,{NULL},S_TRACEEXP3},  // S_TRACEEXP2
  {SPR_FBXP,2|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_TRACEEXP3
  {SPR_SKEL,0,10,{A_Look},S_SKEL_STND2},  // S_SKEL_STND
  {SPR_SKEL,1,10,{A_Look},S_SKEL_STND}, // S_SKEL_STND2
  {SPR_SKEL,0,2,{A_Chase},S_SKEL_RUN2}, // S_SKEL_RUN1
  {SPR_SKEL,0,2,{A_Chase},S_SKEL_RUN3}, // S_SKEL_RUN2
  {SPR_SKEL,1,2,{A_Chase},S_SKEL_RUN4}, // S_SKEL_RUN3
  {SPR_SKEL,1,2,{A_Chase},S_SKEL_RUN5}, // S_SKEL_RUN4
  {SPR_SKEL,2,2,{A_Chase},S_SKEL_RUN6}, // S_SKEL_RUN5
  {SPR_SKEL,2,2,{A_Chase},S_SKEL_RUN7}, // S_SKEL_RUN6
  {SPR_SKEL,3,2,{A_Chase},S_SKEL_RUN8}, // S_SKEL_RUN7
  {SPR_SKEL,3,2,{A_Chase},S_SKEL_RUN9}, // S_SKEL_RUN8
  {SPR_SKEL,4,2,{A_Chase},S_SKEL_RUN10},  // S_SKEL_RUN9
  {SPR_SKEL,4,2,{A_Chase},S_SKEL_RUN11},  // S_SKEL_RUN10
  {SPR_SKEL,5,2,{A_Chase},S_SKEL_RUN12},  // S_SKEL_RUN11
  {SPR_SKEL,5,2,{A_Chase},S_SKEL_RUN1}, // S_SKEL_RUN12
  {SPR_SKEL,6,0,{A_FaceTarget},S_SKEL_FIST2}, // S_SKEL_FIST1
  {SPR_SKEL,6,6,{A_SkelWhoosh},S_SKEL_FIST3}, // S_SKEL_FIST2
  {SPR_SKEL,7,6,{A_FaceTarget},S_SKEL_FIST4}, // S_SKEL_FIST3
  {SPR_SKEL,8,6,{A_SkelFist},S_SKEL_RUN1},  // S_SKEL_FIST4
  {SPR_SKEL,9|FF_FULLBRIGHT,0,{A_FaceTarget},S_SKEL_MISS2}, // S_SKEL_MISS1
  {SPR_SKEL,9|FF_FULLBRIGHT,10,{A_FaceTarget},S_SKEL_MISS3},  // S_SKEL_MISS2
  {SPR_SKEL,10,10,{A_SkelMissile},S_SKEL_MISS4},  // S_SKEL_MISS3
  {SPR_SKEL,10,10,{A_FaceTarget},S_SKEL_RUN1},  // S_SKEL_MISS4
  {SPR_SKEL,11,5,{NULL},S_SKEL_PAIN2},  // S_SKEL_PAIN
  {SPR_SKEL,11,5,{A_Pain},S_SKEL_RUN1}, // S_SKEL_PAIN2
  {SPR_SKEL,11,7,{NULL},S_SKEL_DIE2}, // S_SKEL_DIE1
  {SPR_SKEL,12,7,{NULL},S_SKEL_DIE3}, // S_SKEL_DIE2
  {SPR_SKEL,13,7,{A_Scream},S_SKEL_DIE4}, // S_SKEL_DIE3
  {SPR_SKEL,14,7,{A_Fall},S_SKEL_DIE5}, // S_SKEL_DIE4
  {SPR_SKEL,15,7,{NULL},S_SKEL_DIE6}, // S_SKEL_DIE5
  {SPR_SKEL,16,-1,{NULL},S_NULL}, // S_SKEL_DIE6
  {SPR_SKEL,16,5,{NULL},S_SKEL_RAISE2}, // S_SKEL_RAISE1
  {SPR_SKEL,15,5,{NULL},S_SKEL_RAISE3}, // S_SKEL_RAISE2
  {SPR_SKEL,14,5,{NULL},S_SKEL_RAISE4}, // S_SKEL_RAISE3
  {SPR_SKEL,13,5,{NULL},S_SKEL_RAISE5}, // S_SKEL_RAISE4
  {SPR_SKEL,12,5,{NULL},S_SKEL_RAISE6}, // S_SKEL_RAISE5
  {SPR_SKEL,11,5,{NULL},S_SKEL_RUN1}, // S_SKEL_RAISE6
  {SPR_MANF,0|FF_FULLBRIGHT,4,{NULL},S_FATSHOT2}, // S_FATSHOT1
  {SPR_MANF,1|FF_FULLBRIGHT,4,{NULL},S_FATSHOT1}, // S_FATSHOT2
  {SPR_MISL,1|FF_FULLBRIGHT,8,{NULL},S_FATSHOTX2},  // S_FATSHOTX1
  {SPR_MISL,2|FF_FULLBRIGHT,6,{NULL},S_FATSHOTX3},  // S_FATSHOTX2
  {SPR_MISL,3|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_FATSHOTX3
  {SPR_FATT,0,15,{A_Look},S_FATT_STND2},  // S_FATT_STND
  {SPR_FATT,1,15,{A_Look},S_FATT_STND}, // S_FATT_STND2
  {SPR_FATT,0,4,{A_Chase},S_FATT_RUN2}, // S_FATT_RUN1
  {SPR_FATT,0,4,{A_Chase},S_FATT_RUN3}, // S_FATT_RUN2
  {SPR_FATT,1,4,{A_Chase},S_FATT_RUN4}, // S_FATT_RUN3
  {SPR_FATT,1,4,{A_Chase},S_FATT_RUN5}, // S_FATT_RUN4
  {SPR_FATT,2,4,{A_Chase},S_FATT_RUN6}, // S_FATT_RUN5
  {SPR_FATT,2,4,{A_Chase},S_FATT_RUN7}, // S_FATT_RUN6
  {SPR_FATT,3,4,{A_Chase},S_FATT_RUN8}, // S_FATT_RUN7
  {SPR_FATT,3,4,{A_Chase},S_FATT_RUN9}, // S_FATT_RUN8
  {SPR_FATT,4,4,{A_Chase},S_FATT_RUN10},  // S_FATT_RUN9
  {SPR_FATT,4,4,{A_Chase},S_FATT_RUN11},  // S_FATT_RUN10
  {SPR_FATT,5,4,{A_Chase},S_FATT_RUN12},  // S_FATT_RUN11
  {SPR_FATT,5,4,{A_Chase},S_FATT_RUN1}, // S_FATT_RUN12
  {SPR_FATT,6,20,{A_FatRaise},S_FATT_ATK2}, // S_FATT_ATK1
  {SPR_FATT,7|FF_FULLBRIGHT,10,{A_FatAttack1},S_FATT_ATK3}, // S_FATT_ATK2
  {SPR_FATT,8,5,{A_FaceTarget},S_FATT_ATK4},  // S_FATT_ATK3
  {SPR_FATT,6,5,{A_FaceTarget},S_FATT_ATK5},  // S_FATT_ATK4
  {SPR_FATT,7|FF_FULLBRIGHT,10,{A_FatAttack2},S_FATT_ATK6}, // S_FATT_ATK5
  {SPR_FATT,8,5,{A_FaceTarget},S_FATT_ATK7},  // S_FATT_ATK6
  {SPR_FATT,6,5,{A_FaceTarget},S_FATT_ATK8},  // S_FATT_ATK7
  {SPR_FATT,7|FF_FULLBRIGHT,10,{A_FatAttack3},S_FATT_ATK9}, // S_FATT_ATK8
  {SPR_FATT,8,5,{A_FaceTarget},S_FATT_ATK10}, // S_FATT_ATK9
  {SPR_FATT,6,5,{A_FaceTarget},S_FATT_RUN1},  // S_FATT_ATK10
  {SPR_FATT,9,3,{NULL},S_FATT_PAIN2}, // S_FATT_PAIN
  {SPR_FATT,9,3,{A_Pain},S_FATT_RUN1},  // S_FATT_PAIN2
  {SPR_FATT,10,6,{NULL},S_FATT_DIE2}, // S_FATT_DIE1
  {SPR_FATT,11,6,{A_Scream},S_FATT_DIE3}, // S_FATT_DIE2
  {SPR_FATT,12,6,{A_Fall},S_FATT_DIE4}, // S_FATT_DIE3
  {SPR_FATT,13,6,{NULL},S_FATT_DIE5}, // S_FATT_DIE4
  {SPR_FATT,14,6,{NULL},S_FATT_DIE6}, // S_FATT_DIE5
  {SPR_FATT,15,6,{NULL},S_FATT_DIE7}, // S_FATT_DIE6
  {SPR_FATT,16,6,{NULL},S_FATT_DIE8}, // S_FATT_DIE7
  {SPR_FATT,17,6,{NULL},S_FATT_DIE9}, // S_FATT_DIE8
  {SPR_FATT,18,6,{NULL},S_FATT_DIE10},  // S_FATT_DIE9
  {SPR_FATT,19,-1,{A_BossDeath},S_NULL},  // S_FATT_DIE10
  {SPR_FATT,17,5,{NULL},S_FATT_RAISE2}, // S_FATT_RAISE1
  {SPR_FATT,16,5,{NULL},S_FATT_RAISE3}, // S_FATT_RAISE2
  {SPR_FATT,15,5,{NULL},S_FATT_RAISE4}, // S_FATT_RAISE3
  {SPR_FATT,14,5,{NULL},S_FATT_RAISE5}, // S_FATT_RAISE4
  {SPR_FATT,13,5,{NULL},S_FATT_RAISE6}, // S_FATT_RAISE5
  {SPR_FATT,12,5,{NULL},S_FATT_RAISE7}, // S_FATT_RAISE6
  {SPR_FATT,11,5,{NULL},S_FATT_RAISE8}, // S_FATT_RAISE7
  {SPR_FATT,10,5,{NULL},S_FATT_RUN1}, // S_FATT_RAISE8
  {SPR_CPOS,0,10,{A_Look},S_CPOS_STND2},  // S_CPOS_STND
  {SPR_CPOS,1,10,{A_Look},S_CPOS_STND}, // S_CPOS_STND2
  {SPR_CPOS,0,3,{A_Chase},S_CPOS_RUN2}, // S_CPOS_RUN1
  {SPR_CPOS,0,3,{A_Chase},S_CPOS_RUN3}, // S_CPOS_RUN2
  {SPR_CPOS,1,3,{A_Chase},S_CPOS_RUN4}, // S_CPOS_RUN3
  {SPR_CPOS,1,3,{A_Chase},S_CPOS_RUN5}, // S_CPOS_RUN4
  {SPR_CPOS,2,3,{A_Chase},S_CPOS_RUN6}, // S_CPOS_RUN5
  {SPR_CPOS,2,3,{A_Chase},S_CPOS_RUN7}, // S_CPOS_RUN6
  {SPR_CPOS,3,3,{A_Chase},S_CPOS_RUN8}, // S_CPOS_RUN7
  {SPR_CPOS,3,3,{A_Chase},S_CPOS_RUN1}, // S_CPOS_RUN8
  {SPR_CPOS,4,10,{A_FaceTarget},S_CPOS_ATK2}, // S_CPOS_ATK1
  {SPR_CPOS,5|FF_FULLBRIGHT,4,{A_CPosAttack},S_CPOS_ATK3},  // S_CPOS_ATK2
  {SPR_CPOS,4|FF_FULLBRIGHT,4,{A_CPosAttack},S_CPOS_ATK4},  // S_CPOS_ATK3
  {SPR_CPOS,5,1,{A_CPosRefire},S_CPOS_ATK2},  // S_CPOS_ATK4
  {SPR_CPOS,6,3,{NULL},S_CPOS_PAIN2}, // S_CPOS_PAIN
  {SPR_CPOS,6,3,{A_Pain},S_CPOS_RUN1},  // S_CPOS_PAIN2
  {SPR_CPOS,7,5,{NULL},S_CPOS_DIE2},  // S_CPOS_DIE1
  {SPR_CPOS,8,5,{A_Scream},S_CPOS_DIE3},  // S_CPOS_DIE2
  {SPR_CPOS,9,5,{A_Fall},S_CPOS_DIE4},  // S_CPOS_DIE3
  {SPR_CPOS,10,5,{NULL},S_CPOS_DIE5}, // S_CPOS_DIE4
  {SPR_CPOS,11,5,{NULL},S_CPOS_DIE6}, // S_CPOS_DIE5
  {SPR_CPOS,12,5,{NULL},S_CPOS_DIE7}, // S_CPOS_DIE6
  {SPR_CPOS,13,-1,{NULL},S_NULL}, // S_CPOS_DIE7
  {SPR_CPOS,14,5,{NULL},S_CPOS_XDIE2},  // S_CPOS_XDIE1
  {SPR_CPOS,15,5,{A_XScream},S_CPOS_XDIE3}, // S_CPOS_XDIE2
  {SPR_CPOS,16,5,{A_Fall},S_CPOS_XDIE4},  // S_CPOS_XDIE3
  {SPR_CPOS,17,5,{NULL},S_CPOS_XDIE5},  // S_CPOS_XDIE4
  {SPR_CPOS,18,5,{NULL},S_CPOS_XDIE6},  // S_CPOS_XDIE5
  {SPR_CPOS,19,-1,{NULL},S_NULL}, // S_CPOS_XDIE6
  {SPR_CPOS,13,5,{NULL},S_CPOS_RAISE2}, // S_CPOS_RAISE1
  {SPR_CPOS,12,5,{NULL},S_CPOS_RAISE3}, // S_CPOS_RAISE2
  {SPR_CPOS,11,5,{NULL},S_CPOS_RAISE4}, // S_CPOS_RAISE3
  {SPR_CPOS,10,5,{NULL},S_CPOS_RAISE5}, // S_CPOS_RAISE4
  {SPR_CPOS,9,5,{NULL},S_CPOS_RAISE6},  // S_CPOS_RAISE5
  {SPR_CPOS,8,5,{NULL},S_CPOS_RAISE7},  // S_CPOS_RAISE6
  {SPR_CPOS,7,5,{NULL},S_CPOS_RUN1},  // S_CPOS_RAISE7
  {SPR_TROO,0,10,{A_Look},S_TROO_STND2},  // S_TROO_STND
  {SPR_TROO,1,10,{A_Look},S_TROO_STND}, // S_TROO_STND2
  {SPR_TROO,0,3,{A_Chase},S_TROO_RUN2}, // S_TROO_RUN1
  {SPR_TROO,0,3,{A_Chase},S_TROO_RUN3}, // S_TROO_RUN2
  {SPR_TROO,1,3,{A_Chase},S_TROO_RUN4}, // S_TROO_RUN3
  {SPR_TROO,1,3,{A_Chase},S_TROO_RUN5}, // S_TROO_RUN4
  {SPR_TROO,2,3,{A_Chase},S_TROO_RUN6}, // S_TROO_RUN5
  {SPR_TROO,2,3,{A_Chase},S_TROO_RUN7}, // S_TROO_RUN6
  {SPR_TROO,3,3,{A_Chase},S_TROO_RUN8}, // S_TROO_RUN7
  {SPR_TROO,3,3,{A_Chase},S_TROO_RUN1}, // S_TROO_RUN8
  {SPR_TROO,4,8,{A_FaceTarget},S_TROO_ATK2},  // S_TROO_ATK1
  {SPR_TROO,5,8,{A_FaceTarget},S_TROO_ATK3},  // S_TROO_ATK2
  {SPR_TROO,6,6,{A_TroopAttack},S_TROO_RUN1}, // S_TROO_ATK3
  {SPR_TROO,7,2,{NULL},S_TROO_PAIN2}, // S_TROO_PAIN
  {SPR_TROO,7,2,{A_Pain},S_TROO_RUN1},  // S_TROO_PAIN2
  {SPR_TROO,8,8,{NULL},S_TROO_DIE2},  // S_TROO_DIE1
  {SPR_TROO,9,8,{A_Scream},S_TROO_DIE3},  // S_TROO_DIE2
  {SPR_TROO,10,6,{NULL},S_TROO_DIE4}, // S_TROO_DIE3
  {SPR_TROO,11,6,{A_Fall},S_TROO_DIE5}, // S_TROO_DIE4
  {SPR_TROO,12,-1,{NULL},S_NULL}, // S_TROO_DIE5
  {SPR_TROO,13,5,{NULL},S_TROO_XDIE2},  // S_TROO_XDIE1
  {SPR_TROO,14,5,{A_XScream},S_TROO_XDIE3}, // S_TROO_XDIE2
  {SPR_TROO,15,5,{NULL},S_TROO_XDIE4},  // S_TROO_XDIE3
  {SPR_TROO,16,5,{A_Fall},S_TROO_XDIE5},  // S_TROO_XDIE4
  {SPR_TROO,17,5,{NULL},S_TROO_XDIE6},  // S_TROO_XDIE5
  {SPR_TROO,18,5,{NULL},S_TROO_XDIE7},  // S_TROO_XDIE6
  {SPR_TROO,19,5,{NULL},S_TROO_XDIE8},  // S_TROO_XDIE7
  {SPR_TROO,20,-1,{NULL},S_NULL}, // S_TROO_XDIE8
  {SPR_TROO,12,8,{NULL},S_TROO_RAISE2}, // S_TROO_RAISE1
  {SPR_TROO,11,8,{NULL},S_TROO_RAISE3}, // S_TROO_RAISE2
  {SPR_TROO,10,6,{NULL},S_TROO_RAISE4}, // S_TROO_RAISE3
  {SPR_TROO,9,6,{NULL},S_TROO_RAISE5},  // S_TROO_RAISE4
  {SPR_TROO,8,6,{NULL},S_TROO_RUN1},  // S_TROO_RAISE5
  {SPR_SARG,0,10,{A_Look},S_SARG_STND2},  // S_SARG_STND
  {SPR_SARG,1,10,{A_Look},S_SARG_STND}, // S_SARG_STND2
  {SPR_SARG,0,2,{A_Chase},S_SARG_RUN2}, // S_SARG_RUN1
  {SPR_SARG,0,2,{A_Chase},S_SARG_RUN3}, // S_SARG_RUN2
  {SPR_SARG,1,2,{A_Chase},S_SARG_RUN4}, // S_SARG_RUN3
  {SPR_SARG,1,2,{A_Chase},S_SARG_RUN5}, // S_SARG_RUN4
  {SPR_SARG,2,2,{A_Chase},S_SARG_RUN6}, // S_SARG_RUN5
  {SPR_SARG,2,2,{A_Chase},S_SARG_RUN7}, // S_SARG_RUN6
  {SPR_SARG,3,2,{A_Chase},S_SARG_RUN8}, // S_SARG_RUN7
  {SPR_SARG,3,2,{A_Chase},S_SARG_RUN1}, // S_SARG_RUN8
  {SPR_SARG,4,8,{A_FaceTarget},S_SARG_ATK2},  // S_SARG_ATK1
  {SPR_SARG,5,8,{A_FaceTarget},S_SARG_ATK3},  // S_SARG_ATK2
  {SPR_SARG,6,8,{A_SargAttack},S_SARG_RUN1},  // S_SARG_ATK3
  {SPR_SARG,7,2,{NULL},S_SARG_PAIN2}, // S_SARG_PAIN
  {SPR_SARG,7,2,{A_Pain},S_SARG_RUN1},  // S_SARG_PAIN2
  {SPR_SARG,8,8,{NULL},S_SARG_DIE2},  // S_SARG_DIE1
  {SPR_SARG,9,8,{A_Scream},S_SARG_DIE3},  // S_SARG_DIE2
  {SPR_SARG,10,4,{NULL},S_SARG_DIE4}, // S_SARG_DIE3
  {SPR_SARG,11,4,{A_Fall},S_SARG_DIE5}, // S_SARG_DIE4
  {SPR_SARG,12,4,{NULL},S_SARG_DIE6}, // S_SARG_DIE5
  {SPR_SARG,13,-1,{NULL},S_NULL}, // S_SARG_DIE6
  {SPR_SARG,13,5,{NULL},S_SARG_RAISE2}, // S_SARG_RAISE1
  {SPR_SARG,12,5,{NULL},S_SARG_RAISE3}, // S_SARG_RAISE2
  {SPR_SARG,11,5,{NULL},S_SARG_RAISE4}, // S_SARG_RAISE3
  {SPR_SARG,10,5,{NULL},S_SARG_RAISE5}, // S_SARG_RAISE4
  {SPR_SARG,9,5,{NULL},S_SARG_RAISE6},  // S_SARG_RAISE5
  {SPR_SARG,8,5,{NULL},S_SARG_RUN1},  // S_SARG_RAISE6
  {SPR_HEAD,0,10,{A_Look},S_HEAD_STND}, // S_HEAD_STND
  {SPR_HEAD,0,3,{A_Chase},S_HEAD_RUN1}, // S_HEAD_RUN1
  {SPR_HEAD,1,5,{A_FaceTarget},S_HEAD_ATK2},  // S_HEAD_ATK1
  {SPR_HEAD,2,5,{A_FaceTarget},S_HEAD_ATK3},  // S_HEAD_ATK2
  {SPR_HEAD,3|FF_FULLBRIGHT,5,{A_HeadAttack},S_HEAD_RUN1},  // S_HEAD_ATK3
  {SPR_HEAD,4,3,{NULL},S_HEAD_PAIN2}, // S_HEAD_PAIN
  {SPR_HEAD,4,3,{A_Pain},S_HEAD_PAIN3}, // S_HEAD_PAIN2
  {SPR_HEAD,5,6,{NULL},S_HEAD_RUN1},  // S_HEAD_PAIN3
  {SPR_HEAD,6,8,{NULL},S_HEAD_DIE2},  // S_HEAD_DIE1
  {SPR_HEAD,7,8,{A_Scream},S_HEAD_DIE3},  // S_HEAD_DIE2
  {SPR_HEAD,8,8,{NULL},S_HEAD_DIE4},  // S_HEAD_DIE3
  {SPR_HEAD,9,8,{NULL},S_HEAD_DIE5},  // S_HEAD_DIE4
  {SPR_HEAD,10,8,{A_Fall},S_HEAD_DIE6}, // S_HEAD_DIE5
  {SPR_HEAD,11,-1,{NULL},S_NULL}, // S_HEAD_DIE6
  {SPR_HEAD,11,8,{NULL},S_HEAD_RAISE2}, // S_HEAD_RAISE1
  {SPR_HEAD,10,8,{NULL},S_HEAD_RAISE3}, // S_HEAD_RAISE2
  {SPR_HEAD,9,8,{NULL},S_HEAD_RAISE4},  // S_HEAD_RAISE3
  {SPR_HEAD,8,8,{NULL},S_HEAD_RAISE5},  // S_HEAD_RAISE4
  {SPR_HEAD,7,8,{NULL},S_HEAD_RAISE6},  // S_HEAD_RAISE5
  {SPR_HEAD,6,8,{NULL},S_HEAD_RUN1},  // S_HEAD_RAISE6
  {SPR_BAL7,0|FF_FULLBRIGHT,4,{NULL},S_BRBALL2},  // S_BRBALL1
  {SPR_BAL7,1|FF_FULLBRIGHT,4,{NULL},S_BRBALL1},  // S_BRBALL2
  {SPR_BAL7,2|FF_FULLBRIGHT,6,{NULL},S_BRBALLX2}, // S_BRBALLX1
  {SPR_BAL7,3|FF_FULLBRIGHT,6,{NULL},S_BRBALLX3}, // S_BRBALLX2
  {SPR_BAL7,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_BRBALLX3
  {SPR_BOSS,0,10,{A_Look},S_BOSS_STND2},  // S_BOSS_STND
  {SPR_BOSS,1,10,{A_Look},S_BOSS_STND}, // S_BOSS_STND2
  {SPR_BOSS,0,3,{A_Chase},S_BOSS_RUN2}, // S_BOSS_RUN1
  {SPR_BOSS,0,3,{A_Chase},S_BOSS_RUN3}, // S_BOSS_RUN2
  {SPR_BOSS,1,3,{A_Chase},S_BOSS_RUN4}, // S_BOSS_RUN3
  {SPR_BOSS,1,3,{A_Chase},S_BOSS_RUN5}, // S_BOSS_RUN4
  {SPR_BOSS,2,3,{A_Chase},S_BOSS_RUN6}, // S_BOSS_RUN5
  {SPR_BOSS,2,3,{A_Chase},S_BOSS_RUN7}, // S_BOSS_RUN6
  {SPR_BOSS,3,3,{A_Chase},S_BOSS_RUN8}, // S_BOSS_RUN7
  {SPR_BOSS,3,3,{A_Chase},S_BOSS_RUN1}, // S_BOSS_RUN8
  {SPR_BOSS,4,8,{A_FaceTarget},S_BOSS_ATK2},  // S_BOSS_ATK1
  {SPR_BOSS,5,8,{A_FaceTarget},S_BOSS_ATK3},  // S_BOSS_ATK2
  {SPR_BOSS,6,8,{A_BruisAttack},S_BOSS_RUN1}, // S_BOSS_ATK3
  {SPR_BOSS,7,2,{NULL},S_BOSS_PAIN2}, // S_BOSS_PAIN
  {SPR_BOSS,7,2,{A_Pain},S_BOSS_RUN1},  // S_BOSS_PAIN2
  {SPR_BOSS,8,8,{NULL},S_BOSS_DIE2},  // S_BOSS_DIE1
  {SPR_BOSS,9,8,{A_Scream},S_BOSS_DIE3},  // S_BOSS_DIE2
  {SPR_BOSS,10,8,{NULL},S_BOSS_DIE4}, // S_BOSS_DIE3
  {SPR_BOSS,11,8,{A_Fall},S_BOSS_DIE5}, // S_BOSS_DIE4
  {SPR_BOSS,12,8,{NULL},S_BOSS_DIE6}, // S_BOSS_DIE5
  {SPR_BOSS,13,8,{NULL},S_BOSS_DIE7}, // S_BOSS_DIE6
  {SPR_BOSS,14,-1,{A_BossDeath},S_NULL},  // S_BOSS_DIE7
  {SPR_BOSS,14,8,{NULL},S_BOSS_RAISE2}, // S_BOSS_RAISE1
  {SPR_BOSS,13,8,{NULL},S_BOSS_RAISE3}, // S_BOSS_RAISE2
  {SPR_BOSS,12,8,{NULL},S_BOSS_RAISE4}, // S_BOSS_RAISE3
  {SPR_BOSS,11,8,{NULL},S_BOSS_RAISE5}, // S_BOSS_RAISE4
  {SPR_BOSS,10,8,{NULL},S_BOSS_RAISE6}, // S_BOSS_RAISE5
  {SPR_BOSS,9,8,{NULL},S_BOSS_RAISE7},  // S_BOSS_RAISE6
  {SPR_BOSS,8,8,{NULL},S_BOSS_RUN1},  // S_BOSS_RAISE7
  {SPR_BOS2,0,10,{A_Look},S_BOS2_STND2},  // S_BOS2_STND
  {SPR_BOS2,1,10,{A_Look},S_BOS2_STND}, // S_BOS2_STND2
  {SPR_BOS2,0,3,{A_Chase},S_BOS2_RUN2}, // S_BOS2_RUN1
  {SPR_BOS2,0,3,{A_Chase},S_BOS2_RUN3}, // S_BOS2_RUN2
  {SPR_BOS2,1,3,{A_Chase},S_BOS2_RUN4}, // S_BOS2_RUN3
  {SPR_BOS2,1,3,{A_Chase},S_BOS2_RUN5}, // S_BOS2_RUN4
  {SPR_BOS2,2,3,{A_Chase},S_BOS2_RUN6}, // S_BOS2_RUN5
  {SPR_BOS2,2,3,{A_Chase},S_BOS2_RUN7}, // S_BOS2_RUN6
  {SPR_BOS2,3,3,{A_Chase},S_BOS2_RUN8}, // S_BOS2_RUN7
  {SPR_BOS2,3,3,{A_Chase},S_BOS2_RUN1}, // S_BOS2_RUN8
  {SPR_BOS2,4,8,{A_FaceTarget},S_BOS2_ATK2},  // S_BOS2_ATK1
  {SPR_BOS2,5,8,{A_FaceTarget},S_BOS2_ATK3},  // S_BOS2_ATK2
  {SPR_BOS2,6,8,{A_BruisAttack},S_BOS2_RUN1}, // S_BOS2_ATK3
  {SPR_BOS2,7,2,{NULL},S_BOS2_PAIN2}, // S_BOS2_PAIN
  {SPR_BOS2,7,2,{A_Pain},S_BOS2_RUN1},  // S_BOS2_PAIN2
  {SPR_BOS2,8,8,{NULL},S_BOS2_DIE2},  // S_BOS2_DIE1
  {SPR_BOS2,9,8,{A_Scream},S_BOS2_DIE3},  // S_BOS2_DIE2
  {SPR_BOS2,10,8,{NULL},S_BOS2_DIE4}, // S_BOS2_DIE3
  {SPR_BOS2,11,8,{A_Fall},S_BOS2_DIE5}, // S_BOS2_DIE4
  {SPR_BOS2,12,8,{NULL},S_BOS2_DIE6}, // S_BOS2_DIE5
  {SPR_BOS2,13,8,{NULL},S_BOS2_DIE7}, // S_BOS2_DIE6
  {SPR_BOS2,14,-1,{NULL},S_NULL}, // S_BOS2_DIE7
  {SPR_BOS2,14,8,{NULL},S_BOS2_RAISE2}, // S_BOS2_RAISE1
  {SPR_BOS2,13,8,{NULL},S_BOS2_RAISE3}, // S_BOS2_RAISE2
  {SPR_BOS2,12,8,{NULL},S_BOS2_RAISE4}, // S_BOS2_RAISE3
  {SPR_BOS2,11,8,{NULL},S_BOS2_RAISE5}, // S_BOS2_RAISE4
  {SPR_BOS2,10,8,{NULL},S_BOS2_RAISE6}, // S_BOS2_RAISE5
  {SPR_BOS2,9,8,{NULL},S_BOS2_RAISE7},  // S_BOS2_RAISE6
  {SPR_BOS2,8,8,{NULL},S_BOS2_RUN1},  // S_BOS2_RAISE7
  {SPR_SKUL,0|FF_FULLBRIGHT,10,{A_Look},S_SKULL_STND2}, // S_SKULL_STND
  {SPR_SKUL,1|FF_FULLBRIGHT,10,{A_Look},S_SKULL_STND},  // S_SKULL_STND2
  {SPR_SKUL,0|FF_FULLBRIGHT,6,{A_Chase},S_SKULL_RUN2},  // S_SKULL_RUN1
  {SPR_SKUL,1|FF_FULLBRIGHT,6,{A_Chase},S_SKULL_RUN1},  // S_SKULL_RUN2
  {SPR_SKUL,2|FF_FULLBRIGHT,10,{A_FaceTarget},S_SKULL_ATK2},  // S_SKULL_ATK1
  {SPR_SKUL,3|FF_FULLBRIGHT,4,{A_SkullAttack},S_SKULL_ATK3},  // S_SKULL_ATK2
  {SPR_SKUL,2|FF_FULLBRIGHT,4,{NULL},S_SKULL_ATK4}, // S_SKULL_ATK3
  {SPR_SKUL,3|FF_FULLBRIGHT,4,{NULL},S_SKULL_ATK3}, // S_SKULL_ATK4
  {SPR_SKUL,4|FF_FULLBRIGHT,3,{NULL},S_SKULL_PAIN2},  // S_SKULL_PAIN
  {SPR_SKUL,4|FF_FULLBRIGHT,3,{A_Pain},S_SKULL_RUN1}, // S_SKULL_PAIN2
  {SPR_SKUL,5|FF_FULLBRIGHT,6,{NULL},S_SKULL_DIE2}, // S_SKULL_DIE1
  {SPR_SKUL,6|FF_FULLBRIGHT,6,{A_Scream},S_SKULL_DIE3}, // S_SKULL_DIE2
  {SPR_SKUL,7|FF_FULLBRIGHT,6,{NULL},S_SKULL_DIE4}, // S_SKULL_DIE3
  {SPR_SKUL,8|FF_FULLBRIGHT,6,{A_Fall},S_SKULL_DIE5}, // S_SKULL_DIE4
  {SPR_SKUL,9,6,{NULL},S_SKULL_DIE6}, // S_SKULL_DIE5
  {SPR_SKUL,10,6,{NULL},S_NULL},  // S_SKULL_DIE6
  {SPR_SPID,0,10,{A_Look},S_SPID_STND2},  // S_SPID_STND
  {SPR_SPID,1,10,{A_Look},S_SPID_STND}, // S_SPID_STND2
  {SPR_SPID,0,3,{A_Metal},S_SPID_RUN2}, // S_SPID_RUN1
  {SPR_SPID,0,3,{A_Chase},S_SPID_RUN3}, // S_SPID_RUN2
  {SPR_SPID,1,3,{A_Chase},S_SPID_RUN4}, // S_SPID_RUN3
  {SPR_SPID,1,3,{A_Chase},S_SPID_RUN5}, // S_SPID_RUN4
  {SPR_SPID,2,3,{A_Metal},S_SPID_RUN6}, // S_SPID_RUN5
  {SPR_SPID,2,3,{A_Chase},S_SPID_RUN7}, // S_SPID_RUN6
  {SPR_SPID,3,3,{A_Chase},S_SPID_RUN8}, // S_SPID_RUN7
  {SPR_SPID,3,3,{A_Chase},S_SPID_RUN9}, // S_SPID_RUN8
  {SPR_SPID,4,3,{A_Metal},S_SPID_RUN10},  // S_SPID_RUN9
  {SPR_SPID,4,3,{A_Chase},S_SPID_RUN11},  // S_SPID_RUN10
  {SPR_SPID,5,3,{A_Chase},S_SPID_RUN12},  // S_SPID_RUN11
  {SPR_SPID,5,3,{A_Chase},S_SPID_RUN1}, // S_SPID_RUN12
  {SPR_SPID,0|FF_FULLBRIGHT,20,{A_FaceTarget},S_SPID_ATK2}, // S_SPID_ATK1
  {SPR_SPID,6|FF_FULLBRIGHT,4,{A_SPosAttack},S_SPID_ATK3},  // S_SPID_ATK2
  {SPR_SPID,7|FF_FULLBRIGHT,4,{A_SPosAttack},S_SPID_ATK4},  // S_SPID_ATK3
  {SPR_SPID,7|FF_FULLBRIGHT,1,{A_SpidRefire},S_SPID_ATK2},  // S_SPID_ATK4
  {SPR_SPID,8,3,{NULL},S_SPID_PAIN2}, // S_SPID_PAIN
  {SPR_SPID,8,3,{A_Pain},S_SPID_RUN1},  // S_SPID_PAIN2
  {SPR_SPID,9,20,{A_Scream},S_SPID_DIE2}, // S_SPID_DIE1
  {SPR_SPID,10,10,{A_Fall},S_SPID_DIE3},  // S_SPID_DIE2
  {SPR_SPID,11,10,{NULL},S_SPID_DIE4},  // S_SPID_DIE3
  {SPR_SPID,12,10,{NULL},S_SPID_DIE5},  // S_SPID_DIE4
  {SPR_SPID,13,10,{NULL},S_SPID_DIE6},  // S_SPID_DIE5
  {SPR_SPID,14,10,{NULL},S_SPID_DIE7},  // S_SPID_DIE6
  {SPR_SPID,15,10,{NULL},S_SPID_DIE8},  // S_SPID_DIE7
  {SPR_SPID,16,10,{NULL},S_SPID_DIE9},  // S_SPID_DIE8
  {SPR_SPID,17,10,{NULL},S_SPID_DIE10}, // S_SPID_DIE9
  {SPR_SPID,18,30,{NULL},S_SPID_DIE11}, // S_SPID_DIE10
  {SPR_SPID,18,-1,{A_BossDeath},S_NULL},  // S_SPID_DIE11
  {SPR_BSPI,0,10,{A_Look},S_BSPI_STND2},  // S_BSPI_STND
  {SPR_BSPI,1,10,{A_Look},S_BSPI_STND}, // S_BSPI_STND2
  {SPR_BSPI,0,20,{NULL},S_BSPI_RUN1}, // S_BSPI_SIGHT
  {SPR_BSPI,0,3,{A_BabyMetal},S_BSPI_RUN2}, // S_BSPI_RUN1
  {SPR_BSPI,0,3,{A_Chase},S_BSPI_RUN3}, // S_BSPI_RUN2
  {SPR_BSPI,1,3,{A_Chase},S_BSPI_RUN4}, // S_BSPI_RUN3
  {SPR_BSPI,1,3,{A_Chase},S_BSPI_RUN5}, // S_BSPI_RUN4
  {SPR_BSPI,2,3,{A_Chase},S_BSPI_RUN6}, // S_BSPI_RUN5
  {SPR_BSPI,2,3,{A_Chase},S_BSPI_RUN7}, // S_BSPI_RUN6
  {SPR_BSPI,3,3,{A_BabyMetal},S_BSPI_RUN8}, // S_BSPI_RUN7
  {SPR_BSPI,3,3,{A_Chase},S_BSPI_RUN9}, // S_BSPI_RUN8
  {SPR_BSPI,4,3,{A_Chase},S_BSPI_RUN10},  // S_BSPI_RUN9
  {SPR_BSPI,4,3,{A_Chase},S_BSPI_RUN11},  // S_BSPI_RUN10
  {SPR_BSPI,5,3,{A_Chase},S_BSPI_RUN12},  // S_BSPI_RUN11
  {SPR_BSPI,5,3,{A_Chase},S_BSPI_RUN1}, // S_BSPI_RUN12
  {SPR_BSPI,0|FF_FULLBRIGHT,20,{A_FaceTarget},S_BSPI_ATK2}, // S_BSPI_ATK1
  {SPR_BSPI,6|FF_FULLBRIGHT,4,{A_BspiAttack},S_BSPI_ATK3},  // S_BSPI_ATK2
  {SPR_BSPI,7|FF_FULLBRIGHT,4,{NULL},S_BSPI_ATK4},  // S_BSPI_ATK3
  {SPR_BSPI,7|FF_FULLBRIGHT,1,{A_SpidRefire},S_BSPI_ATK2},  // S_BSPI_ATK4
  {SPR_BSPI,8,3,{NULL},S_BSPI_PAIN2}, // S_BSPI_PAIN
  {SPR_BSPI,8,3,{A_Pain},S_BSPI_RUN1},  // S_BSPI_PAIN2
  {SPR_BSPI,9,20,{A_Scream},S_BSPI_DIE2}, // S_BSPI_DIE1
  {SPR_BSPI,10,7,{A_Fall},S_BSPI_DIE3}, // S_BSPI_DIE2
  {SPR_BSPI,11,7,{NULL},S_BSPI_DIE4}, // S_BSPI_DIE3
  {SPR_BSPI,12,7,{NULL},S_BSPI_DIE5}, // S_BSPI_DIE4
  {SPR_BSPI,13,7,{NULL},S_BSPI_DIE6}, // S_BSPI_DIE5
  {SPR_BSPI,14,7,{NULL},S_BSPI_DIE7}, // S_BSPI_DIE6
  {SPR_BSPI,15,-1,{A_BossDeath},S_NULL},  // S_BSPI_DIE7
  {SPR_BSPI,15,5,{NULL},S_BSPI_RAISE2}, // S_BSPI_RAISE1
  {SPR_BSPI,14,5,{NULL},S_BSPI_RAISE3}, // S_BSPI_RAISE2
  {SPR_BSPI,13,5,{NULL},S_BSPI_RAISE4}, // S_BSPI_RAISE3
  {SPR_BSPI,12,5,{NULL},S_BSPI_RAISE5}, // S_BSPI_RAISE4
  {SPR_BSPI,11,5,{NULL},S_BSPI_RAISE6}, // S_BSPI_RAISE5
  {SPR_BSPI,10,5,{NULL},S_BSPI_RAISE7}, // S_BSPI_RAISE6
  {SPR_BSPI,9,5,{NULL},S_BSPI_RUN1},  // S_BSPI_RAISE7
  {SPR_APLS,0|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLAZ2},  // S_ARACH_PLAZ
  {SPR_APLS,1|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLAZ}, // S_ARACH_PLAZ2
  {SPR_APBX,0|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX2},  // S_ARACH_PLEX
  {SPR_APBX,1|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX3},  // S_ARACH_PLEX2
  {SPR_APBX,2|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX4},  // S_ARACH_PLEX3
  {SPR_APBX,3|FF_FULLBRIGHT,5,{NULL},S_ARACH_PLEX5},  // S_ARACH_PLEX4
  {SPR_APBX,4|FF_FULLBRIGHT,5,{NULL},S_NULL}, // S_ARACH_PLEX5
  {SPR_CYBR,0,10,{A_Look},S_CYBER_STND2}, // S_CYBER_STND
  {SPR_CYBR,1,10,{A_Look},S_CYBER_STND},  // S_CYBER_STND2
  {SPR_CYBR,0,3,{A_Hoof},S_CYBER_RUN2}, // S_CYBER_RUN1
  {SPR_CYBR,0,3,{A_Chase},S_CYBER_RUN3},  // S_CYBER_RUN2
  {SPR_CYBR,1,3,{A_Chase},S_CYBER_RUN4},  // S_CYBER_RUN3
  {SPR_CYBR,1,3,{A_Chase},S_CYBER_RUN5},  // S_CYBER_RUN4
  {SPR_CYBR,2,3,{A_Chase},S_CYBER_RUN6},  // S_CYBER_RUN5
  {SPR_CYBR,2,3,{A_Chase},S_CYBER_RUN7},  // S_CYBER_RUN6
  {SPR_CYBR,3,3,{A_Metal},S_CYBER_RUN8},  // S_CYBER_RUN7
  {SPR_CYBR,3,3,{A_Chase},S_CYBER_RUN1},  // S_CYBER_RUN8
  {SPR_CYBR,4,6,{A_FaceTarget},S_CYBER_ATK2}, // S_CYBER_ATK1
  {SPR_CYBR,5,12,{A_CyberAttack},S_CYBER_ATK3}, // S_CYBER_ATK2
  {SPR_CYBR,4,12,{A_FaceTarget},S_CYBER_ATK4},  // S_CYBER_ATK3
  {SPR_CYBR,5,12,{A_CyberAttack},S_CYBER_ATK5}, // S_CYBER_ATK4
  {SPR_CYBR,4,12,{A_FaceTarget},S_CYBER_ATK6},  // S_CYBER_ATK5
  {SPR_CYBR,5,12,{A_CyberAttack},S_CYBER_RUN1}, // S_CYBER_ATK6
  {SPR_CYBR,6,10,{A_Pain},S_CYBER_RUN1},  // S_CYBER_PAIN
  {SPR_CYBR,7,10,{NULL},S_CYBER_DIE2},  // S_CYBER_DIE1
  {SPR_CYBR,8,10,{A_Scream},S_CYBER_DIE3},  // S_CYBER_DIE2
  {SPR_CYBR,9,10,{NULL},S_CYBER_DIE4},  // S_CYBER_DIE3
  {SPR_CYBR,10,10,{NULL},S_CYBER_DIE5}, // S_CYBER_DIE4
  {SPR_CYBR,11,10,{NULL},S_CYBER_DIE6}, // S_CYBER_DIE5
  {SPR_CYBR,12,10,{A_Fall},S_CYBER_DIE7}, // S_CYBER_DIE6
  {SPR_CYBR,13,10,{NULL},S_CYBER_DIE8}, // S_CYBER_DIE7
  {SPR_CYBR,14,10,{NULL},S_CYBER_DIE9}, // S_CYBER_DIE8
  {SPR_CYBR,15,30,{NULL},S_CYBER_DIE10},  // S_CYBER_DIE9
  {SPR_CYBR,15,-1,{A_BossDeath},S_NULL},  // S_CYBER_DIE10
  {SPR_PAIN,0,10,{A_Look},S_PAIN_STND}, // S_PAIN_STND
  {SPR_PAIN,0,3,{A_Chase},S_PAIN_RUN2}, // S_PAIN_RUN1
  {SPR_PAIN,0,3,{A_Chase},S_PAIN_RUN3}, // S_PAIN_RUN2
  {SPR_PAIN,1,3,{A_Chase},S_PAIN_RUN4}, // S_PAIN_RUN3
  {SPR_PAIN,1,3,{A_Chase},S_PAIN_RUN5}, // S_PAIN_RUN4
  {SPR_PAIN,2,3,{A_Chase},S_PAIN_RUN6}, // S_PAIN_RUN5
  {SPR_PAIN,2,3,{A_Chase},S_PAIN_RUN1}, // S_PAIN_RUN6
  {SPR_PAIN,3,5,{A_FaceTarget},S_PAIN_ATK2},  // S_PAIN_ATK1
  {SPR_PAIN,4,5,{A_FaceTarget},S_PAIN_ATK3},  // S_PAIN_ATK2
  {SPR_PAIN,5|FF_FULLBRIGHT,5,{A_FaceTarget},S_PAIN_ATK4},  // S_PAIN_ATK3
  {SPR_PAIN,5|FF_FULLBRIGHT,0,{A_PainAttack},S_PAIN_RUN1},  // S_PAIN_ATK4
  {SPR_PAIN,6,6,{NULL},S_PAIN_PAIN2}, // S_PAIN_PAIN
  {SPR_PAIN,6,6,{A_Pain},S_PAIN_RUN1},  // S_PAIN_PAIN2
  {SPR_PAIN,7|FF_FULLBRIGHT,8,{NULL},S_PAIN_DIE2},  // S_PAIN_DIE1
  {SPR_PAIN,8|FF_FULLBRIGHT,8,{A_Scream},S_PAIN_DIE3},  // S_PAIN_DIE2
  {SPR_PAIN,9|FF_FULLBRIGHT,8,{NULL},S_PAIN_DIE4},  // S_PAIN_DIE3
  {SPR_PAIN,10|FF_FULLBRIGHT,8,{NULL},S_PAIN_DIE5},  // S_PAIN_DIE4
  {SPR_PAIN,11|FF_FULLBRIGHT,8,{A_PainDie},S_PAIN_DIE6}, // S_PAIN_DIE5
  {SPR_PAIN,12|FF_FULLBRIGHT,8,{NULL},S_NULL}, // S_PAIN_DIE6
  {SPR_PAIN,12,8,{NULL},S_PAIN_RAISE2}, // S_PAIN_RAISE1
  {SPR_PAIN,11,8,{NULL},S_PAIN_RAISE3}, // S_PAIN_RAISE2
  {SPR_PAIN,10,8,{NULL},S_PAIN_RAISE4}, // S_PAIN_RAISE3
  {SPR_PAIN,9,8,{NULL},S_PAIN_RAISE5},  // S_PAIN_RAISE4
  {SPR_PAIN,8,8,{NULL},S_PAIN_RAISE6},  // S_PAIN_RAISE5
  {SPR_PAIN,7,8,{NULL},S_PAIN_RUN1},  // S_PAIN_RAISE6
  {SPR_SSWV,0,10,{A_Look},S_SSWV_STND2},  // S_SSWV_STND
  {SPR_SSWV,1,10,{A_Look},S_SSWV_STND}, // S_SSWV_STND2
  {SPR_SSWV,0,3,{A_Chase},S_SSWV_RUN2}, // S_SSWV_RUN1
  {SPR_SSWV,0,3,{A_Chase},S_SSWV_RUN3}, // S_SSWV_RUN2
  {SPR_SSWV,1,3,{A_Chase},S_SSWV_RUN4}, // S_SSWV_RUN3
  {SPR_SSWV,1,3,{A_Chase},S_SSWV_RUN5}, // S_SSWV_RUN4
  {SPR_SSWV,2,3,{A_Chase},S_SSWV_RUN6}, // S_SSWV_RUN5
  {SPR_SSWV,2,3,{A_Chase},S_SSWV_RUN7}, // S_SSWV_RUN6
  {SPR_SSWV,3,3,{A_Chase},S_SSWV_RUN8}, // S_SSWV_RUN7
  {SPR_SSWV,3,3,{A_Chase},S_SSWV_RUN1}, // S_SSWV_RUN8
  {SPR_SSWV,4,10,{A_FaceTarget},S_SSWV_ATK2}, // S_SSWV_ATK1
  {SPR_SSWV,5,10,{A_FaceTarget},S_SSWV_ATK3}, // S_SSWV_ATK2
  {SPR_SSWV,6|FF_FULLBRIGHT,4,{A_CPosAttack},S_SSWV_ATK4},  // S_SSWV_ATK3
  {SPR_SSWV,5,6,{A_FaceTarget},S_SSWV_ATK5},  // S_SSWV_ATK4
  {SPR_SSWV,6|FF_FULLBRIGHT,4,{A_CPosAttack},S_SSWV_ATK6},  // S_SSWV_ATK5
  {SPR_SSWV,5,1,{A_CPosRefire},S_SSWV_ATK2},  // S_SSWV_ATK6
  {SPR_SSWV,7,3,{NULL},S_SSWV_PAIN2}, // S_SSWV_PAIN
  {SPR_SSWV,7,3,{A_Pain},S_SSWV_RUN1},  // S_SSWV_PAIN2
  {SPR_SSWV,8,5,{NULL},S_SSWV_DIE2},  // S_SSWV_DIE1
  {SPR_SSWV,9,5,{A_Scream},S_SSWV_DIE3},  // S_SSWV_DIE2
  {SPR_SSWV,10,5,{A_Fall},S_SSWV_DIE4}, // S_SSWV_DIE3
  {SPR_SSWV,11,5,{NULL},S_SSWV_DIE5}, // S_SSWV_DIE4
  {SPR_SSWV,12,-1,{NULL},S_NULL}, // S_SSWV_DIE5
  {SPR_SSWV,13,5,{NULL},S_SSWV_XDIE2},  // S_SSWV_XDIE1
  {SPR_SSWV,14,5,{A_XScream},S_SSWV_XDIE3}, // S_SSWV_XDIE2
  {SPR_SSWV,15,5,{A_Fall},S_SSWV_XDIE4},  // S_SSWV_XDIE3
  {SPR_SSWV,16,5,{NULL},S_SSWV_XDIE5},  // S_SSWV_XDIE4
  {SPR_SSWV,17,5,{NULL},S_SSWV_XDIE6},  // S_SSWV_XDIE5
  {SPR_SSWV,18,5,{NULL},S_SSWV_XDIE7},  // S_SSWV_XDIE6
  {SPR_SSWV,19,5,{NULL},S_SSWV_XDIE8},  // S_SSWV_XDIE7
  {SPR_SSWV,20,5,{NULL},S_SSWV_XDIE9},  // S_SSWV_XDIE8
  {SPR_SSWV,21,-1,{NULL},S_NULL}, // S_SSWV_XDIE9
  {SPR_SSWV,12,5,{NULL},S_SSWV_RAISE2}, // S_SSWV_RAISE1
  {SPR_SSWV,11,5,{NULL},S_SSWV_RAISE3}, // S_SSWV_RAISE2
  {SPR_SSWV,10,5,{NULL},S_SSWV_RAISE4}, // S_SSWV_RAISE3
  {SPR_SSWV,9,5,{NULL},S_SSWV_RAISE5},  // S_SSWV_RAISE4
  {SPR_SSWV,8,5,{NULL},S_SSWV_RUN1},  // S_SSWV_RAISE5
  {SPR_KEEN,0,-1,{NULL},S_KEENSTND},  // S_KEENSTND
  {SPR_KEEN,0,6,{NULL},S_COMMKEEN2},  // S_COMMKEEN
  {SPR_KEEN,1,6,{NULL},S_COMMKEEN3},  // S_COMMKEEN2
  {SPR_KEEN,2,6,{A_Scream},S_COMMKEEN4},  // S_COMMKEEN3
  {SPR_KEEN,3,6,{NULL},S_COMMKEEN5},  // S_COMMKEEN4
  {SPR_KEEN,4,6,{NULL},S_COMMKEEN6},  // S_COMMKEEN5
  {SPR_KEEN,5,6,{NULL},S_COMMKEEN7},  // S_COMMKEEN6
  {SPR_KEEN,6,6,{NULL},S_COMMKEEN8},  // S_COMMKEEN7
  {SPR_KEEN,7,6,{NULL},S_COMMKEEN9},  // S_COMMKEEN8
  {SPR_KEEN,8,6,{NULL},S_COMMKEEN10}, // S_COMMKEEN9
  {SPR_KEEN,9,6,{NULL},S_COMMKEEN11}, // S_COMMKEEN10
  {SPR_KEEN,10,6,{A_KeenDie},S_COMMKEEN12},// S_COMMKEEN11
  {SPR_KEEN,11,-1,{NULL},S_NULL},   // S_COMMKEEN12
  {SPR_KEEN,12,4,{NULL},S_KEENPAIN2}, // S_KEENPAIN
  {SPR_KEEN,12,8,{A_Pain},S_KEENSTND},  // S_KEENPAIN2
  {SPR_BBRN,0,-1,{NULL},S_NULL},    // S_BRAIN
  {SPR_BBRN,1,36,{A_BrainPain},S_BRAIN},  // S_BRAIN_PAIN
  {SPR_BBRN,0,100,{A_BrainScream},S_BRAIN_DIE2},  // S_BRAIN_DIE1
  {SPR_BBRN,0,10,{NULL},S_BRAIN_DIE3},  // S_BRAIN_DIE2
  {SPR_BBRN,0,10,{NULL},S_BRAIN_DIE4},  // S_BRAIN_DIE3
  {SPR_BBRN,0,-1,{A_BrainDie},S_NULL},  // S_BRAIN_DIE4
  {SPR_SSWV,0,10,{A_Look},S_BRAINEYE},  // S_BRAINEYE
  {SPR_SSWV,0,181,{A_BrainAwake},S_BRAINEYE1},  // S_BRAINEYESEE
  {SPR_SSWV,0,150,{A_BrainSpit},S_BRAINEYE1}, // S_BRAINEYE1
  {SPR_BOSF,0|FF_FULLBRIGHT,3,{A_SpawnSound},S_SPAWN2}, // S_SPAWN1
  {SPR_BOSF,1|FF_FULLBRIGHT,3,{A_SpawnFly},S_SPAWN3}, // S_SPAWN2
  {SPR_BOSF,2|FF_FULLBRIGHT,3,{A_SpawnFly},S_SPAWN4}, // S_SPAWN3
  {SPR_BOSF,3|FF_FULLBRIGHT,3,{A_SpawnFly},S_SPAWN1}, // S_SPAWN4
  {SPR_FIRE,0|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE2}, // S_SPAWNFIRE1
  {SPR_FIRE,1|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE3}, // S_SPAWNFIRE2
  {SPR_FIRE,2|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE4}, // S_SPAWNFIRE3
  {SPR_FIRE,3|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE5}, // S_SPAWNFIRE4
  {SPR_FIRE,4|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE6}, // S_SPAWNFIRE5
  {SPR_FIRE,5|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE7}, // S_SPAWNFIRE6
  {SPR_FIRE,6|FF_FULLBRIGHT,4,{A_Fire},S_SPAWNFIRE8}, // S_SPAWNFIRE7
  {SPR_FIRE,7|FF_FULLBRIGHT,4,{A_Fire},S_NULL},   // S_SPAWNFIRE8
  {SPR_MISL,1|FF_FULLBRIGHT,10,{NULL},S_BRAINEXPLODE2}, // S_BRAINEXPLODE1
  {SPR_MISL,2|FF_FULLBRIGHT,10,{NULL},S_BRAINEXPLODE3}, // S_BRAINEXPLODE2
  {SPR_MISL,3|FF_FULLBRIGHT,10,{A_BrainExplode},S_NULL},  // S_BRAINEXPLODE3
  {SPR_ARM1,0,6,{NULL},S_ARM1A},  // S_ARM1
  {SPR_ARM1,1|FF_FULLBRIGHT,7,{NULL},S_ARM1}, // S_ARM1A
  {SPR_ARM2,0,6,{NULL},S_ARM2A},  // S_ARM2
  {SPR_ARM2,1|FF_FULLBRIGHT,6,{NULL},S_ARM2}, // S_ARM2A
  {SPR_BAR1,0,6,{NULL},S_BAR2}, // S_BAR1
  {SPR_BAR1,1,6,{NULL},S_BAR1}, // S_BAR2
  {SPR_BEXP,0|FF_FULLBRIGHT,5,{NULL},S_BEXP2},  // S_BEXP
  {SPR_BEXP,1|FF_FULLBRIGHT,5,{A_Scream},S_BEXP3},  // S_BEXP2
  {SPR_BEXP,2|FF_FULLBRIGHT,5,{NULL},S_BEXP4},  // S_BEXP3
  {SPR_BEXP,3|FF_FULLBRIGHT,10,{A_Explode},S_BEXP5},  // S_BEXP4
  {SPR_BEXP,4|FF_FULLBRIGHT,10,{NULL},S_NULL},  // S_BEXP5
  {SPR_FCAN,0|FF_FULLBRIGHT,4,{NULL},S_BBAR2},  // S_BBAR1
  {SPR_FCAN,1|FF_FULLBRIGHT,4,{NULL},S_BBAR3},  // S_BBAR2
  {SPR_FCAN,2|FF_FULLBRIGHT,4,{NULL},S_BBAR1},  // S_BBAR3
  {SPR_BON1,0,6,{NULL},S_BON1A},  // S_BON1
  {SPR_BON1,1,6,{NULL},S_BON1B},  // S_BON1A
  {SPR_BON1,2,6,{NULL},S_BON1C},  // S_BON1B
  {SPR_BON1,3,6,{NULL},S_BON1D},  // S_BON1C
  {SPR_BON1,2,6,{NULL},S_BON1E},  // S_BON1D
  {SPR_BON1,1,6,{NULL},S_BON1}, // S_BON1E
  {SPR_BON2,0,6,{NULL},S_BON2A},  // S_BON2
  {SPR_BON2,1,6,{NULL},S_BON2B},  // S_BON2A
  {SPR_BON2,2,6,{NULL},S_BON2C},  // S_BON2B
  {SPR_BON2,3,6,{NULL},S_BON2D},  // S_BON2C
  {SPR_BON2,2,6,{NULL},S_BON2E},  // S_BON2D
  {SPR_BON2,1,6,{NULL},S_BON2}, // S_BON2E
  {SPR_BKEY,0,10,{NULL},S_BKEY2}, // S_BKEY
  {SPR_BKEY,1|FF_FULLBRIGHT,10,{NULL},S_BKEY},  // S_BKEY2
  {SPR_RKEY,0,10,{NULL},S_RKEY2}, // S_RKEY
  {SPR_RKEY,1|FF_FULLBRIGHT,10,{NULL},S_RKEY},  // S_RKEY2
  {SPR_YKEY,0,10,{NULL},S_YKEY2}, // S_YKEY
  {SPR_YKEY,1|FF_FULLBRIGHT,10,{NULL},S_YKEY},  // S_YKEY2
  {SPR_BSKU,0,10,{NULL},S_BSKULL2}, // S_BSKULL
  {SPR_BSKU,1|FF_FULLBRIGHT,10,{NULL},S_BSKULL},  // S_BSKULL2
  {SPR_RSKU,0,10,{NULL},S_RSKULL2}, // S_RSKULL
  {SPR_RSKU,1|FF_FULLBRIGHT,10,{NULL},S_RSKULL},  // S_RSKULL2
  {SPR_YSKU,0,10,{NULL},S_YSKULL2}, // S_YSKULL
  {SPR_YSKU,1|FF_FULLBRIGHT,10,{NULL},S_YSKULL},  // S_YSKULL2
  {SPR_STIM,0,-1,{NULL},S_NULL},  // S_STIM
  {SPR_MEDI,0,-1,{NULL},S_NULL},  // S_MEDI
  {SPR_SOUL,0|FF_FULLBRIGHT,6,{NULL},S_SOUL2},  // S_SOUL
  {SPR_SOUL,1|FF_FULLBRIGHT,6,{NULL},S_SOUL3},  // S_SOUL2
  {SPR_SOUL,2|FF_FULLBRIGHT,6,{NULL},S_SOUL4},  // S_SOUL3
  {SPR_SOUL,3|FF_FULLBRIGHT,6,{NULL},S_SOUL5},  // S_SOUL4
  {SPR_SOUL,2|FF_FULLBRIGHT,6,{NULL},S_SOUL6},  // S_SOUL5
  {SPR_SOUL,1|FF_FULLBRIGHT,6,{NULL},S_SOUL}, // S_SOUL6
  {SPR_PINV,0|FF_FULLBRIGHT,6,{NULL},S_PINV2},  // S_PINV
  {SPR_PINV,1|FF_FULLBRIGHT,6,{NULL},S_PINV3},  // S_PINV2
  {SPR_PINV,2|FF_FULLBRIGHT,6,{NULL},S_PINV4},  // S_PINV3
  {SPR_PINV,3|FF_FULLBRIGHT,6,{NULL},S_PINV}, // S_PINV4
  {SPR_PSTR,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_PSTR
  {SPR_PINS,0|FF_FULLBRIGHT,6,{NULL},S_PINS2},  // S_PINS
  {SPR_PINS,1|FF_FULLBRIGHT,6,{NULL},S_PINS3},  // S_PINS2
  {SPR_PINS,2|FF_FULLBRIGHT,6,{NULL},S_PINS4},  // S_PINS3
  {SPR_PINS,3|FF_FULLBRIGHT,6,{NULL},S_PINS}, // S_PINS4
  {SPR_MEGA,0|FF_FULLBRIGHT,6,{NULL},S_MEGA2},  // S_MEGA
  {SPR_MEGA,1|FF_FULLBRIGHT,6,{NULL},S_MEGA3},  // S_MEGA2
  {SPR_MEGA,2|FF_FULLBRIGHT,6,{NULL},S_MEGA4},  // S_MEGA3
  {SPR_MEGA,3|FF_FULLBRIGHT,6,{NULL},S_MEGA}, // S_MEGA4
  {SPR_SUIT,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_SUIT
  {SPR_PMAP,0|FF_FULLBRIGHT,6,{NULL},S_PMAP2},  // S_PMAP
  {SPR_PMAP,1|FF_FULLBRIGHT,6,{NULL},S_PMAP3},  // S_PMAP2
  {SPR_PMAP,2|FF_FULLBRIGHT,6,{NULL},S_PMAP4},  // S_PMAP3
  {SPR_PMAP,3|FF_FULLBRIGHT,6,{NULL},S_PMAP5},  // S_PMAP4
  {SPR_PMAP,2|FF_FULLBRIGHT,6,{NULL},S_PMAP6},  // S_PMAP5
  {SPR_PMAP,1|FF_FULLBRIGHT,6,{NULL},S_PMAP}, // S_PMAP6
  {SPR_PVIS,0|FF_FULLBRIGHT,6,{NULL},S_PVIS2},  // S_PVIS
  {SPR_PVIS,1,6,{NULL},S_PVIS}, // S_PVIS2
  {SPR_CLIP,0,-1,{NULL},S_NULL},  // S_CLIP
  {SPR_AMMO,0,-1,{NULL},S_NULL},  // S_AMMO
  {SPR_ROCK,0,-1,{NULL},S_NULL},  // S_ROCK
  {SPR_BROK,0,-1,{NULL},S_NULL},  // S_BROK
  {SPR_CELL,0,-1,{NULL},S_NULL},  // S_CELL
  {SPR_CELP,0,-1,{NULL},S_NULL},  // S_CELP
  {SPR_SHEL,0,-1,{NULL},S_NULL},  // S_SHEL
  {SPR_SBOX,0,-1,{NULL},S_NULL},  // S_SBOX
  {SPR_BPAK,0,-1,{NULL},S_NULL},  // S_BPAK
  {SPR_BFUG,0,-1,{NULL},S_NULL},  // S_BFUG
  {SPR_MGUN,0,-1,{NULL},S_NULL},  // S_MGUN
  {SPR_CSAW,0,-1,{NULL},S_NULL},  // S_CSAW
  {SPR_LAUN,0,-1,{NULL},S_NULL},  // S_LAUN
  {SPR_PLAS,0,-1,{NULL},S_NULL},  // S_PLAS
  {SPR_SHOT,0,-1,{NULL},S_NULL},  // S_SHOT
  {SPR_SGN2,0,-1,{NULL},S_NULL},  // S_SHOT2
  {SPR_COLU,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_COLU
  {SPR_SMT2,0,-1,{NULL},S_NULL},  // S_STALAG
  {SPR_GOR1,0,10,{NULL},S_BLOODYTWITCH2}, // S_BLOODYTWITCH
  {SPR_GOR1,1,15,{NULL},S_BLOODYTWITCH3}, // S_BLOODYTWITCH2
  {SPR_GOR1,2,8,{NULL},S_BLOODYTWITCH4},  // S_BLOODYTWITCH3
  {SPR_GOR1,1,6,{NULL},S_BLOODYTWITCH}, // S_BLOODYTWITCH4
  {SPR_PLAY,13,-1,{NULL},S_NULL}, // S_DEADTORSO
  {SPR_PLAY,18,-1,{NULL},S_NULL}, // S_DEADBOTTOM
  {SPR_POL2,0,-1,{NULL},S_NULL},  // S_HEADSONSTICK
  {SPR_POL5,0,-1,{NULL},S_NULL},  // S_GIBS
  {SPR_POL4,0,-1,{NULL},S_NULL},  // S_HEADONASTICK
  {SPR_POL3,0|FF_FULLBRIGHT,6,{NULL},S_HEADCANDLES2}, // S_HEADCANDLES
  {SPR_POL3,1|FF_FULLBRIGHT,6,{NULL},S_HEADCANDLES},  // S_HEADCANDLES2
  {SPR_POL1,0,-1,{NULL},S_NULL},  // S_DEADSTICK
  {SPR_POL6,0,6,{NULL},S_LIVESTICK2}, // S_LIVESTICK
  {SPR_POL6,1,8,{NULL},S_LIVESTICK},  // S_LIVESTICK2
  {SPR_GOR2,0,-1,{NULL},S_NULL},  // S_MEAT2
  {SPR_GOR3,0,-1,{NULL},S_NULL},  // S_MEAT3
  {SPR_GOR4,0,-1,{NULL},S_NULL},  // S_MEAT4
  {SPR_GOR5,0,-1,{NULL},S_NULL},  // S_MEAT5
  {SPR_SMIT,0,-1,{NULL},S_NULL},  // S_STALAGTITE
  {SPR_COL1,0,-1,{NULL},S_NULL},  // S_TALLGRNCOL
  {SPR_COL2,0,-1,{NULL},S_NULL},  // S_SHRTGRNCOL
  {SPR_COL3,0,-1,{NULL},S_NULL},  // S_TALLREDCOL
  {SPR_COL4,0,-1,{NULL},S_NULL},  // S_SHRTREDCOL
  {SPR_CAND,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_CANDLESTIK
  {SPR_CBRA,0|FF_FULLBRIGHT,-1,{NULL},S_NULL},  // S_CANDELABRA
  {SPR_COL6,0,-1,{NULL},S_NULL},  // S_SKULLCOL
  {SPR_TRE1,0,-1,{NULL},S_NULL},  // S_TORCHTREE
  {SPR_TRE2,0,-1,{NULL},S_NULL},  // S_BIGTREE
  {SPR_ELEC,0,-1,{NULL},S_NULL},  // S_TECHPILLAR
  {SPR_CEYE,0|FF_FULLBRIGHT,6,{NULL},S_EVILEYE2}, // S_EVILEYE
  {SPR_CEYE,1|FF_FULLBRIGHT,6,{NULL},S_EVILEYE3}, // S_EVILEYE2
  {SPR_CEYE,2|FF_FULLBRIGHT,6,{NULL},S_EVILEYE4}, // S_EVILEYE3
  {SPR_CEYE,1|FF_FULLBRIGHT,6,{NULL},S_EVILEYE},  // S_EVILEYE4
  {SPR_FSKU,0|FF_FULLBRIGHT,6,{NULL},S_FLOATSKULL2},  // S_FLOATSKULL
  {SPR_FSKU,1|FF_FULLBRIGHT,6,{NULL},S_FLOATSKULL3},  // S_FLOATSKULL2
  {SPR_FSKU,2|FF_FULLBRIGHT,6,{NULL},S_FLOATSKULL}, // S_FLOATSKULL3
  {SPR_COL5,0,14,{NULL},S_HEARTCOL2}, // S_HEARTCOL
  {SPR_COL5,1,14,{NULL},S_HEARTCOL},  // S_HEARTCOL2
  {SPR_TBLU,0|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH2}, // S_BLUETORCH
  {SPR_TBLU,1|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH3}, // S_BLUETORCH2
  {SPR_TBLU,2|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH4}, // S_BLUETORCH3
  {SPR_TBLU,3|FF_FULLBRIGHT,4,{NULL},S_BLUETORCH},  // S_BLUETORCH4
  {SPR_TGRN,0|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH2},  // S_GREENTORCH
  {SPR_TGRN,1|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH3},  // S_GREENTORCH2
  {SPR_TGRN,2|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH4},  // S_GREENTORCH3
  {SPR_TGRN,3|FF_FULLBRIGHT,4,{NULL},S_GREENTORCH}, // S_GREENTORCH4
  {SPR_TRED,0|FF_FULLBRIGHT,4,{NULL},S_REDTORCH2},  // S_REDTORCH
  {SPR_TRED,1|FF_FULLBRIGHT,4,{NULL},S_REDTORCH3},  // S_REDTORCH2
  {SPR_TRED,2|FF_FULLBRIGHT,4,{NULL},S_REDTORCH4},  // S_REDTORCH3
  {SPR_TRED,3|FF_FULLBRIGHT,4,{NULL},S_REDTORCH}, // S_REDTORCH4
  {SPR_SMBT,0|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT2},  // S_BTORCHSHRT
  {SPR_SMBT,1|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT3},  // S_BTORCHSHRT2
  {SPR_SMBT,2|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT4},  // S_BTORCHSHRT3
  {SPR_SMBT,3|FF_FULLBRIGHT,4,{NULL},S_BTORCHSHRT}, // S_BTORCHSHRT4
  {SPR_SMGT,0|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT2},  // S_GTORCHSHRT
  {SPR_SMGT,1|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT3},  // S_GTORCHSHRT2
  {SPR_SMGT,2|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT4},  // S_GTORCHSHRT3
  {SPR_SMGT,3|FF_FULLBRIGHT,4,{NULL},S_GTORCHSHRT}, // S_GTORCHSHRT4
  {SPR_SMRT,0|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT2},  // S_RTORCHSHRT
  {SPR_SMRT,1|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT3},  // S_RTORCHSHRT2
  {SPR_SMRT,2|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT4},  // S_RTORCHSHRT3
  {SPR_SMRT,3|FF_FULLBRIGHT,4,{NULL},S_RTORCHSHRT}, // S_RTORCHSHRT4
  {SPR_HDB1,0,-1,{NULL},S_NULL},  // S_HANGNOGUTS
  {SPR_HDB2,0,-1,{NULL},S_NULL},  // S_HANGBNOBRAIN
  {SPR_HDB3,0,-1,{NULL},S_NULL},  // S_HANGTLOOKDN
  {SPR_HDB4,0,-1,{NULL},S_NULL},  // S_HANGTSKULL
  {SPR_HDB5,0,-1,{NULL},S_NULL},  // S_HANGTLOOKUP
  {SPR_HDB6,0,-1,{NULL},S_NULL},  // S_HANGTNOBRAIN
  {SPR_POB1,0,-1,{NULL},S_NULL},  // S_COLONGIBS
  {SPR_POB2,0,-1,{NULL},S_NULL},  // S_SMALLPOOL
  {SPR_BRS1,0,-1,{NULL},S_NULL},    // S_BRAINSTEM
  {SPR_TLMP,0|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP2},  // S_TECHLAMP
  {SPR_TLMP,1|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP3},  // S_TECHLAMP2
  {SPR_TLMP,2|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP4},  // S_TECHLAMP3
  {SPR_TLMP,3|FF_FULLBRIGHT,4,{NULL},S_TECHLAMP},   // S_TECHLAMP4
  {SPR_TLP2,0|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP2}, // S_TECH2LAMP
  {SPR_TLP2,1|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP3}, // S_TECH2LAMP2
  {SPR_TLP2,2|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP4}, // S_TECH2LAMP3
  {SPR_TLP2,3|FF_FULLBRIGHT,4,{NULL},S_TECH2LAMP},  // S_TECH2LAMP4

  {SPR_TNT1,0,-1,{NULL},S_TNT1},          // S_TNT1    // phares 3/8/98

  // killough 8/9/98: grenade
  {SPR_MISL,0|FF_FULLBRIGHT,1000,{A_Die},S_GRENADE},      // S_GRENADE

  // killough 8/10/98: variable damage explosion
  {SPR_MISL,1|FF_FULLBRIGHT,4,{A_Scream},S_DETONATE2},    // S_DETONATE
  {SPR_MISL,2|FF_FULLBRIGHT,6,{A_Detonate},S_DETONATE3},  // S_DETONATE2
  {SPR_MISL,3|FF_FULLBRIGHT,10,{NULL},S_NULL},            // S_DETONATE3

  // killough 7/19/98: Marine's best friend :)
  {SPR_DOGS,0,10,{A_Look},S_DOGS_STND2},  // S_DOGS_STND
  {SPR_DOGS,1,10,{A_Look},S_DOGS_STND}, // S_DOGS_STND2
  {SPR_DOGS,0,2,{A_Chase},S_DOGS_RUN2}, // S_DOGS_RUN1
  {SPR_DOGS,0,2,{A_Chase},S_DOGS_RUN3}, // S_DOGS_RUN2
  {SPR_DOGS,1,2,{A_Chase},S_DOGS_RUN4}, // S_DOGS_RUN3
  {SPR_DOGS,1,2,{A_Chase},S_DOGS_RUN5}, // S_DOGS_RUN4
  {SPR_DOGS,2,2,{A_Chase},S_DOGS_RUN6}, // S_DOGS_RUN5
  {SPR_DOGS,2,2,{A_Chase},S_DOGS_RUN7}, // S_DOGS_RUN6
  {SPR_DOGS,3,2,{A_Chase},S_DOGS_RUN8}, // S_DOGS_RUN7
  {SPR_DOGS,3,2,{A_Chase},S_DOGS_RUN1}, // S_DOGS_RUN8
  {SPR_DOGS,4,8,{A_FaceTarget},S_DOGS_ATK2},  // S_DOGS_ATK1
  {SPR_DOGS,5,8,{A_FaceTarget},S_DOGS_ATK3},  // S_DOGS_ATK2
  {SPR_DOGS,6,8,{A_SargAttack},S_DOGS_RUN1},  // S_DOGS_ATK3
  {SPR_DOGS,7,2,{NULL},S_DOGS_PAIN2}, // S_DOGS_PAIN
  {SPR_DOGS,7,2,{A_Pain},S_DOGS_RUN1},  // S_DOGS_PAIN2
  {SPR_DOGS,8,8,{NULL},S_DOGS_DIE2},  // S_DOGS_DIE1
  {SPR_DOGS,9,8,{A_Scream},S_DOGS_DIE3},  // S_DOGS_DIE2
  {SPR_DOGS,10,4,{NULL},S_DOGS_DIE4}, // S_DOGS_DIE3
  {SPR_DOGS,11,4,{A_Fall},S_DOGS_DIE5}, // S_DOGS_DIE4
  {SPR_DOGS,12,4,{NULL},S_DOGS_DIE6}, // S_DOGS_DIE5
  {SPR_DOGS,13,-1,{NULL},S_NULL}, // S_DOGS_DIE6
  {SPR_DOGS,13,5,{NULL},S_DOGS_RAISE2}, // S_DOGS_RAISE1
  {SPR_DOGS,12,5,{NULL},S_DOGS_RAISE3}, // S_DOGS_RAISE2
  {SPR_DOGS,11,5,{NULL},S_DOGS_RAISE4}, // S_DOGS_RAISE3
  {SPR_DOGS,10,5,{NULL},S_DOGS_RAISE5}, // S_DOGS_RAISE4
  {SPR_DOGS,9,5,{NULL},S_DOGS_RAISE6},  // S_DOGS_RAISE5
  {SPR_DOGS,8,5,{NULL},S_DOGS_RUN1},  // S_DOGS_RAISE6

  // killough 7/11/98: beta BFG begins here
  // S_OLDBFG1

#define BFGDELAY 1
#define OLDBFG_1FRAMES(x) {SPR_BFGG,1,BFGDELAY,{A_FireOldBFG},x+S_OLDBFG1+2},
#define OLDBFG_2FRAMES(x) OLDBFG_1FRAMES(x) OLDBFG_1FRAMES(x+1)
#define OLDBFG_4FRAMES(x) OLDBFG_2FRAMES(x) OLDBFG_2FRAMES(x+2)
#define OLDBFG_8FRAMES(x) OLDBFG_4FRAMES(x) OLDBFG_4FRAMES(x+4)
  {SPR_BFGG,0,10,{A_BFGsound},S_OLDBFG1+1},  // S_OLDBFG1

  OLDBFG_8FRAMES(0)
  OLDBFG_8FRAMES(8)
  OLDBFG_8FRAMES(16) 
  OLDBFG_8FRAMES(24)
  OLDBFG_8FRAMES(32)

  {SPR_BFGG,1,0,{A_Light0},S_OLDBFG43}, // S_OLDBFG42
  {SPR_BFGG,1,20,{A_ReFire},S_BFG},   // S_OLDBFG43

  // killough 7/11/98: end of beta BFG

  // killough 7/19/98: First plasma fireball in the beta:
  {SPR_PLS1,0|FF_FULLBRIGHT,6,{NULL},S_PLS1BALL2},  // S_PLS1BALL
  {SPR_PLS1,1|FF_FULLBRIGHT,6,{NULL},S_PLS1BALL}, // S_PLS1BALL2
  {SPR_PLS1,2|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP2}, // S_PLS1EXP
  {SPR_PLS1,3|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP3}, // S_PLS1EXP2
  {SPR_PLS1,4|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP4}, // S_PLS1EXP3
  {SPR_PLS1,5|FF_FULLBRIGHT,4,{NULL},S_PLS1EXP5}, // S_PLS1EXP4
  {SPR_PLS1,6|FF_FULLBRIGHT,4,{NULL},S_NULL}, // S_PLS1EXP5

  // killough 7/19/98: Second plasma fireball in the beta:
  {SPR_PLS2,0|FF_FULLBRIGHT,4,{NULL},S_PLS2BALL2}, // S_PLS2BALL
  {SPR_PLS2,1|FF_FULLBRIGHT,4,{NULL},S_PLS2BALL},  // S_PLS2BALL2
  {SPR_PLS2,2|FF_FULLBRIGHT,6,{NULL},S_PLS2BALLX2},  // S_PLS2BALLX1
  {SPR_PLS2,3|FF_FULLBRIGHT,6,{NULL},S_PLS2BALLX3},  // S_PLS2BALLX2
  {SPR_PLS2,4|FF_FULLBRIGHT,6,{NULL},S_NULL}, // S_PLS2BALLX3

  {SPR_BON3,0,6,{NULL},S_BON3},           // S_BON3  // killough 7/11/98:
  {SPR_BON4,0,6,{NULL},S_BON4},           // S_BON4  // beta bonus items

  // killough 10/98: beta lost souls attacked from a distance, 
  // animated with colors, and stayed in the air when killed.
  // This is an approximation, but I'm sure it can be improved.

  // spawnstate
  {SPR_SKUL,0,10,{A_Look},S_BSKUL_STND},  // S_BSKUL_STND

  // chasestate
  {SPR_SKUL,1,5,{A_Chase},S_BSKUL_RUN2},  // S_BSKUL_RUN1
  {SPR_SKUL,2,5,{A_Chase},S_BSKUL_RUN3},  // S_BSKUL_RUN2
  {SPR_SKUL,3,5,{A_Chase},S_BSKUL_RUN4},  // S_BSKUL_RUN3
  {SPR_SKUL,0,5,{A_Chase},S_BSKUL_RUN1},  // S_BSKUL_RUN4

  // missilestate
  {SPR_SKUL,4,4,{A_FaceTarget},S_BSKUL_ATK2},     // S_BSKUL_ATK1
  {SPR_SKUL,5,5,{A_BetaSkullAttack},S_BSKUL_ATK3}, // S_BSKUL_ATK2
  {SPR_SKUL,5,4,{NULL},S_BSKUL_RUN1},              // S_BSKUL_ATK3

  // painstate
  {SPR_SKUL,6,4,{NULL},S_BSKUL_PAIN2},     // S_BSKUL_PAIN1
  {SPR_SKUL,7,2,{A_Pain},S_BSKUL_RUN1},   // S_BSKUL_PAIN2
  {SPR_SKUL,8,4,{NULL},S_BSKUL_RUN1},      // S_BSKUL_PAIN3

  // deathstate
  {SPR_SKUL, 9,5,{NULL},S_BSKUL_DIE2},     // S_BSKUL_DIE1
  {SPR_SKUL,10,5,{NULL},S_BSKUL_DIE3},     // S_BSKUL_DIE2
  {SPR_SKUL,11,5,{NULL},S_BSKUL_DIE4},     // S_BSKUL_DIE3
  {SPR_SKUL,12,5,{NULL},S_BSKUL_DIE5},     // S_BSKUL_DIE4
  {SPR_SKUL,13,5,{A_Scream},S_BSKUL_DIE6}, // S_BSKUL_DIE5
  {SPR_SKUL,14,5,{NULL},S_BSKUL_DIE7},     // S_BSKUL_DIE6
  {SPR_SKUL,15,5,{A_Fall},S_BSKUL_DIE8},   // S_BSKUL_DIE7
  {SPR_SKUL,16,5,{A_Stop},S_BSKUL_DIE8},   // S_BSKUL_DIE8

  // killough 10/98: mushroom effect
  {SPR_MISL,1|FF_FULLBRIGHT,8,{A_Mushroom},S_EXPLODE2},  // S_MUSHROOM
};

// ********************************************************************
// Object "Thing" definitions
// ********************************************************************
// Now we get to the actual objects and their characteristics.  If
// you've seen Dehacked, much of this is where the Bits are set,
// commented below as "flags", as well as where you wire in which
// frames are the beginning frames for near and far attack, death,
// and such.  Sounds are hooked in here too, as well as how much
// mass, speed and so forth a Thing has.  Everything you ever wanted
// to know...
//
// Like all this other stuff, the MT_* entries are enumerated in info.h
//
// Note that these are all just indices of the elements involved, and
// not real pointers to them.  For example, the player's death sequence
// is S_PLAY_DIE1, which just evaluates to the index in the states[]
// array above, which actually knows what happens then and what the
// sprite looks like, if it makes noise or not, etc.
//
// Additional comments about each of the entries are located in info.h
// next to the mobjinfo_t structure definition.
//
// This goes on for the next 3000+ lines...

mobjinfo_t original_mobjinfo[NUMMOBJTYPES] = {
  {   // MT_PLAYER
    -1,   // doomednum
    S_PLAY,   // spawnstate
    100,    // spawnhealth
    S_PLAY_RUN1,    // seestate
    sfx_None,   // seesound
    0,    // reactiontime
    sfx_None,   // attacksound
    S_PLAY_PAIN,    // painstate
    255,    // painchance
    sfx_plpain,   // painsound
    S_NULL,   // meleestate
    S_PLAY_ATK1,    // missilestate
    S_PLAY_DIE1,    // deathstate
    S_PLAY_XDIE1,   // xdeathstate
    sfx_pldeth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,  // flags // killough 7/18/98
    S_NULL    // raisestate
  },
  
  {   // MT_POSSESSED
    3004,   // doomednum
    S_POSS_STND,    // spawnstate
    20,   // spawnhealth
    S_POSS_RUN1,    // seestate
    sfx_posit1,   // seesound
    8,    // reactiontime
    sfx_pistol,   // attacksound
    S_POSS_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_POSS_ATK1,    // missilestate
    S_POSS_DIE1,    // deathstate
    S_POSS_XDIE1,   // xdeathstate
    sfx_podth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_POSS_RAISE1   // raisestate
  },
  
  {   // MT_SHOTGUY
    9,    // doomednum
    S_SPOS_STND,    // spawnstate
    30,   // spawnhealth
    S_SPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SPOS_ATK1,    // missilestate
    S_SPOS_DIE1,    // deathstate
    S_SPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_SPOS_RAISE1   // raisestate
  },
  
  {   // MT_VILE
    64,   // doomednum
    S_VILE_STND,    // spawnstate
    700,    // spawnhealth
    S_VILE_RUN1,    // seestate
    sfx_vilsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_VILE_PAIN,    // painstate
    10,   // painchance
    sfx_vipain,   // painsound
    0,    // meleestate
    S_VILE_ATK1,    // missilestate
    S_VILE_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_vildth,   // deathsound
    15,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_vilact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_FIRE
    -1,   // doomednum
    S_FIRE1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_UNDEAD
    66,   // doomednum
    S_SKEL_STND,    // spawnstate
    300,    // spawnhealth
    S_SKEL_RUN1,    // seestate
    sfx_skesit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SKEL_PAIN,    // painstate
    100,    // painchance
    sfx_popain,   // painsound
    S_SKEL_FIST1,   // meleestate
    S_SKEL_MISS1,   // missilestate
    S_SKEL_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_skedth,   // deathsound
    10,   // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    500,    // mass
    0,    // damage
    sfx_skeact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,  // flags
    S_SKEL_RAISE1   // raisestate
  },
  
  {   // MT_TRACER
    -1,   // doomednum
    S_TRACER,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_skeatk,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TRACEEXP1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    10*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    10,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SMOKE
    -1,   // doomednum
    S_SMOKE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_FATSO
    67,   // doomednum
    S_FATT_STND,    // spawnstate
    600,    // spawnhealth
    S_FATT_RUN1,    // seestate
    sfx_mansit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_FATT_PAIN,    // painstate
    80,   // painchance
    sfx_mnpain,   // painsound
    0,    // meleestate
    S_FATT_ATK1,    // missilestate
    S_FATT_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_mandth,   // deathsound
    8,    // speed
    48*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_FATT_RAISE1   // raisestate
  },
  
  {   // MT_FATSHOT
    -1,   // doomednum
    S_FATSHOT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_FATSHOTX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    20*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags \\ killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUY
    65,   // doomednum
    S_CPOS_STND,    // spawnstate
    70,   // spawnhealth
    S_CPOS_RUN1,    // seestate
    sfx_posit2,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CPOS_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_CPOS_ATK1,    // missilestate
    S_CPOS_DIE1,    // deathstate
    S_CPOS_XDIE1,   // xdeathstate
    sfx_podth2,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_CPOS_RAISE1   // raisestate
  },
  
  {   // MT_TROOP
    3001,   // doomednum
    S_TROO_STND,    // spawnstate
    60,   // spawnhealth
    S_TROO_RUN1,    // seestate
    sfx_bgsit1,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_TROO_PAIN,    // painstate
    200,    // painchance
    sfx_popain,   // painsound
    S_TROO_ATK1,    // meleestate
    S_TROO_ATK1,    // missilestate
    S_TROO_DIE1,    // deathstate
    S_TROO_XDIE1,   // xdeathstate
    sfx_bgdth1,   // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_bgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_TROO_RAISE1   // raisestate
  },
  
  {   // MT_SERGEANT
    3002,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_SHADOWS
    58,   // doomednum
    S_SARG_STND,    // spawnstate
    150,    // spawnhealth
    S_SARG_RUN1,    // seestate
    sfx_sgtsit,   // seesound
    8,    // reactiontime
    sfx_sgtatk,   // attacksound
    S_SARG_PAIN,    // painstate
    180,    // painchance
    sfx_dmpain,   // painsound
    S_SARG_ATK1,    // meleestate
    0,    // missilestate
    S_SARG_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_sgtdth,   // deathsound
    10,   // speed
    30*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,   // flags
    S_SARG_RAISE1   // raisestate
  },
  
  {   // MT_HEAD
    3005,   // doomednum
    S_HEAD_STND,    // spawnstate
    400,    // spawnhealth
    S_HEAD_RUN1,    // seestate
    sfx_cacsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_HEAD_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_HEAD_ATK1,    // missilestate
    S_HEAD_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_cacdth,   // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_HEAD_RAISE1   // raisestate
  },
  
  {   // MT_BRUISER
    3003,   // doomednum
    S_BOSS_STND,    // spawnstate
    1000,   // spawnhealth
    S_BOSS_RUN1,    // seestate
    sfx_brssit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOSS_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOSS_ATK1,    // meleestate
    S_BOSS_ATK1,    // missilestate
    S_BOSS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_brsdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOSS_RAISE1   // raisestate
  },
  
  {   // MT_BRUISERSHOT
    -1,   // doomednum
    S_BRBALL1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRBALLX1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    15*FRACUNIT,   // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    8,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags  killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_KNIGHT
    69,   // doomednum
    S_BOS2_STND,    // spawnstate
    500,    // spawnhealth
    S_BOS2_RUN1,    // seestate
    sfx_kntsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BOS2_PAIN,    // painstate
    50,   // painchance
    sfx_dmpain,   // painsound
    S_BOS2_ATK1,    // meleestate
    S_BOS2_ATK1,    // missilestate
    S_BOS2_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_kntdth,   // deathsound
    8,    // speed
    24*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BOS2_RAISE1   // raisestate
  },

  {   // MT_SKULL
    3006,   // doomednum
    S_SKULL_STND,   // spawnstate
    100,    // spawnhealth
    S_SKULL_RUN1,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_sklatk,   // attacksound
    S_SKULL_PAIN,   // painstate
    256,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SKULL_ATK1,   // missilestate
    S_SKULL_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    8,    // speed
    16*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    50,   // mass
    3,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPIDER
    7,    // doomednum
    S_SPID_STND,    // spawnstate
    3000,   // spawnhealth
    S_SPID_RUN1,    // seestate
    sfx_spisit,   // seesound
    8,    // reactiontime
    sfx_shotgn,   // attacksound
    S_SPID_PAIN,    // painstate
    40,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_SPID_ATK1,    // missilestate
    S_SPID_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_spidth,   // deathsound
    12,   // speed
    128*FRACUNIT,   // radius
    100*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BABY
    68,   // doomednum
    S_BSPI_STND,    // spawnstate
    500,    // spawnhealth
    S_BSPI_SIGHT,   // seestate
    sfx_bspsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_BSPI_PAIN,    // painstate
    128,    // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_BSPI_ATK1,    // missilestate
    S_BSPI_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_bspdth,   // deathsound
    12,   // speed
    64*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    600,    // mass
    0,    // damage
    sfx_bspact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_BSPI_RAISE1   // raisestate
  },
  
  {   // MT_CYBORG
    16,   // doomednum
    S_CYBER_STND,   // spawnstate
    4000,   // spawnhealth
    S_CYBER_RUN1,   // seestate
    sfx_cybsit,   // seesound
    8,    // reactiontime
    0,    // attacksound
    S_CYBER_PAIN,   // painstate
    20,   // painchance
    sfx_dmpain,   // painsound
    0,    // meleestate
    S_CYBER_ATK1,   // missilestate
    S_CYBER_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_cybdth,   // deathsound
    16,   // speed
    40*FRACUNIT,    // radius
    110*FRACUNIT,   // height
    1000,   // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PAIN
    71,   // doomednum
    S_PAIN_STND,    // spawnstate
    400,    // spawnhealth
    S_PAIN_RUN1,    // seestate
    sfx_pesit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_PAIN_PAIN,    // painstate
    128,    // painchance
    sfx_pepain,   // painsound
    0,    // meleestate
    S_PAIN_ATK1,    // missilestate
    S_PAIN_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_pedth,    // deathsound
    8,    // speed
    31*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    400,    // mass
    0,    // damage
    sfx_dmact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,   // flags
    S_PAIN_RAISE1   // raisestate
  },
  
  {   // MT_WOLFSS
    84,   // doomednum
    S_SSWV_STND,    // spawnstate
    50,   // spawnhealth
    S_SSWV_RUN1,    // seestate
    sfx_sssit,    // seesound
    8,    // reactiontime
    0,    // attacksound
    S_SSWV_PAIN,    // painstate
    170,    // painchance
    sfx_popain,   // painsound
    0,    // meleestate
    S_SSWV_ATK1,    // missilestate
    S_SSWV_DIE1,    // deathstate
    S_SSWV_XDIE1,   // xdeathstate
    sfx_ssdth,    // deathsound
    8,    // speed
    20*FRACUNIT,    // radius
    56*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_posact,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,   // flags
    S_SSWV_RAISE1   // raisestate
  },
  
  {   // MT_KEEN
    72,   // doomednum
    S_KEENSTND,   // spawnstate
    100,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_KEENPAIN,   // painstate
    256,    // painchance
    sfx_keenpn,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_COMMKEEN,   // deathstate
    S_NULL,   // xdeathstate
    sfx_keendt,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    72*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSBRAIN
    88,   // doomednum
    S_BRAIN,    // spawnstate
    250,    // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_BRAIN_PAIN,   // painstate
    255,    // painchance
    sfx_bospn,    // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BRAIN_DIE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_bosdth,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    10000000,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSSPIT
    89,   // doomednum
    S_BRAINEYE,   // spawnstate
    1000,   // spawnhealth
    S_BRAINEYESEE,    // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_BOSSTARGET
    87,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    32*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNSHOT
    -1,   // doomednum
    S_SPAWN1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_bospit,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    32*FRACUNIT,    // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SPAWNFIRE
    -1,   // doomednum
    S_SPAWNFIRE1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,   // flags             // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BARREL
    2035,   // doomednum
    S_BAR1,   // spawnstate
    20,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BEXP,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    42*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TROOPSHOT
    -1,   // doomednum
    S_TBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_TBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    3,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_HEADSHOT
    -1,   // doomednum
    S_RBALL1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_firsht,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_RBALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    10*FRACUNIT,    // speed
    6*FRACUNIT,   // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_ROCKET
    -1,   // doomednum
    S_ROCKET,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_rlaunc,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_EXPLODE1,   // deathstate
    S_NULL,   // xdeathstate
    sfx_barexp,   // deathsound
    20*FRACUNIT,    // speed
    11*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    20,   // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_PLASMA
    -1,   // doomednum
    S_PLASBALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLASEXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BFG
    -1,   // doomednum
    S_BFGSHOT,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    0,    // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_BFGLAND,    // deathstate
    S_NULL,   // xdeathstate
    sfx_rxplod,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    100,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_ARACHPLAZ
    -1,   // doomednum
    S_ARACH_PLAZ,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_ARACH_PLEX,   // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    5,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_PUFF
    -1,   // doomednum
    S_PUFF1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_BLOOD
    -1,   // doomednum
    S_BLOOD1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_TFOG
    -1,   // doomednum
    S_TFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_IFOG
    -1,   // doomednum
    S_IFOG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT, // flags // phares
    S_NULL    // raisestate
  },
  
  {   // MT_TELEPORTMAN
    14,   // doomednum
    S_NULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOSECTOR,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_EXTRABFG
    -1,   // doomednum
    S_BFGEXP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC0
    2018,   // doomednum
    S_ARM1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC1
    2019,   // doomednum
    S_ARM2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC2
    2014,   // doomednum
    S_BON1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC3
    2015,   // doomednum
    S_BON2,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC4
    5,    // doomednum
    S_BKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC5
    13,   // doomednum
    S_RKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC6
    6,    // doomednum
    S_YKEY,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC7
    39,   // doomednum
    S_YSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC8
    38,   // doomednum
    S_RSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC9
    40,   // doomednum
    S_BSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_NOTDMATCH,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC10
    2011,   // doomednum
    S_STIM,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC11
    2012,   // doomednum
    S_MEDI,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC12
    2013,   // doomednum
    S_SOUL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags   // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_INV
    2022,   // doomednum
    S_PINV,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC13
    2023,   // doomednum
    S_PSTR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_INS
    2024,   // doomednum
    S_PINS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_MISC14
    2025,   // doomednum
    S_SUIT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC15
    2026,   // doomednum
    S_PMAP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC16
    2045,   // doomednum
    S_PVIS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MEGA
    83,   // doomednum
    S_MEGA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,    // flags // killough 2/21/98
    S_NULL    // raisestate
  },
  
  {   // MT_CLIP
    2007,   // doomednum
    S_CLIP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC17
    2048,   // doomednum
    S_AMMO,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC18
    2010,   // doomednum
    S_ROCK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC19
    2046,   // doomednum
    S_BROK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC20
    2047,   // doomednum
    S_CELL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC21
    17,   // doomednum
    S_CELP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC22
    2008,   // doomednum
    S_SHEL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC23
    2049,   // doomednum
    S_SBOX,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC24
    8,    // doomednum
    S_BPAK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC25
    2006,   // doomednum
    S_BFUG,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_CHAINGUN
    2002,   // doomednum
    S_MGUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC26
    2005,   // doomednum
    S_CSAW,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC27
    2003,   // doomednum
    S_LAUN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC28
    2004,   // doomednum
    S_PLAS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SHOTGUN
    2001,   // doomednum
    S_SHOT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_SUPERSHOTGUN
    82,   // doomednum
    S_SHOT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC29
    85,   // doomednum
    S_TECHLAMP,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC30
    86,   // doomednum
    S_TECH2LAMP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC31
    2028,   // doomednum
    S_COLU,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC32
    30,   // doomednum
    S_TALLGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC33
    31,   // doomednum
    S_SHRTGRNCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC34
    32,   // doomednum
    S_TALLREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC35
    33,   // doomednum
    S_SHRTREDCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC36
    37,   // doomednum
    S_SKULLCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC37
    36,   // doomednum
    S_HEARTCOL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC38
    41,   // doomednum
    S_EVILEYE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC39
    42,   // doomednum
    S_FLOATSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC40
    43,   // doomednum
    S_TORCHTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC41
    44,   // doomednum
    S_BLUETORCH,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC42
    45,   // doomednum
    S_GREENTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC43
    46,   // doomednum
    S_REDTORCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC44
    55,   // doomednum
    S_BTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC45
    56,   // doomednum
    S_GTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC46
    57,   // doomednum
    S_RTORCHSHRT,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC47
    47,   // doomednum
    S_STALAGTITE,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC48
    48,   // doomednum
    S_TECHPILLAR,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC49
    34,   // doomednum
    S_CANDLESTIK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC50
    35,   // doomednum
    S_CANDELABRA,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC51
    49,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC52
    50,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC53
    51,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC54
    52,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC55
    53,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC56
    59,   // doomednum
    S_MEAT2,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    84*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC57
    60,   // doomednum
    S_MEAT4,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC58
    61,   // doomednum
    S_MEAT3,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC59
    62,   // doomednum
    S_MEAT5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    52*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC60
    63,   // doomednum
    S_BLOODYTWITCH,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    68*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPAWNCEILING|MF_NOGRAVITY,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC61
    22,   // doomednum
    S_HEAD_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC62
    15,   // doomednum
    S_PLAY_DIE7,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC63
    18,   // doomednum
    S_POSS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC64
    21,   // doomednum
    S_SARG_DIE6,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC65
    23,   // doomednum
    S_SKULL_DIE6,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC66
    20,   // doomednum
    S_TROO_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC67
    19,   // doomednum
    S_SPOS_DIE5,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC68
    10,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC69
    12,   // doomednum
    S_PLAY_XDIE9,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC70
    28,   // doomednum
    S_HEADSONSTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC71
    24,   // doomednum
    S_GIBS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    0,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC72
    27,   // doomednum
    S_HEADONASTICK,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC73
    29,   // doomednum
    S_HEADCANDLES,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC74
    25,   // doomednum
    S_DEADSTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC75
    26,   // doomednum
    S_LIVESTICK,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC76
    54,   // doomednum
    S_BIGTREE,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    32*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC77
    70,   // doomednum
    S_BBAR1,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID,   // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC78
    73,   // doomednum
    S_HANGNOGUTS,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC79
    74,   // doomednum
    S_HANGBNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    88*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC80
    75,   // doomednum
    S_HANGTLOOKDN,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC81
    76,   // doomednum
    S_HANGTSKULL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC82
    77,   // doomednum
    S_HANGTLOOKUP,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC83
    78,   // doomednum
    S_HANGTNOBRAIN,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    16*FRACUNIT,    // radius
    64*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC84
    79,   // doomednum
    S_COLONGIBS,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC85
    80,   // doomednum
    S_SMALLPOOL,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },
  
  {   // MT_MISC86
    81,   // doomednum
    S_BRAINSTEM,    // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,    // flags
    S_NULL    // raisestate
  },

  // For use with wind and current effects
  {   // MT_PUSH                       // phares
    5001,           // doomednum       //   |      //jff 5/11/98 deconflict
    S_TNT1,         // spawnstate      //   V      // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

  // For use with wind and current effects
  {   // MT_PULL
    5002,           // doomednum                   //jff 5/11/98 deconflict            
    S_TNT1,         // spawnstate                  // with DOSDoom        
    1000,           // spawnhealth                              
    S_NULL,         // seestate                                 
    sfx_None,       // seesound                                 
    8,              // reactiontime                             
    sfx_None,       // attacksound                              
    S_NULL,         // painstate                                
    0,              // painchance                               
    sfx_None,       // painsound                                
    S_NULL,         // meleestate                               
    S_NULL,         // missilestate                             
    S_NULL,         // deathstate                               
    S_NULL,         // xdeathstate                              
    sfx_None,       // deathsound                               
    0,              // speed                                    
    8,              // radius                                   
    8,              // height                                   
    10,             // mass                                     
    0,              // damage                                   
    sfx_None,       // activesound                              
    MF_NOBLOCKMAP,  // flags
    S_NULL          // raisestate                                   
  },

  // Marine's best friend :)      // killough 7/19/98
  {   // MT_DOGS
    888,   // doomednum
    S_DOGS_STND,    // spawnstate
    500,    // spawnhealth
    S_DOGS_RUN1,    // seestate
    sfx_dgsit,   // seesound
    8,    // reactiontime
    sfx_dgatk,   // attacksound
    S_DOGS_PAIN,    // painstate
    180,    // painchance
    sfx_dgpain,   // painsound
    S_DOGS_ATK1,    // meleestate
    0,    // missilestate
    S_DOGS_DIE1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_dgdth,   // deathsound
    10,   // speed
    12*FRACUNIT,    // radius
    28*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_dgact,    // activesound
    MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
    S_DOGS_RAISE1   // raisestate
  },

  // killough 7/11/98: this is the first of two plasma fireballs in the beta
  {   // MT_PLASMA1
    -1,   // doomednum
    S_PLS1BALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLS1EXP,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    13*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    4,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_BOUNCES|MF_TRANSLUCENT, // [FG] translucent
    S_NULL    // raisestate
  },
  
  // killough 7/11/98: this is the second of two plasma fireballs in the beta
  {   // MT_PLASMA2
    -1,   // doomednum
    S_PLS2BALL,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_plasma,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_PLS2BALLX1,    // deathstate
    S_NULL,   // xdeathstate
    sfx_firxpl,   // deathsound
    25*FRACUNIT,    // speed
    6*FRACUNIT,    // radius
    8*FRACUNIT,   // height
    100,    // mass
    4,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_BOUNCES|MF_TRANSLUCENT, // [FG] translucent
    S_NULL    // raisestate
  },

  // killough 7/11/98: this is the evil sceptre in the beta version
  {   // MT_SCEPTRE
    2016,   // doomednum
    S_BON3,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    10*FRACUNIT,    // radius
    16*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },

  // killough 7/11/98: this is the unholy bible in the beta version
  {   // MT_BIBLE
    2017,   // doomednum
    S_BON4,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,   // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,   // deathsound
    0,    // speed
    20*FRACUNIT,    // radius
    10*FRACUNIT,    // height
    100,    // mass
    0,    // damage
    sfx_None,   // activesound
    MF_SPECIAL|MF_COUNTITEM,    // flags
    S_NULL    // raisestate
  },

  // [crispy] support MUSINFO lump (dynamic music changing)
  {   // MT_MUSICSOURCE
    14164,   // doomednum
    S_TNT1,   // spawnstate
    1000,   // spawnhealth
    S_NULL,   // seestate
    sfx_None,   // seesound
    8,    // reactiontime
    sfx_None,   // attacksound
    S_NULL,   // painstate
    0,    // painchance
    sfx_None,    // painsound
    S_NULL,   // meleestate
    S_NULL,   // missilestate
    S_NULL,   // deathstate
    S_NULL,   // xdeathstate
    sfx_None,    // deathsound
    0,    // speed
    16,   // radius
    16,   // height
    100,   // mass
    0,    // damage
    sfx_None,   // activesound
    MF_NOBLOCKMAP,   // flags
    S_NULL   // raisestate
  },

};


// ********************************************************************
// Predefined lumps
// ********************************************************************
// These are internally defined lumps, which can be overwritten in 
// a PWAD.  There were several things that needed these, such 
// as new menus, font characters, color maps, etc. and this
// is an easy way of incorporating them directly into the EXE rather
// than requiring that an ancillary file be carried around with it.
//
// Near the end of this section there is the actual list where the lumps
// are incorporated, and there it's easy to see explanations in context.

// killough 1/31/98: predefined lumps used to make up for wad deficiencies

//jff 02/16/98 HUD bargraph patches
// The HUD uses vertical stripe characters to make up the bars in
// view during play, and those are made up here at various stages
// of "fullness".  Note that all HUD elements can be recolored
// dynamically in the code, so only the shapes are defined here.

static const unsigned char stbr123[]=  // full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 91,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,
  176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,176,180,185,
   47,  0,255,255,
};

static const unsigned char stbr124[]=  // 3/4 full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 78,  0,  0,  0, 79,  0,  0,  0, 80,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0, 47,185,180,
  176,180,185, 47,  0,255,255,255,255,
};

static const unsigned char stbr125[]=  // half full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 65,  0,  0,  0,
   66,  0,  0,  0, 67,  0,  0,  0, 68,  0,  0,  0, 69,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,  0,  7,  0,
   47,185,180,176,180,185, 47,  0,255,255,255,255,255,255,
};

static const unsigned char stbr126[]=  // quarter full
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 52,  0,  0,  0, 53,  0,  0,  0, 54,  0,  0,  0,
   55,  0,  0,  0, 56,  0,  0,  0, 57,  0,  0,  0, 58,  0,  0,  0,
    0,  7,  0, 47,185,180,176,180,185, 47,  0,255,255,255,255,255,
  255,255,255,
};

static const unsigned char stbr127[]=  // empty block
{
    8,  0,  8,  0,  0,  0,  0,  0,
   40,  0,  0,  0, 41,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,  0,
   44,  0,  0,  0, 45,  0,  0,  0, 46,  0,  0,  0, 47,  0,  0,  0,
  255,255,255,255,255,255,255,255,
};

// The digits themselves that are used in the HUD

static const unsigned char dig0[]=  // zero
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char dig1[]=  // one
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
   67,  0,  0,  0,  5,  1,  0,176,  0,255,  1,  1,  0,176,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,176,  0,  0,255,  4,  3,  0,  0,  0,
    0,  0,255,
};

static const unsigned char dig2[]=  // two
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  1,  0,176,  0,  3,  3,  0,176,176,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,  0,176,  0,
    0,255,  2,  3,  0,  0,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const unsigned char dig3[]=  // three
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 55,  0,  0,  0, 69,  0,  0,  0,
   80,  0,  0,  0,  1,  2,  0,176,176,  0,  4,  2,  0,176,176,  0,
  255,  1,  3,  0,176,  0,  0,  0,  5,  2,  0,176,  0,  0,255,  1,
    3,  0,176,  0,176,  0,  5,  2,  0,176,  0,  0,255,  1,  6,  0,
  176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,  0,  0,  0,
    0,255,
};

static const unsigned char dig4[]=  // four
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 37,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
   67,  0,  0,  0,  1,  4,  0,176,176,176,176,  0,255,  2,  4,  0,
    0,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,176,  0,  0,  0,255,  4,  2,  0,  0,  0,
    0,255,
};

static const unsigned char dig37[] = { // percent '%'
  0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00,
  0x3e, 0x00, 0x00, 0x00, 0xff, 0x01, 0x02, 0x00, 0xb0, 0x00, 0x00, 0x04,
  0x02, 0x00, 0xb0, 0x00, 0x00, 0xff, 0x03, 0x02, 0x00, 0xb0, 0x00, 0x00,
  0xff, 0x02, 0x02, 0x00, 0xb0, 0x00, 0x00, 0x05, 0x02, 0x00, 0xb0, 0x00,
  0x00, 0xff, 0xff
};

static const unsigned char dig43[]= { // plus '+'
  0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00,
  0x33, 0x00, 0x00, 0x00, 0xff, 0x03, 0x01, 0x00, 0xb0, 0x00, 0xff, 0x02,
  0x03, 0x00, 0xb0, 0xb0, 0xb0, 0x00, 0xff, 0x03, 0x03, 0x00, 0xb0, 0x00,
  0x00, 0x00, 0xff, 0x04, 0x01, 0x00, 0x00, 0x00, 0xff
};

static const unsigned char dig45[]=  // minus '-'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 35,  0,  0,  0, 42,  0,  0,  0,
   49,  0,  0,  0,255,  3,  1,  0,176,  0,255,  3,  2,  0,176,  0,
    0,255,  3,  2,  0,176,  0,  0,255,  4,  1,  0,  0,  0,255,
};

static const unsigned char dig46[] = { // '.'
  0x05, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
  0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00,
  0x26, 0x00, 0x00, 0x00, 0xff, 0xff, 0x05, 0x02, 0x00, 0xb0, 0x00, 0x00,
  0xff, 0xff, 0xff
};

static const unsigned char dig47[]=  // slash '/'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 36,  0,  0,  0, 43,  0,  0,  0,
   50,  0,  0,  0,255,  4,  2,  0,176,  0,  0,255,  3,  2,  0,176,
    0,  0,255,  2,  2,  0,176,  0,  0,255,255,
};

static const unsigned char dig5[]=  // five
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char dig58[]=  // colon ':'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 30,  0,  0,  0, 41,  0,  0,  0,
   52,  0,  0,  0,255,255,  2,  1,  0,176,  0,  4,  1,  0,176,  0,
  255,  3,  1,  0,  0,  0,  5,  1,  0,  0,  0,255,255,
};

static const unsigned char dig6[]=  // six
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char dig7[]=  // seven
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,  1,  1,  0,176,  0,255,  1,  2,  0,176,  0,  0,
  255,  1,  5,  0,176,  0,176,176,176,  0,255,  1,  6,  0,176,176,
    0,  0,  0,  0,  0,255,  2,  2,  0,  0,  0,  0,255,
};

static const unsigned char dig8[]=  // eight
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char dig9[]=  // nine
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char dig91[]=  // open bracket '['
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 39,  0,  0,  0, 50,  0,  0,  0,
   61,  0,  0,  0,255,  1,  5,  0,176,176,176,176,176,  0,255,  1,
    6,  0,176,  0,  0,  0,176,  0,  0,255,  2,  1,  0,  0,  0,  6,
    1,  0,  0,  0,255,255,
};

static const unsigned char dig93[]=  // close bracket ']'
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
   61,  0,  0,  0,255,  1,  1,  0,176,  0,  5,  1,  0,176,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,
    0,  0,  0,  0,255,255,
};

static const unsigned char diga[]=  // these are the letters A-Z
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   68,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,
    0,  0,  0,  0,  0,255,
};

static const unsigned char digb[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   70,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,176,176,  0,
  176,  0,  0,255,  2,  5,  0,  0,176,176,176,  0,  0,255,  3,  4,
    0,  0,  0,  0,  0,  0,255,
};

static const unsigned char digc[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   75,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,  2,  0,176,
    0,  0,255,  2,  1,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const unsigned char digd[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   72,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  2,  5,  0,176,176,176,  0,  0,  0,255,
    3,  3,  0,  0,  0,  0,  0,255,
};

static const unsigned char dige[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 60,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,  0,
  176,  0,  0,255,  1,  2,  0,176,  0,  0,  4,  3,  0,  0,176,  0,
    0,255,  2,  1,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const unsigned char digf[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   70,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  2,  0,176,  0,  0,  4,  1,  0,  0,  0,255,  2,  1,
    0,  0,  0,255,
};

static const unsigned char digg[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  3,  0,176,  0,176,  0,
    5,  2,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  1,  0,  0,  0,  4,  3,  0,  0,  0,  0,  0,255,
};

static const unsigned char digh[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   65,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,176,  0,  0,  0,  0,255,  3,  2,  0,176,  0,  0,255,  1,
    5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,  0,
    0,  0,255,
};

static const unsigned char digi[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 29,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,255,  1,  1,  0,176,  0,  5,  1,  0,176,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  1,  6,  0,176,  0,
    0,  0,176,  0,  0,255,  5,  2,  0,  0,  0,  0,255,
};

static const unsigned char digj[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 40,  0,  0,  0, 53,  0,  0,  0, 64,  0,  0,  0,
   75,  0,  0,  0,  1,  1,  0,176,  0,  4,  2,  0,176,176,  0,255,
    1,  2,  0,176,  0,  0,  5,  2,  0,176,  0,  0,255,  1,  6,  0,
  176,176,176,176,176,  0,  0,255,  1,  6,  0,176,  0,  0,  0,  0,
    0,  0,255,  2,  1,  0,  0,  0,255,
};

static const unsigned char digk[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 57,  0,  0,  0,
   68,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,176,176,  0,  0,
  255,  1,  6,  0,176,  0,176,176,176,  0,  0,255,  2,  1,  0,  0,
    0,  4,  3,  0,  0,  0,  0,  0,255,
};

static const unsigned char digl[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   62,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,  0,  0,176,  0,  0,255,  5,  2,  0,176,  0,  0,255,  5,
    2,  0,176,  0,  0,255,  6,  1,  0,  0,  0,255,
};

static const unsigned char digm[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 56,  0,  0,  0,
   66,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,176,176,  0,  0,  0,  0,255,  2,  3,  0,176,176,  0,  0,255,
    1,  5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,
    0,  0,  0,255,
};

static const unsigned char dign[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   65,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,176,176,  0,  0,  0,  0,255,  3,  2,  0,176,176,  0,255,  1,
    5,  0,176,176,176,176,176,  0,255,  2,  5,  0,  0,  0,  0,  0,
    0,  0,255,
};

static const unsigned char digo[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,  0,176,  0,  0,255,  1,  2,  0,176,  0,  0,  5,
    2,  0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,
  255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char digp[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,  0,176,  0,
    0,255,  1,  4,  0,176,176,176,  0,  0,255,  2,  3,  0,  0,  0,
    0,  0,255,
};

static const unsigned char digq[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,  0,176,176,  0,  0,255,  1,  2,  0,176,  0,  0,  4,
    3,  0,  0,176,176,  0,255,  1,  6,  0,176,176,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char digr[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 49,  0,  0,  0, 58,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,
    0,176,  0,176,  0,  0,  0,  0,255,  1,  4,  0,176,176,176,  0,
    0,255,  2,  4,  0,  0,176,176,176,  0,255,  3,  4,  0,  0,  0,
    0,  0,  0,255,
};

static const unsigned char digs[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 52,  0,  0,  0, 63,  0,  0,  0,
   74,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  1,  0,176,  0,
  255,  1,  6,  0,176,  0,176,  0,176,  0,  0,255,  1,  6,  0,176,
    0,176,  0,176,  0,  0,255,  1,  6,  0,176,  0,176,176,176,  0,
    0,255,  2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char digt[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 34,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0,
   62,  0,  0,  0,  1,  1,  0,176,  0,255,  1,  2,  0,176,  0,  0,
  255,  1,  5,  0,176,176,176,176,176,  0,255,  1,  6,  0,176,  0,
    0,  0,  0,  0,  0,255,  2,  1,  0,  0,  0,255,
};

static const unsigned char digu[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 48,  0,  0,  0, 55,  0,  0,  0,
   66,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  2,  5,
    0,  0,  0,  0,176,  0,  0,255,  5,  2,  0,176,  0,  0,255,  1,
    6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,  0,
    0,  0,  0,255,
};

static const unsigned char digv[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 36,  0,  0,  0, 45,  0,  0,  0, 53,  0,  0,  0,
   64,  0,  0,  0,  1,  3,  0,176,176,176,  0,255,  2,  4,  0,  0,
    0,176,176,  0,255,  4,  3,  0,176,176,  0,  0,255,  1,  6,  0,
  176,176,176,  0,  0,  0,  0,255,  2,  3,  0,  0,  0,  0,  0,255,
};

static const unsigned char digw[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 38,  0,  0,  0, 47,  0,  0,  0, 56,  0,  0,  0,
   67,  0,  0,  0,  1,  5,  0,176,176,176,176,176,  0,255,  3,  4,
    0,176,176,  0,  0,  0,255,  3,  4,  0,176,176,  0,  0,  0,255,
    1,  6,  0,176,176,176,176,176,  0,  0,255,  2,  5,  0,  0,  0,
    0,  0,  0,  0,255,
};

static const unsigned char digx[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 41,  0,  0,  0, 51,  0,  0,  0, 60,  0,  0,  0,
   71,  0,  0,  0,  1,  2,  0,176,176,  0,  4,  2,  0,176,176,  0,
  255,  2,  5,  0,176,176,176,  0,  0,  0,255,  2,  4,  0,176,176,
  176,  0,  0,255,  1,  6,  0,176,176,  0,176,176,  0,  0,255,  2,
    5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char digy[]=
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 42,  0,  0,  0, 52,  0,  0,  0, 61,  0,  0,  0,
   72,  0,  0,  0,  1,  3,  0,176,176,176,  0,  5,  2,  0,176,  0,
    0,255,  2,  5,  0,  0,176,  0,176,  0,  0,255,  3,  4,  0,176,
    0,176,  0,  0,255,  1,  6,  0,176,176,176,176,176,  0,  0,255,
    2,  5,  0,  0,  0,  0,  0,  0,  0,255,
};

static const unsigned char digz[]=  // end of letters A-Z
{
    5,  0,  7,  0,  0,  0,  0,  0,
   28,  0,  0,  0, 40,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   73,  0,  0,  0,  1,  1,  0,176,  0,  4,  2,  0,176,176,  0,255,
    1,  6,  0,176,  0,176,176,176,  0,  0,255,  1,  6,  0,176,176,
  176,  0,176,  0,  0,255,  1,  6,  0,176,176,  0,  0,176,  0,  0,
  255,  2,  2,  0,  0,  0,  0,  6,  1,  0,  0,  0,255,
};

static const unsigned char stkeys6[]=  // show both blue keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,198,
  200,  0,255,  0,  3,  0,198,202,203,  0,255,  0,  6,  0,198,  0,
  202,204,199,197,  0,255,  0,  7,  0,198,202,202,198,207,199,203,
    0,255,  0,  7,  0,200,  0,201,199,200,207,202,  0,255,  2,  5,
    0,202,199,207,199,202,  0,255,  3,  3,  0,204,199,197,  0,255,
};

static const unsigned char stkeys7[]=  // show both yellow keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,161,
  161,  0,255,  0,  3,  0,161,163,163,  0,255,  0,  6,  0,161,  0,
  163,220,162,235,  0,255,  0,  7,  0,161,163,217,162,246,214,221,
    0,255,  0,  7,  0,161,  0,214,213,214,246,218,  0,255,  2,  5,
    0,217,162,246,214,221,  0,255,  3,  3,  0,220,162,235,  0,255,
};

static const unsigned char stkeys8[]=  // show both red keys on stat bar
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 43,  0,  0,  0, 51,  0,  0,  0, 62,  0,  0,  0,
   74,  0,  0,  0, 86,  0,  0,  0, 96,  0,  0,  0,  1,  2,  0,174,
  176,  0,255,  0,  3,  0,174,179,179,  0,255,  0,  6,  0,176,  0,
  179,184,174,174,  0,255,  0,  7,  0,176,179,185,175,246,185,182,
    0,255,  0,  7,  0,176,  0,183,177,176,246,179,  0,255,  2,  5,
    0,185,177,246,185,182,  0,255,  3,  3,  0,185,175,174,  0,255,
};

// An invisible sprite, used for the TNT1 sprite for point wind
static const unsigned char invis_sprite[]=
{
    1,  0,  1,  0,  0,  0,  0,  0,
   12,  0,  0,  0,255,
};

// A new setup menu was added in BOOM, and the various menu graphic
// text strings etc. are included here.

// phares 3/31/98
//
// Lumps for menus

static const unsigned char m_colors[]=  // Palette for color selection
{
  137,  0,137,  0,  0,  0,  0,  0,
   44,  2,  0,  0,186,  2,  0,  0, 72,  3,  0,  0,214,  3,  0,  0,
  100,  4,  0,  0,242,  4,  0,  0,128,  5,  0,  0, 14,  6,  0,  0,
  156,  6,  0,  0, 42,  7,  0,  0,184,  7,  0,  0, 70,  8,  0,  0,
  212,  8,  0,  0, 98,  9,  0,  0,240,  9,  0,  0,126, 10,  0,  0,
   12, 11,  0,  0,154, 11,  0,  0, 40, 12,  0,  0,182, 12,  0,  0,
   68, 13,  0,  0,210, 13,  0,  0, 96, 14,  0,  0,238, 14,  0,  0,
  124, 15,  0,  0, 10, 16,  0,  0,152, 16,  0,  0, 38, 17,  0,  0,
  180, 17,  0,  0, 66, 18,  0,  0,208, 18,  0,  0, 94, 19,  0,  0,
  236, 19,  0,  0,122, 20,  0,  0,  8, 21,  0,  0,150, 21,  0,  0,
   36, 22,  0,  0,178, 22,  0,  0, 64, 23,  0,  0,206, 23,  0,  0,
   92, 24,  0,  0,234, 24,  0,  0,120, 25,  0,  0,  6, 26,  0,  0,
  148, 26,  0,  0, 34, 27,  0,  0,176, 27,  0,  0, 62, 28,  0,  0,
  204, 28,  0,  0, 90, 29,  0,  0,232, 29,  0,  0,118, 30,  0,  0,
    4, 31,  0,  0,146, 31,  0,  0, 32, 32,  0,  0,174, 32,  0,  0,
   60, 33,  0,  0,202, 33,  0,  0, 88, 34,  0,  0,230, 34,  0,  0,
  116, 35,  0,  0,  2, 36,  0,  0,144, 36,  0,  0, 30, 37,  0,  0,
  172, 37,  0,  0, 58, 38,  0,  0,200, 38,  0,  0, 86, 39,  0,  0,
  228, 39,  0,  0,114, 40,  0,  0,  0, 41,  0,  0,142, 41,  0,  0,
   28, 42,  0,  0,170, 42,  0,  0, 56, 43,  0,  0,198, 43,  0,  0,
   84, 44,  0,  0,226, 44,  0,  0,112, 45,  0,  0,254, 45,  0,  0,
  140, 46,  0,  0, 26, 47,  0,  0,168, 47,  0,  0, 54, 48,  0,  0,
  196, 48,  0,  0, 82, 49,  0,  0,224, 49,  0,  0,110, 50,  0,  0,
  252, 50,  0,  0,138, 51,  0,  0, 24, 52,  0,  0,166, 52,  0,  0,
   52, 53,  0,  0,194, 53,  0,  0, 80, 54,  0,  0,222, 54,  0,  0,
  108, 55,  0,  0,250, 55,  0,  0,136, 56,  0,  0, 22, 57,  0,  0,
  164, 57,  0,  0, 50, 58,  0,  0,192, 58,  0,  0, 78, 59,  0,  0,
  220, 59,  0,  0,106, 60,  0,  0,248, 60,  0,  0,134, 61,  0,  0,
   20, 62,  0,  0,162, 62,  0,  0, 48, 63,  0,  0,190, 63,  0,  0,
   76, 64,  0,  0,218, 64,  0,  0,104, 65,  0,  0,246, 65,  0,  0,
  132, 66,  0,  0, 18, 67,  0,  0,160, 67,  0,  0, 46, 68,  0,  0,
  188, 68,  0,  0, 74, 69,  0,  0,216, 69,  0,  0,102, 70,  0,  0,
  244, 70,  0,  0,130, 71,  0,  0, 16, 72,  0,  0,158, 72,  0,  0,
   44, 73,  0,  0,186, 73,  0,  0, 72, 74,  0,  0,214, 74,  0,  0,
  100, 75,  0,  0,242, 75,  0,  0,128, 76,  0,  0, 14, 77,  0,  0,
  156, 77,  0,  0,  0,137,  0, 91, 91, 91, 94, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 98,
    0,255,  0,137,  0, 91, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,105,  0,255,
    0,137,  0, 91, 98,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105, 94, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  4,  0,  0,  0,  0,  0,  4,  0, 16, 16, 16, 16, 16, 16,
   16,  0, 32, 32, 32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48,
   48,  0, 64, 64, 64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80,
   80,  0, 96, 96, 96, 96, 96, 96, 96,  0,112,112,112,112,112,112,
  112,  0,128,128,128,128,128,128,128,  0,144,144,144,144,144,144,
  144,  0,160,160,160,160,160,160,160,  0,176,176,176,176,176,176,
  176,  0,192,192,192,192,192,192,192,  0,255,255,255,255,255,255,
  255,  0,255,255,255,255,255,255,255,  0,207,207,207,207,207,207,
  207,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    0,  4,  0,  0,  0,  4,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0,
   32, 32, 32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0,
   64, 64, 64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0,
   96, 96, 96, 96, 96, 96, 96,  0,112,112,112,112,112,112,112,  0,
  128,128,128,128,128,128,128,  0,144,144,144,144,144,144,144,  0,
  160,160,160,160,160,160,160,  0,176,176,176,176,176,176,176,  0,
  192,192,192,192,192,192,192,  0,255,255,255,255,255,255,255,  0,
  255,255,255,255,255,255,255,  0,207,207,207,207,207,207,207,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,
    4,  0,  4,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32,
   32, 32, 32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64,
   64, 64, 64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96,
   96, 96, 96, 96, 96,  0,112,112,112,112,112,112,112,  0,128,128,
  128,128,128,128,128,  0,144,144,144,144,144,144,144,  0,160,160,
  160,160,160,160,160,  0,176,176,176,176,176,176,176,  0,192,192,
  192,192,192,192,192,  0,255,255,255,255,255,255,255,  0,255,255,
  255,255,255,255,255,  0,207,207,207,207,207,207,207,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,  0,  4,
    0,  0,  0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32,
   32, 32, 32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64,
   64, 64, 64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96,
   96, 96, 96,  0,112,112,112,112,112,112,112,  0,128,128,128,128,
  128,128,128,  0,144,144,144,144,144,144,144,  0,160,160,160,160,
  160,160,160,  0,176,176,176,176,176,176,176,  0,192,192,192,192,
  192,192,192,  0,255,255,255,255,255,255,255,  0,255,255,255,255,
  255,255,255,  0,207,207,207,207,207,207,207,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  0,  0,  4,  0,  4,  0,
    0,  0, 16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32,
   32,  0, 48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64,
   64,  0, 80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96,
   96,  0,112,112,112,112,112,112,112,  0,128,128,128,128,128,128,
  128,  0,144,144,144,144,144,144,144,  0,160,160,160,160,160,160,
  160,  0,176,176,176,176,176,176,176,  0,192,192,192,192,192,192,
  192,  0,255,255,255,255,255,255,255,  0,255,255,255,255,255,255,
  255,  0,207,207,207,207,207,207,207,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,
   16, 16, 16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32, 32,  0,
   48, 48, 48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64, 64,  0,
   80, 80, 80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96, 96,  0,
  112,112,112,112,112,112,112,  0,128,128,128,128,128,128,128,  0,
  144,144,144,144,144,144,144,  0,160,160,160,160,160,160,160,  0,
  176,176,176,176,176,176,176,  0,192,192,192,192,192,192,192,  0,
  255,255,255,255,255,255,255,  0,255,255,255,255,255,255,255,  0,
  207,207,207,207,207,207,207,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  4,  0,  0,  0,  0,  0,  4,  0, 16, 16,
   16, 16, 16, 16, 16,  0, 32, 32, 32, 32, 32, 32, 32,  0, 48, 48,
   48, 48, 48, 48, 48,  0, 64, 64, 64, 64, 64, 64, 64,  0, 80, 80,
   80, 80, 80, 80, 80,  0, 96, 96, 96, 96, 96, 96, 96,  0,112,112,
  112,112,112,112,112,  0,128,128,128,128,128,128,128,  0,144,144,
  144,144,144,144,144,  0,160,160,160,160,160,160,160,  0,176,176,
  176,176,176,176,176,  0,192,192,192,192,192,192,192,  0,255,255,
  255,255,255,255,255,  0,255,255,255,255,255,255,255,  0,207,207,
  207,207,207,207,207,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  1,  1,  1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17,
   17,  0, 33, 33, 33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49,
   49,  0, 65, 65, 65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81,
   81,  0, 97, 97, 97, 97, 97, 97, 97,  0,113,113,113,113,113,113,
  113,  0,129,129,129,129,129,129,129,  0,145,145,145,145,145,145,
  145,  0,161,161,161,161,161,161,161,  0,177,177,177,177,177,177,
  177,  0,193,193,193,193,193,193,193,  0,209,209,209,209,209,209,
  209,  0,225,225,225,225,225,225,225,  0,241,241,241,241,241,241,
  241,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    1,  1,  1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0,
   33, 33, 33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0,
   65, 65, 65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0,
   97, 97, 97, 97, 97, 97, 97,  0,113,113,113,113,113,113,113,  0,
  129,129,129,129,129,129,129,  0,145,145,145,145,145,145,145,  0,
  161,161,161,161,161,161,161,  0,177,177,177,177,177,177,177,  0,
  193,193,193,193,193,193,193,  0,209,209,209,209,209,209,209,  0,
  225,225,225,225,225,225,225,  0,241,241,241,241,241,241,241,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,
    1,  1,  1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33,
   33, 33, 33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65,
   65, 65, 65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97,
   97, 97, 97, 97, 97,  0,113,113,113,113,113,113,113,  0,129,129,
  129,129,129,129,129,  0,145,145,145,145,145,145,145,  0,161,161,
  161,161,161,161,161,  0,177,177,177,177,177,177,177,  0,193,193,
  193,193,193,193,193,  0,209,209,209,209,209,209,209,  0,225,225,
  225,225,225,225,225,  0,241,241,241,241,241,241,241,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,
    1,  1,  1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33,
   33, 33, 33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65,
   65, 65, 65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97,
   97, 97, 97,  0,113,113,113,113,113,113,113,  0,129,129,129,129,
  129,129,129,  0,145,145,145,145,145,145,145,  0,161,161,161,161,
  161,161,161,  0,177,177,177,177,177,177,177,  0,193,193,193,193,
  193,193,193,  0,209,209,209,209,209,209,209,  0,225,225,225,225,
  225,225,225,  0,241,241,241,241,241,241,241,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,
    1,  0, 17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33,
   33,  0, 49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65,
   65,  0, 81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97,
   97,  0,113,113,113,113,113,113,113,  0,129,129,129,129,129,129,
  129,  0,145,145,145,145,145,145,145,  0,161,161,161,161,161,161,
  161,  0,177,177,177,177,177,177,177,  0,193,193,193,193,193,193,
  193,  0,209,209,209,209,209,209,209,  0,225,225,225,225,225,225,
  225,  0,241,241,241,241,241,241,241,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0,
   17, 17, 17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33, 33,  0,
   49, 49, 49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65, 65,  0,
   81, 81, 81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97, 97,  0,
  113,113,113,113,113,113,113,  0,129,129,129,129,129,129,129,  0,
  145,145,145,145,145,145,145,  0,161,161,161,161,161,161,161,  0,
  177,177,177,177,177,177,177,  0,193,193,193,193,193,193,193,  0,
  209,209,209,209,209,209,209,  0,225,225,225,225,225,225,225,  0,
  241,241,241,241,241,241,241,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  1,  1,  1,  1,  1,  1,  1,  0, 17, 17,
   17, 17, 17, 17, 17,  0, 33, 33, 33, 33, 33, 33, 33,  0, 49, 49,
   49, 49, 49, 49, 49,  0, 65, 65, 65, 65, 65, 65, 65,  0, 81, 81,
   81, 81, 81, 81, 81,  0, 97, 97, 97, 97, 97, 97, 97,  0,113,113,
  113,113,113,113,113,  0,129,129,129,129,129,129,129,  0,145,145,
  145,145,145,145,145,  0,161,161,161,161,161,161,161,  0,177,177,
  177,177,177,177,177,  0,193,193,193,193,193,193,193,  0,209,209,
  209,209,209,209,209,  0,225,225,225,225,225,225,225,  0,241,241,
  241,241,241,241,241,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  2,  2,  2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18,
   18,  0, 34, 34, 34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50,
   50,  0, 66, 66, 66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82,
   82,  0, 98, 98, 98, 98, 98, 98, 98,  0,114,114,114,114,114,114,
  114,  0,130,130,130,130,130,130,130,  0,146,146,146,146,146,146,
  146,  0,162,162,162,162,162,162,162,  0,178,178,178,178,178,178,
  178,  0,194,194,194,194,194,194,194,  0,210,210,210,210,210,210,
  210,  0,226,226,226,226,226,226,226,  0,242,242,242,242,242,242,
  242,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    2,  2,  2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0,
   34, 34, 34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0,
   66, 66, 66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0,
   98, 98, 98, 98, 98, 98, 98,  0,114,114,114,114,114,114,114,  0,
  130,130,130,130,130,130,130,  0,146,146,146,146,146,146,146,  0,
  162,162,162,162,162,162,162,  0,178,178,178,178,178,178,178,  0,
  194,194,194,194,194,194,194,  0,210,210,210,210,210,210,210,  0,
  226,226,226,226,226,226,226,  0,242,242,242,242,242,242,242,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,
    2,  2,  2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34,
   34, 34, 34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66,
   66, 66, 66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98,
   98, 98, 98, 98, 98,  0,114,114,114,114,114,114,114,  0,130,130,
  130,130,130,130,130,  0,146,146,146,146,146,146,146,  0,162,162,
  162,162,162,162,162,  0,178,178,178,178,178,178,178,  0,194,194,
  194,194,194,194,194,  0,210,210,210,210,210,210,210,  0,226,226,
  226,226,226,226,226,  0,242,242,242,242,242,242,242,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,
    2,  2,  2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34,
   34, 34, 34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66,
   66, 66, 66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98,
   98, 98, 98,  0,114,114,114,114,114,114,114,  0,130,130,130,130,
  130,130,130,  0,146,146,146,146,146,146,146,  0,162,162,162,162,
  162,162,162,  0,178,178,178,178,178,178,178,  0,194,194,194,194,
  194,194,194,  0,210,210,210,210,210,210,210,  0,226,226,226,226,
  226,226,226,  0,242,242,242,242,242,242,242,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,
    2,  0, 18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34,
   34,  0, 50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66,
   66,  0, 82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98,
   98,  0,114,114,114,114,114,114,114,  0,130,130,130,130,130,130,
  130,  0,146,146,146,146,146,146,146,  0,162,162,162,162,162,162,
  162,  0,178,178,178,178,178,178,178,  0,194,194,194,194,194,194,
  194,  0,210,210,210,210,210,210,210,  0,226,226,226,226,226,226,
  226,  0,242,242,242,242,242,242,242,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0,
   18, 18, 18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34, 34,  0,
   50, 50, 50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66, 66,  0,
   82, 82, 82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98, 98,  0,
  114,114,114,114,114,114,114,  0,130,130,130,130,130,130,130,  0,
  146,146,146,146,146,146,146,  0,162,162,162,162,162,162,162,  0,
  178,178,178,178,178,178,178,  0,194,194,194,194,194,194,194,  0,
  210,210,210,210,210,210,210,  0,226,226,226,226,226,226,226,  0,
  242,242,242,242,242,242,242,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  2,  2,  2,  2,  2,  2,  2,  0, 18, 18,
   18, 18, 18, 18, 18,  0, 34, 34, 34, 34, 34, 34, 34,  0, 50, 50,
   50, 50, 50, 50, 50,  0, 66, 66, 66, 66, 66, 66, 66,  0, 82, 82,
   82, 82, 82, 82, 82,  0, 98, 98, 98, 98, 98, 98, 98,  0,114,114,
  114,114,114,114,114,  0,130,130,130,130,130,130,130,  0,146,146,
  146,146,146,146,146,  0,162,162,162,162,162,162,162,  0,178,178,
  178,178,178,178,178,  0,194,194,194,194,194,194,194,  0,210,210,
  210,210,210,210,210,  0,226,226,226,226,226,226,226,  0,242,242,
  242,242,242,242,242,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  3,  3,  3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19,
   19,  0, 35, 35, 35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51,
   51,  0, 67, 67, 67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83,
   83,  0, 99, 99, 99, 99, 99, 99, 99,  0,115,115,115,115,115,115,
  115,  0,131,131,131,131,131,131,131,  0,147,147,147,147,147,147,
  147,  0,163,163,163,163,163,163,163,  0,179,179,179,179,179,179,
  179,  0,195,195,195,195,195,195,195,  0,211,211,211,211,211,211,
  211,  0,227,227,227,227,227,227,227,  0,243,243,243,243,243,243,
  243,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    3,  3,  3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0,
   35, 35, 35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0,
   67, 67, 67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0,
   99, 99, 99, 99, 99, 99, 99,  0,115,115,115,115,115,115,115,  0,
  131,131,131,131,131,131,131,  0,147,147,147,147,147,147,147,  0,
  163,163,163,163,163,163,163,  0,179,179,179,179,179,179,179,  0,
  195,195,195,195,195,195,195,  0,211,211,211,211,211,211,211,  0,
  227,227,227,227,227,227,227,  0,243,243,243,243,243,243,243,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,
    3,  3,  3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35,
   35, 35, 35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67,
   67, 67, 67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99,
   99, 99, 99, 99, 99,  0,115,115,115,115,115,115,115,  0,131,131,
  131,131,131,131,131,  0,147,147,147,147,147,147,147,  0,163,163,
  163,163,163,163,163,  0,179,179,179,179,179,179,179,  0,195,195,
  195,195,195,195,195,  0,211,211,211,211,211,211,211,  0,227,227,
  227,227,227,227,227,  0,243,243,243,243,243,243,243,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,
    3,  3,  3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35,
   35, 35, 35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67,
   67, 67, 67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99,
   99, 99, 99,  0,115,115,115,115,115,115,115,  0,131,131,131,131,
  131,131,131,  0,147,147,147,147,147,147,147,  0,163,163,163,163,
  163,163,163,  0,179,179,179,179,179,179,179,  0,195,195,195,195,
  195,195,195,  0,211,211,211,211,211,211,211,  0,227,227,227,227,
  227,227,227,  0,243,243,243,243,243,243,243,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,
    3,  0, 19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35,
   35,  0, 51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67,
   67,  0, 83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99,
   99,  0,115,115,115,115,115,115,115,  0,131,131,131,131,131,131,
  131,  0,147,147,147,147,147,147,147,  0,163,163,163,163,163,163,
  163,  0,179,179,179,179,179,179,179,  0,195,195,195,195,195,195,
  195,  0,211,211,211,211,211,211,211,  0,227,227,227,227,227,227,
  227,  0,243,243,243,243,243,243,243,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0,
   19, 19, 19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35, 35,  0,
   51, 51, 51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67, 67,  0,
   83, 83, 83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99, 99,  0,
  115,115,115,115,115,115,115,  0,131,131,131,131,131,131,131,  0,
  147,147,147,147,147,147,147,  0,163,163,163,163,163,163,163,  0,
  179,179,179,179,179,179,179,  0,195,195,195,195,195,195,195,  0,
  211,211,211,211,211,211,211,  0,227,227,227,227,227,227,227,  0,
  243,243,243,243,243,243,243,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  3,  3,  3,  3,  3,  3,  3,  0, 19, 19,
   19, 19, 19, 19, 19,  0, 35, 35, 35, 35, 35, 35, 35,  0, 51, 51,
   51, 51, 51, 51, 51,  0, 67, 67, 67, 67, 67, 67, 67,  0, 83, 83,
   83, 83, 83, 83, 83,  0, 99, 99, 99, 99, 99, 99, 99,  0,115,115,
  115,115,115,115,115,  0,131,131,131,131,131,131,131,  0,147,147,
  147,147,147,147,147,  0,163,163,163,163,163,163,163,  0,179,179,
  179,179,179,179,179,  0,195,195,195,195,195,195,195,  0,211,211,
  211,211,211,211,211,  0,227,227,227,227,227,227,227,  0,243,243,
  243,243,243,243,243,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  4,  4,  4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20,
   20,  0, 36, 36, 36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52,
   52,  0, 68, 68, 68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84,
   84,  0,100,100,100,100,100,100,100,  0,116,116,116,116,116,116,
  116,  0,132,132,132,132,132,132,132,  0,148,148,148,148,148,148,
  148,  0,164,164,164,164,164,164,164,  0,180,180,180,180,180,180,
  180,  0,196,196,196,196,196,196,196,  0,212,212,212,212,212,212,
  212,  0,228,228,228,228,228,228,228,  0,244,244,244,244,244,244,
  244,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    4,  4,  4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0,
   36, 36, 36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0,
   68, 68, 68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,
  100,100,100,100,100,100,100,  0,116,116,116,116,116,116,116,  0,
  132,132,132,132,132,132,132,  0,148,148,148,148,148,148,148,  0,
  164,164,164,164,164,164,164,  0,180,180,180,180,180,180,180,  0,
  196,196,196,196,196,196,196,  0,212,212,212,212,212,212,212,  0,
  228,228,228,228,228,228,228,  0,244,244,244,244,244,244,244,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,
    4,  4,  4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36,
   36, 36, 36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68,
   68, 68, 68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,
  100,100,100,100,100,  0,116,116,116,116,116,116,116,  0,132,132,
  132,132,132,132,132,  0,148,148,148,148,148,148,148,  0,164,164,
  164,164,164,164,164,  0,180,180,180,180,180,180,180,  0,196,196,
  196,196,196,196,196,  0,212,212,212,212,212,212,212,  0,228,228,
  228,228,228,228,228,  0,244,244,244,244,244,244,244,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,
    4,  4,  4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36,
   36, 36, 36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68,
   68, 68, 68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,
  100,100,100,  0,116,116,116,116,116,116,116,  0,132,132,132,132,
  132,132,132,  0,148,148,148,148,148,148,148,  0,164,164,164,164,
  164,164,164,  0,180,180,180,180,180,180,180,  0,196,196,196,196,
  196,196,196,  0,212,212,212,212,212,212,212,  0,228,228,228,228,
  228,228,228,  0,244,244,244,244,244,244,244,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,
    4,  0, 20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36,
   36,  0, 52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68,
   68,  0, 84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,100,100,
  100,  0,116,116,116,116,116,116,116,  0,132,132,132,132,132,132,
  132,  0,148,148,148,148,148,148,148,  0,164,164,164,164,164,164,
  164,  0,180,180,180,180,180,180,180,  0,196,196,196,196,196,196,
  196,  0,212,212,212,212,212,212,212,  0,228,228,228,228,228,228,
  228,  0,244,244,244,244,244,244,244,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,  4,  0,
   20, 20, 20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36, 36,  0,
   52, 52, 52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68, 68,  0,
   84, 84, 84, 84, 84, 84, 84,  0,100,100,100,100,100,100,100,  0,
  116,116,116,116,116,116,116,  0,132,132,132,132,132,132,132,  0,
  148,148,148,148,148,148,148,  0,164,164,164,164,164,164,164,  0,
  180,180,180,180,180,180,180,  0,196,196,196,196,196,196,196,  0,
  212,212,212,212,212,212,212,  0,228,228,228,228,228,228,228,  0,
  244,244,244,244,244,244,244,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  4,  4,  4,  4,  4,  4,  4,  0, 20, 20,
   20, 20, 20, 20, 20,  0, 36, 36, 36, 36, 36, 36, 36,  0, 52, 52,
   52, 52, 52, 52, 52,  0, 68, 68, 68, 68, 68, 68, 68,  0, 84, 84,
   84, 84, 84, 84, 84,  0,100,100,100,100,100,100,100,  0,116,116,
  116,116,116,116,116,  0,132,132,132,132,132,132,132,  0,148,148,
  148,148,148,148,148,  0,164,164,164,164,164,164,164,  0,180,180,
  180,180,180,180,180,  0,196,196,196,196,196,196,196,  0,212,212,
  212,212,212,212,212,  0,228,228,228,228,228,228,228,  0,244,244,
  244,244,244,244,244,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  5,  5,  5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21,
   21,  0, 37, 37, 37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53,
   53,  0, 69, 69, 69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85,
   85,  0,101,101,101,101,101,101,101,  0,117,117,117,117,117,117,
  117,  0,133,133,133,133,133,133,133,  0,149,149,149,149,149,149,
  149,  0,165,165,165,165,165,165,165,  0,181,181,181,181,181,181,
  181,  0,197,197,197,197,197,197,197,  0,213,213,213,213,213,213,
  213,  0,229,229,229,229,229,229,229,  0,245,245,245,245,245,245,
  245,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    5,  5,  5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0,
   37, 37, 37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0,
   69, 69, 69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,
  101,101,101,101,101,101,101,  0,117,117,117,117,117,117,117,  0,
  133,133,133,133,133,133,133,  0,149,149,149,149,149,149,149,  0,
  165,165,165,165,165,165,165,  0,181,181,181,181,181,181,181,  0,
  197,197,197,197,197,197,197,  0,213,213,213,213,213,213,213,  0,
  229,229,229,229,229,229,229,  0,245,245,245,245,245,245,245,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,
    5,  5,  5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37,
   37, 37, 37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69,
   69, 69, 69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,
  101,101,101,101,101,  0,117,117,117,117,117,117,117,  0,133,133,
  133,133,133,133,133,  0,149,149,149,149,149,149,149,  0,165,165,
  165,165,165,165,165,  0,181,181,181,181,181,181,181,  0,197,197,
  197,197,197,197,197,  0,213,213,213,213,213,213,213,  0,229,229,
  229,229,229,229,229,  0,245,245,245,245,245,245,245,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,
    5,  5,  5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37,
   37, 37, 37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69,
   69, 69, 69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,
  101,101,101,  0,117,117,117,117,117,117,117,  0,133,133,133,133,
  133,133,133,  0,149,149,149,149,149,149,149,  0,165,165,165,165,
  165,165,165,  0,181,181,181,181,181,181,181,  0,197,197,197,197,
  197,197,197,  0,213,213,213,213,213,213,213,  0,229,229,229,229,
  229,229,229,  0,245,245,245,245,245,245,245,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,
    5,  0, 21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37,
   37,  0, 53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69,
   69,  0, 85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,101,101,
  101,  0,117,117,117,117,117,117,117,  0,133,133,133,133,133,133,
  133,  0,149,149,149,149,149,149,149,  0,165,165,165,165,165,165,
  165,  0,181,181,181,181,181,181,181,  0,197,197,197,197,197,197,
  197,  0,213,213,213,213,213,213,213,  0,229,229,229,229,229,229,
  229,  0,245,245,245,245,245,245,245,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0,
   21, 21, 21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37, 37,  0,
   53, 53, 53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69, 69,  0,
   85, 85, 85, 85, 85, 85, 85,  0,101,101,101,101,101,101,101,  0,
  117,117,117,117,117,117,117,  0,133,133,133,133,133,133,133,  0,
  149,149,149,149,149,149,149,  0,165,165,165,165,165,165,165,  0,
  181,181,181,181,181,181,181,  0,197,197,197,197,197,197,197,  0,
  213,213,213,213,213,213,213,  0,229,229,229,229,229,229,229,  0,
  245,245,245,245,245,245,245,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  5,  5,  5,  5,  5,  5,  5,  0, 21, 21,
   21, 21, 21, 21, 21,  0, 37, 37, 37, 37, 37, 37, 37,  0, 53, 53,
   53, 53, 53, 53, 53,  0, 69, 69, 69, 69, 69, 69, 69,  0, 85, 85,
   85, 85, 85, 85, 85,  0,101,101,101,101,101,101,101,  0,117,117,
  117,117,117,117,117,  0,133,133,133,133,133,133,133,  0,149,149,
  149,149,149,149,149,  0,165,165,165,165,165,165,165,  0,181,181,
  181,181,181,181,181,  0,197,197,197,197,197,197,197,  0,213,213,
  213,213,213,213,213,  0,229,229,229,229,229,229,229,  0,245,245,
  245,245,245,245,245,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  6,  6,  6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22,
   22,  0, 38, 38, 38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54,
   54,  0, 70, 70, 70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86,
   86,  0,102,102,102,102,102,102,102,  0,118,118,118,118,118,118,
  118,  0,134,134,134,134,134,134,134,  0,150,150,150,150,150,150,
  150,  0,166,166,166,166,166,166,166,  0,182,182,182,182,182,182,
  182,  0,198,198,198,198,198,198,198,  0,214,214,214,214,214,214,
  214,  0,230,230,230,230,230,230,230,  0,246,246,246,246,246,246,
  246,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    6,  6,  6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0,
   38, 38, 38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0,
   70, 70, 70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,
  102,102,102,102,102,102,102,  0,118,118,118,118,118,118,118,  0,
  134,134,134,134,134,134,134,  0,150,150,150,150,150,150,150,  0,
  166,166,166,166,166,166,166,  0,182,182,182,182,182,182,182,  0,
  198,198,198,198,198,198,198,  0,214,214,214,214,214,214,214,  0,
  230,230,230,230,230,230,230,  0,246,246,246,246,246,246,246,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,
    6,  6,  6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38,
   38, 38, 38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70,
   70, 70, 70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,
  102,102,102,102,102,  0,118,118,118,118,118,118,118,  0,134,134,
  134,134,134,134,134,  0,150,150,150,150,150,150,150,  0,166,166,
  166,166,166,166,166,  0,182,182,182,182,182,182,182,  0,198,198,
  198,198,198,198,198,  0,214,214,214,214,214,214,214,  0,230,230,
  230,230,230,230,230,  0,246,246,246,246,246,246,246,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,
    6,  6,  6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38,
   38, 38, 38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70,
   70, 70, 70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,
  102,102,102,  0,118,118,118,118,118,118,118,  0,134,134,134,134,
  134,134,134,  0,150,150,150,150,150,150,150,  0,166,166,166,166,
  166,166,166,  0,182,182,182,182,182,182,182,  0,198,198,198,198,
  198,198,198,  0,214,214,214,214,214,214,214,  0,230,230,230,230,
  230,230,230,  0,246,246,246,246,246,246,246,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,
    6,  0, 22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38,
   38,  0, 54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70,
   70,  0, 86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,102,102,
  102,  0,118,118,118,118,118,118,118,  0,134,134,134,134,134,134,
  134,  0,150,150,150,150,150,150,150,  0,166,166,166,166,166,166,
  166,  0,182,182,182,182,182,182,182,  0,198,198,198,198,198,198,
  198,  0,214,214,214,214,214,214,214,  0,230,230,230,230,230,230,
  230,  0,246,246,246,246,246,246,246,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,  6,  0,
   22, 22, 22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38, 38,  0,
   54, 54, 54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70, 70,  0,
   86, 86, 86, 86, 86, 86, 86,  0,102,102,102,102,102,102,102,  0,
  118,118,118,118,118,118,118,  0,134,134,134,134,134,134,134,  0,
  150,150,150,150,150,150,150,  0,166,166,166,166,166,166,166,  0,
  182,182,182,182,182,182,182,  0,198,198,198,198,198,198,198,  0,
  214,214,214,214,214,214,214,  0,230,230,230,230,230,230,230,  0,
  246,246,246,246,246,246,246,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  6,  6,  6,  6,  6,  6,  6,  0, 22, 22,
   22, 22, 22, 22, 22,  0, 38, 38, 38, 38, 38, 38, 38,  0, 54, 54,
   54, 54, 54, 54, 54,  0, 70, 70, 70, 70, 70, 70, 70,  0, 86, 86,
   86, 86, 86, 86, 86,  0,102,102,102,102,102,102,102,  0,118,118,
  118,118,118,118,118,  0,134,134,134,134,134,134,134,  0,150,150,
  150,150,150,150,150,  0,166,166,166,166,166,166,166,  0,182,182,
  182,182,182,182,182,  0,198,198,198,198,198,198,198,  0,214,214,
  214,214,214,214,214,  0,230,230,230,230,230,230,230,  0,246,246,
  246,246,246,246,246,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  7,  7,  7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23,
   23,  0, 39, 39, 39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55,
   55,  0, 71, 71, 71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87,
   87,  0,103,103,103,103,103,103,103,  0,119,119,119,119,119,119,
  119,  0,135,135,135,135,135,135,135,  0,151,151,151,151,151,151,
  151,  0,167,167,167,167,167,167,167,  0,183,183,183,183,183,183,
  183,  0,199,199,199,199,199,199,199,  0,215,215,215,215,215,215,
  215,  0,231,231,231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    7,  7,  7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0,
   39, 39, 39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0,
   71, 71, 71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,
  103,103,103,103,103,103,103,  0,119,119,119,119,119,119,119,  0,
  135,135,135,135,135,135,135,  0,151,151,151,151,151,151,151,  0,
  167,167,167,167,167,167,167,  0,183,183,183,183,183,183,183,  0,
  199,199,199,199,199,199,199,  0,215,215,215,215,215,215,215,  0,
  231,231,231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,
    7,  7,  7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39,
   39, 39, 39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71,
   71, 71, 71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,
  103,103,103,103,103,  0,119,119,119,119,119,119,119,  0,135,135,
  135,135,135,135,135,  0,151,151,151,151,151,151,151,  0,167,167,
  167,167,167,167,167,  0,183,183,183,183,183,183,183,  0,199,199,
  199,199,199,199,199,  0,215,215,215,215,215,215,215,  0,231,231,
  231,231,231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,
    7,  7,  7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39,
   39, 39, 39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71,
   71, 71, 71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,
  103,103,103,  0,119,119,119,119,119,119,119,  0,135,135,135,135,
  135,135,135,  0,151,151,151,151,151,151,151,  0,167,167,167,167,
  167,167,167,  0,183,183,183,183,183,183,183,  0,199,199,199,199,
  199,199,199,  0,215,215,215,215,215,215,215,  0,231,231,231,231,
  231,231,231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,
    7,  0, 23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39,
   39,  0, 55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71,
   71,  0, 87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,103,103,
  103,  0,119,119,119,119,119,119,119,  0,135,135,135,135,135,135,
  135,  0,151,151,151,151,151,151,151,  0,167,167,167,167,167,167,
  167,  0,183,183,183,183,183,183,183,  0,199,199,199,199,199,199,
  199,  0,215,215,215,215,215,215,215,  0,231,231,231,231,231,231,
  231,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,  7,  0,
   23, 23, 23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39, 39,  0,
   55, 55, 55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71, 71,  0,
   87, 87, 87, 87, 87, 87, 87,  0,103,103,103,103,103,103,103,  0,
  119,119,119,119,119,119,119,  0,135,135,135,135,135,135,135,  0,
  151,151,151,151,151,151,151,  0,167,167,167,167,167,167,167,  0,
  183,183,183,183,183,183,183,  0,199,199,199,199,199,199,199,  0,
  215,215,215,215,215,215,215,  0,231,231,231,231,231,231,231,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  7,  7,  7,  7,  7,  7,  7,  0, 23, 23,
   23, 23, 23, 23, 23,  0, 39, 39, 39, 39, 39, 39, 39,  0, 55, 55,
   55, 55, 55, 55, 55,  0, 71, 71, 71, 71, 71, 71, 71,  0, 87, 87,
   87, 87, 87, 87, 87,  0,103,103,103,103,103,103,103,  0,119,119,
  119,119,119,119,119,  0,135,135,135,135,135,135,135,  0,151,151,
  151,151,151,151,151,  0,167,167,167,167,167,167,167,  0,183,183,
  183,183,183,183,183,  0,199,199,199,199,199,199,199,  0,215,215,
  215,215,215,215,215,  0,231,231,231,231,231,231,231,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  8,  8,  8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24,
   24,  0, 40, 40, 40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56,
   56,  0, 72, 72, 72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88,
   88,  0,104,104,104,104,104,104,104,  0,120,120,120,120,120,120,
  120,  0,136,136,136,136,136,136,136,  0,152,152,152,152,152,152,
  152,  0,255,255,255,255,255,255,255,  0,184,184,184,184,184,184,
  184,  0,200,200,200,200,200,200,200,  0,216,216,216,216,216,216,
  216,  0,232,232,232,232,232,232,232,  0,248,248,248,248,248,248,
  248,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    8,  8,  8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0,
   40, 40, 40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0,
   72, 72, 72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,
  104,104,104,104,104,104,104,  0,120,120,120,120,120,120,120,  0,
  136,136,136,136,136,136,136,  0,152,152,152,152,152,152,152,  0,
  255,255,255,255,255,255,255,  0,184,184,184,184,184,184,184,  0,
  200,200,200,200,200,200,200,  0,216,216,216,216,216,216,216,  0,
  232,232,232,232,232,232,232,  0,248,248,248,248,248,248,248,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,
    8,  8,  8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40,
   40, 40, 40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72,
   72, 72, 72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,
  104,104,104,104,104,  0,120,120,120,120,120,120,120,  0,136,136,
  136,136,136,136,136,  0,152,152,152,152,152,152,152,  0,255,255,
  255,255,255,255,255,  0,184,184,184,184,184,184,184,  0,200,200,
  200,200,200,200,200,  0,216,216,216,216,216,216,216,  0,232,232,
  232,232,232,232,232,  0,248,248,248,248,248,248,248,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,
    8,  8,  8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40,
   40, 40, 40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72,
   72, 72, 72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,
  104,104,104,  0,120,120,120,120,120,120,120,  0,136,136,136,136,
  136,136,136,  0,152,152,152,152,152,152,152,  0,255,255,255,255,
  255,255,255,  0,184,184,184,184,184,184,184,  0,200,200,200,200,
  200,200,200,  0,216,216,216,216,216,216,216,  0,232,232,232,232,
  232,232,232,  0,248,248,248,248,248,248,248,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,
    8,  0, 24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40,
   40,  0, 56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72,
   72,  0, 88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,104,104,
  104,  0,120,120,120,120,120,120,120,  0,136,136,136,136,136,136,
  136,  0,152,152,152,152,152,152,152,  0,255,255,255,255,255,255,
  255,  0,184,184,184,184,184,184,184,  0,200,200,200,200,200,200,
  200,  0,216,216,216,216,216,216,216,  0,232,232,232,232,232,232,
  232,  0,248,248,248,248,248,248,248,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0,
   24, 24, 24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40, 40,  0,
   56, 56, 56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72, 72,  0,
   88, 88, 88, 88, 88, 88, 88,  0,104,104,104,104,104,104,104,  0,
  120,120,120,120,120,120,120,  0,136,136,136,136,136,136,136,  0,
  152,152,152,152,152,152,152,  0,255,255,255,255,255,255,255,  0,
  184,184,184,184,184,184,184,  0,200,200,200,200,200,200,200,  0,
  216,216,216,216,216,216,216,  0,232,232,232,232,232,232,232,  0,
  248,248,248,248,248,248,248,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  8,  8,  8,  8,  8,  8,  8,  0, 24, 24,
   24, 24, 24, 24, 24,  0, 40, 40, 40, 40, 40, 40, 40,  0, 56, 56,
   56, 56, 56, 56, 56,  0, 72, 72, 72, 72, 72, 72, 72,  0, 88, 88,
   88, 88, 88, 88, 88,  0,104,104,104,104,104,104,104,  0,120,120,
  120,120,120,120,120,  0,136,136,136,136,136,136,136,  0,152,152,
  152,152,152,152,152,  0,255,255,255,255,255,255,255,  0,184,184,
  184,184,184,184,184,  0,200,200,200,200,200,200,200,  0,216,216,
  216,216,216,216,216,  0,232,232,232,232,232,232,232,  0,248,248,
  248,248,248,248,248,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  9,  9,  9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25,
   25,  0, 41, 41, 41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57,
   57,  0, 73, 73, 73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89,
   89,  0,105,105,105,105,105,105,105,  0,121,121,121,121,121,121,
  121,  0,137,137,137,137,137,137,137,  0,153,153,153,153,153,153,
  153,  0,169,169,169,169,169,169,169,  0,185,185,185,185,185,185,
  185,  0,201,201,201,201,201,201,201,  0,217,217,217,217,217,217,
  217,  0,233,233,233,233,233,233,233,  0,249,249,249,249,249,249,
  249,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
    9,  9,  9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0,
   41, 41, 41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0,
   73, 73, 73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,
  105,105,105,105,105,105,105,  0,121,121,121,121,121,121,121,  0,
  137,137,137,137,137,137,137,  0,153,153,153,153,153,153,153,  0,
  169,169,169,169,169,169,169,  0,185,185,185,185,185,185,185,  0,
  201,201,201,201,201,201,201,  0,217,217,217,217,217,217,217,  0,
  233,233,233,233,233,233,233,  0,249,249,249,249,249,249,249,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,
    9,  9,  9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41,
   41, 41, 41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73,
   73, 73, 73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,
  105,105,105,105,105,  0,121,121,121,121,121,121,121,  0,137,137,
  137,137,137,137,137,  0,153,153,153,153,153,153,153,  0,169,169,
  169,169,169,169,169,  0,185,185,185,185,185,185,185,  0,201,201,
  201,201,201,201,201,  0,217,217,217,217,217,217,217,  0,233,233,
  233,233,233,233,233,  0,249,249,249,249,249,249,249,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,
    9,  9,  9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41,
   41, 41, 41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73,
   73, 73, 73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,
  105,105,105,  0,121,121,121,121,121,121,121,  0,137,137,137,137,
  137,137,137,  0,153,153,153,153,153,153,153,  0,169,169,169,169,
  169,169,169,  0,185,185,185,185,185,185,185,  0,201,201,201,201,
  201,201,201,  0,217,217,217,217,217,217,217,  0,233,233,233,233,
  233,233,233,  0,249,249,249,249,249,249,249,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,
    9,  0, 25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41,
   41,  0, 57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73,
   73,  0, 89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,105,105,
  105,  0,121,121,121,121,121,121,121,  0,137,137,137,137,137,137,
  137,  0,153,153,153,153,153,153,153,  0,169,169,169,169,169,169,
  169,  0,185,185,185,185,185,185,185,  0,201,201,201,201,201,201,
  201,  0,217,217,217,217,217,217,217,  0,233,233,233,233,233,233,
  233,  0,249,249,249,249,249,249,249,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0,
   25, 25, 25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41, 41,  0,
   57, 57, 57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73, 73,  0,
   89, 89, 89, 89, 89, 89, 89,  0,105,105,105,105,105,105,105,  0,
  121,121,121,121,121,121,121,  0,137,137,137,137,137,137,137,  0,
  153,153,153,153,153,153,153,  0,169,169,169,169,169,169,169,  0,
  185,185,185,185,185,185,185,  0,201,201,201,201,201,201,201,  0,
  217,217,217,217,217,217,217,  0,233,233,233,233,233,233,233,  0,
  249,249,249,249,249,249,249,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0,  9,  9,  9,  9,  9,  9,  9,  0, 25, 25,
   25, 25, 25, 25, 25,  0, 41, 41, 41, 41, 41, 41, 41,  0, 57, 57,
   57, 57, 57, 57, 57,  0, 73, 73, 73, 73, 73, 73, 73,  0, 89, 89,
   89, 89, 89, 89, 89,  0,105,105,105,105,105,105,105,  0,121,121,
  121,121,121,121,121,  0,137,137,137,137,137,137,137,  0,153,153,
  153,153,153,153,153,  0,169,169,169,169,169,169,169,  0,185,185,
  185,185,185,185,185,  0,201,201,201,201,201,201,201,  0,217,217,
  217,217,217,217,217,  0,233,233,233,233,233,233,233,  0,249,249,
  249,249,249,249,249,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 10, 10, 10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26,
   26,  0, 42, 42, 42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58,
   58,  0, 74, 74, 74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90,
   90,  0,106,106,106,106,106,106,106,  0,122,122,122,122,122,122,
  122,  0,138,138,138,138,138,138,138,  0,154,154,154,154,154,154,
  154,  0,170,170,170,170,170,170,170,  0,186,186,186,186,186,186,
  186,  0,202,202,202,202,202,202,202,  0,218,218,218,218,218,218,
  218,  0,234,234,234,234,234,234,234,  0,250,250,250,250,250,250,
  250,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   10, 10, 10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0,
   42, 42, 42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0,
   74, 74, 74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,
  106,106,106,106,106,106,106,  0,122,122,122,122,122,122,122,  0,
  138,138,138,138,138,138,138,  0,154,154,154,154,154,154,154,  0,
  170,170,170,170,170,170,170,  0,186,186,186,186,186,186,186,  0,
  202,202,202,202,202,202,202,  0,218,218,218,218,218,218,218,  0,
  234,234,234,234,234,234,234,  0,250,250,250,250,250,250,250,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10,
   10, 10, 10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42,
   42, 42, 42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74,
   74, 74, 74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,
  106,106,106,106,106,  0,122,122,122,122,122,122,122,  0,138,138,
  138,138,138,138,138,  0,154,154,154,154,154,154,154,  0,170,170,
  170,170,170,170,170,  0,186,186,186,186,186,186,186,  0,202,202,
  202,202,202,202,202,  0,218,218,218,218,218,218,218,  0,234,234,
  234,234,234,234,234,  0,250,250,250,250,250,250,250,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10,
   10, 10, 10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42,
   42, 42, 42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74,
   74, 74, 74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,
  106,106,106,  0,122,122,122,122,122,122,122,  0,138,138,138,138,
  138,138,138,  0,154,154,154,154,154,154,154,  0,170,170,170,170,
  170,170,170,  0,186,186,186,186,186,186,186,  0,202,202,202,202,
  202,202,202,  0,218,218,218,218,218,218,218,  0,234,234,234,234,
  234,234,234,  0,250,250,250,250,250,250,250,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10,
   10,  0, 26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42,
   42,  0, 58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74,
   74,  0, 90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,106,106,
  106,  0,122,122,122,122,122,122,122,  0,138,138,138,138,138,138,
  138,  0,154,154,154,154,154,154,154,  0,170,170,170,170,170,170,
  170,  0,186,186,186,186,186,186,186,  0,202,202,202,202,202,202,
  202,  0,218,218,218,218,218,218,218,  0,234,234,234,234,234,234,
  234,  0,250,250,250,250,250,250,250,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0,
   26, 26, 26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42, 42,  0,
   58, 58, 58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74, 74,  0,
   90, 90, 90, 90, 90, 90, 90,  0,106,106,106,106,106,106,106,  0,
  122,122,122,122,122,122,122,  0,138,138,138,138,138,138,138,  0,
  154,154,154,154,154,154,154,  0,170,170,170,170,170,170,170,  0,
  186,186,186,186,186,186,186,  0,202,202,202,202,202,202,202,  0,
  218,218,218,218,218,218,218,  0,234,234,234,234,234,234,234,  0,
  250,250,250,250,250,250,250,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 10, 10, 10, 10, 10, 10, 10,  0, 26, 26,
   26, 26, 26, 26, 26,  0, 42, 42, 42, 42, 42, 42, 42,  0, 58, 58,
   58, 58, 58, 58, 58,  0, 74, 74, 74, 74, 74, 74, 74,  0, 90, 90,
   90, 90, 90, 90, 90,  0,106,106,106,106,106,106,106,  0,122,122,
  122,122,122,122,122,  0,138,138,138,138,138,138,138,  0,154,154,
  154,154,154,154,154,  0,170,170,170,170,170,170,170,  0,186,186,
  186,186,186,186,186,  0,202,202,202,202,202,202,202,  0,218,218,
  218,218,218,218,218,  0,234,234,234,234,234,234,234,  0,250,250,
  250,250,250,250,250,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 11, 11, 11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27,
   27,  0, 43, 43, 43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59,
   59,  0, 75, 75, 75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91,
   91,  0,107,107,107,107,107,107,107,  0,123,123,123,123,123,123,
  123,  0,139,139,139,139,139,139,139,  0,155,155,155,155,155,155,
  155,  0,171,171,171,171,171,171,171,  0,187,187,187,187,187,187,
  187,  0,203,203,203,203,203,203,203,  0,219,219,219,219,219,219,
  219,  0,235,235,235,235,235,235,235,  0,251,251,251,251,251,251,
  251,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   11, 11, 11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0,
   43, 43, 43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0,
   75, 75, 75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,
  107,107,107,107,107,107,107,  0,123,123,123,123,123,123,123,  0,
  139,139,139,139,139,139,139,  0,155,155,155,155,155,155,155,  0,
  171,171,171,171,171,171,171,  0,187,187,187,187,187,187,187,  0,
  203,203,203,203,203,203,203,  0,219,219,219,219,219,219,219,  0,
  235,235,235,235,235,235,235,  0,251,251,251,251,251,251,251,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11,
   11, 11, 11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43,
   43, 43, 43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75,
   75, 75, 75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,
  107,107,107,107,107,  0,123,123,123,123,123,123,123,  0,139,139,
  139,139,139,139,139,  0,155,155,155,155,155,155,155,  0,171,171,
  171,171,171,171,171,  0,187,187,187,187,187,187,187,  0,203,203,
  203,203,203,203,203,  0,219,219,219,219,219,219,219,  0,235,235,
  235,235,235,235,235,  0,251,251,251,251,251,251,251,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11,
   11, 11, 11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43,
   43, 43, 43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75,
   75, 75, 75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,
  107,107,107,  0,123,123,123,123,123,123,123,  0,139,139,139,139,
  139,139,139,  0,155,155,155,155,155,155,155,  0,171,171,171,171,
  171,171,171,  0,187,187,187,187,187,187,187,  0,203,203,203,203,
  203,203,203,  0,219,219,219,219,219,219,219,  0,235,235,235,235,
  235,235,235,  0,251,251,251,251,251,251,251,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11,
   11,  0, 27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43,
   43,  0, 59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75,
   75,  0, 91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,107,107,
  107,  0,123,123,123,123,123,123,123,  0,139,139,139,139,139,139,
  139,  0,155,155,155,155,155,155,155,  0,171,171,171,171,171,171,
  171,  0,187,187,187,187,187,187,187,  0,203,203,203,203,203,203,
  203,  0,219,219,219,219,219,219,219,  0,235,235,235,235,235,235,
  235,  0,251,251,251,251,251,251,251,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11, 11,  0,
   27, 27, 27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43, 43,  0,
   59, 59, 59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75, 75,  0,
   91, 91, 91, 91, 91, 91, 91,  0,107,107,107,107,107,107,107,  0,
  123,123,123,123,123,123,123,  0,139,139,139,139,139,139,139,  0,
  155,155,155,155,155,155,155,  0,171,171,171,171,171,171,171,  0,
  187,187,187,187,187,187,187,  0,203,203,203,203,203,203,203,  0,
  219,219,219,219,219,219,219,  0,235,235,235,235,235,235,235,  0,
  251,251,251,251,251,251,251,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 11, 11, 11, 11, 11, 11, 11,  0, 27, 27,
   27, 27, 27, 27, 27,  0, 43, 43, 43, 43, 43, 43, 43,  0, 59, 59,
   59, 59, 59, 59, 59,  0, 75, 75, 75, 75, 75, 75, 75,  0, 91, 91,

   91, 91, 91, 91, 91,  0,107,107,107,107,107,107,107,  0,123,123,
  123,123,123,123,123,  0,139,139,139,139,139,139,139,  0,155,155,
  155,155,155,155,155,  0,171,171,171,171,171,171,171,  0,187,187,
  187,187,187,187,187,  0,203,203,203,203,203,203,203,  0,219,219,
  219,219,219,219,219,  0,235,235,235,235,235,235,235,  0,251,251,
  251,251,251,251,251,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28,
   28,  0, 44, 44, 44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60,
   60,  0, 76, 76, 76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92,
   92,  0,108,108,108,108,108,108,108,  0,124,124,124,124,124,124,
  124,  0,140,140,140,140,140,140,140,  0,156,156,156,156,156,156,
  156,  0,172,172,172,172,172,172,172,  0,188,188,188,188,188,188,
  188,  0,204,204,204,204,204,204,204,  0,220,220,220,220,220,220,
  220,  0,236,236,236,236,236,236,236,  0,252,252,252,252,252,252,
  252,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   12, 12, 12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0,
   44, 44, 44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0,
   76, 76, 76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,
  108,108,108,108,108,108,108,  0,124,124,124,124,124,124,124,  0,
  140,140,140,140,140,140,140,  0,156,156,156,156,156,156,156,  0,
  172,172,172,172,172,172,172,  0,188,188,188,188,188,188,188,  0,
  204,204,204,204,204,204,204,  0,220,220,220,220,220,220,220,  0,
  236,236,236,236,236,236,236,  0,252,252,252,252,252,252,252,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12,
   12, 12, 12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44,
   44, 44, 44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76,
   76, 76, 76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,
  108,108,108,108,108,  0,124,124,124,124,124,124,124,  0,140,140,
  140,140,140,140,140,  0,156,156,156,156,156,156,156,  0,172,172,
  172,172,172,172,172,  0,188,188,188,188,188,188,188,  0,204,204,
  204,204,204,204,204,  0,220,220,220,220,220,220,220,  0,236,236,
  236,236,236,236,236,  0,252,252,252,252,252,252,252,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12,
   12, 12, 12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44,
   44, 44, 44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76,
   76, 76, 76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,
  108,108,108,  0,124,124,124,124,124,124,124,  0,140,140,140,140,
  140,140,140,  0,156,156,156,156,156,156,156,  0,172,172,172,172,
  172,172,172,  0,188,188,188,188,188,188,188,  0,204,204,204,204,
  204,204,204,  0,220,220,220,220,220,220,220,  0,236,236,236,236,
  236,236,236,  0,252,252,252,252,252,252,252,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12,
   12,  0, 28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44,
   44,  0, 60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76,
   76,  0, 92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,108,108,
  108,  0,124,124,124,124,124,124,124,  0,140,140,140,140,140,140,
  140,  0,156,156,156,156,156,156,156,  0,172,172,172,172,172,172,
  172,  0,188,188,188,188,188,188,188,  0,204,204,204,204,204,204,
  204,  0,220,220,220,220,220,220,220,  0,236,236,236,236,236,236,
  236,  0,252,252,252,252,252,252,252,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0,
   28, 28, 28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44, 44,  0,
   60, 60, 60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76, 76,  0,
   92, 92, 92, 92, 92, 92, 92,  0,108,108,108,108,108,108,108,  0,
  124,124,124,124,124,124,124,  0,140,140,140,140,140,140,140,  0,
  156,156,156,156,156,156,156,  0,172,172,172,172,172,172,172,  0,
  188,188,188,188,188,188,188,  0,204,204,204,204,204,204,204,  0,
  220,220,220,220,220,220,220,  0,236,236,236,236,236,236,236,  0,
  252,252,252,252,252,252,252,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 12, 12, 12, 12, 12, 12, 12,  0, 28, 28,
   28, 28, 28, 28, 28,  0, 44, 44, 44, 44, 44, 44, 44,  0, 60, 60,
   60, 60, 60, 60, 60,  0, 76, 76, 76, 76, 76, 76, 76,  0, 92, 92,
   92, 92, 92, 92, 92,  0,108,108,108,108,108,108,108,  0,124,124,
  124,124,124,124,124,  0,140,140,140,140,140,140,140,  0,156,156,
  156,156,156,156,156,  0,172,172,172,172,172,172,172,  0,188,188,
  188,188,188,188,188,  0,204,204,204,204,204,204,204,  0,220,220,
  220,220,220,220,220,  0,236,236,236,236,236,236,236,  0,252,252,
  252,252,252,252,252,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 13, 13, 13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29,
   29,  0, 45, 45, 45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61,
   61,  0, 77, 77, 77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93,
   93,  0,109,109,109,109,109,109,109,  0,125,125,125,125,125,125,
  125,  0,141,141,141,141,141,141,141,  0,157,157,157,157,157,157,
  157,  0,173,173,173,173,173,173,173,  0,189,189,189,189,189,189,
  189,  0,205,205,205,205,205,205,205,  0,221,221,221,221,221,221,
  221,  0,237,237,237,237,237,237,237,  0,253,253,253,253,253,253,
  253,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   13, 13, 13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0,
   45, 45, 45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0,
   77, 77, 77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,
  109,109,109,109,109,109,109,  0,125,125,125,125,125,125,125,  0,
  141,141,141,141,141,141,141,  0,157,157,157,157,157,157,157,  0,
  173,173,173,173,173,173,173,  0,189,189,189,189,189,189,189,  0,
  205,205,205,205,205,205,205,  0,221,221,221,221,221,221,221,  0,
  237,237,237,237,237,237,237,  0,253,253,253,253,253,253,253,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13,
   13, 13, 13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45,
   45, 45, 45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77,
   77, 77, 77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,
  109,109,109,109,109,  0,125,125,125,125,125,125,125,  0,141,141,
  141,141,141,141,141,  0,157,157,157,157,157,157,157,  0,173,173,
  173,173,173,173,173,  0,189,189,189,189,189,189,189,  0,205,205,
  205,205,205,205,205,  0,221,221,221,221,221,221,221,  0,237,237,
  237,237,237,237,237,  0,253,253,253,253,253,253,253,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13,
   13, 13, 13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45,
   45, 45, 45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77,
   77, 77, 77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,
  109,109,109,  0,125,125,125,125,125,125,125,  0,141,141,141,141,
  141,141,141,  0,157,157,157,157,157,157,157,  0,173,173,173,173,
  173,173,173,  0,189,189,189,189,189,189,189,  0,205,205,205,205,
  205,205,205,  0,221,221,221,221,221,221,221,  0,237,237,237,237,
  237,237,237,  0,253,253,253,253,253,253,253,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13,
   13,  0, 29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45,
   45,  0, 61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77,
   77,  0, 93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,109,109,
  109,  0,125,125,125,125,125,125,125,  0,141,141,141,141,141,141,
  141,  0,157,157,157,157,157,157,157,  0,173,173,173,173,173,173,
  173,  0,189,189,189,189,189,189,189,  0,205,205,205,205,205,205,
  205,  0,221,221,221,221,221,221,221,  0,237,237,237,237,237,237,
  237,  0,253,253,253,253,253,253,253,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0,
   29, 29, 29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45, 45,  0,
   61, 61, 61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77, 77,  0,
   93, 93, 93, 93, 93, 93, 93,  0,109,109,109,109,109,109,109,  0,
  125,125,125,125,125,125,125,  0,141,141,141,141,141,141,141,  0,
  157,157,157,157,157,157,157,  0,173,173,173,173,173,173,173,  0,
  189,189,189,189,189,189,189,  0,205,205,205,205,205,205,205,  0,
  221,221,221,221,221,221,221,  0,237,237,237,237,237,237,237,  0,
  253,253,253,253,253,253,253,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0, 29, 29,
   29, 29, 29, 29, 29,  0, 45, 45, 45, 45, 45, 45, 45,  0, 61, 61,
   61, 61, 61, 61, 61,  0, 77, 77, 77, 77, 77, 77, 77,  0, 93, 93,
   93, 93, 93, 93, 93,  0,109,109,109,109,109,109,109,  0,125,125,
  125,125,125,125,125,  0,141,141,141,141,141,141,141,  0,157,157,
  157,157,157,157,157,  0,173,173,173,173,173,173,173,  0,189,189,
  189,189,189,189,189,  0,205,205,205,205,205,205,205,  0,221,221,
  221,221,221,221,221,  0,237,237,237,237,237,237,237,  0,253,253,
  253,253,253,253,253,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 14, 14, 14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30,
   30,  0, 46, 46, 46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62,
   62,  0, 78, 78, 78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94,
   94,  0,110,110,110,110,110,110,110,  0,126,126,126,126,126,126,
  126,  0,142,142,142,142,142,142,142,  0,158,158,158,158,158,158,
  158,  0,174,174,174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45,
   45,  0,206,206,206,206,206,206,206,  0,222,222,222,222,222,222,
  222,  0,238,238,238,238,238,238,238,  0,254,254,254,254,254,254,
  254,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   14, 14, 14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0,
   46, 46, 46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0,
   78, 78, 78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,
  110,110,110,110,110,110,110,  0,126,126,126,126,126,126,126,  0,
  142,142,142,142,142,142,142,  0,158,158,158,158,158,158,158,  0,
  174,174,174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,
  206,206,206,206,206,206,206,  0,222,222,222,222,222,222,222,  0,
  238,238,238,238,238,238,238,  0,254,254,254,254,254,254,254,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14,
   14, 14, 14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46,
   46, 46, 46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78,
   78, 78, 78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,
  110,110,110,110,110,  0,126,126,126,126,126,126,126,  0,142,142,
  142,142,142,142,142,  0,158,158,158,158,158,158,158,  0,174,174,
  174,174,174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,
  206,206,206,206,206,  0,222,222,222,222,222,222,222,  0,238,238,
  238,238,238,238,238,  0,254,254,254,254,254,254,254,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14,
   14, 14, 14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46,
   46, 46, 46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78,
   78, 78, 78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,
  110,110,110,  0,126,126,126,126,126,126,126,  0,142,142,142,142,
  142,142,142,  0,158,158,158,158,158,158,158,  0,174,174,174,174,
  174,174,174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,
  206,206,206,  0,222,222,222,222,222,222,222,  0,238,238,238,238,
  238,238,238,  0,254,254,254,254,254,254,254,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14,
   14,  0, 30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46,
   46,  0, 62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78,
   78,  0, 94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,110,110,
  110,  0,126,126,126,126,126,126,126,  0,142,142,142,142,142,142,
  142,  0,158,158,158,158,158,158,158,  0,174,174,174,174,174,174,
  174,  0, 45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,206,206,
  206,  0,222,222,222,222,222,222,222,  0,238,238,238,238,238,238,
  238,  0,254,254,254,254,254,254,254,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14, 14,  0,
   30, 30, 30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46, 46,  0,
   62, 62, 62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78, 78,  0,
   94, 94, 94, 94, 94, 94, 94,  0,110,110,110,110,110,110,110,  0,
  126,126,126,126,126,126,126,  0,142,142,142,142,142,142,142,  0,
  158,158,158,158,158,158,158,  0,174,174,174,174,174,174,174,  0,
   45, 45, 45, 45, 45, 45, 45,  0,206,206,206,206,206,206,206,  0,
  222,222,222,222,222,222,222,  0,238,238,238,238,238,238,238,  0,
  254,254,254,254,254,254,254,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 14, 14, 14, 14, 14, 14, 14,  0, 30, 30,
   30, 30, 30, 30, 30,  0, 46, 46, 46, 46, 46, 46, 46,  0, 62, 62,
   62, 62, 62, 62, 62,  0, 78, 78, 78, 78, 78, 78, 78,  0, 94, 94,
   94, 94, 94, 94, 94,  0,110,110,110,110,110,110,110,  0,126,126,
  126,126,126,126,126,  0,142,142,142,142,142,142,142,  0,158,158,
  158,158,158,158,158,  0,174,174,174,174,174,174,174,  0, 45, 45,
   45, 45, 45, 45, 45,  0,206,206,206,206,206,206,206,  0,222,222,
  222,222,222,222,222,  0,238,238,238,238,238,238,238,  0,254,254,
  254,254,254,254,254,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0, 15, 15, 15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31,
   31,  0, 47, 47, 47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63,
   63,  0, 79, 79, 79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95,
   95,  0,111,111,111,111,111,111,111,  0,127,127,127,127,127,127,
  127,  0,143,143,143,143,143,143,143,  0,159,159,159,159,159,159,
  159,  0,175,175,175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47,
   47,  0,207,207,207,207,207,207,207,  0,223,223,223,223,223,223,
  223,  0,239,239,239,239,239,239,239,  0,255,255,255,255,255,255,
  255,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0,
   15, 15, 15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0,
   47, 47, 47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0,
   79, 79, 79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,
  111,111,111,111,111,111,111,  0,127,127,127,127,127,127,127,  0,
  143,143,143,143,143,143,143,  0,159,159,159,159,159,159,159,  0,
  175,175,175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,
  207,207,207,207,207,207,207,  0,223,223,223,223,223,223,223,  0,
  239,239,239,239,239,239,239,  0,255,255,255,255,255,255,255,  0,
    0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15,
   15, 15, 15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47,
   47, 47, 47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79,
   79, 79, 79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,
  111,111,111,111,111,  0,127,127,127,127,127,127,127,  0,143,143,
  143,143,143,143,143,  0,159,159,159,159,159,159,159,  0,175,175,
  175,175,175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,
  207,207,207,207,207,  0,223,223,223,223,223,223,223,  0,239,239,
  239,239,239,239,239,  0,255,255,255,255,255,255,255,  0,  0, 91,
   98,105,  0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15,
   15, 15, 15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47,
   47, 47, 47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79,
   79, 79, 79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,
  111,111,111,  0,127,127,127,127,127,127,127,  0,143,143,143,143,
  143,143,143,  0,159,159,159,159,159,159,159,  0,175,175,175,175,
  175,175,175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,
  207,207,207,  0,223,223,223,223,223,223,223,  0,239,239,239,239,
  239,239,239,  0,255,255,255,255,255,255,255,  0,  0, 91, 98,105,
    0,255,  0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15,
   15,  0, 31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47,
   47,  0, 63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79,
   79,  0, 95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,111,111,
  111,  0,127,127,127,127,127,127,127,  0,143,143,143,143,143,143,
  143,  0,159,159,159,159,159,159,159,  0,175,175,175,175,175,175,
  175,  0, 47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,207,207,
  207,  0,223,223,223,223,223,223,223,  0,239,239,239,239,239,239,
  239,  0,255,255,255,255,255,255,255,  0,  0, 91, 98,105,  0,255,
    0,137,  0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15, 15,  0,
   31, 31, 31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47, 47,  0,
   63, 63, 63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79, 79,  0,
   95, 95, 95, 95, 95, 95, 95,  0,111,111,111,111,111,111,111,  0,
  127,127,127,127,127,127,127,  0,143,143,143,143,143,143,143,  0,
  159,159,159,159,159,159,159,  0,175,175,175,175,175,175,175,  0,
   47, 47, 47, 47, 47, 47, 47,  0,207,207,207,207,207,207,207,  0,
  223,223,223,223,223,223,223,  0,239,239,239,239,239,239,239,  0,
  255,255,255,255,255,255,255,  0,  0, 91, 98,105,  0,255,  0,137,
    0, 91, 98,105,  0,  0, 15, 15, 15, 15, 15, 15, 15,  0, 31, 31,
   31, 31, 31, 31, 31,  0, 47, 47, 47, 47, 47, 47, 47,  0, 63, 63,
   63, 63, 63, 63, 63,  0, 79, 79, 79, 79, 79, 79, 79,  0, 95, 95,
   95, 95, 95, 95, 95,  0,111,111,111,111,111,111,111,  0,127,127,
  127,127,127,127,127,  0,143,143,143,143,143,143,143,  0,159,159,
  159,159,159,159,159,  0,175,175,175,175,175,175,175,  0, 47, 47,
   47, 47, 47, 47, 47,  0,207,207,207,207,207,207,207,  0,223,223,
  223,223,223,223,223,  0,239,239,239,239,239,239,239,  0,255,255,
  255,255,255,255,255,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91,
   98,105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98,105,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0, 91, 98,105,  0,255,  0,137,  0, 91, 98, 94, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91,
   91, 91, 98,105,  0,255,  0,137,  0, 91, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
   98,105,  0,255,  0,137,  0, 98,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
  105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
    0,255,
};

static const unsigned char m_palno[]=  // Marker to not show this color in automap
{
    7,  0,  7,  0,  0,  0,  0,  0,
   36,  0,  0,  0, 48,  0,  0,  0, 60,  0,  0,  0, 72,  0,  0,  0,
   84,  0,  0,  0, 96,  0,  0,  0,108,  0,  0,  0,  0,  7,  0,  4,
    0,  0,  0,  0,  0,  4,  0,255,  0,  7,  0,  0,  4,  0,  0,  0,
    4,  0,  0,255,  0,  7,  0,  0,  0,  4,  0,  4,  0,  0,  0,255,
    0,  7,  0,  0,  0,  0,  4,  0,  0,  0,  0,255,  0,  7,  0,  0,
    0,  4,  0,  4,  0,  0,  0,255,  0,  7,  0,  0,  4,  0,  0,  0,
    4,  0,  0,255,  0,  7,  0,  4,  0,  0,  0,  0,  0,  4,  0,255,
};

static const unsigned char m_butt1[]=  // Options reset button unlit
{
   15,  0, 15,  0,  0,  0,  0,  0,
   68,  0,  0,  0, 88,  0,  0,  0,108,  0,  0,  0,128,  0,  0,  0,
  148,  0,  0,  0,168,  0,  0,  0,188,  0,  0,  0,208,  0,  0,  0,
  228,  0,  0,  0,248,  0,  0,  0, 12,  1,  0,  0, 32,  1,  0,  0,
   52,  1,  0,  0, 72,  1,  0,  0, 92,  1,  0,  0,  0, 15,  0, 59,
   59, 57, 59, 56, 59, 59, 57, 56, 57, 56, 59, 59, 59, 63,  0,255,
    0, 15,  0, 59, 67, 67, 67, 65, 68, 65, 67, 67, 67, 67, 65, 67,
   67, 73,  0,255,  0, 15,  0, 57, 67, 67, 67, 67, 65, 67, 67, 65,
   67, 67, 65, 67, 67, 75,  0,255,  0, 15,  0, 57, 65, 67,119,120,
  118,119,117,119,118,120,123, 70, 65, 73,  0,255,  0, 15,  0, 57,
   65, 67,119,117,119,119,120,119,119,123,124, 73, 67, 75,  0,255,
    0, 15,  0, 57, 67, 65,118,119, 47, 47, 47, 47, 47,125,126, 73,
   67, 74,  0,255,  0, 15,  0, 57, 67, 67,119,119, 47,188,188,188,
   47,124,125, 73, 65, 74,  0,255,  0, 15,  0, 59, 67, 65,119,119,
   47,188,188,188, 47,125,124, 73, 68, 74,  0,255,  0, 15,  0, 60,
   67, 67,117,120, 47,188,188,188, 47,125,125, 73, 65, 73,  0,255,
    0, 15,  0, 57, 67, 67,119,119, 47, 47, 47, 47, 47,126,125, 73,
   65, 73,  0,255,  0, 15,  0, 59, 65, 67,119,123,125,125,124,125,
  125,125,125, 73, 65, 75,  0,255,  0, 15,  0, 59, 68, 67,123,124,
  126,125,125,125,124,125,125, 73, 68, 73,  0,255,  0, 15,  0, 59,
   67, 65, 70, 73, 73, 73, 73, 73, 73, 73, 73, 73, 67, 74,  0,255,
    0, 15,  0, 59, 67, 67, 65, 67, 67, 65, 68, 67, 67, 67, 67, 67,
   67, 73,  0,255,  0, 15,  0, 64, 73, 73, 75, 73, 73, 75, 74, 74,
   74, 74, 74, 73, 73, 73,  0,255,
};


static const unsigned char m_butt2[]=  // Options reset button lit
{
   15,  0, 15,  0,  0,  0,  0,  0,
   68,  0,  0,  0, 88,  0,  0,  0,108,  0,  0,  0,128,  0,  0,  0,
  148,  0,  0,  0,168,  0,  0,  0,188,  0,  0,  0,208,  0,  0,  0,
  228,  0,  0,  0,248,  0,  0,  0, 12,  1,  0,  0, 32,  1,  0,  0,
   52,  1,  0,  0, 72,  1,  0,  0, 92,  1,  0,  0,  0, 15,  0, 59,
   59, 57, 59, 56, 59, 59, 57, 56, 57, 56, 59, 59, 59, 63,  0,255,
    0, 15,  0, 59, 67, 67, 67, 65, 68, 65, 67, 67, 67, 67, 65, 67,
   67, 73,  0,255,  0, 15,  0, 57, 67, 67, 67, 67, 65, 67, 67, 65,
   67, 67, 65, 67, 67, 75,  0,255,  0, 15,  0, 57, 65, 67,119,120,
  118,119,117,119,118,120,123, 70, 65, 73,  0,255,  0, 15,  0, 57,
   65, 67,119,117,119,119,120,119,119,123,124, 73, 67, 75,  0,255,
    0, 15,  0, 57, 67, 65,118,119, 47, 47, 47, 47, 47,125,126, 73,
   67, 74,  0,255,  0, 15,  0, 57, 67, 67,119,119, 47,176,176,176,
   47,124,125, 73, 65, 74,  0,255,  0, 15,  0, 59, 67, 65,119,119,
   47,176,176,176, 47,125,124, 73, 68, 74,  0,255,  0, 15,  0, 60,
   67, 67,117,120, 47,176,176,176, 47,125,125, 73, 65, 73,  0,255,
    0, 15,  0, 57, 67, 67,119,119, 47, 47, 47, 47, 47,126,125, 73,
   65, 73,  0,255,  0, 15,  0, 59, 65, 67,119,123,125,125,124,125,
  125,125,125, 73, 65, 75,  0,255,  0, 15,  0, 59, 68, 67,123,124,
  126,125,125,125,124,125,125, 73, 68, 73,  0,255,  0, 15,  0, 59,
   67, 65, 70, 73, 73, 73, 73, 73, 73, 73, 73, 73, 67, 74,  0,255,
    0, 15,  0, 59, 67, 67, 65, 67, 67, 65, 68, 67, 67, 67, 67, 67,
   67, 73,  0,255,  0, 15,  0, 64, 73, 73, 75, 73, 73, 75, 74, 74,
   74, 74, 74, 73, 73, 73,  0,255,
};

// Animated textures definition lump -- see SWANTBLS.EXE docs
static const unsigned char animated[]=
{
    0, 78, 85, 75, 65, 71, 69, 51,  0,  0, 78, 85, 75, 65, 71, 69,
   49,  0,  0,  8,  0,  0,  0,  0, 70, 87, 65, 84, 69, 82, 52,  0,
    0, 70, 87, 65, 84, 69, 82, 49,  0,  0,  8,  0,  0,  0,  0, 83,
   87, 65, 84, 69, 82, 52,  0,  0, 83, 87, 65, 84, 69, 82, 49,  0,
    0,  8,  0,  0,  0,  0, 76, 65, 86, 65, 52,  0,  0,  0,  0, 76,
   65, 86, 65, 49,  0,  0,  0,  0,  8,  0,  0,  0,  0, 66, 76, 79,
   79, 68, 51,  0,  0,  0, 66, 76, 79, 79, 68, 49,  0,  0,  0,  8,
    0,  0,  0,  0, 82, 82, 79, 67, 75, 48, 56,  0,  0, 82, 82, 79,
   67, 75, 48, 53,  0,  0,  8,  0,  0,  0,  0, 83, 76, 73, 77, 69,
   48, 52,  0,  0, 83, 76, 73, 77, 69, 48, 49,  0,  0,  8,  0,  0,
    0,  0, 83, 76, 73, 77, 69, 48, 56,  0,  0, 83, 76, 73, 77, 69,
   48, 53,  0,  0,  8,  0,  0,  0,  0, 83, 76, 73, 77, 69, 49, 50,
    0,  0, 83, 76, 73, 77, 69, 48, 57,  0,  0,  8,  0,  0,  0,  1,
   66, 76, 79, 68, 71, 82, 52,  0,  0, 66, 76, 79, 68, 71, 82, 49,
    0,  0,  8,  0,  0,  0,  1, 83, 76, 65, 68, 82, 73, 80, 51,  0,
   83, 76, 65, 68, 82, 73, 80, 49,  0,  8,  0,  0,  0,  1, 66, 76,
   79, 68, 82, 73, 80, 52,  0, 66, 76, 79, 68, 82, 73, 80, 49,  0,
    8,  0,  0,  0,  1, 70, 73, 82, 69, 87, 65, 76, 76,  0, 70, 73,
   82, 69, 87, 65, 76, 65,  0,  8,  0,  0,  0,  1, 71, 83, 84, 70,
   79, 78, 84, 51,  0, 71, 83, 84, 70, 79, 78, 84, 49,  0,  8,  0,
    0,  0,  1, 70, 73, 82, 69, 76, 65, 86, 65,  0, 70, 73, 82, 69,
   76, 65, 86, 51,  0,  8,  0,  0,  0,  1, 70, 73, 82, 69, 77, 65,
   71, 51,  0, 70, 73, 82, 69, 77, 65, 71, 49,  0,  8,  0,  0,  0,
    1, 70, 73, 82, 69, 66, 76, 85, 50,  0, 70, 73, 82, 69, 66, 76,
   85, 49,  0,  8,  0,  0,  0,  1, 82, 79, 67, 75, 82, 69, 68, 51,
    0, 82, 79, 67, 75, 82, 69, 68, 49,  0,  8,  0,  0,  0,  1, 66,
   70, 65, 76, 76, 52,  0,  0,  0, 66, 70, 65, 76, 76, 49,  0,  0,
    0,  8,  0,  0,  0,  1, 83, 70, 65, 76, 76, 52,  0,  0,  0, 83,
   70, 65, 76, 76, 49,  0,  0,  0,  8,  0,  0,  0,  1, 87, 70, 65,
   76, 76, 52,  0,  0,  0, 87, 70, 65, 76, 76, 49,  0,  0,  0,  8,
    0,  0,  0,  1, 68, 66, 82, 65, 73, 78, 52,  0,  0, 68, 66, 82,
   65, 73, 78, 49,  0,  0,  8,  0,  0,  0,255,255,255,255,
};

// Switch textures definition lump -- see SWANTBLS.EXE docs
static const unsigned char switches[]=
{
   83, 87, 49, 66, 82, 67, 79, 77,  0, 83, 87, 50, 66, 82, 67, 79,
   77,  0,  1,  0, 83, 87, 49, 66, 82, 78, 49,  0,  0, 83, 87, 50,
   66, 82, 78, 49,  0,  0,  1,  0, 83, 87, 49, 66, 82, 78, 50,  0,
    0, 83, 87, 50, 66, 82, 78, 50,  0,  0,  1,  0, 83, 87, 49, 66,
   82, 78, 71, 78,  0, 83, 87, 50, 66, 82, 78, 71, 78,  0,  1,  0,
   83, 87, 49, 66, 82, 79, 87, 78,  0, 83, 87, 50, 66, 82, 79, 87,
   78,  0,  1,  0, 83, 87, 49, 67, 79, 77, 77,  0,  0, 83, 87, 50,
   67, 79, 77, 77,  0,  0,  1,  0, 83, 87, 49, 67, 79, 77, 80,  0,
    0, 83, 87, 50, 67, 79, 77, 80,  0,  0,  1,  0, 83, 87, 49, 68,
   73, 82, 84,  0,  0, 83, 87, 50, 68, 73, 82, 84,  0,  0,  1,  0,
   83, 87, 49, 69, 88, 73, 84,  0,  0, 83, 87, 50, 69, 88, 73, 84,
    0,  0,  1,  0, 83, 87, 49, 71, 82, 65, 89,  0,  0, 83, 87, 50,
   71, 82, 65, 89,  0,  0,  1,  0, 83, 87, 49, 71, 82, 65, 89, 49,
    0, 83, 87, 50, 71, 82, 65, 89, 49,  0,  1,  0, 83, 87, 49, 77,
   69, 84, 65, 76,  0, 83, 87, 50, 77, 69, 84, 65, 76,  0,  1,  0,
   83, 87, 49, 80, 73, 80, 69,  0,  0, 83, 87, 50, 80, 73, 80, 69,
    0,  0,  1,  0, 83, 87, 49, 83, 76, 65, 68,  0,  0, 83, 87, 50,
   83, 76, 65, 68,  0,  0,  1,  0, 83, 87, 49, 83, 84, 65, 82, 71,
    0, 83, 87, 50, 83, 84, 65, 82, 71,  0,  1,  0, 83, 87, 49, 83,
   84, 79, 78, 49,  0, 83, 87, 50, 83, 84, 79, 78, 49,  0,  1,  0,
   83, 87, 49, 83, 84, 79, 78, 50,  0, 83, 87, 50, 83, 84, 79, 78,
   50,  0,  1,  0, 83, 87, 49, 83, 84, 79, 78, 69,  0, 83, 87, 50,
   83, 84, 79, 78, 69,  0,  1,  0, 83, 87, 49, 83, 84, 82, 84, 78,
    0, 83, 87, 50, 83, 84, 82, 84, 78,  0,  1,  0, 83, 87, 49, 66,
   76, 85, 69,  0,  0, 83, 87, 50, 66, 76, 85, 69,  0,  0,  2,  0,
   83, 87, 49, 67, 77, 84,  0,  0,  0, 83, 87, 50, 67, 77, 84,  0,
    0,  0,  2,  0, 83, 87, 49, 71, 65, 82, 71,  0,  0, 83, 87, 50,
   71, 65, 82, 71,  0,  0,  2,  0, 83, 87, 49, 71, 83, 84, 79, 78,
    0, 83, 87, 50, 71, 83, 84, 79, 78,  0,  2,  0, 83, 87, 49, 72,
   79, 84,  0,  0,  0, 83, 87, 50, 72, 79, 84,  0,  0,  0,  2,  0,
   83, 87, 49, 76, 73, 79, 78,  0,  0, 83, 87, 50, 76, 73, 79, 78,
    0,  0,  2,  0, 83, 87, 49, 83, 65, 84, 89, 82,  0, 83, 87, 50,
   83, 65, 84, 89, 82,  0,  2,  0, 83, 87, 49, 83, 75, 73, 78,  0,
    0, 83, 87, 50, 83, 75, 73, 78,  0,  0,  2,  0, 83, 87, 49, 86,
   73, 78, 69,  0,  0, 83, 87, 50, 86, 73, 78, 69,  0,  0,  2,  0,
   83, 87, 49, 87, 79, 79, 68,  0,  0, 83, 87, 50, 87, 79, 79, 68,
    0,  0,  2,  0, 83, 87, 49, 80, 65, 78, 69, 76,  0, 83, 87, 50,
   80, 65, 78, 69, 76,  0,  3,  0, 83, 87, 49, 82, 79, 67, 75,  0,
    0, 83, 87, 50, 82, 79, 67, 75,  0,  0,  3,  0, 83, 87, 49, 77,
   69, 84, 50,  0,  0, 83, 87, 50, 77, 69, 84, 50,  0,  0,  3,  0,
   83, 87, 49, 87, 68, 77, 69, 84,  0, 83, 87, 50, 87, 68, 77, 69,
   84,  0,  3,  0, 83, 87, 49, 66, 82, 73, 75,  0,  0, 83, 87, 50,
   66, 82, 73, 75,  0,  0,  3,  0, 83, 87, 49, 77, 79, 68, 49,  0,
    0, 83, 87, 50, 77, 79, 68, 49,  0,  0,  3,  0, 83, 87, 49, 90,
   73, 77,  0,  0,  0, 83, 87, 50, 90, 73, 77,  0,  0,  0,  3,  0,
   83, 87, 49, 83, 84, 79, 78, 54,  0, 83, 87, 50, 83, 84, 79, 78,
   54,  0,  3,  0, 83, 87, 49, 84, 69, 75,  0,  0,  0, 83, 87, 50,
   84, 69, 75,  0,  0,  0,  3,  0, 83, 87, 49, 77, 65, 82, 66,  0,
    0, 83, 87, 50, 77, 65, 82, 66,  0,  0,  3,  0, 83, 87, 49, 83,
   75, 85, 76, 76,  0, 83, 87, 50, 83, 75, 85, 76, 76,  0,  3,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,
};

// colormap for underwater, original default greenish
static const unsigned char watermap[] = {
  0,126,127,103,193,5,6,7,8,123,124,126,12,122,123,124,193,193,194,194,88,90,
  92,93,95,96,98,98,100,101,102,103,3,105,106,107,14,15,15,238,238,239,239,239,
  1,2,2,2,193,193,193,193,193,193,193,86,112,112,112,112,113,114,115,115,115,
  116,117,117,118,118,119,120,121,121,122,122,123,124,124,125,193,193,194,194,
  194,194,194,194,194,194,194,194,194,195,195,195,93,94,95,96,97,98,100,101,
  102,104,104,106,106,108,109,110,112,112,113,113,113,114,115,115,117,119,120,
  121,123,124,125,127,112,112,112,113,114,115,115,116,117,118,118,119,119,121,
  121,122,115,116,117,118,120,121,122,123,115,116,117,118,119,121,121,122,112,
  112,112,114,117,120,122,78,193,193,193,194,91,95,136,34,186,187,187,188,188,
  189,189,45,45,46,47,47,47,47,2,2,193,194,194,195,196,197,198,199,200,200,200,
  200,201,202,204,205,193,193,193,193,112,112,114,116,117,118,118,120,120,120,
  74,75,193,193,193,86,112,112,113,114,75,75,76,77,122,124,125,126,205,206,207,
  241,243,244,246,0,113,112,195,198,198,199,204,96,0,126,127,103,193,5,6,7,8,
  123,124,126,12,122,123,124,193,194,194,88,90,90,93,95,95,96,98,98,100,101,
  103,103,105,105,106,107,14,15,15,238,238,239,239,239,1,2,2,2,193,193,193,193,
  193,193,86,86,112,112,112,113,114,115,115,115,115,117,117,117,118,118,120,
  120,121,121,122,122,123,124,124,125,193,194,194,194,194,194,194,194,194,194,
  194,194,195,195,195,195,94,94,95,97,97,98,101,101,103,104,104,106,106,108,
  109,110,112,112,113,113,113,114,115,115,117,119,120,121,123,124,125,127,112,
  112,113,114,115,115,115,117,117,118,118,119,119,121,122,122,115,116,117,118,
  120,121,122,123,115,116,117,118,119,121,121,122,112,112,112,114,117,120,122,
  78,193,193,193,194,91,95,136,34,186,187,188,188,188,189,189,45,45,46,47,47,
  47,47,2,2,193,194,194,195,196,197,198,199,200,200,200,200,201,202,204,205,
  193,193,193,193,112,112,114,116,118,118,120,120,120,120,75,75,193,193,193,86,
  112,112,113,114,75,75,76,77,122,124,125,126,205,206,207,241,243,244,246,0,
  113,112,195,198,198,199,204,96,0,126,127,104,193,5,6,7,8,123,124,126,12,122,
  123,124,193,194,194,90,90,92,93,95,96,98,98,100,101,102,103,3,105,106,107,14,
  15,15,238,238,239,239,239,1,1,2,2,2,193,193,193,193,193,193,86,112,112,112,
  112,113,114,115,115,115,116,117,117,118,118,119,120,121,121,122,122,123,123,
  124,124,125,194,194,194,194,194,194,194,194,194,194,194,194,195,195,195,93,
  94,95,96,97,98,100,101,102,103,104,104,106,106,108,109,110,112,113,113,113,
  114,115,115,117,119,119,120,121,123,124,125,127,112,112,113,114,115,115,116,
  117,118,118,119,119,121,121,122,122,115,117,118,119,121,121,123,124,116,117,
  118,118,119,121,122,122,112,112,112,114,117,120,122,78,193,193,193,88,91,95,
  136,34,187,187,188,188,189,189,45,45,46,47,47,47,47,2,2,2,194,194,194,195,
  196,197,198,199,200,200,200,200,201,202,204,205,193,193,193,86,112,112,114,
  117,118,118,120,120,120,74,75,75,193,193,193,86,112,112,113,114,75,76,76,77,
  123,124,125,126,205,206,207,241,243,244,246,0,114,112,195,198,198,199,204,96,
  0,126,127,104,193,5,6,7,8,123,124,126,12,123,124,125,194,194,88,90,92,93,95,
  96,98,98,100,100,101,102,3,3,106,106,107,14,15,15,238,238,239,239,1,1,1,2,2,
  2,194,193,193,193,193,194,112,112,112,112,113,114,115,115,115,116,117,117,
  118,118,118,119,121,121,121,122,122,123,123,124,125,125,194,194,194,194,194,
  194,194,194,194,194,194,195,195,195,93,94,95,95,97,98,98,100,102,102,104,104,
  106,106,108,108,110,110,112,113,113,113,114,115,115,117,119,120,121,123,123,
  124,125,127,112,113,114,115,115,116,117,118,118,119,119,119,121,121,122,122,
  116,117,118,119,121,122,123,124,116,117,118,119,121,121,122,123,112,112,114,
  117,117,120,122,78,193,194,194,88,92,95,136,34,187,188,188,189,189,189,45,45,
  46,47,47,47,47,2,2,2,194,194,195,195,196,197,198,199,200,200,200,201,202,202,
  204,206,193,194,193,112,112,113,114,118,118,120,120,120,74,75,75,75,193,193,
  193,86,112,112,113,114,75,76,77,78,123,124,125,126,206,207,207,241,243,244,
  246,0,114,112,195,198,198,199,204,96,0,126,127,104,194,5,6,7,8,123,124,126,
  12,123,124,125,194,88,90,90,93,93,95,96,98,100,100,101,102,103,3,105,106,107,
  14,15,15,15,238,238,239,239,1,1,2,2,2,2,194,194,193,193,194,194,194,112,112,
  113,114,115,115,115,116,116,117,118,118,118,119,120,121,121,121,122,122,123,
  124,124,125,125,194,194,194,194,194,194,194,194,194,194,195,195,195,93,93,95,
  95,96,97,98,100,101,102,103,104,106,106,106,108,109,110,5,113,113,113,114,
  114,115,115,117,119,120,121,123,123,124,125,127,113,113,114,115,116,116,117,
  118,118,119,119,121,121,122,122,122,116,117,118,120,121,122,123,124,116,118,
  118,119,121,121,122,123,112,112,114,117,120,122,78,78,194,194,194,90,93,96,
  136,34,187,188,188,189,189,45,45,46,46,47,47,47,47,2,2,2,194,194,195,196,196,
  197,198,199,200,200,200,201,202,204,205,206,194,194,193,112,112,114,115,118,
  120,120,120,120,74,75,75,75,194,194,193,112,112,112,113,114,76,76,77,78,123,
  124,125,126,206,207,241,241,243,244,246,0,115,112,195,198,199,199,204,117,0,
  127,127,104,194,5,6,7,8,123,124,126,12,123,124,125,194,90,90,93,93,95,96,98,
  98,100,101,102,103,3,105,106,106,14,14,15,15,238,238,239,239,239,1,1,2,2,2,2,
  194,194,194,112,112,112,88,112,113,114,114,115,115,116,117,117,117,118,118,
  119,119,121,121,121,122,122,122,123,124,124,125,126,194,194,194,194,194,194,
  194,194,195,195,195,195,93,94,94,95,96,97,98,100,100,101,103,103,104,106,106,
  108,108,109,110,5,113,113,113,114,115,115,117,117,119,120,121,123,124,125,
  125,127,113,114,115,115,116,117,118,118,119,119,119,121,121,122,122,123,117,
  118,119,120,121,122,123,124,117,118,119,119,121,121,122,123,112,112,114,117,
  120,122,78,78,194,194,194,90,95,98,136,188,188,188,189,189,45,45,45,46,47,47,
  47,47,47,2,2,2,194,194,195,196,197,197,198,200,200,200,200,201,202,204,205,
  206,194,194,112,112,113,115,115,118,120,120,120,74,75,75,75,76,194,194,193,
  112,112,112,112,114,76,77,78,78,123,125,125,126,206,207,241,243,243,244,246,
  0,115,112,195,198,199,204,204,117,0,127,127,106,194,6,6,7,8,124,126,126,12,
  123,124,125,112,90,92,93,95,96,96,98,100,100,102,102,103,3,106,106,14,14,15,
  15,238,238,238,239,239,1,1,2,2,2,2,2,194,194,112,112,112,112,112,113,113,114,
  115,115,116,116,117,117,118,118,119,119,120,121,121,121,122,122,123,123,124,
  124,125,126,194,194,194,194,194,194,194,194,195,195,195,195,93,94,95,96,97,
  97,98,100,101,102,103,104,104,106,106,108,108,109,110,5,113,113,114,114,115,
  115,117,119,120,120,121,123,124,125,127,127,114,115,115,116,117,117,118,118,
  119,119,121,121,121,122,123,123,117,118,119,121,122,122,124,124,117,118,119,
  121,121,122,123,123,112,112,114,117,120,122,78,78,194,194,112,92,96,98,101,
  188,188,189,189,189,45,45,46,46,47,47,47,47,2,2,2,2,194,194,195,196,197,198,
  198,200,200,200,201,201,202,204,205,206,194,194,112,112,114,115,115,120,120,
  120,74,74,75,75,75,76,194,194,112,112,112,112,112,114,76,77,78,78,124,125,
  126,126,206,207,241,243,244,244,246,0,115,112,195,198,199,204,204,118,0,127,
  127,106,194,6,6,7,8,124,126,12,12,124,124,125,112,112,93,96,96,96,96,100,100,
  101,102,103,3,105,106,106,14,14,15,15,238,238,239,239,1,1,2,2,2,2,2,2,194,
  194,112,112,112,112,112,112,114,115,115,115,116,117,117,118,118,118,119,120,
  121,121,121,122,122,122,123,124,124,124,125,126,194,194,194,194,194,194,194,
  195,195,195,93,93,94,95,95,96,98,98,100,101,101,103,104,104,106,106,106,108,
  108,109,5,5,113,113,114,115,115,115,117,119,120,120,121,123,124,125,127,127,
  115,115,116,117,117,118,118,119,119,121,121,121,122,122,123,123,118,119,119,
  121,122,123,124,124,118,118,119,121,121,122,123,123,112,114,114,117,120,122,
  78,78,194,194,112,93,96,100,102,188,188,189,189,45,45,45,46,47,47,47,47,47,2,
  2,2,2,194,194,194,196,197,198,198,200,200,200,201,202,202,204,205,206,194,
  194,112,112,114,115,117,120,120,120,74,75,75,75,76,76,194,194,112,112,112,
  112,112,114,77,78,78,78,124,125,126,126,206,207,241,243,244,244,246,0,115,
  112,90,198,199,204,204,118,0,127,127,106,194,6,7,8,8,124,126,12,12,124,125,
  125,112,112,113,96,96,96,96,100,101,102,103,103,3,106,106,14,14,15,15,238,
  238,238,239,1,1,1,2,2,2,2,2,2,194,112,112,112,112,112,112,112,115,115,115,
  116,117,117,118,118,118,119,120,121,121,121,122,122,122,123,123,124,124,125,
  125,126,194,194,194,194,194,195,195,195,195,93,94,94,95,96,96,97,98,98,100,
  101,102,103,104,104,106,106,108,108,109,110,5,5,113,114,114,115,115,117,119,
  119,120,121,123,123,124,125,127,127,115,115,116,117,118,118,119,119,119,121,
  121,122,122,123,123,124,118,119,121,121,122,123,124,124,118,119,119,121,121,
  122,123,123,112,114,117,118,120,122,78,1,194,112,112,95,98,101,103,189,189,
  189,45,45,45,46,46,47,47,47,47,47,2,2,2,2,194,194,195,196,197,198,200,200,
  200,200,201,202,204,204,205,207,194,194,112,112,115,115,117,120,120,74,75,75,
  75,76,76,77,194,194,112,112,112,112,114,114,78,78,78,239,124,125,126,126,207,
  207,241,243,244,244,246,0,116,114,90,198,199,204,204,118,0,127,127,106,194,6,
  7,8,8,124,126,12,12,124,125,125,112,113,96,96,96,96,100,100,118,103,119,120,
  106,106,14,14,15,15,15,238,238,239,1,1,1,1,2,2,2,2,2,2,194,112,112,112,112,
  112,113,113,115,115,116,117,117,118,118,118,119,120,120,121,121,121,122,122,
  122,123,124,124,124,125,125,126,194,194,194,194,195,195,195,195,93,93,94,95,
  96,96,97,98,100,100,101,102,103,104,104,104,106,106,108,109,109,110,5,5,113,
  114,115,115,115,117,119,120,120,121,123,123,124,125,127,127,115,116,117,118,
  118,118,119,119,121,121,121,122,122,123,123,124,118,119,121,121,122,123,124,
  124,118,119,121,121,122,123,123,123,112,114,117,118,121,122,78,1,194,112,112,
  96,98,101,103,189,189,45,45,45,46,46,47,47,47,47,47,2,2,2,2,2,194,194,195,93,
  197,198,200,200,200,201,201,202,204,205,205,207,194,112,112,113,115,116,117,
  120,120,75,75,75,122,76,76,78,194,112,112,112,112,114,114,114,78,78,78,239,
  124,125,126,126,207,241,241,243,244,244,246,0,117,114,195,198,199,204,204,
  119,0,127,7,106,194,6,7,8,8,124,126,12,12,124,125,125,113,96,96,96,96,96,100,
  118,119,119,120,120,106,106,14,14,15,15,238,238,238,239,1,1,1,2,2,2,2,2,2,2,
  194,112,112,112,113,113,114,115,115,116,117,117,118,118,118,119,119,120,121,
  121,121,122,122,122,123,123,124,124,125,125,126,126,194,194,195,195,195,195,
  195,93,94,94,95,95,96,97,98,98,100,101,102,103,103,104,104,106,106,108,108,
  109,109,110,5,5,114,115,115,115,117,119,119,120,121,121,123,124,124,125,127,
  127,116,117,118,118,118,119,119,119,121,121,121,122,122,123,124,124,119,119,
  121,122,123,123,124,125,119,121,121,121,122,123,123,110,114,114,117,118,121,
  78,78,1,194,194,113,96,100,101,3,189,189,45,45,45,46,47,47,47,47,47,47,2,2,2,
  2,2,194,195,195,94,96,198,200,200,200,201,202,202,204,205,206,207,194,194,
  112,113,116,117,117,120,120,75,122,122,122,76,78,78,194,112,112,112,114,114,
  114,114,78,78,78,239,124,125,126,126,207,241,241,243,244,246,246,0,117,114,
  96,199,199,204,204,119,0,127,7,108,194,6,7,8,8,124,126,127,12,124,125,125,96,
  96,96,96,96,117,118,119,119,120,121,121,121,121,14,15,15,15,238,238,1,1,1,1,
  1,2,2,2,2,2,2,2,194,112,112,113,113,114,115,115,116,117,117,118,118,118,119,
  119,120,121,121,121,121,122,122,122,123,124,124,124,125,125,126,126,194,195,
  195,195,195,93,93,94,95,95,96,96,97,98,98,100,101,101,102,103,104,104,106,
  106,106,108,108,109,110,5,5,5,114,115,115,117,117,119,120,120,121,121,123,
  124,124,125,127,7,117,117,118,118,119,119,119,121,121,122,122,122,123,123,
  124,124,119,121,121,122,123,124,124,125,119,121,121,121,122,123,123,110,114,
  116,118,120,121,78,78,1,194,195,114,96,100,102,105,45,45,45,45,46,46,47,47,
  47,47,47,2,2,2,2,2,2,194,195,93,95,97,200,200,200,200,201,202,204,204,205,
  206,207,194,194,113,115,116,117,120,120,120,75,122,122,122,78,78,78,194,112,
  112,113,114,114,114,117,78,78,78,239,124,125,126,126,207,241,243,243,244,246,
  246,0,117,114,96,199,199,204,204,119,0,127,7,108,194,6,7,8,8,5,126,12,8,124,
  125,125,96,96,96,117,117,118,118,119,120,120,121,121,121,121,15,15,15,238,
  238,239,1,1,1,1,2,2,2,2,2,2,2,2,195,113,113,114,114,115,115,115,116,117,118,
  118,118,119,120,120,121,121,121,121,122,122,122,123,123,124,124,124,125,125,
  126,126,195,195,195,195,93,94,94,95,96,96,97,97,98,100,100,101,102,102,103,
  104,104,106,106,106,108,108,109,109,110,5,5,6,115,115,115,117,119,119,120,
  120,121,123,123,124,125,125,127,8,118,118,118,119,119,119,121,121,121,122,
  122,123,123,124,124,124,119,121,122,122,123,124,124,125,119,121,121,122,123,
  123,124,124,115,116,118,121,121,122,123,1,194,195,115,96,101,103,105,45,45,
  45,46,46,47,47,47,47,47,47,2,2,2,2,2,2,195,195,94,96,98,201,201,201,201,202,
  202,204,204,205,206,241,194,195,114,115,117,118,120,120,122,122,122,122,122,
  78,78,78,194,112,113,115,114,114,117,117,78,78,239,1,124,125,126,127,241,241,
  243,243,244,246,246,0,118,117,96,199,204,204,108,119,0,127,7,108,195,6,7,8,8,
  5,126,12,8,125,125,126,96,116,117,117,118,118,119,119,119,121,121,121,121,
  122,15,15,238,238,238,1,1,1,1,2,2,2,2,2,2,2,2,127,195,114,114,115,115,115,
  116,116,116,118,118,118,119,120,120,121,121,121,121,122,122,122,123,123,124,
  124,125,124,125,126,126,126,195,195,93,93,94,95,95,96,96,97,98,98,100,100,
  101,101,102,103,104,104,104,106,106,106,108,109,109,110,110,5,5,6,115,115,
  117,117,119,120,120,121,121,123,123,124,125,125,127,8,118,118,119,119,119,
  121,121,121,122,122,122,123,123,124,124,124,121,121,122,123,124,124,125,125,
  121,121,121,122,123,123,124,124,116,116,118,121,122,123,124,126,195,195,115,
  117,102,3,106,45,45,46,46,47,47,47,47,47,47,2,2,2,2,2,2,127,195,93,95,97,98,
  201,201,201,201,202,202,204,205,205,207,241,195,195,115,115,117,118,120,120,
  122,122,122,122,78,78,78,78,195,195,114,115,116,117,117,117,78,78,239,1,125,
  125,126,127,241,241,243,244,244,246,246,0,118,117,96,199,204,204,108,121,0,
  127,8,109,195,6,7,8,8,125,126,127,8,125,125,126,116,117,117,118,118,118,119,
  119,121,121,121,121,122,122,123,123,124,238,1,1,1,1,1,2,2,2,2,2,2,2,127,127,
  93,115,115,115,115,116,116,117,117,118,118,119,120,121,121,121,121,122,122,
  122,122,123,123,124,124,124,125,125,125,126,126,127,93,93,94,94,95,96,96,97,
  97,98,98,100,100,101,101,102,103,104,104,106,106,106,106,108,108,109,109,110,
  5,5,6,6,115,117,117,119,119,120,121,121,123,123,124,124,125,127,127,8,118,
  119,119,119,121,121,121,122,122,122,123,123,124,124,124,125,121,122,122,123,
  124,124,125,125,121,121,122,122,123,109,124,5,116,117,120,121,122,123,124,
  126,195,93,116,117,103,105,107,15,46,46,47,47,47,47,47,47,47,2,2,2,2,2,2,127,
  93,95,96,98,100,201,201,201,201,202,204,204,205,206,207,241,195,93,115,116,
  117,118,119,122,122,122,122,78,78,78,78,78,195,195,115,116,116,117,117,117,
  78,239,1,1,125,126,126,127,241,243,243,244,244,246,246,0,119,117,96,199,204,
  204,109,121,0,7,8,109,195,7,7,8,8,126,127,127,8,125,125,126,117,117,118,118,
  119,119,119,121,121,121,122,122,122,122,123,123,124,124,1,1,1,1,2,2,2,2,2,2,
  2,2,127,127,94,95,115,116,116,117,117,117,117,118,118,120,121,121,121,121,
  122,122,122,122,122,123,124,124,124,125,125,125,125,126,126,127,94,94,95,95,
  96,97,97,98,98,98,100,100,101,102,102,103,104,104,104,106,106,106,108,108,
  109,109,110,5,5,5,6,6,117,117,119,119,120,120,121,121,123,123,124,124,125,
  127,127,8,119,119,119,121,121,121,122,122,122,123,123,124,124,124,124,125,
  121,122,123,123,124,124,125,126,121,122,122,123,123,110,124,5,116,118,121,
  121,122,123,125,126,195,95,117,118,119,106,107,15,46,47,47,47,47,47,47,47,2,
  2,2,2,2,2,2,127,94,95,97,98,101,202,202,202,202,202,204,204,205,206,207,241,
  195,94,116,117,118,119,120,122,122,122,78,78,78,78,78,78,195,94,115,116,116,
  117,117,120,239,1,1,1,125,126,126,127,241,243,243,244,244,246,246,0,120,118,
  96,199,204,204,109,121,0,7,8,109,94,7,7,8,8,126,127,127,8,125,126,126,118,
  118,118,119,119,119,121,121,121,121,122,122,122,123,123,124,124,124,125,1,1,
  2,2,2,2,2,2,2,127,127,127,127,95,115,117,117,117,118,118,118,118,118,120,121,
  121,121,121,121,122,122,122,122,123,124,124,124,124,125,125,125,125,126,126,
  127,95,95,96,96,97,98,98,98,100,100,101,101,102,103,103,104,104,104,106,106,
  106,108,108,108,109,110,110,5,5,5,6,6,117,119,119,120,120,121,121,123,123,
  123,124,125,125,127,127,8,119,119,121,121,121,122,122,122,123,123,123,124,
  124,124,125,125,122,122,123,124,124,125,125,126,121,122,122,123,109,110,124,
  5,117,118,121,122,122,123,125,126,94,95,117,118,120,106,14,15,47,47,47,47,47,
  47,47,2,2,2,2,2,2,2,127,127,95,96,98,100,102,202,202,202,202,204,204,205,205,
  206,207,241,94,95,117,118,118,120,121,122,122,78,78,78,78,78,78,239,94,115,
  115,116,117,118,120,120,1,1,1,2,125,126,126,127,241,243,243,244,244,246,246,
  0,121,118,97,204,204,204,110,122,0,7,8,110,95,7,7,8,0,6,127,7,8,125,126,126,
  118,119,119,119,119,121,121,121,122,122,122,122,123,123,124,124,124,125,125,
  125,126,126,126,2,2,2,2,127,127,127,127,127,96,97,117,118,118,118,118,118,
  119,119,120,121,121,121,122,122,122,122,123,123,124,124,124,124,125,125,125,
  125,126,126,127,127,96,97,97,97,98,98,100,100,101,101,102,102,103,104,104,
  104,106,106,106,106,108,108,108,109,109,110,5,5,5,6,6,6,119,119,120,120,120,
  121,121,123,123,124,124,125,125,127,127,8,121,121,121,121,122,122,122,123,
  123,124,124,124,124,125,125,125,122,123,123,124,124,125,126,126,122,122,123,
  123,110,124,5,5,118,120,121,122,123,124,125,126,95,97,118,119,121,14,15,238,
  47,47,47,47,47,47,2,2,2,2,2,2,2,2,127,127,96,98,100,101,103,202,202,202,202,
  204,204,205,206,207,241,243,95,96,118,118,118,121,121,122,78,78,78,78,78,78,
  1,1,95,115,116,117,118,118,120,120,1,1,1,2,125,126,127,127,243,243,244,244,
  246,246,0,0,121,120,98,204,204,204,110,122,0,7,8,110,96,7,8,8,0,6,127,7,8,
  126,126,126,119,119,119,121,121,121,121,122,122,122,123,123,123,124,124,124,
  125,125,125,126,126,126,126,126,126,126,127,127,127,127,127,127,97,98,118,
  118,118,119,119,119,119,120,121,121,122,122,122,122,122,123,123,124,124,124,
  125,125,125,125,125,126,126,126,127,127,97,98,98,98,100,100,101,101,102,102,
  103,103,104,104,104,106,106,106,106,108,108,108,109,109,110,5,5,5,5,6,6,6,
  119,119,120,120,121,121,123,123,124,124,124,125,127,127,7,8,121,121,121,122,
  122,122,123,123,124,124,124,124,110,125,125,5,122,123,124,124,125,125,126,
  126,122,123,123,109,110,5,5,126,118,120,122,122,123,124,126,126,96,98,119,
  119,121,14,15,238,47,47,47,47,47,2,2,2,2,2,2,2,2,127,127,127,97,98,101,102,
  104,204,204,204,204,204,205,205,206,207,241,243,96,97,118,119,120,121,121,78,
  78,78,78,78,78,1,1,1,96,116,116,118,118,121,121,122,1,1,126,2,126,126,127,
  127,243,243,244,244,246,246,0,0,121,121,100,204,204,108,110,123,0,8,8,5,97,7,
  8,8,0,6,127,8,8,126,126,127,119,119,121,121,121,121,122,122,123,123,123,123,
  124,124,125,125,125,125,126,126,126,126,126,126,126,127,127,127,127,127,127,
  127,98,100,119,119,119,119,119,119,121,121,121,121,122,122,122,122,123,124,
  124,124,124,125,125,125,125,125,126,126,126,127,127,127,98,100,100,100,101,
  102,102,102,103,103,104,104,104,106,106,106,106,106,108,108,108,109,109,110,
  110,5,5,5,6,6,6,7,120,120,120,121,121,123,123,123,124,124,125,125,127,127,8,
  8,121,122,122,122,123,123,123,124,124,109,124,125,125,125,5,126,123,124,124,
  124,125,125,126,126,108,123,109,110,5,5,126,6,120,120,122,123,124,125,126,
  126,97,100,119,121,121,15,238,239,47,47,47,47,2,2,2,2,2,2,2,2,2,127,127,127,
  98,101,102,103,104,204,204,204,204,205,205,206,207,207,241,243,97,98,119,119,
  120,121,122,78,78,78,78,78,1,1,1,1,97,117,117,118,120,120,121,122,126,126,
  126,2,126,126,127,127,243,243,244,244,246,246,0,0,122,120,101,204,204,109,5,
  123,0,8,8,5,98,7,8,8,0,6,7,8,8,126,126,127,121,121,121,121,122,122,122,123,
  123,123,124,124,124,125,125,125,126,126,126,126,126,126,126,126,127,127,127,
  127,127,127,127,127,100,101,119,119,119,121,121,121,121,121,122,122,122,122,
  123,123,124,124,124,124,125,125,125,125,125,126,126,126,126,127,127,127,100,
  101,101,102,102,103,103,104,104,104,104,104,106,106,106,106,108,108,108,109,
  109,109,110,110,5,5,5,6,6,6,6,7,120,120,121,121,123,123,123,124,124,124,125,
  125,127,127,8,8,122,122,106,106,123,108,108,124,109,109,110,125,125,5,126,
  126,123,124,124,125,125,126,126,127,123,109,110,110,5,5,126,6,120,121,122,
  123,124,125,126,126,98,101,121,121,122,122,238,239,47,47,2,2,2,2,2,2,2,2,2,2,
  127,127,127,127,100,102,103,104,106,204,204,204,204,205,206,206,207,241,243,
  243,98,101,119,121,121,122,122,78,78,78,123,124,125,1,126,126,98,118,118,120,
  120,120,122,122,126,126,126,126,126,127,127,127,243,244,244,244,246,246,0,0,
  122,122,102,204,204,109,5,124,0,8,8,5,101,7,8,8,0,127,7,8,8,126,127,127,121,
  121,122,122,122,122,123,123,124,124,124,124,125,125,125,126,126,126,126,126,
  126,126,126,126,127,127,127,127,127,127,127,127,102,102,103,121,121,121,121,
  121,122,122,122,122,123,123,124,124,124,124,125,125,125,125,125,125,126,126,
  126,126,127,127,127,7,102,102,103,103,103,104,104,104,104,106,106,106,106,
  106,106,108,108,108,109,109,109,110,5,5,5,5,5,6,6,6,7,7,121,121,121,123,123,
  123,124,124,124,125,125,127,127,127,8,8,106,106,106,108,108,108,109,109,109,
  110,110,125,5,126,126,126,124,124,124,125,126,126,126,127,109,110,110,5,5,5,
  6,6,121,122,123,124,125,126,126,126,101,102,121,122,122,123,238,239,47,2,2,2,
  2,2,2,2,2,2,2,127,127,127,127,127,102,103,104,106,106,205,205,205,205,205,
  206,207,207,241,243,243,101,102,121,121,122,122,123,123,123,124,124,125,125,
  126,126,126,101,118,119,119,121,122,122,122,126,126,126,126,126,127,127,7,
  243,244,244,246,246,246,0,0,122,122,104,204,204,110,5,124,0,8,8,5,102,8,8,0,
  0,7,7,8,8,127,127,127,122,122,122,123,123,123,124,124,124,124,125,125,125,
  125,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  103,104,104,121,121,122,122,122,122,122,123,123,124,124,124,124,124,125,125,
  125,125,125,126,126,126,126,126,126,127,127,127,7,103,104,104,104,104,104,
  106,106,106,106,106,106,108,108,108,108,109,109,109,110,110,5,5,5,5,6,6,6,6,
  6,7,7,121,121,123,123,123,124,124,124,125,125,125,127,127,127,8,8,106,108,
  108,108,109,109,109,110,110,110,5,5,5,126,126,126,124,124,125,125,126,126,
  127,127,110,110,5,5,5,6,6,6,121,122,123,124,125,126,126,127,102,104,122,122,
  123,124,1,1,2,2,2,2,2,2,2,2,2,2,127,127,127,127,127,127,103,104,106,106,108,
  205,205,205,205,206,207,207,241,241,243,244,102,103,121,122,122,123,123,124,
  124,125,125,125,126,126,126,126,102,103,119,121,122,122,122,122,126,126,126,
  126,127,127,127,8,244,244,244,246,246,246,0,0,123,122,104,204,108,110,6,125,
  0,8,8,6,104,8,8,0,0,7,8,8,0,127,127,127,122,123,123,123,123,124,124,124,125,
  125,125,125,126,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,
  127,127,8,8,104,104,104,122,122,122,122,123,123,123,124,124,124,124,125,125,
  125,125,125,125,126,126,126,126,126,126,126,127,127,127,7,8,104,104,104,106,
  106,106,106,106,106,108,108,108,108,109,109,109,109,110,110,5,5,5,5,5,6,6,6,
  6,6,7,7,7,123,123,123,123,124,124,124,125,125,125,127,127,127,8,8,8,108,108,
  109,109,109,110,110,110,5,5,5,126,126,126,6,127,124,125,125,126,126,126,127,
  127,110,5,5,5,6,6,6,127,122,123,124,124,125,126,126,127,104,104,122,123,124,
  124,1,1,2,2,2,2,2,2,2,2,2,127,127,127,127,127,127,8,104,106,106,108,108,206,
  206,206,206,207,207,241,241,243,243,244,104,104,122,122,123,124,124,125,125,
  125,126,126,126,126,126,126,104,104,121,121,122,122,123,123,126,126,126,127,
  127,127,7,8,244,244,244,246,246,246,0,0,124,123,106,204,109,5,6,110,0,8,8,6,
  104,8,8,0,0,7,8,8,0,127,127,7,123,123,124,124,124,124,125,125,125,125,126,
  126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,8,8,
  8,106,106,106,106,123,123,123,123,124,124,124,124,125,125,125,125,125,125,
  125,126,126,126,126,126,126,127,127,127,127,7,7,8,106,106,106,106,106,106,
  108,108,108,108,108,109,109,109,109,110,110,110,5,5,5,5,5,6,6,6,6,6,7,7,7,7,
  123,123,124,124,124,124,125,125,125,125,127,127,127,8,8,8,109,109,109,110,
  110,110,5,5,5,5,126,126,126,6,127,127,125,125,126,126,126,127,127,127,5,5,5,
  6,6,6,127,7,123,124,124,125,126,126,126,127,104,106,123,124,124,125,126,2,2,
  2,2,2,2,2,2,2,127,127,127,127,127,127,8,8,106,106,108,108,109,207,207,207,
  207,207,241,241,243,243,244,244,104,106,106,123,124,124,125,125,126,126,126,
  126,126,126,126,126,104,106,121,122,123,123,124,124,126,126,127,127,127,127,
  7,8,244,244,246,246,246,246,0,0,124,123,106,109,110,5,6,110,0,8,0,6,106,8,8,
  0,0,7,8,8,0,127,7,7,108,124,109,109,125,125,125,126,126,126,126,126,126,126,
  126,126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,8,106,108,108,
  108,108,124,124,124,124,125,125,125,125,125,125,126,126,126,126,126,126,126,
  126,126,127,127,127,127,7,7,8,8,106,106,108,108,108,108,108,109,109,109,109,
  109,110,110,110,5,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,8,124,124,124,124,125,125,
  125,125,127,127,127,127,7,8,8,0,110,110,110,110,5,5,5,5,126,126,126,6,6,127,
  127,127,5,126,126,126,127,127,127,7,5,6,6,6,6,7,7,7,123,124,124,125,126,126,
  127,127,106,108,108,124,125,125,126,2,2,2,2,2,2,2,127,127,127,127,127,127,
  127,8,8,8,106,108,108,109,110,207,207,207,207,241,241,243,243,243,244,244,
  106,106,108,124,124,125,125,126,126,126,126,126,126,126,126,126,106,106,122,
  123,124,124,124,124,126,127,127,127,127,7,8,8,244,246,246,246,246,0,0,0,125,
  124,108,109,5,5,6,5,0,8,0,7,108,8,8,0,0,8,8,8,0,7,7,8,109,110,110,110,110,
  125,126,126,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  127,8,8,8,8,8,8,8,108,108,109,109,109,109,125,125,125,125,125,125,125,126,
  126,126,126,126,126,126,126,127,127,127,127,127,127,7,7,8,8,8,108,108,109,
  109,109,109,109,110,110,110,110,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,8,8,
  124,124,125,125,125,125,125,127,127,127,127,127,8,8,8,0,110,5,5,5,5,5,126,
  126,6,6,6,127,127,127,7,7,126,126,126,127,127,127,7,7,6,6,6,6,7,7,7,7,124,
  125,125,126,126,127,127,127,108,108,109,125,126,126,126,2,2,2,2,127,127,127,
  127,127,127,127,127,127,8,8,8,8,108,109,109,110,5,241,241,241,241,241,243,
  243,243,244,244,246,108,108,109,124,125,125,126,126,126,126,126,126,126,126,
  127,127,108,108,123,123,124,124,124,124,127,127,127,127,7,7,8,8,246,246,246,
  246,246,0,0,0,126,124,109,110,5,6,7,126,0,8,0,7,109,8,0,0,0,8,8,0,0,7,8,8,
  110,5,5,5,5,126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,
  127,127,8,8,8,8,8,8,8,8,0,109,110,110,110,110,110,125,125,125,125,126,126,
  126,126,126,126,126,126,127,127,127,127,127,127,127,127,7,7,8,8,8,8,109,110,
  110,110,110,110,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,125,125,
  125,125,125,127,127,127,127,127,7,8,8,8,0,0,5,5,5,6,6,6,6,6,6,127,127,127,7,
  7,7,7,6,6,127,127,7,7,8,8,6,6,6,7,7,7,7,8,124,125,126,126,127,127,127,127,
  109,110,110,5,126,126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,
  8,8,0,109,110,110,5,5,243,243,243,243,243,243,244,244,244,244,246,109,109,
  110,125,125,126,126,126,126,126,126,127,127,127,127,127,109,109,110,124,124,
  124,124,124,127,127,127,127,7,8,8,8,246,246,246,246,0,0,0,0,126,125,110,5,6,
  6,7,6,0,0,0,7,110,0,0,0,0,8,8,0,0,8,8,8,5,5,126,126,126,126,127,127,127,127,
  127,127,127,127,127,127,127,127,7,8,8,8,8,8,8,8,8,8,8,0,0,0,5,5,5,5,5,5,126,
  126,126,126,126,126,126,127,127,127,127,127,127,127,127,127,127,7,7,7,8,8,8,
  8,8,8,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,8,8,8,8,8,8,125,
  125,127,127,127,127,127,127,7,8,8,8,8,8,0,0,6,6,6,6,6,6,127,7,7,7,7,7,7,7,8,
  8,127,127,7,7,7,8,8,8,7,7,7,7,7,8,8,8,126,126,126,127,127,127,127,8,110,5,5,
  126,126,127,127,127,127,127,127,127,127,127,127,127,8,8,8,8,8,8,0,0,5,5,5,6,
  6,243,243,243,243,244,244,244,244,246,246,246,110,5,5,126,126,126,126,127,
  127,127,127,127,127,127,127,127,110,5,5,126,126,126,126,126,127,127,127,8,8,
  8,8,0,246,246,246,246,0,0,0,0,126,126,5,6,6,7,7,127,0,0,0,8,5,0,0,0,0,8,0,0,
  0,8,8,8,6,6,6,127,127,127,127,127,127,127,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,
  8,0,0,0,0,6,6,6,6,6,6,6,6,127,127,127,127,127,127,127,127,127,127,7,7,7,7,8,
  8,8,8,8,8,8,8,8,0,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,
  8,8,0,127,127,127,127,127,7,7,8,8,8,8,8,8,0,0,0,6,6,7,7,7,7,7,7,7,7,7,8,8,8,
  8,8,7,7,7,8,8,8,8,8,7,7,7,8,8,8,8,8,126,127,127,127,127,8,8,8,5,6,6,6,127,
  127,127,127,127,127,127,8,8,8,8,8,8,8,8,8,0,0,0,0,6,6,6,6,6,244,244,244,244,
  244,244,244,246,246,246,246,5,6,6,6,127,127,127,127,127,127,127,127,127,127,
  127,8,5,6,6,126,126,126,126,12,8,8,8,8,8,8,0,0,246,246,246,0,0,0,0,0,127,127,
  6,6,7,7,8,7,0,0,0,8,6,0,0,0,0,0,0,0,0,8,0,0,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,
  8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,6,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,0,0,0,0,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,
  0,0,0,0,7,7,8,8,8,8,8,8,8,8,8,0,0,0,0,0,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,0,8,8,8,8,8,8,8,0,127,7,7,8,8,8,8,0,6,7,7,7,7,7,8,8,8,8,8,8,8,8,8,
  0,0,0,0,0,0,0,0,0,7,7,7,7,7,246,246,246,246,246,246,246,246,246,246,0,6,6,7,
  7,7,7,7,8,8,8,8,8,8,8,8,8,6,6,7,127,127,127,12,12,8,8,8,0,8,0,0,0,0,0,0,0,0,
  0,0,0,7,127,7,7,8,8,8,8,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,
  8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,0,
  0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,
  0,0,0,0,8,8,0,0,0,0,0,0,8,0,0,0,0,0,0,0,8,8,8,8,0,0,0,0,8,8,8,8,8,8,8,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,246,246,246,246,246,246,246,0,0,0,0,8,
  8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,8,8,8,8,8,0,0,8,193,193,193,194,0,193,193,193,193,194,194,193,193,194,194,
  194,108,106,104,103,102,100,98,97,95,94,93,195,195,195,194,194,194,194,194,
  194,194,194,194,194,194,194,194,194,194,193,193,193,7,6,6,5,110,109,108,108,
  106,104,104,102,101,98,97,97,95,94,93,93,195,195,194,194,194,194,194,194,194,
  194,194,194,7,6,5,5,109,108,108,106,104,104,102,101,100,98,97,96,95,94,93,
  195,195,195,194,194,194,194,194,194,194,194,194,194,106,104,102,100,97,95,93,
  195,195,194,194,194,194,194,193,193,102,101,98,97,96,95,94,93,195,195,195,
  194,194,194,194,194,95,93,195,195,194,194,194,194,93,195,195,194,194,194,194,
  194,7,108,104,98,94,195,194,194,0,6,109,104,100,96,93,194,194,194,194,194,
  194,194,194,194,194,194,194,194,194,193,193,193,7,109,104,100,95,195,194,194,
  194,194,194,193,193,193,193,193,0,7,5,109,106,104,101,98,96,95,94,93,195,195,
  194,194,0,0,8,7,7,6,5,5,194,194,194,194,194,194,194,194,193,193,193,193,193,
  193,193,193,103,110,104,195,194,194,194,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,
};

//jff 2/18/98 palette color ranges for translation

static const unsigned char cr_brick[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,46,46,46,46,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,46,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,
//   176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const unsigned char cr_tan[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,78,45,78,78,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,78,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const unsigned char cr_gray[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,110,110,46,110,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,110,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const unsigned char cr_green[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,127,127,46,127,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,127,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const unsigned char cr_brown[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,143,143,46,143,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,143,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const unsigned char cr_gold[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,167,167,46,167,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,167,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     160,160,161,161,162,162,163,163,164,164,165,165,166,166,167,167,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const unsigned char cr_red[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,191,191,46,191,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,191,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const unsigned char cr_blue[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,203,203,46,203,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,203,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     196,196,197,197,198,198,199,199,200,200,201,201,202,202,203,203,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

// killough 2/28/98: The blue translation table above looks bad on the
// status bar but a little better on the HUD. So I've created a separate
// translation table for the status bar, which is the same as last week's.

static const unsigned char cr_blue2[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,207,207,46,207,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,207,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     200,200,201,201,202,202,203,203,204,204,205,205,206,206,207,207,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

    
static const unsigned char cr_orange[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,223,223,46,223,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,223,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};
    
static const unsigned char cr_yellow[]=
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,231,231,46,231,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,231,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     224,224,225,225,226,226,227,227,228,228,229,229,230,230,231,231,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const unsigned char cr_black[] =
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
     16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
     32,33,34,35,36,37,38,39,40,41,42,43,111,111,46,111,
     48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     64,65,66,111,68,69,70,71,72,73,74,75,76,77,78,79,
     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
     96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
     112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
     128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
     144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
     160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
     104,104,105,105,106,106,107,107,108,108,109,109,110,110,111,111,
     192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
     208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
     224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
     240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const unsigned char cr_purple[] =
    {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
    16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
    32,33,34,35,36,37,38,39,40,41,42,43,254,254,46,254,
    48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
    64,65,66,254,68,69,70,71,72,73,74,75,76,77,78,79,
    80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
    96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
    112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
    128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
    144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
    160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
    251,251,251,251,252,252,252,252,253,253,253,253,254,254,254,254,
    192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
    208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
    224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
    240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

static const unsigned char cr_white[] =
   {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
   16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
   32,33,34,35,36,37,38,39,40,41,42,43,87,87,46,87,
   48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
   64,65,66,87,68,69,70,71,72,73,74,75,76,77,78,79,
   80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,
   96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
   112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
   128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
   144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
   160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
   80,80,81,81,82,82,83,83,84,84,85,85,86,86,87,87,
   192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
   208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
   224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
   240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255};

// [FG] replace embedded non-free dogs sprites and sounds
#include "dogs.h"

// [FG] replace embedded non-free plasma ball sprites
#include "beta.h"

// [FG] crosshair patches
#include "cross.h"

// mini-thermo patches
#include "thermo.h"

// killough 1/31/98: 
// Table of predefined lumps, used to make up for any wad deficiencies.
// Always overriden by iwad or pwads.

// see also the lump definitions above for additional comments

const lumpinfo_t predefined_lumps[]={
  { "STBR123",  sizeof stbr123, stbr123 }, //jff 02/16/98 bargraph patches
  { "STBR124",  sizeof stbr124, stbr124 },
  { "STBR125",  sizeof stbr125, stbr125 },
  { "STBR126",  sizeof stbr126, stbr126 },
  { "STBR127",  sizeof stbr127, stbr127 },
  { "DIG0",     sizeof dig0, dig0 }, //jff 02/20/98 smaller digit patches
  { "DIG1",     sizeof dig1, dig1 },
  { "DIG2",     sizeof dig2, dig2 },
  { "DIG3",     sizeof dig3, dig3 },
  { "DIG4",     sizeof dig4, dig4 },
  { "DIG5",     sizeof dig5, dig5 },
  { "DIG6",     sizeof dig6, dig6 },
  { "DIG7",     sizeof dig7, dig7 },
  { "DIG8",     sizeof dig8, dig8 },
  { "DIG9",     sizeof dig9, dig9 },
  { "DIGA",     sizeof diga, diga }, //jff 2/22/98 full new smaller hud font
  { "DIGB",     sizeof digb, digb },
  { "DIGC",     sizeof digc, digc },
  { "DIGD",     sizeof digd, digd },
  { "DIGE",     sizeof dige, dige },
  { "DIGF",     sizeof digf, digf },
  { "DIGG",     sizeof digg, digg },
  { "DIGH",     sizeof digh, digh },
  { "DIGI",     sizeof digi, digi },
  { "DIGJ",     sizeof digj, digj },
  { "DIGK",     sizeof digk, digk },
  { "DIGL",     sizeof digl, digl },
  { "DIGM",     sizeof digm, digm },
  { "DIGN",     sizeof dign, dign },
  { "DIGO",     sizeof digo, digo },
  { "DIGP",     sizeof digp, digp },
  { "DIGQ",     sizeof digq, digq },
  { "DIGR",     sizeof digr, digr },
  { "DIGS",     sizeof digs, digs },
  { "DIGT",     sizeof digt, digt },
  { "DIGU",     sizeof digu, digu },
  { "DIGV",     sizeof digv, digv },
  { "DIGW",     sizeof digw, digw },
  { "DIGX",     sizeof digx, digx },
  { "DIGY",     sizeof digy, digy },
  { "DIGZ",     sizeof digz, digz },
  { "DIG37",    sizeof dig37, dig37 },
  { "DIG43",    sizeof dig43, dig43 },
  { "DIG45",    sizeof dig45, dig45 },        //jff 3/3/98 add minus sign
  { "DIG46",    sizeof dig46, dig46 },
  { "DIG47",    sizeof dig47, dig47 },
  { "DIG58",    sizeof dig58, dig58 },
  { "DIG91",    sizeof dig91, dig91 },
  { "DIG93",    sizeof dig93, dig93 },
  { "STKEYS6",  sizeof stkeys6, stkeys6 }, //jff 2/24/98 double key graphics
  { "STKEYS7",  sizeof stkeys7, stkeys7 },
  { "STKEYS8",  sizeof stkeys8, stkeys8 },

  // [FG] crosshair patches
  { "CROSS00",  sizeof cross00, cross00 },
  { "CROSS01",  sizeof cross01, cross01 },
  { "CROSS02",  sizeof cross02, cross02 },
  { "CROSS03",  sizeof cross03, cross03 },

  // mini-thermo patches
  { "M_MTHRML",  sizeof therml, therml },
  { "M_MTHRMM",  sizeof thermm, thermm },
  { "M_MTHRMR",  sizeof thermr, thermr },
  { "M_MTHRMO",  sizeof thermo, thermo },

  // killough 8/98: remove ENDBOOM lump, use id's ENDOOM instead

  { "S_START"},                              // killough 3/21/98
  { "TNT1A0",   sizeof invis_sprite, invis_sprite },            // invis sprite

  // killough 7/19/98: Marine's best friend :)
  {"DOGSA1", sizeof dogsa1, dogsa1},
  {"DOGSA2", sizeof dogsa2, dogsa2},
  {"DOGSA3", sizeof dogsa3, dogsa3},
  {"DOGSA4", sizeof dogsa4, dogsa4},
  {"DOGSA5", sizeof dogsa5, dogsa5},
  {"DOGSA6", sizeof dogsa6, dogsa6},
  {"DOGSA7", sizeof dogsa7, dogsa7},
  {"DOGSA8", sizeof dogsa8, dogsa8},
  {"DOGSB1", sizeof dogsb1, dogsb1},
  {"DOGSB2", sizeof dogsb2, dogsb2},
  {"DOGSB3", sizeof dogsb3, dogsb3},
  {"DOGSB4", sizeof dogsb4, dogsb4},
  {"DOGSB5", sizeof dogsb5, dogsb5},
  {"DOGSB6", sizeof dogsb6, dogsb6},
  {"DOGSB7", sizeof dogsb7, dogsb7},
  {"DOGSB8", sizeof dogsb8, dogsb8},
  {"DOGSC1", sizeof dogsc1, dogsc1},
  {"DOGSC2", sizeof dogsc2, dogsc2},
  {"DOGSC3", sizeof dogsc3, dogsc3},
  {"DOGSC4", sizeof dogsc4, dogsc4},
  {"DOGSC5", sizeof dogsc5, dogsc5},
  {"DOGSC6", sizeof dogsc6, dogsc6},
  {"DOGSC7", sizeof dogsc7, dogsc7},
  {"DOGSC8", sizeof dogsc8, dogsc8},
  {"DOGSD1", sizeof dogsd1, dogsd1},
  {"DOGSD2", sizeof dogsd2, dogsd2},
  {"DOGSD3", sizeof dogsd3, dogsd3},
  {"DOGSD4", sizeof dogsd4, dogsd4},
  {"DOGSD5", sizeof dogsd5, dogsd5},
  {"DOGSD6", sizeof dogsd6, dogsd6},
  {"DOGSD7", sizeof dogsd7, dogsd7},
  {"DOGSD8", sizeof dogsd8, dogsd8},
  {"DOGSE1", sizeof dogse1, dogse1},
  {"DOGSE2", sizeof dogse2, dogse2},
  {"DOGSE3", sizeof dogse3, dogse3},
  {"DOGSE4", sizeof dogse4, dogse4},
  {"DOGSE5", sizeof dogse5, dogse5},
  {"DOGSE6", sizeof dogse6, dogse6},
  {"DOGSE7", sizeof dogse7, dogse7},
  {"DOGSE8", sizeof dogse8, dogse8},
  {"DOGSF1", sizeof dogsf1, dogsf1},
  {"DOGSF2", sizeof dogsf2, dogsf2},
  {"DOGSF3", sizeof dogsf3, dogsf3},
  {"DOGSF4", sizeof dogsf4, dogsf4},
  {"DOGSF5", sizeof dogsf5, dogsf5},
  {"DOGSF6", sizeof dogsf6, dogsf6},
  {"DOGSF7", sizeof dogsf7, dogsf7},
  {"DOGSF8", sizeof dogsf8, dogsf8},
  {"DOGSG1", sizeof dogsg1, dogsg1},
  {"DOGSG2", sizeof dogsg2, dogsg2},
  {"DOGSG3", sizeof dogsg3, dogsg3},
  {"DOGSG4", sizeof dogsg4, dogsg4},
  {"DOGSG5", sizeof dogsg5, dogsg5},
  {"DOGSG6", sizeof dogsg6, dogsg6},
  {"DOGSG7", sizeof dogsg7, dogsg7},
  {"DOGSG8", sizeof dogsg8, dogsg8},
  {"DOGSH1", sizeof dogsh1, dogsh1},
  {"DOGSH2", sizeof dogsh2, dogsh2},
  {"DOGSH3", sizeof dogsh3, dogsh3},
  {"DOGSH4", sizeof dogsh4, dogsh4},
  {"DOGSH5", sizeof dogsh5, dogsh5},
  {"DOGSH6", sizeof dogsh6, dogsh6},
  {"DOGSH7", sizeof dogsh7, dogsh7},
  {"DOGSH8", sizeof dogsh8, dogsh8},
  {"DOGSI0", sizeof dogsi0, dogsi0},
  {"DOGSJ0", sizeof dogsj0, dogsj0},
  {"DOGSK0", sizeof dogsk0, dogsk0},
  {"DOGSL0", sizeof dogsl0, dogsl0},
  {"DOGSM0", sizeof dogsm0, dogsm0},
  {"DOGSN0", sizeof dogsn0, dogsn0},

  // killough 7/19/98: Pre-Beta BFG fireballs
  {"PLS1A0", sizeof pls1a0, pls1a0},
  {"PLS1B0", sizeof pls1b0, pls1b0},
  {"PLS1C0", sizeof pls1a0, pls1a0}, // [FG] duplicate
  {"PLS1D0", sizeof pls1b0, pls1b0}, // [FG] duplicate
  {"PLS1E0", sizeof pls1e0, pls1e0},
  {"PLS1F0", sizeof pls1e0, pls1e0}, // [FG] duplicate
  {"PLS1G0", sizeof pls1g0, pls1g0},
  {"PLS2A0", sizeof pls2a0, pls2a0},
  {"PLS2B0", sizeof pls2b0, pls2b0},
  {"PLS2C0", sizeof pls2c0, pls2c0},
  {"PLS2D0", sizeof pls2d0, pls2d0},
  {"PLS2E0", sizeof pls2e0, pls2e0},

  // end of sprites
  { "S_END"},                          // phares 3/9/98    killough 3/21/98

  {"DSDGSIT", sizeof dsdgsit, dsdgsit},
  {"DSDGATK", sizeof dsdgatk, dsdgatk},
  {"DSDGACT", sizeof dsdgact, dsdgact},
  {"DSDGDTH", sizeof dsdgdth, dsdgdth},
  {"DSDGPAIN", sizeof dsdgpain, dsdgpain},

  { "SWITCHES", sizeof switches, switches},   // jff 3/23/98 switch list
  { "ANIMATED", sizeof animated, animated},   // jff 3/23/98 animation list
  { "M_COLORS", sizeof m_colors, m_colors},   // phares 4/01/98 menu item
  { "M_PALNO",  sizeof m_palno,  m_palno},    // phares 4/01/98 menu item
  { "C_START" },  // killough 4/4/98: colormap markers
  { "WATERMAP", sizeof watermap, watermap},   // killough 3/21/98, 4/4/98
  { "C_END" },    // killough 4/4/98: end colormap markers
  { "M_BUTT1",  sizeof m_butt1,  m_butt1},    // phares 4/16/98 reset button
  { "M_BUTT2",  sizeof m_butt2,  m_butt2},    // phares 4/16/98 reset button
  { "CRBRICK",  sizeof cr_brick, cr_brick},   // jff 4/24/98 brick color range
  { "CRTAN",    sizeof cr_tan,   cr_tan},     // jff 4/24/98 tan color range
  { "CRGRAY",   sizeof cr_gray,  cr_gray},    // jff 4/24/98 gray color range
  { "CRGREEN",  sizeof cr_green, cr_green},   // jff 4/24/98 green color range
  { "CRBROWN",  sizeof cr_brown, cr_brown},   // jff 4/24/98 brown color range
  { "CRGOLD",   sizeof cr_gold,  cr_gold},    // jff 4/24/98 gold color range
  { "CRRED",    sizeof cr_red,   cr_red},     // jff 4/24/98 red color range
  { "CRBLUE",   sizeof cr_blue,  cr_blue},    // jff 4/24/98 blue color range
  { "CRBLUE2",  sizeof cr_blue2, cr_blue2},   // jff 4/24/98 blue2 color range
  { "CRORANGE", sizeof cr_orange,cr_orange},  // jff 4/24/98 orange color range
  { "CRYELLOW", sizeof cr_yellow,cr_yellow},  // jff 4/24/98 yellow color range
  { "CRBLACK",  sizeof cr_black, cr_black},
  { "CRPURPLE", sizeof cr_purple,cr_purple},
  { "CRWHITE",  sizeof cr_white, cr_white},
};

// Calculate how many of them there are
const size_t num_predefined_lumps =
  sizeof predefined_lumps / sizeof *predefined_lumps;

//----------------------------------------------------------------------------
//
// $Log: info.c,v $
// Revision 1.44  1998/05/12  12:46:36  phares
// Removed OVER_UNDER code
//
// Revision 1.43  1998/05/12  09:35:07  phares
// Corrected 4001->5001 and 4002->5002 in OVER/UNDER table
//
// Revision 1.42  1998/05/12  08:41:13  jim
// fix decl of endboom
//
// Revision 1.40  1998/05/11  12:21:20  jim
// 4001/2 deconflicted with DosDOOM
//
// Revision 1.39  1998/05/06  11:30:54  jim
// Moved predefined lump writer info->w_wad
//
// Revision 1.38  1998/05/04  21:34:49  thldrmn
// commenting and reformatting
//
// Revision 1.37  1998/05/03  23:23:50  killough
// Fix #includes at the top, nothing else
//
// Revision 1.36  1998/04/29  09:20:37  jim
// New ENDBOOM
//
// Revision 1.35  1998/04/27  02:15:10  killough
// Fix cr_gold declaration, add missing v1.1 lumps
//
// Revision 1.34  1998/04/24  08:08:36  jim
// Make text translate tables lumps
//
// Revision 1.33  1998/04/22  13:45:37  phares
// Added Setup screen Reset to Defaults
//
// Revision 1.32  1998/04/22  06:34:43  killough
// Make WritePredefinedLumpWad endian-independent, remove tabs
//
// Revision 1.31  1998/04/21  23:46:21  jim
// Predefined lump dumper option
//
// Revision 1.30  1998/04/17  00:04:11  jim
// text file changes and new ENDBOOM
//
// Revision 1.29  1998/04/12  22:54:55  phares
// Remaining 3 Setup screens
//
// Revision 1.28  1998/04/06  04:36:51  killough
// Change WATERMAP, add C_START/C_END
//
// Revision 1.27  1998/04/05  10:10:13  jim
// added STCFN096 lump
//
// Revision 1.26  1998/04/03  19:18:46  phares
// Automap Palette work, slot 0 = disable, 247 = BLACK
//
// Revision 1.25  1998/04/02  05:01:49  jim
// Added ENDOOM, BOOM.TXT mods
//
// Revision 1.24  1998/04/01  15:34:30  phares
// Added Automap Setup Screen, fixed Seg Viol in Setup Menus
//
// Revision 1.23  1998/03/31  01:08:26  phares
// Initial Setup screens and Extended HELP screens
//
// Revision 1.22  1998/03/23  18:39:10  jim
// Switch and animation tables now lumps
//
// Revision 1.21  1998/03/23  15:23:54  phares
// Changed pushers to linedef control
//
// Revision 1.20  1998/03/23  03:18:09  killough
// Add WATERMAP colormap lump for underwater viewing
//
// Revision 1.19  1998/03/09  18:30:28  phares
// Added invisible sprite for MT_PUSH
//
// Revision 1.18  1998/03/09  07:15:14  killough
// Remove unnecessary translucency lumps
//
// Revision 1.17  1998/03/04  22:23:04  phares
// Removed BOOMHELP predefined lump
//
// Revision 1.16  1998/03/04  11:52:43  jim
// Add TRAN50 TRAN66 predefined lumps
//
// Revision 1.15  1998/03/03  00:21:54  jim
// Added predefined ENDBETA lump for beta test
//
// Revision 1.13  1998/02/27  11:51:50  jim
// Add predefined lump STTMINUS
//
// Revision 1.11  1998/02/24  08:45:44  phares
// Pushers, recoil, new friction, and over/under work
//
// Revision 1.10  1998/02/24  04:13:37  jim
// Added double keys to status
//
// Revision 1.8  1998/02/23  04:31:13  killough
// Make tranlucency apply realistically
//
// Revision 1.7  1998/02/22  12:51:38  jim
// HUD control on F5, z coord, spacing change
//
// Revision 1.5  1998/02/20  21:56:49  phares
// Preliminarey sprite translucency
//
// Revision 1.4  1998/02/18  00:59:44  jim
// Addition of HUD
//
// Revision 1.3  1998/02/02  13:36:12  killough
// Add predefined lumps
//
// Revision 1.2  1998/01/26  19:23:34  phares
// First rev with no ^Ms
//
// Revision 1.1.1.1  1998/01/19  14:02:56  rand
// Lee's Jan 19 sources
//
//----------------------------------------------------------------------------
