/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_RENDER_PASS_H
#define VN_PROTOCOL_RENDERER_RENDER_PASS_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/* struct VkAttachmentDescription */

static inline void
vn_decode_VkAttachmentDescription_temp(struct vn_cs_decoder *dec, VkAttachmentDescription *val)
{
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkSampleCountFlagBits(dec, &val->samples);
    vn_decode_VkAttachmentLoadOp(dec, &val->loadOp);
    vn_decode_VkAttachmentStoreOp(dec, &val->storeOp);
    vn_decode_VkAttachmentLoadOp(dec, &val->stencilLoadOp);
    vn_decode_VkAttachmentStoreOp(dec, &val->stencilStoreOp);
    vn_decode_VkImageLayout(dec, &val->initialLayout);
    vn_decode_VkImageLayout(dec, &val->finalLayout);
}

static inline void
vn_replace_VkAttachmentDescription_handle(VkAttachmentDescription *val)
{
    /* skip val->flags */
    /* skip val->format */
    /* skip val->samples */
    /* skip val->loadOp */
    /* skip val->storeOp */
    /* skip val->stencilLoadOp */
    /* skip val->stencilStoreOp */
    /* skip val->initialLayout */
    /* skip val->finalLayout */
}

/* struct VkAttachmentReference */

static inline void
vn_decode_VkAttachmentReference_temp(struct vn_cs_decoder *dec, VkAttachmentReference *val)
{
    vn_decode_uint32_t(dec, &val->attachment);
    vn_decode_VkImageLayout(dec, &val->layout);
}

static inline void
vn_replace_VkAttachmentReference_handle(VkAttachmentReference *val)
{
    /* skip val->attachment */
    /* skip val->layout */
}

/* struct VkSubpassDescription */

static inline void
vn_decode_VkSubpassDescription_temp(struct vn_cs_decoder *dec, VkSubpassDescription *val)
{
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkPipelineBindPoint(dec, &val->pipelineBindPoint);
    vn_decode_uint32_t(dec, &val->inputAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->inputAttachmentCount);
        val->pInputAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pInputAttachments) * iter_count);
        if (!val->pInputAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentReference_temp(dec, &((VkAttachmentReference *)val->pInputAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->inputAttachmentCount);
        val->pInputAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &val->colorAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pColorAttachments) * iter_count);
        if (!val->pColorAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentReference_temp(dec, &((VkAttachmentReference *)val->pColorAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachments = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pResolveAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pResolveAttachments) * iter_count);
        if (!val->pResolveAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentReference_temp(dec, &((VkAttachmentReference *)val->pResolveAttachments)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pResolveAttachments = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDepthStencilAttachment = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDepthStencilAttachment));
        if (!val->pDepthStencilAttachment) return;
        vn_decode_VkAttachmentReference_temp(dec, (VkAttachmentReference *)val->pDepthStencilAttachment);
    } else {
        val->pDepthStencilAttachment = NULL;
    }
    vn_decode_uint32_t(dec, &val->preserveAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->preserveAttachmentCount);
        val->pPreserveAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pPreserveAttachments) * array_size);
        if (!val->pPreserveAttachments) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pPreserveAttachments, array_size);
    } else {
        vn_decode_array_size(dec, val->preserveAttachmentCount);
        val->pPreserveAttachments = NULL;
    }
}

static inline void
vn_replace_VkSubpassDescription_handle(VkSubpassDescription *val)
{
    /* skip val->flags */
    /* skip val->pipelineBindPoint */
    /* skip val->inputAttachmentCount */
    if (val->pInputAttachments) {
       for (uint32_t i = 0; i < val->inputAttachmentCount; i++)
            vn_replace_VkAttachmentReference_handle(&((VkAttachmentReference *)val->pInputAttachments)[i]);
    }
    /* skip val->colorAttachmentCount */
    if (val->pColorAttachments) {
       for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_replace_VkAttachmentReference_handle(&((VkAttachmentReference *)val->pColorAttachments)[i]);
    }
    if (val->pResolveAttachments) {
       for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_replace_VkAttachmentReference_handle(&((VkAttachmentReference *)val->pResolveAttachments)[i]);
    }
    if (val->pDepthStencilAttachment)
        vn_replace_VkAttachmentReference_handle((VkAttachmentReference *)val->pDepthStencilAttachment);
    /* skip val->preserveAttachmentCount */
    /* skip val->pPreserveAttachments */
}

/* struct VkSubpassDependency */

static inline void
vn_decode_VkSubpassDependency_temp(struct vn_cs_decoder *dec, VkSubpassDependency *val)
{
    vn_decode_uint32_t(dec, &val->srcSubpass);
    vn_decode_uint32_t(dec, &val->dstSubpass);
    vn_decode_VkFlags(dec, &val->srcStageMask);
    vn_decode_VkFlags(dec, &val->dstStageMask);
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
    vn_decode_VkFlags(dec, &val->dependencyFlags);
}

static inline void
vn_replace_VkSubpassDependency_handle(VkSubpassDependency *val)
{
    /* skip val->srcSubpass */
    /* skip val->dstSubpass */
    /* skip val->srcStageMask */
    /* skip val->dstStageMask */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
    /* skip val->dependencyFlags */
}

/* struct VkRenderPassMultiviewCreateInfo chain */

static inline void *
vn_decode_VkRenderPassMultiviewCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkRenderPassMultiviewCreateInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassMultiviewCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->subpassCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->subpassCount);
        val->pViewMasks = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pViewMasks) * array_size);
        if (!val->pViewMasks) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pViewMasks, array_size);
    } else {
        vn_decode_array_size(dec, val->subpassCount);
        val->pViewMasks = NULL;
    }
    vn_decode_uint32_t(dec, &val->dependencyCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->dependencyCount);
        val->pViewOffsets = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pViewOffsets) * array_size);
        if (!val->pViewOffsets) return;
        vn_decode_int32_t_array(dec, (int32_t *)val->pViewOffsets, array_size);
    } else {
        vn_decode_array_size(dec, val->dependencyCount);
        val->pViewOffsets = NULL;
    }
    vn_decode_uint32_t(dec, &val->correlationMaskCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->correlationMaskCount);
        val->pCorrelationMasks = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pCorrelationMasks) * array_size);
        if (!val->pCorrelationMasks) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pCorrelationMasks, array_size);
    } else {
        vn_decode_array_size(dec, val->correlationMaskCount);
        val->pCorrelationMasks = NULL;
    }
}

static inline void
vn_decode_VkRenderPassMultiviewCreateInfo_temp(struct vn_cs_decoder *dec, VkRenderPassMultiviewCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassMultiviewCreateInfo_pnext_temp(dec);
    vn_decode_VkRenderPassMultiviewCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassMultiviewCreateInfo_handle_self(VkRenderPassMultiviewCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->subpassCount */
    /* skip val->pViewMasks */
    /* skip val->dependencyCount */
    /* skip val->pViewOffsets */
    /* skip val->correlationMaskCount */
    /* skip val->pCorrelationMasks */
}

static inline void
vn_replace_VkRenderPassMultiviewCreateInfo_handle(VkRenderPassMultiviewCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
            vn_replace_VkRenderPassMultiviewCreateInfo_handle_self((VkRenderPassMultiviewCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkInputAttachmentAspectReference */

static inline void
vn_decode_VkInputAttachmentAspectReference_temp(struct vn_cs_decoder *dec, VkInputAttachmentAspectReference *val)
{
    vn_decode_uint32_t(dec, &val->subpass);
    vn_decode_uint32_t(dec, &val->inputAttachmentIndex);
    vn_decode_VkFlags(dec, &val->aspectMask);
}

static inline void
vn_replace_VkInputAttachmentAspectReference_handle(VkInputAttachmentAspectReference *val)
{
    /* skip val->subpass */
    /* skip val->inputAttachmentIndex */
    /* skip val->aspectMask */
}

/* struct VkRenderPassInputAttachmentAspectCreateInfo chain */

static inline void *
vn_decode_VkRenderPassInputAttachmentAspectCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkRenderPassInputAttachmentAspectCreateInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->aspectReferenceCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->aspectReferenceCount);
        val->pAspectReferences = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pAspectReferences) * iter_count);
        if (!val->pAspectReferences) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkInputAttachmentAspectReference_temp(dec, &((VkInputAttachmentAspectReference *)val->pAspectReferences)[i]);
    } else {
        vn_decode_array_size(dec, val->aspectReferenceCount);
        val->pAspectReferences = NULL;
    }
}

static inline void
vn_decode_VkRenderPassInputAttachmentAspectCreateInfo_temp(struct vn_cs_decoder *dec, VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassInputAttachmentAspectCreateInfo_pnext_temp(dec);
    vn_decode_VkRenderPassInputAttachmentAspectCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassInputAttachmentAspectCreateInfo_handle_self(VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->aspectReferenceCount */
    if (val->pAspectReferences) {
       for (uint32_t i = 0; i < val->aspectReferenceCount; i++)
            vn_replace_VkInputAttachmentAspectReference_handle(&((VkInputAttachmentAspectReference *)val->pAspectReferences)[i]);
    }
}

static inline void
vn_replace_VkRenderPassInputAttachmentAspectCreateInfo_handle(VkRenderPassInputAttachmentAspectCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
            vn_replace_VkRenderPassInputAttachmentAspectCreateInfo_handle_self((VkRenderPassInputAttachmentAspectCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderPassCreateInfo chain */

static inline void *
vn_decode_VkRenderPassCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkRenderPassMultiviewCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderPassCreateInfo_pnext_temp(dec);
            vn_decode_VkRenderPassMultiviewCreateInfo_self_temp(dec, (VkRenderPassMultiviewCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkRenderPassInputAttachmentAspectCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkRenderPassCreateInfo_pnext_temp(dec);
            vn_decode_VkRenderPassInputAttachmentAspectCreateInfo_self_temp(dec, (VkRenderPassInputAttachmentAspectCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkRenderPassCreateInfo_self_temp(struct vn_cs_decoder *dec, VkRenderPassCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pAttachments) * iter_count);
        if (!val->pAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentDescription_temp(dec, &((VkAttachmentDescription *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &val->subpassCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->subpassCount);
        val->pSubpasses = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSubpasses) * iter_count);
        if (!val->pSubpasses) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSubpassDescription_temp(dec, &((VkSubpassDescription *)val->pSubpasses)[i]);
    } else {
        vn_decode_array_size(dec, val->subpassCount);
        val->pSubpasses = NULL;
    }
    vn_decode_uint32_t(dec, &val->dependencyCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->dependencyCount);
        val->pDependencies = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDependencies) * iter_count);
        if (!val->pDependencies) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSubpassDependency_temp(dec, &((VkSubpassDependency *)val->pDependencies)[i]);
    } else {
        vn_decode_array_size(dec, val->dependencyCount);
        val->pDependencies = NULL;
    }
}

static inline void
vn_decode_VkRenderPassCreateInfo_temp(struct vn_cs_decoder *dec, VkRenderPassCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassCreateInfo_pnext_temp(dec);
    vn_decode_VkRenderPassCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassCreateInfo_handle_self(VkRenderPassCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkAttachmentDescription_handle(&((VkAttachmentDescription *)val->pAttachments)[i]);
    }
    /* skip val->subpassCount */
    if (val->pSubpasses) {
       for (uint32_t i = 0; i < val->subpassCount; i++)
            vn_replace_VkSubpassDescription_handle(&((VkSubpassDescription *)val->pSubpasses)[i]);
    }
    /* skip val->dependencyCount */
    if (val->pDependencies) {
       for (uint32_t i = 0; i < val->dependencyCount; i++)
            vn_replace_VkSubpassDependency_handle(&((VkSubpassDependency *)val->pDependencies)[i]);
    }
}

static inline void
vn_replace_VkRenderPassCreateInfo_handle(VkRenderPassCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
            vn_replace_VkRenderPassCreateInfo_handle_self((VkRenderPassCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
            vn_replace_VkRenderPassMultiviewCreateInfo_handle_self((VkRenderPassMultiviewCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
            vn_replace_VkRenderPassInputAttachmentAspectCreateInfo_handle_self((VkRenderPassInputAttachmentAspectCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAttachmentDescriptionStencilLayout chain */

static inline void *
vn_decode_VkAttachmentDescriptionStencilLayout_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkAttachmentDescriptionStencilLayout_self_temp(struct vn_cs_decoder *dec, VkAttachmentDescriptionStencilLayout *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageLayout(dec, &val->stencilInitialLayout);
    vn_decode_VkImageLayout(dec, &val->stencilFinalLayout);
}

static inline void
vn_decode_VkAttachmentDescriptionStencilLayout_temp(struct vn_cs_decoder *dec, VkAttachmentDescriptionStencilLayout *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAttachmentDescriptionStencilLayout_pnext_temp(dec);
    vn_decode_VkAttachmentDescriptionStencilLayout_self_temp(dec, val);
}

static inline void
vn_replace_VkAttachmentDescriptionStencilLayout_handle_self(VkAttachmentDescriptionStencilLayout *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->stencilInitialLayout */
    /* skip val->stencilFinalLayout */
}

static inline void
vn_replace_VkAttachmentDescriptionStencilLayout_handle(VkAttachmentDescriptionStencilLayout *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
            vn_replace_VkAttachmentDescriptionStencilLayout_handle_self((VkAttachmentDescriptionStencilLayout *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAttachmentDescription2 chain */

static inline void *
vn_decode_VkAttachmentDescription2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkAttachmentDescriptionStencilLayout));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkAttachmentDescription2_pnext_temp(dec);
            vn_decode_VkAttachmentDescriptionStencilLayout_self_temp(dec, (VkAttachmentDescriptionStencilLayout *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkAttachmentDescription2_self_temp(struct vn_cs_decoder *dec, VkAttachmentDescription2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkSampleCountFlagBits(dec, &val->samples);
    vn_decode_VkAttachmentLoadOp(dec, &val->loadOp);
    vn_decode_VkAttachmentStoreOp(dec, &val->storeOp);
    vn_decode_VkAttachmentLoadOp(dec, &val->stencilLoadOp);
    vn_decode_VkAttachmentStoreOp(dec, &val->stencilStoreOp);
    vn_decode_VkImageLayout(dec, &val->initialLayout);
    vn_decode_VkImageLayout(dec, &val->finalLayout);
}

static inline void
vn_decode_VkAttachmentDescription2_temp(struct vn_cs_decoder *dec, VkAttachmentDescription2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAttachmentDescription2_pnext_temp(dec);
    vn_decode_VkAttachmentDescription2_self_temp(dec, val);
}

static inline void
vn_replace_VkAttachmentDescription2_handle_self(VkAttachmentDescription2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->format */
    /* skip val->samples */
    /* skip val->loadOp */
    /* skip val->storeOp */
    /* skip val->stencilLoadOp */
    /* skip val->stencilStoreOp */
    /* skip val->initialLayout */
    /* skip val->finalLayout */
}

static inline void
vn_replace_VkAttachmentDescription2_handle(VkAttachmentDescription2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2:
            vn_replace_VkAttachmentDescription2_handle_self((VkAttachmentDescription2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
            vn_replace_VkAttachmentDescriptionStencilLayout_handle_self((VkAttachmentDescriptionStencilLayout *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAttachmentReferenceStencilLayout chain */

static inline void *
vn_decode_VkAttachmentReferenceStencilLayout_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkAttachmentReferenceStencilLayout_self_temp(struct vn_cs_decoder *dec, VkAttachmentReferenceStencilLayout *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageLayout(dec, &val->stencilLayout);
}

static inline void
vn_decode_VkAttachmentReferenceStencilLayout_temp(struct vn_cs_decoder *dec, VkAttachmentReferenceStencilLayout *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAttachmentReferenceStencilLayout_pnext_temp(dec);
    vn_decode_VkAttachmentReferenceStencilLayout_self_temp(dec, val);
}

static inline void
vn_replace_VkAttachmentReferenceStencilLayout_handle_self(VkAttachmentReferenceStencilLayout *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->stencilLayout */
}

static inline void
vn_replace_VkAttachmentReferenceStencilLayout_handle(VkAttachmentReferenceStencilLayout *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
            vn_replace_VkAttachmentReferenceStencilLayout_handle_self((VkAttachmentReferenceStencilLayout *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkAttachmentReference2 chain */

static inline void *
vn_decode_VkAttachmentReference2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkAttachmentReferenceStencilLayout));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkAttachmentReference2_pnext_temp(dec);
            vn_decode_VkAttachmentReferenceStencilLayout_self_temp(dec, (VkAttachmentReferenceStencilLayout *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkAttachmentReference2_self_temp(struct vn_cs_decoder *dec, VkAttachmentReference2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->attachment);
    vn_decode_VkImageLayout(dec, &val->layout);
    vn_decode_VkFlags(dec, &val->aspectMask);
}

static inline void
vn_decode_VkAttachmentReference2_temp(struct vn_cs_decoder *dec, VkAttachmentReference2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkAttachmentReference2_pnext_temp(dec);
    vn_decode_VkAttachmentReference2_self_temp(dec, val);
}

static inline void
vn_replace_VkAttachmentReference2_handle_self(VkAttachmentReference2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachment */
    /* skip val->layout */
    /* skip val->aspectMask */
}

static inline void
vn_replace_VkAttachmentReference2_handle(VkAttachmentReference2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2:
            vn_replace_VkAttachmentReference2_handle_self((VkAttachmentReference2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
            vn_replace_VkAttachmentReferenceStencilLayout_handle_self((VkAttachmentReferenceStencilLayout *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassDescriptionDepthStencilResolve chain */

static inline void *
vn_decode_VkSubpassDescriptionDepthStencilResolve_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSubpassDescriptionDepthStencilResolve_self_temp(struct vn_cs_decoder *dec, VkSubpassDescriptionDepthStencilResolve *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkResolveModeFlagBits(dec, &val->depthResolveMode);
    vn_decode_VkResolveModeFlagBits(dec, &val->stencilResolveMode);
    if (vn_decode_simple_pointer(dec)) {
        val->pDepthStencilResolveAttachment = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDepthStencilResolveAttachment));
        if (!val->pDepthStencilResolveAttachment) return;
        vn_decode_VkAttachmentReference2_temp(dec, (VkAttachmentReference2 *)val->pDepthStencilResolveAttachment);
    } else {
        val->pDepthStencilResolveAttachment = NULL;
    }
}

static inline void
vn_decode_VkSubpassDescriptionDepthStencilResolve_temp(struct vn_cs_decoder *dec, VkSubpassDescriptionDepthStencilResolve *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassDescriptionDepthStencilResolve_pnext_temp(dec);
    vn_decode_VkSubpassDescriptionDepthStencilResolve_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassDescriptionDepthStencilResolve_handle_self(VkSubpassDescriptionDepthStencilResolve *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->depthResolveMode */
    /* skip val->stencilResolveMode */
    if (val->pDepthStencilResolveAttachment)
        vn_replace_VkAttachmentReference2_handle((VkAttachmentReference2 *)val->pDepthStencilResolveAttachment);
}

static inline void
vn_replace_VkSubpassDescriptionDepthStencilResolve_handle(VkSubpassDescriptionDepthStencilResolve *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
            vn_replace_VkSubpassDescriptionDepthStencilResolve_handle_self((VkSubpassDescriptionDepthStencilResolve *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassDescription2 chain */

static inline void *
vn_decode_VkSubpassDescription2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkSubpassDescriptionDepthStencilResolve));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkSubpassDescription2_pnext_temp(dec);
            vn_decode_VkSubpassDescriptionDepthStencilResolve_self_temp(dec, (VkSubpassDescriptionDepthStencilResolve *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkSubpassDescription2_self_temp(struct vn_cs_decoder *dec, VkSubpassDescription2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkPipelineBindPoint(dec, &val->pipelineBindPoint);
    vn_decode_uint32_t(dec, &val->viewMask);
    vn_decode_uint32_t(dec, &val->inputAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->inputAttachmentCount);
        val->pInputAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pInputAttachments) * iter_count);
        if (!val->pInputAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentReference2_temp(dec, &((VkAttachmentReference2 *)val->pInputAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->inputAttachmentCount);
        val->pInputAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &val->colorAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pColorAttachments) * iter_count);
        if (!val->pColorAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentReference2_temp(dec, &((VkAttachmentReference2 *)val->pColorAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pColorAttachments = NULL;
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->colorAttachmentCount);
        val->pResolveAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pResolveAttachments) * iter_count);
        if (!val->pResolveAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentReference2_temp(dec, &((VkAttachmentReference2 *)val->pResolveAttachments)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pResolveAttachments = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDepthStencilAttachment = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDepthStencilAttachment));
        if (!val->pDepthStencilAttachment) return;
        vn_decode_VkAttachmentReference2_temp(dec, (VkAttachmentReference2 *)val->pDepthStencilAttachment);
    } else {
        val->pDepthStencilAttachment = NULL;
    }
    vn_decode_uint32_t(dec, &val->preserveAttachmentCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->preserveAttachmentCount);
        val->pPreserveAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pPreserveAttachments) * array_size);
        if (!val->pPreserveAttachments) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pPreserveAttachments, array_size);
    } else {
        vn_decode_array_size(dec, val->preserveAttachmentCount);
        val->pPreserveAttachments = NULL;
    }
}

static inline void
vn_decode_VkSubpassDescription2_temp(struct vn_cs_decoder *dec, VkSubpassDescription2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassDescription2_pnext_temp(dec);
    vn_decode_VkSubpassDescription2_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassDescription2_handle_self(VkSubpassDescription2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->pipelineBindPoint */
    /* skip val->viewMask */
    /* skip val->inputAttachmentCount */
    if (val->pInputAttachments) {
       for (uint32_t i = 0; i < val->inputAttachmentCount; i++)
            vn_replace_VkAttachmentReference2_handle(&((VkAttachmentReference2 *)val->pInputAttachments)[i]);
    }
    /* skip val->colorAttachmentCount */
    if (val->pColorAttachments) {
       for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_replace_VkAttachmentReference2_handle(&((VkAttachmentReference2 *)val->pColorAttachments)[i]);
    }
    if (val->pResolveAttachments) {
       for (uint32_t i = 0; i < val->colorAttachmentCount; i++)
            vn_replace_VkAttachmentReference2_handle(&((VkAttachmentReference2 *)val->pResolveAttachments)[i]);
    }
    if (val->pDepthStencilAttachment)
        vn_replace_VkAttachmentReference2_handle((VkAttachmentReference2 *)val->pDepthStencilAttachment);
    /* skip val->preserveAttachmentCount */
    /* skip val->pPreserveAttachments */
}

static inline void
vn_replace_VkSubpassDescription2_handle(VkSubpassDescription2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2:
            vn_replace_VkSubpassDescription2_handle_self((VkSubpassDescription2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
            vn_replace_VkSubpassDescriptionDepthStencilResolve_handle_self((VkSubpassDescriptionDepthStencilResolve *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubpassDependency2 chain */

static inline void *
vn_decode_VkSubpassDependency2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkMemoryBarrier2));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkSubpassDependency2_pnext_temp(dec);
            vn_decode_VkMemoryBarrier2_self_temp(dec, (VkMemoryBarrier2 *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkSubpassDependency2_self_temp(struct vn_cs_decoder *dec, VkSubpassDependency2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->srcSubpass);
    vn_decode_uint32_t(dec, &val->dstSubpass);
    vn_decode_VkFlags(dec, &val->srcStageMask);
    vn_decode_VkFlags(dec, &val->dstStageMask);
    vn_decode_VkFlags(dec, &val->srcAccessMask);
    vn_decode_VkFlags(dec, &val->dstAccessMask);
    vn_decode_VkFlags(dec, &val->dependencyFlags);
    vn_decode_int32_t(dec, &val->viewOffset);
}

static inline void
vn_decode_VkSubpassDependency2_temp(struct vn_cs_decoder *dec, VkSubpassDependency2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSubpassDependency2_pnext_temp(dec);
    vn_decode_VkSubpassDependency2_self_temp(dec, val);
}

static inline void
vn_replace_VkSubpassDependency2_handle_self(VkSubpassDependency2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->srcSubpass */
    /* skip val->dstSubpass */
    /* skip val->srcStageMask */
    /* skip val->dstStageMask */
    /* skip val->srcAccessMask */
    /* skip val->dstAccessMask */
    /* skip val->dependencyFlags */
    /* skip val->viewOffset */
}

static inline void
vn_replace_VkSubpassDependency2_handle(VkSubpassDependency2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2:
            vn_replace_VkSubpassDependency2_handle_self((VkSubpassDependency2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
            vn_replace_VkMemoryBarrier2_handle_self((VkMemoryBarrier2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkRenderPassCreateInfo2 chain */

static inline void *
vn_decode_VkRenderPassCreateInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkRenderPassCreateInfo2_self_temp(struct vn_cs_decoder *dec, VkRenderPassCreateInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pAttachments) * iter_count);
        if (!val->pAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkAttachmentDescription2_temp(dec, &((VkAttachmentDescription2 *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &val->subpassCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->subpassCount);
        val->pSubpasses = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSubpasses) * iter_count);
        if (!val->pSubpasses) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSubpassDescription2_temp(dec, &((VkSubpassDescription2 *)val->pSubpasses)[i]);
    } else {
        vn_decode_array_size(dec, val->subpassCount);
        val->pSubpasses = NULL;
    }
    vn_decode_uint32_t(dec, &val->dependencyCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->dependencyCount);
        val->pDependencies = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDependencies) * iter_count);
        if (!val->pDependencies) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSubpassDependency2_temp(dec, &((VkSubpassDependency2 *)val->pDependencies)[i]);
    } else {
        vn_decode_array_size(dec, val->dependencyCount);
        val->pDependencies = NULL;
    }
    vn_decode_uint32_t(dec, &val->correlatedViewMaskCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->correlatedViewMaskCount);
        val->pCorrelatedViewMasks = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pCorrelatedViewMasks) * array_size);
        if (!val->pCorrelatedViewMasks) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pCorrelatedViewMasks, array_size);
    } else {
        vn_decode_array_size(dec, val->correlatedViewMaskCount);
        val->pCorrelatedViewMasks = NULL;
    }
}

static inline void
vn_decode_VkRenderPassCreateInfo2_temp(struct vn_cs_decoder *dec, VkRenderPassCreateInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkRenderPassCreateInfo2_pnext_temp(dec);
    vn_decode_VkRenderPassCreateInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkRenderPassCreateInfo2_handle_self(VkRenderPassCreateInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkAttachmentDescription2_handle(&((VkAttachmentDescription2 *)val->pAttachments)[i]);
    }
    /* skip val->subpassCount */
    if (val->pSubpasses) {
       for (uint32_t i = 0; i < val->subpassCount; i++)
            vn_replace_VkSubpassDescription2_handle(&((VkSubpassDescription2 *)val->pSubpasses)[i]);
    }
    /* skip val->dependencyCount */
    if (val->pDependencies) {
       for (uint32_t i = 0; i < val->dependencyCount; i++)
            vn_replace_VkSubpassDependency2_handle(&((VkSubpassDependency2 *)val->pDependencies)[i]);
    }
    /* skip val->correlatedViewMaskCount */
    /* skip val->pCorrelatedViewMasks */
}

static inline void
vn_replace_VkRenderPassCreateInfo2_handle(VkRenderPassCreateInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
            vn_replace_VkRenderPassCreateInfo2_handle_self((VkRenderPassCreateInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCreateRenderPass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateRenderPass *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkRenderPassCreateInfo_temp(dec, (VkRenderPassCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderPass = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderPass));
        if (!args->pRenderPass) return;
        vn_decode_VkRenderPass(dec, args->pRenderPass);
    } else {
        args->pRenderPass = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateRenderPass_args_handle(struct vn_command_vkCreateRenderPass *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkRenderPassCreateInfo_handle((VkRenderPassCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pRenderPass */
}

static inline void vn_encode_vkCreateRenderPass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateRenderPass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateRenderPass_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pRenderPass))
        vn_encode_VkRenderPass(enc, args->pRenderPass);
}

static inline void vn_decode_vkDestroyRenderPass_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyRenderPass *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkRenderPass_lookup(dec, &args->renderPass);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyRenderPass_args_handle(struct vn_command_vkDestroyRenderPass *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkRenderPass_handle(&args->renderPass);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyRenderPass_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyRenderPass *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyRenderPass_EXT});

    /* skip args->device */
    /* skip args->renderPass */
    /* skip args->pAllocator */
}

static inline void vn_decode_vkGetRenderAreaGranularity_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetRenderAreaGranularity *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkRenderPass_lookup(dec, &args->renderPass);
    if (vn_decode_simple_pointer(dec)) {
        args->pGranularity = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pGranularity));
        if (!args->pGranularity) return;
        vn_decode_VkExtent2D_partial_temp(dec, args->pGranularity);
    } else {
        args->pGranularity = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetRenderAreaGranularity_args_handle(struct vn_command_vkGetRenderAreaGranularity *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkRenderPass_handle(&args->renderPass);
    /* skip args->pGranularity */
}

static inline void vn_encode_vkGetRenderAreaGranularity_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetRenderAreaGranularity *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetRenderAreaGranularity_EXT});

    /* skip args->device */
    /* skip args->renderPass */
    if (vn_encode_simple_pointer(enc, args->pGranularity))
        vn_encode_VkExtent2D(enc, args->pGranularity);
}

static inline void vn_decode_vkCreateRenderPass2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateRenderPass2 *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkRenderPassCreateInfo2_temp(dec, (VkRenderPassCreateInfo2 *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pRenderPass = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pRenderPass));
        if (!args->pRenderPass) return;
        vn_decode_VkRenderPass(dec, args->pRenderPass);
    } else {
        args->pRenderPass = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateRenderPass2_args_handle(struct vn_command_vkCreateRenderPass2 *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkRenderPassCreateInfo2_handle((VkRenderPassCreateInfo2 *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pRenderPass */
}

static inline void vn_encode_vkCreateRenderPass2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateRenderPass2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateRenderPass2_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pRenderPass))
        vn_encode_VkRenderPass(enc, args->pRenderPass);
}

static inline void vn_dispatch_vkCreateRenderPass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateRenderPass args;

    if (!ctx->dispatch_vkCreateRenderPass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateRenderPass_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateRenderPass(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateRenderPass returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateRenderPass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyRenderPass(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyRenderPass args;

    if (!ctx->dispatch_vkDestroyRenderPass) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyRenderPass_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyRenderPass(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkDestroyRenderPass_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetRenderAreaGranularity(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetRenderAreaGranularity args;

    if (!ctx->dispatch_vkGetRenderAreaGranularity) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetRenderAreaGranularity_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetRenderAreaGranularity(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkGetRenderAreaGranularity_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateRenderPass2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateRenderPass2 args;

    if (!ctx->dispatch_vkCreateRenderPass2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateRenderPass2_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateRenderPass2(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateRenderPass2 returned %d", args.ret);
#endif

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateRenderPass2_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_RENDER_PASS_H */
