////////////////////////////////////////////////////////////////////////////////
// 
// Statistics.cc
//
//    produced: 17 Sep 2021 jr
//
////////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <thread>
#include <cstdlib>

#include "Statistics.hh"

namespace topcom {

  std::fstream Statistics::_stats_stream;
  size_type    Statistics::_no_of_singleton_map_calls = 0;
  size_type    Statistics::_no_of_structure_map_calls = 0;

  // initialization:
  void Statistics::init() {
    MessageStreams::verbose() << "initializing statistics output ..." << '\n'
			      << "... output file: " << CommandlineOptions::stats_file() << " ..." << std::endl;
    Statistics::stats_stream().open(CommandlineOptions::stats_file(), std::ios::out | std::ios::trunc);
    Statistics::stats_stream() << "//////////////////////////////////////////////////////////////////////////////" << std::endl;
    Statistics::stats_stream() << "// statistics file (automatically generated by TOPCOM)" << std::endl;
    Statistics::stats_stream() << "//////////////////////////////////////////////////////////////////////////////" << std::endl;
    Statistics::stats_stream() << std::endl;
    MessageStreams::verbose() << "... done." << std::endl;
  }
  
  // termination:
  void Statistics::term() {
    MessageStreams::verbose() << "terminating statistics output ..." << std::endl;
    Statistics::stats_stream() << "terminating statistics:" << std::endl;
    Statistics::stats_stream() << "no of singleton-map calls: \t" << _no_of_singleton_map_calls << std::endl;
    Statistics::stats_stream() << "no of structure-map calls: \t" << _no_of_structure_map_calls << std::endl;
    Statistics::stats_stream().close();
    MessageStreams::verbose() << "... done." << std::endl;
  }

  // report:
  void Statistics::report() {
    MessageStreams::verbose() << "reporting statistic values ..." << std::endl;
    Statistics::stats_stream() << "report statistics:" << std::endl;
    Statistics::stats_stream() << "no of singleton-map calls: \t" << _no_of_singleton_map_calls << std::endl;
    Statistics::stats_stream() << "no of structure-map calls: \t" << _no_of_structure_map_calls << std::endl;
    MessageStreams::verbose() << "... done." << std::endl;
  }
  
  // reset:
  void Statistics::reset() {
    MessageStreams::verbose() << "reset statistic values ..." << std::endl;
    Statistics::stats_stream() << "reset statistics:" << std::endl;
    _no_of_singleton_map_calls = 0;
    _no_of_structure_map_calls = 0;
    Statistics::stats_stream() << "no of singleton-map calls: \t" << _no_of_singleton_map_calls << std::endl;
    Statistics::stats_stream() << "no of structure-map calls: \t" << _no_of_structure_map_calls << std::endl;
    MessageStreams::verbose() << "... done." << std::endl;
  }

  
}; // namespace topcom

// eof CommandlineOptions.cc
