#define XERR "loop"
#include "loop.ih"

// headers by headerrounds.cc

    // by iterate.cc

void Loop::writeRounds(CSVTable &tab) const
{
    if (not tab.stream() or d_nRounds == 0)
        return;

    std::vector<ModBase *> const &modBase = d_modalities.activeMods();

    for (size_t rnd = 0; rnd != d_nRounds; ++rnd)
    {
        tab.more() << (rnd + 1);          // rounds.txt: natural round nrs

        for (ModBase const *ptr: modBase)
            tab.more() << ptr->truePositive(rnd) << ptr->falsePositive(rnd) << 
                          ptr->trueNegative(rnd) << ptr->falseNegative(rnd);
//                      d_nRoundTP[rnd] << d_nRoundFP[rnd] <<
//                      d_nRoundTN[rnd] << d_nRoundFN[rnd] <<

        tab.more() << d_nDetections[rnd] << 
                      d_nIntervals[rnd] << d_nTrueIntervals[rnd] << 
                      static_cast<size_t>(round(d_roundCost[rnd])) <<
                      static_cast<size_t>(round(d_roundBiopCosts[rnd]));

        d_modalities.writeRounds(tab, rnd);
        tab.row();
    }

    tab << hline();
}
