documentation_complete: true

hidden: true

title: Default Profile for Alibaba Cloud Linux 3

description: |-
    This profile contains all the rules that once belonged to the
    alinux3 product via 'prodtype'. This profile won't
    be rendered into an XCCDF Profile entity, nor it will select any
    of these rules by default. The only purpose of this profile
    is to keep a rule in the product's XCCDF Benchmark.

selections:
    - grub2_enable_iommu_force
    - kernel_config_module_sig_key
    - auditd_data_disk_full_action
    - grub2_rng_core_default_quality_argument
    - kernel_config_debug_list
    - package_MFEhiplsm_installed
    - grub2_nosmep_argument_absent
    - configure_user_data_backups
    - accounts_polyinstantiated_var_tmp
    - kernel_config_page_table_isolation
    - kernel_config_module_sig_sha512
    - dir_ownership_binary_dirs
    - kernel_config_slub_debug
    - kernel_config_page_poisoning_no_sanity
    - rsyslog_encrypt_offload_defaultnetstreamdriver
    - file_permissions_library_dirs
    - file_ownership_library_dirs
    - kernel_config_seccomp
    - auditd_data_retention_max_log_file_action_stig
    - sysctl_net_ipv6_conf_default_disable_ipv6
    - audit_rules_usergroup_modification
    - kernel_config_security_yama
    - package_bind_removed
    - audit_rules_dac_modification_umount
    - kernel_module_uvcvideo_disabled
    - sshd_disable_user_known_hosts
    - sudoers_no_command_negation
    - restrict_serial_port_logins
    - sysctl_net_ipv4_conf_all_arp_filter
    - auditd_local_events
    - kernel_config_default_mmap_min_addr
    - kernel_config_hibernation
    - set_iptables_default_rule_forward
    - file_groupowner_var_log
    - account_use_centralized_automated_auth
    - kernel_config_seccomp_filter
    - sshd_rekey_limit
    - kernel_config_security
    - sysctl_net_ipv6_conf_all_disable_ipv6
    - sudo_vdsm_nopasswd
    - kernel_config_security_writable_hooks
    - fapolicyd_prevent_home_folder_access
    - kernel_config_binfmt_misc
    - audit_rules_dac_modification_umount2
    - sysctl_net_ipv4_conf_all_accept_local
    - kernel_config_security_dmesg_restrict
    - package_postfix_installed
    - sysctl_kernel_kptr_restrict
    - audit_privileged_commands_poweroff
    - sudoers_no_root_target
    - auditd_write_logs
    - grub2_mce_argument
    - package_inetutils-telnetd_removed
    - audit_rules_unsuccessful_file_modification_truncate
    - kernel_config_kexec
    - accounts_polyinstantiated_tmp
    - kernel_disable_entropy_contribution_for_solid_state_drives
    - avahi_disable_publishing
    - package_ntpdate_removed
    - rsyslog_nolisten
    - sshd_use_priv_separation
    - kernel_module_rds_disabled
    - audit_privileged_commands_shutdown
    - file_groupownership_sshd_pub_key
    - account_passwords_pam_faillock_dir
    - directory_permissions_var_log_audit
    - kernel_config_devkmem
    - kernel_config_panic_timeout
    - kernel_config_debug_credentials
    - dir_permissions_library_dirs
    - kernel_config_legacy_ptys
    - file_ownership_sshd_private_key
    - sshd_enable_warning_banner_net
    - kernel_config_panic_on_oops
    - file_groupowner_var_log_syslog
    - grub2_systemd_debug-shell_argument_absent
    - sysctl_fs_protected_symlinks
    - service_netfs_disabled
    - ftp_limit_users
    - file_groupownership_sshd_private_key
    - kernel_module_ipv6_option_disabled
    - file_groupownership_audit_configuration
    - rsyslog_accept_remote_messages_tcp
    - audit_rules_privileged_commands
    - auditd_data_disk_full_action_stig
    - file_ownership_sshd_pub_key
    - kernel_config_randomize_memory
    - sudo_add_requiretty
    - package_ntp_installed
    - sshd_disable_compression
    - sysctl_fs_protected_hardlinks
    - sshd_disable_gssapi_auth
    - enable_dconf_user_profile
    - package_cron_installed
    - sshd_enable_gssapi_auth
    - kernel_config_debug_sg
    - sshd_print_last_log
    - kernel_config_module_sig_hash
    - grub2_nosmap_argument_absent
    - dir_ownership_library_dirs
    - partition_for_dev_shm
    - kernel_config_randomize_base
    - sshd_set_loglevel_info
    - sysctl_net_ipv4_conf_default_shared_media
    - grub2_l1tf_argument
    - ftp_configure_firewall
    - auditd_data_disk_error_action
    - kernel_config_x86_vsyscall_emulation
    - kernel_config_debug_notifiers
    - package_libreswan_installed
    - kernel_config_proc_kcore
    - auditd_overflow_action
    - service_systemd-journald_enabled
    - file_permissions_systemmap
    - sshd_allow_only_protocol2
    - sysctl_net_ipv4_conf_all_arp_ignore
    - grub2_spectre_v2_argument
    - kernel_config_ipv6
    - file_permissions_home_dirs
    - audit_rules_unsuccessful_file_modification_open
    - file_ownership_binary_dirs
    - grub2_disable_recovery
    - postfix_client_configure_mail_alias_postmaster
    - sshd_set_keepalive_0
    - package_telnetd_removed
    - accounts_password_minlen_login_defs
    - selinux_not_disabled
    - package_nss-tools_installed
    - sysctl_net_ipv4_conf_all_shared_media
    - audit_rules_unsuccessful_file_modification_open_by_handle_at
    - sshd_enable_strictmodes
    - sudo_remove_nopasswd
    - kernel_config_bug
    - kernel_config_page_poisoning_zero
    - sshd_enable_pubkey_auth
    - kernel_config_compat_vdso
    - postfix_client_configure_mail_alias
    - package_xorg-x11-server-common_removed
    - service_iptables_enabled
    - postfix_client_configure_relayhost
    - audit_privileged_commands_init
    - iptables_sshd_disabled
    - chronyd_server_directive
    - kernel_config_compat_brk
    - grub2_spec_store_bypass_disable_argument
    - sudo_remove_no_authenticate
    - kernel_config_unmap_kernel_at_el0
    - service_postfix_enabled
    - package_openssh-server_removed
    - partition_for_srv
    - sudo_add_noexec
    - sysctl_net_ipv4_conf_all_route_localnet
    - auditd_log_format
    - service_syslogng_enabled
    - kernel_config_retpoline
    - kernel_config_debug_fs
    - account_passwords_pam_faillock_audit
    - disallow_bypass_password_sudo
    - sudoers_explicit_command_args
    - accounts_max_concurrent_login_sessions
    - auditd_data_retention_num_logs
    - file_owner_var_log
    - service_cron_enabled
    - prefer_64bit_os
    - sshd_enable_x11_forwarding
    - ensure_logrotate_activated
    - service_sshd_disabled
    - sshd_disable_rhosts_rsa
    - sysctl_kernel_panic_on_oops
    - file_permissions_audit_configuration
    - harden_ssh_client_crypto_policy
    - dhcp_server_minimize_served_info
    - no_all_squash_exports
    - sshd_disable_kerb_auth
    - service_ufw_enabled
    - package_openssh-server_installed
    - accounts_logon_fail_delay
    - dir_permissions_binary_dirs
    - file_groupowner_var_log_messages
    - package_nis_removed
    - set_iptables_default_rule
    - kernel_config_acpi_custom_method
    - sshd_disable_pubkey_auth
    - package_gnutls-utils_installed
    - dhcp_client_restrict_options
    - audit_privileged_commands_reboot
    - audit_rules_unsuccessful_file_modification_ftruncate
    - file_permissions_binary_dirs
    - auditd_freq
    - kernel_module_tipc_disabled
    - accounts_passwords_pam_faillock_audit
    - audit_rules_unsuccessful_file_modification_openat
    - kernel_config_module_sig_all
    - rsyslog_encrypt_offload_actionsendstreamdriverauthmode
    - kernel_config_syn_cookies
    - rsyslog_encrypt_offload_actionsendstreamdrivermode
    - package_syslogng_installed
    - auditd_data_disk_error_action_stig
    - kernel_config_ia32_emulation
    - rsyslog_accept_remote_messages_udp
    - file_owner_var_log_messages
    - grub2_slab_nomerge_argument
    - audit_rules_unsuccessful_file_modification_creat
    - sshd_disable_root_password_login
    - kernel_config_module_sig
    - file_ownership_audit_configuration
    - audit_rules_mac_modification_usr_share
    - package_telnetd-ssl_removed
    - kernel_config_module_sig_force
    - service_chronyd_enabled
    - file_owner_var_log_syslog
    - service_ip6tables_enabled
