/*
  subgroups.cc, copyright (c) 2006 by Vincent Fourmond: 
  The implementations for the subgroups (parentheses).
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#include <calc_internals.hh>

namespace SCalc {
  
  std::string Subgroup::pretty_print()
  {
    std::string str;
    str += "(";
    str += sub->pretty_print();
    str += ")";
    return str;
  }

  Expression * Subgroup::simplify()
  {
    Expression * s = sub->simplify();
    if(s->is_const())
      {
	double val = sub->evaluate(NULL, NULL);
	delete s;
	return new Const(session(), val);
      }
    return new Subgroup(session(), s);
  }

};
