# 2023-06-06 Triage Log

This week was a bunch of improvements, largely driven by cutting std debuginfo
in [#110221] and a few MIR or codegen optimizations. No pure regressions landed
this week!

Triage done by **@simulacrum**.
Revision range: [1221e43bdf413f7c405e9b17ef19d76c88222098..adc719d7147d5e2578ce08e0b4504be44650256e](https://perf.rust-lang.org/?start=1221e43bdf413f7c405e9b17ef19d76c88222098&end=adc719d7147d5e2578ce08e0b4504be44650256e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.3%, 2.0%]    | 11    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 1.0%]    | 9     |
| Improvements ✅ <br /> (primary)   | -1.9% | [-17.4%, -0.2%] | 103   |
| Improvements ✅ <br /> (secondary) | -5.2% | [-17.4%, -0.2%] | 116   |
| All ❌✅ (primary)                 | -1.7% | [-17.4%, 2.0%]  | 114   |

0 Regressions, 1 Improvements, 12 Mixed; 2 of them in rollups
79 artifact comparisons made in total

#### Regressions

No regressions this week.

#### Improvements

Greatly decrease the size of `rustc_driver.so` when debuginfo is enabled [#110221](https://github.com/rust-lang/rust/pull/110221) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=51f714c8c5021fe25442e46798b1cbef2f2249ed&end=42f28f9eb41adb7a197697e5e2d6535d00fd0f4a&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -8.8% | [-17.6%, -0.5%] | 17    |
| Improvements ✅ <br /> (secondary) | -7.5% | [-17.2%, -0.2%] | 72    |
| All ❌✅ (primary)                 | -8.8% | [-17.6%, -0.5%] | 17    |

This PR compresses and cuts some debuginfo from the shipped std library,
somewhat unintentionally. This might be something we roll back if we get
regression reports about it - not clear whether this changes behavior in a
meaningful way for anyone.

[#110221]: https://github.com/rust-lang/rust/pull/110221

#### Mixed

Rollup of 6 pull requests [#112016](https://github.com/rust-lang/rust/pull/112016) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=786178b2ab79ae471c5efc4e1faa0c83b9151703&end=82b311b4189cce2bde455f3e091ae662a382d592&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.0%]   | 14    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.5%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [-1.1%, 1.0%]  | 16    |

Roughly scattered changes, many of which are in high-variance benchmarks.

Enable MatchBranchSimplification [#112001](https://github.com/rust-lang/rust/pull/112001) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ddad0576caf8d0515ed453e04b468977c7d3dfc1&end=f59d577838fb0449a2b59ec3525a7fa91509e861&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 0.7%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 0.8%]   | 10    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [-0.4%, 0.7%]  | 9     |

Scattered changes, mostly a wash. Optimization targets particular code patterns
which don't occur that often in rustc most likely.

MIR: opt-in normalization of `BasicBlock` and `Local` numbering [#111813](https://github.com/rust-lang/rust/pull/111813) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1c53407e8c7cc922d718bde61ca34f47b6d2120f&end=089677eb32af83318467325edbef9b64053df532&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.3%, 1.2%]   | 8     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.5%, -0.3%] | 7     |
| All ❌✅ (primary)                 | 0.3%  | [0.3%, 0.3%]   | 1     |

Mostly noise, probably. The new normalization is off by default.

Inline derived `hash` [#111963](https://github.com/rust-lang/rust/pull/111963) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=089677eb32af83318467325edbef9b64053df532&end=f8447b963893b410f1dbce2cd752a898dc3ed8d4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 0.6%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.2%] | 16    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.4%, -0.3%] | 21    |
| All ❌✅ (primary)                 | -0.2% | [-0.6%, 0.3%]  | 17    |

Improvements outweigh regressions.

Use `Cow` in `{D,Subd}iagnosticMessage`. [#111748](https://github.com/rust-lang/rust/pull/111748) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dc0943d2eebf139e7e509882b803f77bfd25656d&end=70e04bd88d85cab8ed110ace5a278fab106d0ef5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.6%, 0.8%]   | 5     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.8%, -0.3%] | 10    |
| All ❌✅ (primary)                 | -     | -              | 0     |

Regressions limited to secondary benchmarks, and a good portion of them are
bimodal benchmarks. No further investigation warranted.

Make `TrustedStep` require `Copy` [#112083](https://github.com/rust-lang/rust/pull/112083) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=45eec0fe931e02932b43b79c51f90050c973c690&end=578bcbc2b42191556c4438b80ba37fafa4193e82&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 0.7%]   | 5     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-3.5%, -0.4%] | 13    |
| All ❌✅ (primary)                 | -0.4% | [-1.1%, 0.2%]  | 2     |

Improvements clearly outweigh regressions.

move `super_relate_consts` hack to `normalize_param_env_or_error` [#111623](https://github.com/rust-lang/rust/pull/111623) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=617d3d6d722c432cdcbf210e6db55c3bdeafe381&end=e29821ff85a2a3000d226f99f62f89464028d5d6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.6%]   | 8     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-2.2%, -2.0%] | 6     |
| All ❌✅ (primary)                 | 0.2%  | [-0.3%, 0.6%]  | 10    |

Most likely inlining or other codegen changes; roughly neutral change overall.

Enable ScalarReplacementOfAggregates in optimized builds [#112002](https://github.com/rust-lang/rust/pull/112002) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fabf9298633ca64450fa2af535252dc44a3b1080&end=642c92e63008ffb49f6ad8344e07bfa7d5b0d9bb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.9%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.3%, 2.3%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.9%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-2.9%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.1% | [-0.9%, 0.9%]  | 19    |

SROA benefits cranelift codegen and has no significant impact on runtimes, so
enabling by default makes sense. It also helps with MatchBranchSimplification,
enabled in a separate PR.

Enable ConstGoto and SeparateConstSwitch passes by default [#112040](https://github.com/rust-lang/rust/pull/112040) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=642c92e63008ffb49f6ad8344e07bfa7d5b0d9bb&end=789dd0b2a2cd68c129ba9b0aa1008939209adcfd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.6%  | [2.6%, 2.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.1%, -0.2%] | 72    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.0%, -0.2%] | 33    |
| All ❌✅ (primary)                 | -0.4% | [-1.1%, 2.6%]  | 73    |

More MIR opt enablement -- some regressions here, but improvements are much
more wide-ranging than the regressions.

Rollup of 7 pull requests [#112253](https://github.com/rust-lang/rust/pull/112253) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f5e6bb817c115c067ff47453eb9aa89a0a31358&end=398fa2187c88de46c13c142f600064483a563c86&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.6%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.4%, 1.3%]   | 9     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 4     |
| All ❌✅ (primary)                 | 0.4%  | [-0.4%, 0.6%]  | 7     |

Possibly just noise/bimodality given benchmarks and lack of significant PRs in
this rollup. Not investigating further.

Only check inlining counter after recursing. [#112240](https://github.com/rust-lang/rust/pull/112240) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d8095acb5f8134cbff59b2cc8c8b7f5cec364280&end=9eee230cd0a56bfba3ce65121798d9f9f4341cdd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.3%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.3%] | 11    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 6     |

Changes in inlining, overall a positive despite a few regressions.

Use `load`+`store` instead of `memcpy` for small integer arrays [#111999](https://github.com/rust-lang/rust/pull/111999) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=adc719d7147d5e2578ce08e0b4504be44650256e&end=fd9bf594366e73efb1a26a023e0b4de8eff82b94&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.2%  | [0.1%, 5.7%]   | 3     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -     | -              | 0     |

No clear impact on rustc workloads, but may benefit others.
