RabbitMQ `3.9.10` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports Erlang 24. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### Core Server

#### Bug Fixes

 * Make stream coordinator more defensive to rapid declaration and deletion cycles

   GitHub issue: [#3731](https://github.com/rabbitmq/rabbitmq-server/pull/3731)

#### Enhancements

 * Several inter-node communication listener settings are now exposed to `rabbitmq.conf`:

   ``` ini
   # this port range is used by default
   distribution.listener.port_range.min = 25675
   distribution.listener.port_range.max = 25675
   # instead of listening on all interfaces
   distribution.listener.interface = 192.168.0.1
   ```

   GitHub issue: [#3739](https://github.com/rabbitmq/rabbitmq-server/issues/3739)


### OAuth 2 Plugin

#### Bug Fixes

 * Signing keys specified in `rabbitmq.conf` were not translated correctly,
   resulting in exceptions during permission checks.

   GitHub issue: [#3759](https://github.com/rabbitmq/rabbitmq-server/pull/3759)


## Dependency Upgrades

* Ra was [upgraded to `2.0.3`](https://github.com/rabbitmq/ra/compare/v2.0.2...v2.0.3)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.10.tar.xz`
instead of the source tarball produced by GitHub.
