## RabbitMQ 3.6.3

RabbitMQ `3.6.3` is a maintenance release that includes
bug fixes, packaging and build system enhancements.

As of `3.6.3`, RabbitMQ also comes with several additional plugins in the distribution:

 * [rabbitmq_top](http://github.com/rabbitmq/rabbitmq-top), which helps identify (Erlang) processes
   that consume most RAM and CPU resources

 * [rabbitmq_trust_store](https://github.com/rabbitmq/rabbitmq-trust-store) which manages
   trusted client x509/TLS certificates

 * [rabbitmq_jms_topic_exchange](https://github.com/rabbitmq/rabbitmq-jms-topic-exchange/) which, together with [RabbitMQ JMS Java client](https://github.com/rabbitmq/rabbitmq-jms-client), provides support for the JMS 1.1 API
   atop RabbitMQ.

### Breaking Changes

 * Debian package now [supports systemd and also drops support for some older distributions](https://groups.google.com/forum/#!topic/rabbitmq-users/orFuEYExcxk).

 * All artifacts in this release are signed with a [new 4096-bit OpenGPG key](https://groups.google.com/forum/#!msg/rabbitmq-users/BO5cmEsdEhc/Jupz1_Q4AwAJ).

### Known Issues on Erlang 19.0

An undocumented runtime metric change in Erlang 19.0 [breaks management plugin](https://github.com/rabbitmq/rabbitmq-management/issues/244).

### Server

#### Bug Fixes

 * (Newly elected) queue leader process could terminate immediately after promotion

   GitHub issue: [rabbitmq-server#812](https://github.com/rabbitmq/rabbitmq-server/issues/812)

 * Priority queue mirror could fail to synchronize after restart

   GitHub issues: [rabbitmq-server#687](https://github.com/rabbitmq/rabbitmq-server/issues/687), [rabbitmq-server#802](https://github.com/rabbitmq/rabbitmq-server/issues/802)

 * Shutdown timeouts for worker processes are now much more reasonable.
   Earlier the timeouts were virtually infinite which could lead to a deadlock during node shutdown.

   GitHub issue: [rabbitmq-server#541](https://github.com/rabbitmq/rabbitmq-server/issues/541)

 * Purging of a durable queue could result in undelivered publisher confirms.
   Contributed by Andreas Ländle.

   GitHub issue: [rabbitmq-server#854](https://github.com/rabbitmq/rabbitmq-server/issues/854)

 * Old incarnations of queue mirrors are now ensured to be stopped before new ones are started

   GitHub issue: [rabbitmq-server#863](https://github.com/rabbitmq/rabbitmq-server/issues/863)

#### Enhancements

 * `systemd` support in Debian and RPM packages

   Contributed by Alexey Lebedeff (Mirantis).

   GitHub issue: [rabbitmq-server#570](https://github.com/rabbitmq/rabbitmq-server/issues/570)

 * Debian repository and release artifacts are now signed with a [new 4096-bit OpenGPG key](https://groups.google.com/forum/#!msg/rabbitmq-users/BO5cmEsdEhc/Jupz1_Q4AwAJ)

   GitHub issue: [rabbitmq-server#718](https://github.com/rabbitmq/rabbitmq-server/issues/718)

 * More resilient `worker_pool`, particularly important for LDAP plugin users

   GitHub issue: [rabbitmq-server#834](https://github.com/rabbitmq/rabbitmq-server/issues/834)

 * More efficient file handle management

   GitHub issue: [rabbitmq-server#828](https://github.com/rabbitmq/rabbitmq-server/issues/828)

 * Test suite ported to Common Test

   Plugin developers will be encouraged to port their test suites to Common Test
   in the future.

   GitHub issue: [rabbitmq-server#725](https://github.com/rabbitmq/rabbitmq-server/issues/725)

 * Compilation on [Erlang/OTP 19.0](http://erlang.org/download/otp_src_19.0.readme).

   GitHub issue: [rabbitmq-server#860](https://github.com/rabbitmq/rabbitmq-server/issues/860)

### Management Plugin

#### Enhancements

 * New API endpoint for reporting ETS tables memory consumption (absolute and relative)

   GitHub issue: [rabbitmq-management#219](https://github.com/rabbitmq/rabbitmq-management/issues/219)

 * Node information page now includes GC and context switching stats

   GitHub issue: [rabbitmq-management#208](https://github.com/rabbitmq/rabbitmq-management/issues/208)

 * Connection, channel, and queue information pages now include several runtime metrics

   GitHub issues: [rabbitmq-management#209](https://github.com/rabbitmq/rabbitmq-management/issues/209), [rabbitmq-management#210](https://github.com/rabbitmq/rabbitmq-management/issues/210), [rabbitmq-management#211](https://github.com/rabbitmq/rabbitmq-management/issues/211)

 * Node metrics now include information about how long it takes to obtain a file handle

   GitHub issue: [rabbitmq-server#825](https://github.com/rabbitmq/rabbitmq-server/issues/825)

 * Partial HTTPS support in `rabbitmqadmin` on Python versions older than `2.7.9`

   GitHub issue: [rabbitmq-management#225](https://github.com/rabbitmq/rabbitmq-management/issues/225)

#### Bug Fixes

 * A channel statistics-related memory leak fixed.

   GitHub issue: [rabbitmq-management#214](https://github.com/rabbitmq/rabbitmq-management/issues/214)

 * Stats collectors event queue is now bounded (again)

   GitHub issue: [rabbitmq-management#221](https://github.com/rabbitmq/rabbitmq-management/issues/221)

 * Stats table name was logged as a tuple

   GitHub issue: [rabbitmq-management#206](https://github.com/rabbitmq/rabbitmq-management/issues/206)


### .NET Client

#### Bug Fixes

 * Setting user-provided connection name didn't have an effect.

   GitHub issue: [rabbitmq-dotnet-client#187](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/187)

 * `IConnection#CreateModel` could throw a `NullPointerException` due to a race
   condition.

   GitHub issue: [rabbitmq-dotnet-client#185](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/185)

 * Connections with automatic recovery enabled ignored ports from the hostname
   list.

   GitHub issues: [rabbitmq-dotnet-client#157](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/157),
                  [rabbitmq-dotnet-client#190](https://github.com/rabbitmq/rabbitmq-dotnet-client/pull/190)

 * Fixes an underflow in delivery tag handling after connection recovery

   Contributed by @harishvadali and @Entroper.

   GitHub issue: [rabbitmq-dotnet-client#200](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/200)

#### Enhancements

 * New [FAKE](https://fsharp.github.io/FAKE/) and [Paket](https://fsprojects.github.io/Paket/)-based build tooling: development on OS X and Linux with Mono is now
   possible again.

   GitHub issue: [rabbitmq-dotnet-client#169](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/169)


### LDAP Plugin

#### Enhancements

 * Nested groups are now supported with a separate query type

   GitHub issue: [rabbitmq-auth-backend-ldap#3](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/3)

#### Bug Fixes

 * Query failures (e.g. `noSuchObject` responses) from LDAP servers are now correctly treated as `false` in
   `or` and `and` queries instead of erroring.

   GitHub issue: [rabbitmq-auth-backend-ldap#48](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/48)

### Trust Store Plugin

#### Bug Fixes

 * Invalid/unparseable certificates no longer prevent other certificates from (re)loading

   GitHub issue: [rabbitmq-trust-store#27](https://github.com/rabbitmq/rabbitmq-trust-store/issues/27)

#### Enhancements

 * Certificate verification now can validate only leaf certificates.
   This is more convenient in some cases. It will be one of the opt-in modes
   in future versions.

   GitHub issue: [rabbitmq-trust-store#34](https://github.com/rabbitmq/rabbitmq-trust-store/issues/34)

 * The plugin now logs when a certificate is added (loaded) or removed (unloaded)

   GitHub issue: [rabbitmq-trust-store#28](https://github.com/rabbitmq/rabbitmq-trust-store/issues/28)

 * The plugin now provides a function for listing trust store certificates
   via `rabbitmqctl eval`: `rabbitmqctl eval 'io:format(rabbit_trust_store:list()).'`

   GitHub issue: [rabbitmq-trust-store#31](https://github.com/rabbitmq/rabbitmq-trust-store/issues/31)

### Erlang Client

#### Enhancements

 * `amqp_connection:close/4` is now exported

   GitHub issue: [rabbitmq-erlang-client#59](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/59)

#### Bug Fixes

 * The client now compiles on Erlang/OTP 19.0

   GitHub issue: [rabbitmq-erlang-client#41](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/41)

### Delayed Message Exchange Plugin

#### Enhacements

 * Efficiency improvements when publications and delayed delivery happen concurrently.

   Contributed by Richard Larocque.

   GitHub issues: [rabbitmq-delayed-message-exchange#51](https://github.com/rabbitmq/rabbitmq-delayed-message-exchange/pull/51), [rabbitmq-delayed-message-exchange#54](https://github.com/rabbitmq/rabbitmq-delayed-message-exchange/pull/54)
