## Release Highlights

This is the release notes for RabbitMQ 3.6.0 RC3. This is a preview of
a feature release.

Key improvements in this release are:

 * Lazy queues
 * Much better queue synchronisation throughput
 * Lower RAM use, tunable flow control
 * Stronger password encryption with pluggable algorithms
 * Development moved to GitHub; build system now uses erlang.mk
 * Significant improvements to Web STOMP
 * Experimental WinRT-compatible .NET client, SQL CLR compatibility in the "regular" one
 * Pagination in management UI


### Server

#### Bug Fixes

 * Cluster-wide alarm state is not updated when alarmed node goes down.

   Contributed by Alexey Lebedeff (@binarin).

   GitHub issue: [rabbitmq-server#362](https://github.com/rabbitmq/rabbitmq-server/issues/362)

 * Blocked connections could be unblocked too early.

   When multiple resource alarms were in effect, clearing just one of them would
   unblock all publishers prematurely.

   Contributed by Alexey Lebedeff (@binarin).

   GitHub issue: [rabbitmq-server#379](https://github.com/rabbitmq/rabbitmq-server/issues/379)

 * Blocked connections that are closed by clients are now expired
   and cleaned up by the heartbeat mechanism.

   Contributed by Alexey Lebedeff (@binarin).

   GitHub issue: [rabbitmq-server#384](https://github.com/rabbitmq/rabbitmq-server/issues/384)

 * If `RABBITMQ_MNESIA_DIR` was set to a value with a trailing slash, it could prevent
   automatic clustering (and other operations that assume pristine node state) from starting.

   GitHub issue: [rabbitmq-server#118](https://github.com/rabbitmq/rabbitmq-server/issues/118)

 * Standard output and error redirection in package scripts not respects `RABBITMQ_LOG_BASE`.

   GitHub issue: [rabbitmq-server#88](https://github.com/rabbitmq/rabbitmq-server/issues/88)

 * Properly seed pseudo-random number generator when picking client port

   Contributed by Alexey Lebedeff (@binarin).

   GitHub issue: [rabbitmq-common#3](https://github.com/rabbitmq/rabbitmq-common/issues/3)

 * `RABBITMQ_ALLOW_INPUT` was ignored on Windows

   GitHub issue: [rabbitmq-server#490](https://github.com/rabbitmq/rabbitmq-server/issues/490)


#### Enhancements

 * Lazy queues.

   Lazy queues is a new feature that can significantly reduce RAM use of queues
   that can grow very long (e.g. don't have consumers online for hours or day).
   Such queues page messages to disk as they enter the queue.

   This feature is opt-in and has virtually no overhead for consumers in most cases,
   making throughput for publishers much more even and reducing RAM use.

   GitHub issue: [rabbitmq-server#351](https://github.com/rabbitmq/rabbitmq-server/issues/351)

 * Queue synchronisation to mirrors now happens in batches of configurable size,
   4096 messages by default. This can improve sync throughput by an order of magnitude.

   GitHub issue: [rabbitmq-server#336](https://github.com/rabbitmq/rabbitmq-server/issues/336)

 * queue leader-to-node distribution is now more flexible: there are several
   strategies to choose from.

   GitHub issue: [rabbitmq-server#121](https://github.com/rabbitmq/rabbitmq-server/issues/121)

 * Stronger password encryption algorithm.

   SHA-256 is the hashing function used by default now, with SHA-512 being an option provided
   out of the box. Support for more options (Scrypt, bcrypt, etc) can be added with plugins.

   Existing user records will continue using MD5. To force re-hashing/encryption, change
   user password using `rabbitmqctl` or management UI/HTTP API.

   This should improve FIPS-180 compatibility.

   GitHub issue: [rabbitmq-server#270](https://github.com/rabbitmq/rabbitmq-server/issues/270)

 * Lower RAM use thanks to disabled in-process caching.

   RabbitMQ's in-process read buffers are now disabled by default. This often significantly
   reduces RAM usage at effectively no throughput or latency cost because the OS and file
   system do the same job fairly well.

   GitHub issue: [rabbitmq-server#228](https://github.com/rabbitmq/rabbitmq-server/issues/228)

 * [Configurable flow control settings](https://blog.rabbitmq.com/posts/2015/10/new-credit-flow-settings-on-rabbitmq-3-5-5/)

   Note that larger values will not necessarily lead to higher throughput or lower latency.
   They can also result in larger RAM use and therefore can be dangerous.

   GitHub issue: [rabbitmq-server#143](https://github.com/rabbitmq/rabbitmq-server/issues/143)

 * Build system switched to erlang.mk.

   [erlang.mk](https://github.com/ninenines/erlang.mk) is a modern build system for Erlang
   projects. RabbitMQ and all of its sub-projects have been switched to it.

   This yields several benefits for RabbitMQ maintainers and plugin developers,
   for example, dependency management for plugins is much more straightforward, build
   times are significantly improved, there is no need to depend on `rabbitmq-server` for most
   plugins.

   Various 3rd party plugins need to migrate to erlang.mk in order to be built against
   RabbitMQ 3.6.0 (`rabbit_common`).

   GitHub issue: [rabbitmq-server#388](https://github.com/rabbitmq/rabbitmq-server/issues/388)

 * Streaming `rabbitmqctl`: `rabbitmqctl` list operations now stream results
   instead of waiting for the entire result set to arrive. This both improves
   responsiveness and makes it possible to list individual items, including those
   which did not respond in time.

   GitHub issue: [rabbitmq-server#62](https://github.com/rabbitmq/rabbitmq-server/issues/62)

 * (More) standard exit codes for command line tools

   `rabbitmqctl` and `rabbitmq-plugins` now use more standard, or at least distinctive,
   error codes for various failures.

   Contributed by Alexey Lebedeff (@binarin).

   GitHub issue: [rabbitmq-server#396](https://github.com/rabbitmq/rabbitmq-server/issues/396)

 * Improved log message for channel exceptions.

   GitHub issues: [rabbitmq-server#416](https://github.com/rabbitmq/rabbitmq-server/issues/416)

 * Improved log message when a client's TCP connection is closed unexpectedly.

   GitHub issue: [rabbitmq-server#60](https://github.com/rabbitmq/rabbitmq-server/issues/60)

 * Improved log message when a client connects to a non-existent vhost

   GitHub issue: [rabbitmq-server#320](https://github.com/rabbitmq/rabbitmq-server/issues/320)

 * Improved log message for `access_refused` connection errors.

   GitHub issue: [rabbitmq-server#418](https://github.com/rabbitmq/rabbitmq-server/issues/418)

 * Improved log message for `command_invalid` connection errors.

   GitHub issue: [rabbitmq-server#419](https://github.com/rabbitmq/rabbitmq-server/issues/419)

 * More sensible error code when a client connects to a non-existent vhost (or vhost it has
   no permissions for). The code returned is now `530`.

   GitHub issue: [rabbitmq-server#237](https://github.com/rabbitmq/rabbitmq-server/issues/237)

 * Memory monitoring interval is now configurable.

   GitHub issue: [rabbitmq-server#112](https://github.com/rabbitmq/rabbitmq-server/issues/112)

 * Prevent background GC interval from becoming too large due to backoff.

   Contributed by Dallas Marlow (@dallasmarlow).

   GitHub issue: [rabbitmq-server#100](https://github.com/rabbitmq/rabbitmq-server/issues/100)

 * Windows installer now supports "unattended" NSIS installs.

   Contributed by Ryan Zink (@ryanzink).

   GitHub issue: [rabbitmq-server#264](https://github.com/rabbitmq/rabbitmq-server/issues/264)

 * Windows package name now includes RabbitMQ version it provides.

   GitHub issue: [rabbitmq-server#80](https://github.com/rabbitmq/rabbitmq-server/issues/80)

 * `kernel.net_ticktime` is now included into `rabbitmqctl status` output.

   GitHub issue: [rabbitmq-server#63](https://github.com/rabbitmq/rabbitmq-server/issues/63)

 * `rabbitmqctl` now has a command for setting up free disk space limit at runtime.

   GitHub issue: [rabbitmq-server#461](https://github.com/rabbitmq/rabbitmq-server/issues/461)

 * Backup directory location is now mentioned in failed upgrade messages.

   GitHub issue: [rabbitmq-server#169](https://github.com/rabbitmq/rabbitmq-server/issues/169)

 * `rabbit_diagnostics:maybe_stuck/0` now includes date and time in its output.

   GitHub issue: [rabbitmq-server#506](https://github.com/rabbitmq/rabbitmq-server/issues/506)

#### Other

 * Erlang R16B03 is now required.

   17.5 or 18.x are recommended.

   GitHub issue: [rabbitmq-server#250](https://github.com/rabbitmq/rabbitmq-server/issues/250)

 * Use/support new Erlang/OTP 18 date and time API.

   Only when it is available, of course.

   GitHub issue: [rabbitmq-server#233](https://github.com/rabbitmq/rabbitmq-server/issues/233)

 * RabbitMQ server now supports tracing of credit flow events (e.g. when a process is blocked
   by credit flow). This is currently a compile-time flag aimed to be used in development
   environments.

   GitHub issue: [rabbitmq-server#137](https://github.com/rabbitmq/rabbitmq-server/issues/137)


### Java Client

#### Enhancements

 * Shutdown threads can use an executor.

   In environments with very constrainted per-process thread reasources, e.g. basic PaaS plans,
   temporary threads created during connection shutdown may make the app run over the limit.

   It is now possible to use a user-provided executor for shutdown operations instead.

   GitHub issue: [rabbitmq-java-client#87](https://github.com/rabbitmq/rabbitmq-java-client/issues/87)

 * ChannelManager now can use an executor.

   Similar to the above but for `ChannelManager` operations.

   GitHub issue: [rabbitmq-java-client#94](https://github.com/rabbitmq/rabbitmq-java-client/issues/94)

 * `Channel#consumerCount(string)` is a new convenience method for retrieving number of consumers on a queue.

   GitHub issue: [rabbitmq-java-client#49](https://github.com/rabbitmq/rabbitmq-java-client/issues/49)

 * `Channel#messageCount(string)` is a new convenience method for retrieving number of messages in a queue.

   GitHub issue: [rabbitmq-java-client#41](https://github.com/rabbitmq/rabbitmq-java-client/issues/41)

 * `LongString#toString` is part of the API

   GitHub issue: [rabbitmq-java-client#84](https://github.com/rabbitmq/rabbitmq-java-client/issues/84)


### .NET Client

#### Enhancements

 * Host/address list support is back. Host selection strategy (when recovering a connection) is now pluggable.

   GitHub issue: [rabbitmq-dotnet-client#81](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/81)

 * Experimental .NET client with Windows RT support is now available.

   GitHub issue: [rabbitmq-dotnet-client#16](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/16)

 * SQL CLR compatibility.

   GitHub issue: [rabbitmq-dotnet-client#57](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/57)

 * `IModel#ConsumerCount(string)` is a new convenience method for retrieving number of consumers on a queue.

   GitHub issue: [rabbitmq-dotnet-client#73](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/73)

 * `IModel#MessageCount(string)` is a new convenience method for retrieving number of messages in a queue.

   GitHub issue: [rabbitmq-dotnet-client#74](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/74)

 * Continuation timeout is now configurable.

   GitHub issue: [rabbitmq-dotnet-client#80](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/80)

 * `RabbitMQ.Client.Headers` is a new class that contains constants for commonly used headers.

   Contributed by Yury Pliner (@Pliner).

   GitHub issue: [](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/52)

#### Other

 * .NET 4.5 is now required by the library.

   GitHub issue: [rabbitmq-dotnet-client#134](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/134)

 * Code examples are removed from the .NET client repository. All examples belong
   to `rabbitmq-tutorials` now.

   GitHub issue: [rabbitmq-dotnet-client#39](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/39)



### Management plugin

#### Enhancements

 * Pagination for connections, channels, exchanges, and queues.

   Management UI now supports pagination, making the UI much more responsive
   in environments with many connections, queues, etc.

   GitHub issue: [rabbitmq-management#50](https://github.com/rabbitmq/rabbitmq-management/issues/50)

 * Queue information objects in responses now has a boolean property for queue
   exclusivity instead of a confusing `owner_pid`.

   GitHub issue: [rabbitmq-management#40](https://github.com/rabbitmq/rabbitmq-management/issues/40)

#### Bug Fixes

 * Connection and channel filtering should respect active vhost.

   GitHub issue: [rabbitmq-management#34](https://github.com/rabbitmq/rabbitmq-management/issues/34)

 * GET requests to `/api/queues/{vhost}/{name}/get` now accept/provide `application/json`

   GitHub issue: [rabbitmq-management#46](https://github.com/rabbitmq/rabbitmq-management/issues/46)


### MQTT plugin

#### Enhancements

 * Pluggable retained message stores. Since MQTT 3.1.1 spec doesn't dictate any consistency
   or availability from the store in clustered environments, we only provide an in-memory implementation
   suitable for development environments with a single node. For production environments, plugins that
   provide stores with specific consistency guarantees are expected to be developed.

   GitHub issue: [rabbitmq-mqtt#16](https://github.com/rabbitmq/rabbitmq-mqtt/issues/16)

 * Default subscription (queue) TTL for non-clean sessions is now 24 hours

   GitHub issue: [rabbitmq-mqtt#49](https://github.com/rabbitmq/rabbitmq-mqtt/issues/49)

 * Socket-based authentication plugins now can work with plugins such as MQTT and STOMP
   (those using direct Erlang client).

   Contributed by Petr Gotthard (@gotthardp).

   GitHub issue: [rabbitmq-server#111](https://github.com/rabbitmq/rabbitmq-server/issues/111)


### STOMP plugin

#### Enhancement

 * Control over queue properties.

   It is now possible to control queue properties (durable, auto-delete, exclusive plus several
   supported x-arguments) for all STOMP destinations.

   When using durable topics, it is now necessary to configure queue auto-deletion to `false`
   explicitly via a header.

   GitHub issue: [rabbitmq-stomp#24](https://github.com/rabbitmq/rabbitmq-stomp/issues/24)

 * Socket-based authentication plugins now can work with plugins such as MQTT and STOMP
   (those using direct Erlang client).

   Contributed by Petr Gotthard (@gotthardp).

   GitHub issue: [rabbitmq-server#111](https://github.com/rabbitmq/rabbitmq-server/issues/111)


### Web STOMP plugin

#### Enhancements

 * Raw WebSocket endpoint.

   The plugin now supports a new endpoint, `/ws`, which supports WebSocket connections directly
   without the need to use SockJS.

   GitHub issue: [rabbitmq-web-stomp#17](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/17).

 * Support for binary data streams.

   Thanks to the new direct WebSocket support, binary data now can be transferred over
   Web STOMP connections.

   GitHub issue: [rabbitmq-web-stomp#19](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/19)

 * STOMP heartbeat support.

   GitHub issue: [rabbitmq-web-stomp#15](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/15)

 * Heartbeats are disabled for SockJS.

   GitHub issue: [rabbitmq-web-stomp#28](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/28)

 * CORS headers support

   GitHub issue: [rabbitmq-web-stomp#12](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/12)

 * Cowboy configuration.

   Key settings of Cowboy, the HTTP/WebSocket server powering the plugin, now can be fine tuned
   via this plugin.

   GitHub issue: [rabbitmq-web-stomp#22](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/22)

 * Cowboy is upgraded to `1.0.3`

   GitHub issue: [rabbitmq-web-stomp#13](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/13)

 * SockJS is upgraded to `1.0.3`.

   GitHub issue: [rabbitmq-web-stomp#4](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/4)

 * Queue parameters now can be configured via headers (just like in the regular STOMP plugin).

   GitHub issue: [rabbitmq-web-stomp#7](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/7)

 * Address Web STOMP listener binds to now can be configured.
   Previously only port was configurable.

   GitHub issue: [rabbitmq-web-stomp#2](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/2)


### LDAP plugin

#### Enhancements

 * LDAP server connections are now pooled. This significantly reduces
   the load on LDAP servers.

   Contributed by [LShift](http://www.lshift.net).

   GitHub issue: [rabbitmq-auth-backend-ldap#1](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/1).



### Sharding plugin

#### Enhancements

 * Routing key policy is now optional.

   GitHub issue: [rabbitmq-sharding#6](https://github.com/rabbitmq/rabbitmq-sharding/issues/6)



### Delayed Message Exchange

#### Enhancement

 * Initial public release.

   GitHub issue: [rabbitmq-delayed-message-exchange#1](https://github.com/rabbitmq/rabbitmq-delayed-message-exchange/issues/1)
