RabbitMQ `3.12.7` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Server

#### Bug Fixes

 * Stream replication connections configured to use exclusively TLSv1.3 failed.

   GitHub issue:[#9678](https://github.com/rabbitmq/rabbitmq-server/pull/9678)

 * On startup, stream replicas will handle one more potential case of segment file corruption
   after an unclean shutdown.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#9678](https://github.com/rabbitmq/rabbitmq-server/pull/9678)

 * `default_policies.*.queue_pattern` definition in `rabbitmq.conf` was incorrectly parsed.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#9545](https://github.com/rabbitmq/rabbitmq-server/pull/9545)

 * Avoid log noise when inter-node connections frequently fail and recover.

   Contributed by @Ayanda-D.

   GitHub issue: [#9667](https://github.com/rabbitmq/rabbitmq-server/pull/9667)

#### Enhancements

 * Optimized stream index scans. Longer scans could result in some replicas stopping
   with a timeout.

   GitHub issue:[#9678](https://github.com/rabbitmq/rabbitmq-server/pull/9678)

 * Classic queue storage version is now a supported key for [operator policies](https://rabbitmq.com/parameters.html#operator-policies).

   Contributed by @SignalWhisperer (AWS).

   GitHub issue: [#9548](https://github.com/rabbitmq/rabbitmq-server/pull/9548)

 * [Queue length limit](https://rabbitmq.com/maxlength.html) overflow behavior now can be configured via [operator policies](https://rabbitmq.com/parameters.html#operator-policies).

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#9636](https://github.com/rabbitmq/rabbitmq-server/issues/9636)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-streams list_stream_consumer_groups` incorrectly validated the set of columns it accepts.

   GitHub issue: [#9671](https://github.com/rabbitmq/rabbitmq-server/pull/9671)

#### Enhancements

 * Several `list_stream_*` commands (available via both `rabbitmq-diagnostics` and `rabbitmq-streams`) commands now can
   display replica node in addition to other fields.

   GitHub issue: [#9582](https://github.com/rabbitmq/rabbitmq-server/issues/9582)

 * `rabbitmqctl add_user` now can accept a [pre-generated salted password](https://rabbitmq.com/passwords.html) instead
   of a plain text password, both as a positional argument and via standard input:

   ``` shell
   # This is just an example, DO NOT use this value in production!
   # The 2nd argument is a Base64-encoded pre-hashed and salted value of "guest4"
   rabbitmqctl -- add_user "guest4" "BMT6cj/MsI+4UOBtsPPQWpQfk7ViRLj4VqpMTxu54FU3qa1G" --pre-hashed-password
   # try authenticating with a pair of credentials
   rabbitmqctl authenticate_user "guest4" "guest4"
   ```

   GitHub issue: [#9669](https://github.com/rabbitmq/rabbitmq-server/issues/9669)


### Management Plugin

#### Bug Fixes

 * Message consumption with the "Nack message, requeue: true" option did not actually requeue deliveries.

   GitHub issue: [#9715](https://github.com/rabbitmq/rabbitmq-server/pull/9715)

#### Enhancements

 * HTTP API request body size is now limited to 10 MiB by default.
   Two endpoints, one that accepts messages for publishing (note: publishing over the HTTP API is greatly discouraged)
   and another for [definition import](https://rabbitmq.com/definitions.html#import),
   will now reject larger transfers with a `400 Bad Request` response.

   GitHub issue: [#9708](https://github.com/rabbitmq/rabbitmq-server/pull/9708)

 * `DELETE /api/queues/{vhost}/{name}` now can delete exclusive queues.

   GitHub issue: [#8758](https://github.com/rabbitmq/rabbitmq-server/issues/8758)

 * Key supported by operator policies are now grouped by queue type in the UI.

   GitHub issue: [#9544](https://github.com/rabbitmq/rabbitmq-server/pull/9544)


### MQTT Plugin

#### Enhancements

 * Improved data safety for confirms in environments where the plugin uses classic queues.

   GitHub issue: [#9530](https://github.com/rabbitmq/rabbitmq-server/pull/9530)


### Web MQTT Plugin

#### Bug Fixes

 * Avoid an exception when a not fully established MQTT-over-WebSockets connection terminated.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#9654](https://github.com/rabbitmq/rabbitmq-server/pull/9654)


### JMS Topic Exchange Plugin

#### Bug Fixes

 * Recovery of bindings of durable queues bound to a transient JMS topic exchange failed.

   GitHub issue: [#9533](https://github.com/rabbitmq/rabbitmq-server/issues/9533)


### Sharding Plugin

#### Bug Fixes

 * Recovery of bindings of durable queues bound to a transient `x-modulo-hash` exchange failed.

   GitHub issue: [#9533](https://github.com/rabbitmq/rabbitmq-server/issues/9533)


### Recent History Exchange Plugin

#### Bug Fixes

 * Recovery of bindings of durable queues bound to a transient recent history exchange failed.

   GitHub issue: [#9533](https://github.com/rabbitmq/rabbitmq-server/issues/9533)


## Dependency Upgrades

 * `osiris` has been upgraded to [`1.6.9`](https://github.com/rabbitmq/osiris/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.7.tar.xz`
instead of the source tarball produced by GitHub.
