% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_transliterate.R
\name{stri_trans_list}
\alias{stri_trans_list}
\title{List Available Text Transforms and Transliterators}
\usage{
stri_trans_list()
}
\value{
Returns a character vector.
}
\description{
Returns a list of available text transform identifiers.
Each of them may be used in \code{\link{stri_trans_general}}
tasks.
}
\examples{
stri_trans_list()

}
\references{
\emph{General Transforms} -- ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/transforms/general/}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other transform: 
\code{\link{stri_trans_char}()},
\code{\link{stri_trans_general}()},
\code{\link{stri_trans_nfc}()},
\code{\link{stri_trans_tolower}()}
}
\concept{transform}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
