library(spatialreg)
data(oldcol, package="spdep")
lwB <- spdep::nb2listw(COL.nb, style="B")
expect_silent(mod0 <- lmSLX(CRIME ~ INC + HOVAL, data=COL.OLD, listw=lwB))
coef(mod0)
INCB <- spdep::lag.listw(lwB, COL.OLD$INC)
HOVALB <- spdep::lag.listw(lwB, COL.OLD$HOVAL)
INTERCEPTB <- spdep::card(lwB$neighbours)
mod1 <- lm(CRIME ~ INC + HOVAL + INTERCEPTB + INCB + HOVALB, data=COL.OLD)
expect_true(isTRUE(all.equal(unname(coef(mod0)), unname(coef(mod1)))))
expect_silent(modx <- lmSLX(CRIME ~ INC + HOVAL + 0, data=COL.OLD, listw=lwB))
mod1x <- lm(CRIME ~ INC + HOVAL + 0 + INCB + HOVALB, data=COL.OLD)
expect_true(isTRUE(all.equal(unname(coef(modx)), unname(coef(mod1x)))))
expect_error(mod0_no_x <- lmSLX(CRIME ~ 1, data=COL.OLD, listw=lwB, Durbin=TRUE))
expect_error(mod0_no_x <- lmSLX(CRIME ~ 1, data=COL.OLD, listw=lwB, Durbin= ~ INC))
expect_warning(mod0_no_x <- errorsarlm(CRIME ~ 1, data=COL.OLD, listw=lwB, Durbin=TRUE))
expect_warning(mod0_no_x <- errorsarlm(CRIME ~ 1, data=COL.OLD, listw=lwB, Durbin= ~ INC))

