% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_createalias.R
\name{collection_createalias}
\alias{collection_createalias}
\title{Create an alias for a collection}
\usage{
collection_createalias(conn, alias, collections, raw = FALSE,
  callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{alias}{(character) Required. The alias name to be created}

\item{collections}{(character) Required. A character vector of collections
to be aliased}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Create a new alias pointing to one or more collections. If an
alias by the same name already exists, this action will replace the existing
alias, effectively acting like an atomic "MOVE" command.
}
\examples{
\dontrun{
(conn <- SolrClient$new())

if (!conn$collection_exists("thingsstuff")) {
  conn$collection_create(name = "thingsstuff")
}

conn$collection_createalias("tstuff", "thingsstuff")
conn$collection_clusterstatus()$cluster$collections$thingsstuff$aliases
}
}
