% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hop2.R, R/phop.R
\name{hop2}
\alias{hop2}
\alias{hop2_vec}
\alias{phop}
\alias{phop_vec}
\title{Hop along multiple inputs simultaneously}
\usage{
hop2(.x, .y, .starts, .stops, .f, ...)

hop2_vec(.x, .y, .starts, .stops, .f, ..., .ptype = NULL)

phop(.l, .starts, .stops, .f, ...)

phop_vec(.l, .starts, .stops, .f, ..., .ptype = NULL)
}
\arguments{
\item{.x, .y}{\verb{[vector]}

Vectors to iterate over. Vectors of size 1 will be recycled.}

\item{.starts, .stops}{\verb{[integer]}

Vectors of boundary locations that make up the windows to bucket \code{.x} with.
Both \code{.starts} and \code{.stops} will be recycled to their common size, and
that common size will be the size of the result. Both vectors should be
integer locations along \code{.x}, but out-of-bounds values are allowed.}

\item{.f}{\verb{[function / formula]}

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.ptype}{\verb{[vector(0) / NULL]}

A prototype corresponding to the type of the output.

If \code{NULL}, the default, the output type is determined by computing the
common type across the results of the calls to \code{.f}.

If supplied, the result of each call to \code{.f} will be cast to that type,
and the final output will have that type.

If \code{getOption("vctrs.no_guessing")} is \code{TRUE}, the \code{.ptype} must be
supplied. This is a way to make production code demand fixed types.}

\item{.l}{\verb{[list]}

A list of vectors. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. If \code{.l} has names,
they will be used as named arguments to \code{.f}. Elements of \code{.l} with size
1 will be recycled.}
}
\value{
A vector fulfilling the following invariants:

\subsection{\code{hop2()}}{
\itemize{
\item \code{vec_size(hop2(.x, .y, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_ptype(hop2(.x, .y, .starts, .stops)) == list()}
}

}

\subsection{\code{hop2_vec()}}{
\itemize{
\item \code{vec_size(hop2_vec(.x, .y, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_size(hop2_vec(.x, .y, .starts, .stops)[[1]]) == 1L}
\item \code{vec_ptype(hop2_vec(.x, .y, .starts, .stops, .ptype = ptype)) == ptype}
}

}

\subsection{\code{phop()}}{
\itemize{
\item \code{vec_size(phop(.l, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_ptype(phop(.l, .starts, .stops)) == list()}
}

}

\subsection{\code{phop_vec()}}{
\itemize{
\item \code{vec_size(phop_vec(.l, .starts, .stops)) == vec_size_common(.starts, .stops)}
\item \code{vec_size(phop_vec(.l, .starts, .stops)[[1]]) == 1L}
\item \code{vec_ptype(phop_vec(.l, .starts, .stops, .ptype = ptype)) == ptype}
}

}
}
\description{
\code{hop2()} and \code{phop()} represent the combination
of \code{\link[=slide2]{slide2()}} and \code{\link[=pslide]{pslide()}} with \code{\link[=hop]{hop()}}, allowing you to iterate
over multiple vectors at once, hopping along them using boundaries defined
by \code{.starts} and \code{.stops}.
}
\examples{
hop2(1:2, 3:4, .starts = 1, .stops = c(2, 1), ~c(x = .x, y = .y))

phop(
 list(1, 2:4, 5:7),
 .starts = c(0, 1),
 .stops  = c(2, 4),
 ~c(x = ..1, y = ..2, z = ..3)
)

}
\seealso{
\code{\link[=hop]{hop()}}, \code{\link[=hop_index]{hop_index()}}, \code{\link[=slide2]{slide2()}}
}
