% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{BGTextColor}
\alias{BGTextColor}
\title{Determine text color based on background color}
\source{
\url{https://stackoverflow.com/questions/3942878/how-to-decide-font-color-in-white-or-black-depending-on-background-color}
}
\usage{
BGTextColor(
  background,
  threshold = 186,
  w3c = FALSE,
  dark = "black",
  light = "white"
)
}
\arguments{
\item{background}{A vector of background colors; supports R color names and
hexadecimal codes}

\item{threshold}{Intensity threshold for light/dark cutoff; intensities
greater than \code{theshold} yield \code{dark}, others yield \code{light}}

\item{w3c}{Use \href{http://www.w3.org/TR/WCAG20/}{W3C} formula for calculating
background text color; ignores \code{threshold}}

\item{dark}{Color for dark text}

\item{light}{Color for light text}
}
\value{
A named vector of either \code{dark} or \code{light}, depending on
\code{background}; names of vector are \code{background}
}
\description{
Determine text color based on background color
}
\examples{
BGTextColor(background = c('black', 'white', '#E76BF3'))

}
\concept{visualization}
