% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_growth_forms.R
\name{rl_growth_forms}
\alias{rl_growth_forms}
\alias{rl_growth_forms_}
\title{Get plant species growth forms by taxon name, IUCN id, and region}
\usage{
rl_growth_forms(
  name = NULL,
  id = NULL,
  region = NULL,
  key = NULL,
  parse = TRUE,
  ...
)

rl_growth_forms_(name = NULL, id = NULL, region = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) A taxonomic name}

\item{id}{(character) An IUCN identifier}

\item{region}{(character) A region name, see \code{\link{rl_regions}} for
acceptable region identifiers (use the entries in the \code{identifier}
column)}

\item{key}{A IUCN API token. See \code{\link{rl_use_iucn}}.}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get plant species growth forms by taxon name, IUCN id, and region
}
\examples{
\dontrun{
rl_growth_forms('Quercus robur')
rl_growth_forms('Quercus robur', region = 'europe')
rl_growth_forms(id = 63532)
rl_growth_forms(id = 63532, region = 'europe')

rl_growth_forms('Mucuna bracteata')
rl_growth_forms('Abarema villifera')
rl_growth_forms('Adansonia perrieri')
rl_growth_forms('Adenostemma harlingii')

rl_growth_forms_('Quercus robur')
rl_growth_forms_(id = 63532, region = 'europe')
}
}
\references{
API docs at https://apiv3.iucnredlist.org/api/v3/docs
}
