% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevel.R
\name{step_relevel}
\alias{step_relevel}
\alias{tidy.step_relevel}
\title{Relevel factors to a desired level}
\usage{
step_relevel(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  ref_level,
  objects = NULL,
  skip = FALSE,
  id = rand_id("relevel")
)

\method{tidy}{step_relevel}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables that will be affected by the step. These variables
should be character or factor types. See \code{\link[=selections]{selections()}} for more
details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{ref_level}{A single character value that will be used to
relevel the factor column(s) (if the level is present).}

\item{objects}{A list of objects that contain the information
on factor levels that will be determined by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_relevel} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any).
}
\description{
\code{step_relevel} creates a \emph{specification} of a recipe
step that will reorder the provided factor columns so that
the level specified by ref_level is first. This is useful
for contr.treatment contrasts which take the first level as the
reference.
}
\details{
The selected variables are releveled to a level
(given by \code{ref_level}). Placing the \code{ref_level} in the first
position.

Note that if the original columns are character, they will be
converted to factors by this step.
}
\examples{

library(modeldata)
data(okc)
rec <- recipe(~ diet + location, data = okc) \%>\%
  step_unknown(diet, new_level = "UNKNOWN") \%>\%
  step_relevel(diet, ref_level = "UNKNOWN") \%>\%
  prep()

data <- bake(rec, okc)
levels(data$diet)
}
\concept{factors}
\concept{preprocessing}
\keyword{datagen}
