% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ci.R
\name{print.ci}
\alias{print.ci}
\title{Print confidence intervals}
\usage{
\method{print}{ci}(x, se = FALSE, print = TRUE, ...)
}
\arguments{
\item{x}{Object containing point estimates and the corresponding
confidence intervals}

\item{se}{If \code{TRUE} add the standard error.}

\item{print}{Logical: if \code{FALSE} do not actually print
confidence intervals but just return them invisibly.}

\item{...}{passed to summary.ci}
}
\value{
A string: the formatted confidence intervals
}
\description{
Print confidence intervals
}
\details{
This format of the confidence intervals is user-manipulable.
}
\examples{
library(lava)
m <- lvm(Y~X)
m <- categorical(m,Y~X,K=4)
set.seed(4)
d <- sim(m,24)
ci.mean(Y~X,data=d)
x <- ci.mean(Y~X,data=d)
print(x,format="(l,u)")
}
\seealso{
ci plot.ci formatCI summary.ci
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
