% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancestral.R
\name{write.ancestral}
\alias{write.ancestral}
\alias{as.ancestral}
\alias{print.ancestral}
\title{Export and convenience functions for  ancestral reconstructions}
\usage{
write.ancestral(x, file = "ancestral")

as.ancestral(tree, align, prob)

\method{print}{ancestral}(x, ...)
}
\arguments{
\item{x}{an object of class ancestral.}

\item{file}{a file name. File endings are added.}

\item{tree}{an object of class phylo.}

\item{align}{an object of class phyDat.}

\item{prob}{an data.frame containing a matrix of posterior probabilities for
each state and site.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\code{write.ancestral}  returns the input x invisibly.
}
\description{
\code{write.ancestral} allows to export ancestral reconstructions. It writes
out the tree, a tab delimited text file with the probabilities and the
alignment. \code{ancestral} generates an object of class ancestral.
}
\details{
This allows also to read in reconstruction  made by iqtree to use the
plotting capabilities of R.
}
\examples{
data(Laurasiatherian)
fit <- pml_bb(Laurasiatherian[,1:100], "JC", rearrangement = "none")
anc_ml <- anc_pml(fit)
write.ancestral(anc_ml)
# Can be also results from iqtree
align <- read.phyDat("ancestral_align.fasta", format="fasta")
tree <- read.tree("ancestral_tree.nwk")
df <- read.table("ancestral.state", header=TRUE)
anc_ml_disc <- as.ancestral(tree, align, df)
plotAnc(anc_ml_disc, 20)
unlink(c("ancestral_align.fasta", "ancestral_tree.nwk", "ancestral.state"))
}
\seealso{
\code{\link{ancestral.pml}}, \code{\link{plotAnc}}
}
