% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_reliability.R
\name{item_reliability}
\alias{item_reliability}
\title{Reliability Test for Items or Scales}
\usage{
item_reliability(x, standardize = FALSE, digits = 3)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{standardize}{Logical, if \code{TRUE}, the data frame's vectors will be
standardized. Recommended when the variables have different measures /
scales.}

\item{digits}{Amount of digits for returned values.}
}
\value{
A data frame with the corrected item-total correlations (\emph{item
discrimination}, column \code{item_discrimination}) and Cronbach's Alpha
(if item deleted, column \code{alpha_if_deleted}) for each item
of the scale, or \code{NULL} if data frame had too less columns.
}
\description{
Compute various measures of internal consistencies
for tests or item-scales of questionnaires.
}
\details{
This function calculates the item discriminations (corrected item-total
correlations for each item of \code{x} with the remaining items) and the
Cronbach's alpha for each item, if it was deleted from the scale. The
absolute value of the item discrimination indices should be above 0.1. An
index between 0.1 and 0.3 is considered as "fair", while an index above 0.3
(or below -0.3) is "good". Items with low discrimination indices are often
ambiguously worded and should be examined. Items with negative indices should
be examined to determine why a negative value was obtained (e.g. reversed
answer categories regarding positive and negative poles).
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
item_reliability(x)
}
