% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasType.R
\name{hasType}
\alias{hasType}
\alias{hasDiscrete}
\alias{hasInteger}
\alias{hasLogical}
\alias{hasCharacter}
\alias{hasNumeric}
\title{Check whether parameter set contains a certain type.}
\usage{
hasDiscrete(par.set, include.logical = TRUE)

hasInteger(par.set)

hasLogical(par.set)

hasCharacter(par.set)

hasNumeric(par.set, include.int = TRUE)
}
\arguments{
\item{par.set}{\link{ParamSet}\cr
Parameter set.}

\item{include.logical}{(\code{logical(1)})\cr
Are logicals also considered to be discrete?
Default is \code{TRUE}.}

\item{include.int}{(\code{logical(1)})\cr
Are integers also considered to be numeric?
Default is \code{TRUE}.}
}
\value{
\code{logical(1)}
}
\description{
\code{TRUE} if the parameter set contains at least one parameter of
the mentioned type x. Type x always subsumes x and x-vector.
}
