% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_stress.R, R/layouts.R
\name{layout_focus_group}
\alias{layout_focus_group}
\alias{layout_with_focus_group}
\alias{layout_igraph_focus_group}
\title{radial focus group layout}
\usage{
layout_with_focus_group(
  g,
  v,
  group,
  shrink = 10,
  weights = NA,
  iter = 500,
  tol = 1e-04
)

layout_igraph_focus_group(
  g,
  v,
  group,
  shrink = 10,
  weights = NA,
  iter = 500,
  tol = 1e-04,
  circular
)
}
\arguments{
\item{g}{igraph object}

\item{v}{id of focal node to be placed in the center}

\item{group}{vector indicating grouping of nodes}

\item{shrink}{shrink the reserved angle range for a group to increase the gaps between groups}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
arrange nodes in concentric circles around a focal node according to their distance from the focus and keep predefined groups in the same angle range.
}
\details{
Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight).
}
\examples{
library(igraph)
g <- sample_islands(4, 5, 0.8, 2)
grp <- as.character(rep(1:4, each = 5))
layout_with_focus_group(g, v = 1, group = grp, shrink = 10)
}
\seealso{
\link{layout_focus}
The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
}
