% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_auth.R
\name{drive_deauth}
\alias{drive_deauth}
\title{Suspend authorization}
\usage{
drive_deauth()
}
\description{
Put googledrive into a de-authorized state. Instead of sending a token,
googledrive will send an API key. This can be used to access public
resources for which no Google sign-in is required. This is handy for using
googledrive in a non-interactive setting to make requests that do not
require a token. It will prevent the attempt to obtain a token
interactively in the browser. The user can configure their own API key
via \code{\link[=drive_auth_configure]{drive_auth_configure()}} and retrieve that key via
\code{\link[=drive_api_key]{drive_api_key()}}.
In the absence of a user-configured key, a built-in default key is used.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
drive_deauth()
drive_user()

# in a deauth'ed state, we can still get metadata on a world-readable file
public_file <- drive_example_remote("chicken.csv")
public_file
# we can still download it too
drive_download(public_file)
\dontshow{\}) # examplesIf}
}
\seealso{
Other auth functions: 
\code{\link{drive_auth_configure}()},
\code{\link{drive_auth}()},
\code{\link{drive_scopes}()}
}
\concept{auth functions}
