% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_multivariate_normal.R
\name{dist_multivariate_normal}
\alias{dist_multivariate_normal}
\title{The multivariate normal distribution}
\usage{
dist_multivariate_normal(mu = 0, sigma = diag(1))
}
\arguments{
\item{mu}{A list of numeric vectors for the distribution's mean.}

\item{sigma}{A list of matrices for the distribution's variance-covariance matrix.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
dist <- dist_multivariate_normal(mu = list(c(1,2)), sigma = list(matrix(c(4,2,2,3), ncol=2)))
dimnames(dist) <- c("x", "y")
dist

\dontshow{if (requireNamespace("mvtnorm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, cbind(2, 1))
density(dist, cbind(2, 1), log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
quantile(dist, 0.7, type = "marginal")
\dontshow{\}) # examplesIf}
}
\seealso{
\link[mvtnorm:Mvnorm]{mvtnorm::dmvnorm}, \link[mvtnorm:qmvnorm]{mvtnorm::qmvnorm}
}
