% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-credential.R
\name{http_credentials}
\alias{http_credentials}
\alias{git_credential_ask}
\alias{credentials}
\alias{git_credential_update}
\alias{git_credential_forget}
\title{Load and store git HTTPS credentials}
\usage{
git_credential_ask(url = "https://github.com", save = TRUE, verbose = TRUE)

git_credential_update(url = "https://github.com", verbose = TRUE)

git_credential_forget(url = "https://github.com", verbose = TRUE)
}
\arguments{
\item{url}{target url, possibly including username or path}

\item{save}{in case the user is prompted for credentials, attempt to
remember them.}

\item{verbose}{print errors from \verb{git credential} to stdout}
}
\description{
This requires you have the \code{git} command line program installed.The
\link{git_credential_ask} function looks up a suitable username/password
from the \href{https://git-scm.com/docs/gitcredentials}{\code{git-credential} store}.
If none are available it will prompt the user for credentials which
may be saved the store. On subsequent calls for the same URL, the
function will then return the stored credentials without prompting
the user.
}
\details{
The appearance and security policy of the credential store depends
on your version of git, your operating system, your R frontend and
which \link{credential_helper} is used. On Windows and MacOS the credentials
are stored in the system password manager by default.

It should be assumed that reading credentials always involves user
interaction. The user may be asked to unlock the system keychain or
enter new credentials. In reality, user interaction is usually only
required on the first authentication attempt, but the security policy
of most credential helpers prevent you from programmatically testing
if the credentials are already unlocked.
}
\seealso{
Other credentials: 
\code{\link{ssh_credentials}}
}
\concept{credentials}
