% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year-quarter-day-widen}
\alias{year-quarter-day-widen}
\alias{calendar_widen.clock_year_quarter_day}
\title{Widen: year-quarter-day}
\usage{
\method{calendar_widen}{clock_year_quarter_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_quarter_day]}

A year-quarter-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} widened to the supplied \code{precision}.
}
\description{
This is a year-quarter-day method for the \code{\link[=calendar_widen]{calendar_widen()}} generic. It
widens a year-quarter-day vector to the specified \code{precision}.
}
\examples{
# Quarter precision
x <- year_quarter_day(2019, 1)
x

# Widen to day precision
calendar_widen(x, "day")

# Or second precision
sec <- calendar_widen(x, "second")
sec
}
