% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekday.R
\name{weekday_code}
\alias{weekday_code}
\title{Extract underlying weekday codes}
\usage{
weekday_code(x, ..., encoding = "western")
}
\arguments{
\item{x}{\verb{[weekday]}

A weekday vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{encoding}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"western"}: Encode weekdays assuming \code{1 == Sunday} and \code{7 == Saturday}.
\item \code{"iso"}: Encode weekdays assuming \code{1 == Monday} and \code{7 == Sunday}. This
is in line with the ISO standard.
}}
}
\value{
An integer vector of codes.
}
\description{
\code{weekday_code()} extracts out the integer code for the weekday.
}
\examples{
# Here we supply a western encoding to `weekday()`
x <- weekday(1:7)
x

# We can extract out the codes using different encodings
weekday_code(x, encoding = "western")
weekday_code(x, encoding = "iso")
}
