% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar_group}
\alias{calendar_group}
\title{Group calendar components}
\usage{
calendar_group(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar vector.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the calendar used.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
\code{x} grouped at the specified \code{precision}.
}
\description{
\code{calendar_group()} groups at a multiple of the specified precision. Grouping
alters the value of a single component (i.e. the month component
if grouping by month). Components that are more precise than the precision
being grouped at are dropped altogether (i.e. the day component is dropped
if grouping by month).

Each calendar has its own help page describing the grouping process in more
detail:
\itemize{
\item \link[=year-month-day-group]{year-month-day}
\item \link[=year-month-weekday-group]{year-month-weekday}
\item \link[=year-week-day-group]{year-week-day}
\item \link[=iso-year-week-day-group]{iso-year-week-day}
\item \link[=year-quarter-day-group]{year-quarter-day}
\item \link[=year-day-group]{year-day}
}
}
\examples{
# See the calendar specific help pages for more examples
x <- year_month_day(2019, c(1, 1, 2, 2, 3, 3, 4, 4), 1:8)
x

# Group by two months
calendar_group(x, "month", n = 2)

# Group by two days of the month
calendar_group(x, "day", n = 2)
}
