% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_strata.R
\name{ard_strata}
\alias{ard_strata}
\title{Stratified ARD}
\usage{
ard_strata(.data, .by = NULL, .strata = NULL, .f, ...)
}
\arguments{
\item{.data}{(\code{data.frame})\cr
a data frame}

\item{.by, .strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to tabulate by/stratify by for calculation.
Arguments are similar, but with an important distinction:

\code{.by}: results are tabulated by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{.strata}: results are tabulated by \strong{all \emph{observed} combinations} of the
columns specified.

These argument \emph{should not} include any columns that appear in the \code{.f} argument.}

\item{.f}{(\code{function}, \code{formula})\cr
a function or a formula that can be coerced to a function with
\code{rlang::as_function()} (similar to \code{purrr::map(.f)})}

\item{...}{Additional arguments passed on to the \code{.f} function.}
}
\value{
an ARD data frame of class 'card'
}
\description{
General function for calculating ARD results within subgroups.

While the examples below show use with other functions from the cards package,
this function would primarily be used with the statistical functions in the
cardx functions.
}
\examples{
# Example 1 ----------------------------------
ard_strata(
  ADSL,
  .by = ARM,
  .f = ~ ard_summary(.x, variables = AGE)
)

# Example 2 ----------------------------------
df <- data.frame(
  USUBJID = 1:12,
  PARAMCD = rep(c("PARAM1", "PARAM2"), each = 6),
  AVALC = c(
    "Yes", "No", "Yes", # PARAM1
    "Yes", "Yes", "No", # PARAM1
    "Low", "Medium", "High", # PARAM2
    "Low", "Low", "Medium" # PARAM2
  )
)

ard_strata(
  df,
  .strata = PARAMCD,
  .f = \(.x) {
    lvls <-
      switch(.x[["PARAMCD"]][1],
        "PARAM1" = c("Yes", "No"),
        "PARAM2" = c("Zero", "Low", "Medium", "High")
      )

    .x |>
      dplyr::mutate(AVALC = factor(AVALC, levels = lvls)) |>
      ard_tabulate(variables = AVALC)
  }
)
}
