% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantreg-rq-tidiers.R
\name{tidy.rq}
\alias{tidy.rq}
\alias{rq_tidiers}
\alias{quantreg_tidiers}
\title{Tidy a(n) rq object}
\usage{
\method{tidy}{rq}(x, se.type = NULL, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An \code{rq} object returned from \code{\link[quantreg:rq]{quantreg::rq()}}.}

\item{se.type}{Character specifying the method to use to calculate
standard errors. Passed to \code{\link[quantreg:summary.rq]{quantreg::summary.rq()}} \code{se} argument.
Defaults to \code{"rank"} if the sample size is less than 1000,
otherwise defaults to \code{"nid"}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments passed to \code{\link[quantreg:summary.rq]{quantreg::summary.rq()}}.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
If \code{se.type = "rank"} confidence intervals are calculated by
\code{summary.rq} and \code{statistic} and \code{p.value} values are not returned.
When only a single predictor is included in the model,
no confidence intervals are calculated and the confidence limits are
set to NA.
}
\examples{
\dontshow{if (rlang::is_installed("quantreg")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load modeling library and data
library(quantreg)

data(stackloss)

# median (l1) regression fit for the stackloss data. 
mod1 <- rq(stack.loss ~ stack.x, .5)  

# weighted sample median
mod2 <- rq(rnorm(50) ~ 1, weights = runif(50))

# summarize model fit with tidiers
tidy(mod1)
glance(mod1)
augment(mod1)

tidy(mod2)
glance(mod2)
augment(mod2)

# varying tau to generate an rqs object
mod3 <- rq(stack.loss ~ stack.x, tau = c(.25, .5))

tidy(mod3)
augment(mod3)

# glance cannot handle rqs objects like `mod3`--use a purrr 
# `map`-based workflow instead
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[quantreg:rq]{quantreg::rq()}}

Other quantreg tidiers: 
\code{\link{augment.nlrq}()},
\code{\link{augment.rqs}()},
\code{\link{augment.rq}()},
\code{\link{glance.nlrq}()},
\code{\link{glance.rq}()},
\code{\link{tidy.nlrq}()},
\code{\link{tidy.rqs}()}
}
\concept{quantreg tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
