% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missmap.R
\name{missmap}
\alias{missmap}
\title{Missingness Map}
\usage{
missmap(obj, vars, legend = TRUE, col, main, y.cex = 0.8,
  x.cex = 0.8, y.labels, y.at, csvar = NULL, tsvar = NULL,
  rank.order = TRUE, margins = c(5, 5), gap.xaxis = 1, x.las = 2,
  ...)
}
\arguments{
\item{obj}{an object of class "amelia"; typically output from the
function \code{amelia}, a matrix or a dataframe.}

\item{vars}{a vector of column numbers or column names of the data
to include in the plot. The default is to plot all variables.}

\item{legend}{should a legend be drawn? (True or False)}

\item{col}{a vector of length two where the first element specifies
the color for missing cells and the second element specifies}

\item{main}{main title of the plot. Defaults to "Missingness Map".}

\item{y.cex}{expansion for the variables names on the x-axis.}

\item{x.cex}{expansion for the unit names on the y-axis.}

\item{y.labels}{a vector of row labels to print on the y-axis}

\item{y.at}{a vector of the same length as \code{y.labels} with row
nmumbers associated with the labels.}

\item{csvar}{column number or name of the variable corresponding to
the unit indicator. Only used when the \code{obj} is not of class
\code{amelia}.}

\item{tsvar}{column number or name of the variable corresponding to
the time indicator. Only used when the \code{obj} is not of class
\code{amelia}.}

\item{rank.order}{a logical value. If \code{TRUE}, the default, then
the order of the variables along the the x-axis is sorted by the
percent missing (from highest to lowest). If \code{FALSE}, it is
simply the order of the variables in the data.}

\item{margins}{a vector of length two that specifies the bottom and
left margins of the plot. Useful for when variable names or
row names are long.}

\item{gap.xaxis}{value to pass to the \code{gap.axis} argument of
the \code{axis} function that plots the x-axis. See
\code{\link{axis}} for more details. Ignored on R versions less
than 4.0.0.}

\item{x.las}{value of the \code{las} argument to pass to the
\code{\link{axis}} function creating the x-axis.}

\item{...}{further graphical arguments.}
}
\description{
Plots a missingness map showing where missingness occurs in
the dataset passed to \code{amelia}.
}
\details{
\code{missmap} draws a map of the missingness in a dataset using the
\code{image} function. The columns are reordered to put the most
missing variable farthest to the left. The rows are reordered to a
unit-period order if the \code{ts} and \code{cs} arguments were passed
to \code{amelia}. If not, the rows are not reordered.

The \code{y.labels} and \code{y.at} commands can be used to associate
labels with rows in the data to identify them in the plot. The y-axis
is internally inverted so that the first row of the data is associated
with the top-most row of the missingness map. The values of
\code{y.at} should refer to the rows of the data, not to any point on
the plotting region.
}
\seealso{
\code{\link{compare.density}}, \code{\link{overimpute}},
\code{\link{tscsPlot}}, \code{\link{image}}, \code{\link{heatmap}}
}
