% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_variance_explained.R
\name{plot_variance_explained}
\alias{plot_variance_explained}
\title{Plot variance explained by the model}
\usage{
plot_variance_explained(
  object,
  x = "view",
  y = "factor",
  split_by = NA,
  plot_total = FALSE,
  factors = "all",
  min_r2 = 0,
  max_r2 = NULL,
  legend = TRUE,
  use_cache = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object}

\item{x}{character specifying the dimension for the x-axis ("view", "factor", or "group").}

\item{y}{character specifying the dimension for the y-axis ("view", "factor", or "group").}

\item{split_by}{character specifying the dimension to be faceted ("view", "factor", or "group").}

\item{plot_total}{logical value to indicate if to plot the total variance explained (for the variable in the x-axis)}

\item{factors}{character vector with a factor name(s), or numeric vector with the index(es) of the factor(s). Default is "all".}

\item{min_r2}{minimum variance explained for the color scheme (default is 0).}

\item{max_r2}{maximum variance explained for the color scheme.}

\item{legend}{logical indicating whether to add a legend to the plot  (default is TRUE).}

\item{use_cache}{logical indicating whether to use cache (default is TRUE)}

\item{...}{extra arguments to be passed to \code{\link{calculate_variance_explained}}}
}
\value{
A list of \code{\link{ggplot}} objects (if \code{plot_total} is TRUE) or a single \code{\link{ggplot}} object
}
\description{
plots the variance explained by the MOFA factors across different views and groups, as specified by the user.
Consider using cowplot::plot_grid(plotlist = ...) to combine the multiple plots that this function generates.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Calculate variance explained (R2)
r2 <- calculate_variance_explained(model)

# Plot variance explained values (view as x-axis, and factor as y-axis)
plot_variance_explained(model, x="view", y="factor")

# Plot variance explained values (view as x-axis, and group as y-axis)
plot_variance_explained(model, x="view", y="group")

# Plot variance explained values for factors 1 to 3
plot_variance_explained(model, x="view", y="group", factors=1:3)

# Scale R2 values
plot_variance_explained(model, max_r2=0.25)
}
